'''
Created on 1 avr. 2021

@author: tleduc

Copyright 2020-2021 Thomas Leduc

This file is part of t4gpd.

t4gpd is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

t4gpd is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with t4gpd.  If not, see <https://www.gnu.org/licenses/>.
'''
from os import path
from geopandas import read_file


class TestUtils(object):
    '''
    classdocs
    '''

    @staticmethod
    def getDataSetFilename(dirname, basename):
        if path.exists('%s/%s' % (dirname, basename)):
            return '%s/%s' % (dirname, basename)
        elif path.exists('data/%s' % (basename)):
            return 'data/%s' % (basename)
        raise Exception('dataset not found: %s' % (basename)) 

    @staticmethod
    def loadDataSet(dirname, basename):
        return read_file(TestUtils.getDataSetFilename(dirname, basename))
