'''
Created on 26 janv. 2021

@author: tleduc

Copyright 2020 Thomas Leduc

This file is part of t4gpd.

t4gpd is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

t4gpd is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with t4gpd.  If not, see <https://www.gnu.org/licenses/>.
'''
from geopandas.geodataframe import GeoDataFrame
from pandas import DataFrame
from shapely.wkt import loads


class GeoDataFrameDemos(object):
    '''
    classdocs
    '''

    @staticmethod
    def coursCambronneInNantes():
        _geom = loads('POLYGON ((354726 6689012, 354744 6689026.908633, 354750 6689031.3, \
354756 6689036.858278, 354781 6689058.025785, 354791 6689065.9, 354799 6689072.434249, \
354805 6689078.221882, 354811 6689083.2, 354827 6689096.035821, 354833 6689101.518421, \
354843 6689109.9, 354851 6689116.727514, 354866 6689129.3, 354869 6689126.7, 354875 6689119.2, \
354893 6689097.6, 354900 6689090.3, 354888 6689081, 354890 6689078.8, 354762 6688970.8, \
354750 6688984.484763, 354752 6688985.6, 354750 6688987.5, 354749 6688986.317651, \
354739 6688997.550236, 354740 6688998.7, 354739 6689000.8, 354737 6688999.498647, \
354726 6689012))')
        return GeoDataFrame([{'gid': 1, 'geometry': _geom}], crs='epsg:2154')

    @staticmethod
    def districtGraslinInNantesBuildings():
        _rawData = [
            ('BATIMENT0000000302923519', 3.4, 'POLYGON Z ((354748.2 6688985.8 23.3, 354750.1 6688987.5 23.3, 354751.7 6688985.6 23.3, 354749.8 6688984 23.3, 354749.5 6688983.7 23.3, 354747.9 6688985.6 23.3, 354748.2 6688985.8 23.3))'),
            ('BATIMENT0000000302923520', 3.0, 'POLYGON Z ((354740.5 6688998.7 23, 354738.4 6688997.1 23, 354738.1 6688996.8 23, 354736.5 6688998.7 23, 354736.6 6688998.9 23, 354738.8 6689000.8 23, 354740.5 6688998.7 23))'),
            ('BATIMENT0000000302923434', 19.4, 'POLYGON Z ((354987.9 6688985.7 26.3, 354985.1 6688984.5 26.3, 354984.3 6688986.8 26.3, 354987 6688987.8 26.3, 354987.2 6688987.3 26.3, 354987.9 6688985.7 26.3))'),
            ('BATIMENT0000000302923394', 11.8, 'POLYGON Z ((354750.1 6688948.9 30.5, 354750 6688948.6 30.5, 354747.7 6688947.3 30.5, 354744.1 6688951.3 30.5, 354746.5 6688953.4 30.5, 354750.1 6688948.9 30.5))'),
            ('BATIMENT0000000302923451', 10.8, 'POLYGON Z ((354917.2 6689004.2 20, 354909.6 6688999.1 20, 354907.6 6689002.3 20, 354906.2 6689004.9 20, 354910.9 6689007.9 20, 354913.1 6689009.6 20, 354913.5 6689009.8 20, 354917.2 6689004.2 20))'),
            ('BATIMENT0000000302923444', 4.8, 'POLYGON Z ((354944.3 6688994.8 13.3, 354948.1 6688997.1 13.3, 354953.3 6688988 13.3, 354949.6 6688986.2 13.3, 354947 6688990.2 13.3, 354944.3 6688994.8 13.3))'),
            ('BATIMENT0000000302923579', 4.3, 'POLYGON Z ((354931.3 6689005.5 12.8, 354938.2 6689009.8 12.8, 354944.6 6688999.3 12.8, 354937.7 6688995 12.8, 354935.2 6688998.9 12.8, 354931.3 6689005.5 12.8))'),
            ('BATIMENT0000000302923042', 16.1, 'POLYGON Z ((354817.2 6688917.9 26, 354816.6 6688919 26, 354818.1 6688919.9 26, 354818.5 6688918.8 26, 354817.2 6688917.9 26))'),
            ('BATIMENT0000000302923366', 23.0, 'POLYGON Z ((354857.8 6688926 31, 354855.6 6688924.8 31, 354853.6 6688931.2 31, 354854.6 6688931.9 31, 354857.8 6688926 31))'),
            ('BATIMENT0000000302923367', 12.5, 'POLYGON Z ((354852.3 6688992.5 28.2, 354851.3 6688994 28.2, 354870.4 6689010.2 28.2, 354871.2 6689008.6 28.2, 354853 6688993.1 28.2, 354852.3 6688992.5 28.2))'),
            ('BATIMENT0000000302923044', 12.1, 'POLYGON Z ((354816.6 6688919 22.2, 354816.3 6688919.5 22.2, 354815.7 6688920.6 22.2, 354818.7 6688922.9 22.2, 354819.6 6688921 22.2, 354818.1 6688919.9 22.2, 354816.6 6688919 22.2))'),
            ('BATIMENT0000000302923395', 18.0, 'POLYGON Z ((354743.1 6688960 37, 354743 6688959.1 37, 354740.1 6688959.3 37, 354740.4 6688960.4 37, 354743.1 6688960 37))'),
            ('BATIMENT0000000302923121', 12.2, 'POLYGON Z ((354694.4 6688884.1 21, 354683.2 6688898.8 21, 354683.6 6688899.2 21, 354687.9 6688902.7 21, 354688.3 6688902.3 21, 354699.6 6688888 21, 354694.4 6688884.1 21))'),
            ('BATIMENT0000000302923386', 20.2, 'POLYGON Z ((354706.4 6688988.5 38.5, 354705.1 6688987.3 38.5, 354704.2 6688988.4 38.5, 354705.5 6688989.7 38.5, 354706.4 6688988.5 38.5))'),
            ('BATIMENT0000000302923440', 17.9, 'POLYGON Z ((354997.8 6688993.2 24.8, 354994.2 6688991.9 24.8, 354993.8 6688993.2 24.8, 354997.1 6688994.5 24.8, 354997.8 6688993.2 24.8))'),
            ('BATIMENT0000000302923381', 8.7, 'POLYGON Z ((354689.3 6688990.5 26.7, 354690.7 6688991.6 26.7, 354692.1 6688989.8 26.7, 354690.7 6688988.9 26.7, 354689.3 6688990.5 26.7))'),
            ('BATIMENT0000000302923375', 16.8, 'POLYGON Z ((354680 6688998.146666666 36.3, 354681.1 6688996.9 36.3, 354680 6688995.986792454 36.3, 354680 6688998.146666666 36.3))'),
            ('BATIMENT0000000302928282', 16.3, 'POLYGON Z ((354733 6689087.7 39.5, 354732.2 6689088.9 39.5, 354733 6689089.4 39.5, 354733.7 6689088.1 39.5, 354733 6689087.7 39.5))'),
            ('BATIMENT0000000302923562', 5.7, 'POLYGON Z ((354819 6689001.9 23.6, 354822.1 6688998.3 23.6, 354829.9 6688988.9 23.6, 354824.7 6688984.5 23.6, 354813.7 6688997.6 23.6, 354819 6689001.9 23.6))'),
            ('BATIMENT0000000302923047', 20.4, 'POLYGON Z ((354867.3 6688913.8 29.5, 354859.5 6688929.4 29.5, 354857.6 6688933.7 29.5, 354857 6688933.7 29.5, 354853.4 6688940.8 29.5, 354857.2 6688942.7 29.5, 354855 6688946.4 29.5, 354865.5 6688951.8 29.5, 354871.2 6688954.7 29.5, 354875.9 6688957.1 29.5, 354873.5 6688957.7 29.5, 354875.6 6688967.1 29.5, 354878.1 6688966.5 29.5, 354875.9 6688970.9 29.5, 354865.6 6688990.9 29.5, 354857 6688987.1 29.5, 354856.5 6688986.8 29.5, 354852.3 6688992.5 29.5, 354853 6688993.1 29.5, 354871.2 6689008.6 29.5, 354873.5 6689005 29.5, 354873.1 6689004.8 29.5, 354873.6 6689003.7 29.5, 354873.4 6689002.9 29.5, 354877.5 6689002 29.5, 354877.7 6689002.6 29.5, 354878.8 6689003.3 29.5, 354878.6 6689003.8 29.5, 354883.7 6689007 29.5, 354900.2 6688979.4 29.5, 354902.9 6688974.8 29.5, 354896.5 6688970.9 29.5, 354891.2 6688947.2 29.5, 354899.1 6688931.5 29.5, 354898.4 6688929.2 29.5, 354867.3 6688913.8 29.5))'),
            ('BATIMENT0000000302928338', 13.6, 'POLYGON Z ((354825.9 6689111.7 35.2, 354824 6689110.1 35.2, 354821.6 6689113 35.2, 354820.8 6689114 35.2, 354822.8 6689115.6 35.2, 354823.5 6689114.7 35.2, 354824.3 6689115.3 35.2, 354825.9 6689113.4 35.2, 354825.1 6689112.8 35.2, 354825.9 6689111.7 35.2))'),
            ('BATIMENT0000000302927588', 6.2, 'POLYGON Z ((354851 6689235.6 28.3, 354852 6689235.8 28.3, 354854.8 6689236.2 28.3, 354854.7 6689234.6 28.3, 354857 6689234.6 28.3, 354858.1 6689229.5 28.3, 354852.7 6689228.4 28.3, 354851.4 6689234.4 28.3, 354851.2 6689234.4 28.3, 354851 6689235.6 28.3))'),
            ('BATIMENT0000000302928285', 18.7, 'POLYGON Z ((354723.6 6689083.3 41.5, 354724.6 6689084 41.5, 354725.6 6689082.7 41.5, 354724.3 6689082 41.5, 354723.6 6689083.3 41.5))'),
            ('BATIMENT0000000302928344', 3.5, 'POLYGON Z ((354714.3 6689040.5 25, 354716.2 6689042.1 25, 354720.2 6689037.4 25, 354718.3 6689035.9 25, 354714.3 6689040.5 25))'),
            ('BATIMENT0000000302928275', 13.8, 'POLYGON Z ((354702.6 6689069.7 36.5, 354709.3 6689074 36.5, 354711.1 6689071.8 36.5, 354704.9 6689067.1 36.5, 354702.6 6689069.7 36.5))'),
            ('BATIMENT0000000302927584', 3.5, 'POLYGON Z ((354847 6689255.6 28, 354848 6689255.8 28, 354849.6 6689256.1 28, 354855 6689257.1 28, 354855.3 6689254.6 28, 354847.7 6689253 28, 354847.4 6689254.4 28, 354847.2 6689254.4 28, 354847 6689255.6 28))'),
            ('BATIMENT0000000302927576', 2.9, 'POLYGON Z ((354985.3 6689088.6 16.7, 354989.2 6689086 16.7, 354993.3 6689083.4 16.7, 354991.7 6689080.8 16.7, 354987.3 6689083.5 16.7, 354987.5 6689083.9 16.7, 354983.9 6689086.2 16.7, 354983.2 6689085.2 16.7, 354981.7 6689086.1 16.7, 354983.8 6689089.5 16.7, 354985.3 6689088.6 16.7))'),
            ('BATIMENT0000000302928044', 2.8, 'POLYGON Z ((354786.1 6689214.2 27.8, 354784 6689215.3 27.8, 354783.4 6689215.8 27.8, 354780.7 6689217.3 27.8, 354777.7 6689219 27.8, 354776.4 6689219.7 27.8, 354775 6689220.5 27.8, 354774.7 6689220.8 27.8, 354772 6689222.3 27.8, 354768.8 6689224 27.8, 354770.5 6689229.3 27.8, 354774.6 6689227 27.8, 354777.4 6689225.5 27.8, 354780.5 6689223.8 27.8, 354783.4 6689222.3 27.8, 354786.3 6689220.8 27.8, 354789.3 6689219.1 27.8, 354786.1 6689214.2 27.8))'),
            ('BATIMENT0000000302928043', 5.9, 'POLYGON Z ((354770.9 6689231.1 31, 354766.3 6689233.4 31, 354767.1 6689236.6 31, 354771.6 6689232.8 31, 354770.9 6689231.1 31))'),
            ('BATIMENT0000000302928288', 14.2, 'POLYGON Z ((354737.4 6689093.6 37.5, 354737.9 6689092.6 37.5, 354737.2 6689092.1 37.5, 354733 6689089.4 37.5, 354732.2 6689088.9 37.5, 354731.4 6689088.3 37.5, 354730.5 6689089.8 37.5, 354737.4 6689093.6 37.5))'),
            ('BATIMENT0000000302928028', 1.7, 'POLYGON Z ((354809.3 6689196 25.8, 354822 6689195.6 25.8, 354821.1 6689178.6 25.8, 354814.8 6689175.2 25.8, 354809.3 6689175.6 25.8, 354809.1 6689189.3 25.8, 354809.3 6689196 25.8))'),
            ('BATIMENT0000000302928345', 9.5, 'POLYGON Z ((354728.2 6689044 31, 354726 6689042.3 31, 354722 6689047 31, 354724.2 6689048.7 31, 354728.2 6689044 31))'),
            ('BATIMENT0000000302928116', 7.3, 'POLYGON Z ((354684 6689269.9 34.8, 354683.8500000006 6689270 34.8, 354684.0666666665 6689270 34.8, 354684 6689269.9 34.8))'),
            ('BATIMENT0000000302928048', 6.4, 'POLYGON Z ((354784 6689215.3 33.2, 354782.7 6689213.1 33.2, 354779.5 6689214.7 33.2, 354780.7 6689217.3 33.2, 354783.4 6689215.8 33.2, 354784 6689215.3 33.2))'),
            ('BATIMENT0000000302927583', 3.8, 'POLYGON Z ((354848.5 6689248.9 27.9, 354847.7 6689253 27.9, 354855.3 6689254.6 27.9, 354855.9 6689250.4 27.9, 354849.5 6689249 27.9, 354848.5 6689248.9 27.9))'),
            ('BATIMENT0000000302928118', 6.6, 'POLYGON Z ((354694 6689240.5 34.2, 354694 6689240.4 34.2, 354690.9 6689242.6 34.2, 354689.2 6689243.8 34.2, 354687.8 6689244.8 34.2, 354690.4 6689248.5 34.2, 354696.5 6689244.1 34.2, 354694 6689240.5 34.2))'),
            ('BATIMENT0000000302927590', 5.8, 'POLYGON Z ((354848.8 6689247.2 29.7, 354848.5 6689248.9 29.7, 354849.5 6689249 29.7, 354849.7 6689247.4 29.7, 354848.8 6689247.2 29.7))'),
            ('BATIMENT0000000302927383', 9.5, 'POLYGON Z ((354906.2 6689004.9 21.7, 354902.7 6689010.6 21.7, 354906.9 6689013.5 21.7, 354910.9 6689007.9 21.7, 354906.2 6689004.9 21.7))'),
            ('BATIMENT0000000302927591', 12.3, 'POLYGON Z ((354849.5 6689243.8 36, 354849.3 6689245.4 36, 354850.2 6689245.5 36, 354850.4 6689243.9 36, 354849.5 6689243.8 36))'),
            ('BATIMENT0000000302928032', 11.9, 'POLYGON Z ((354746.5 6689152.3 35.2, 354747 6689151.3 35.2, 354744.6 6689150.2 35.2, 354744.2 6689151.3 35.2, 354746.5 6689152.3 35.2))'),
            ('BATIMENT0000000302928037', 6.6, 'POLYGON Z ((354755.6 6689145.2 29.7, 354753.2 6689144.2 29.7, 354750.4 6689150.6 29.7, 354750.1 6689151.3 29.7, 354753.8 6689152.8 29.7, 354756.7 6689145.8 29.7, 354755.6 6689145.2 29.7))'),
            ('BATIMENT0000000302928123', 16.3, 'POLYGON Z ((354702.1 6689243.9 44, 354700.2 6689245.4 44, 354708.3 6689253.7 44, 354710.2 6689252.3 44, 354702.1 6689243.9 44))'),
            ('BATIMENT0000000302927577', 18.1, 'POLYGON Z ((354989 6689097.7 32.1, 354995.7 6689093.5 32.1, 354992.9 6689089.2 32.1, 354991.9 6689090 32.1, 354987.3 6689093.5 32.1, 354986.5 6689094 32.1, 354989 6689097.7 32.1))'),
            ('BATIMENT0000000302928035', 2.8, 'POLYGON Z ((354807.4 6689197.3 27.1, 354809.3 6689196 27.1, 354809.1 6689189.3 27.1, 354802.6 6689189.7 27.1, 354807.4 6689197.3 27.1))'),
            ('BATIMENT0000000302928121', 16.2, 'POLYGON Z ((354717.2 6689263.2 44, 354719 6689261.5 44, 354710.2 6689252.3 44, 354708.3 6689253.7 44, 354717.2 6689263.2 44))'),
            ('BATIMENT0000000302928023', 8.3, 'POLYGON Z ((354750.4 6689150.6 31.7, 354749.2 6689150.1 31.7, 354748.4 6689151.8 31.7, 354749.7 6689152.3 31.7, 354750.1 6689151.3 31.7, 354750.4 6689150.6 31.7))'),
            ('BATIMENT0000000302928038', 5.1, 'POLYGON Z ((354800.4 6689194.8 29, 354804.2 6689200.8 29, 354808 6689198.3 29, 354807.4 6689197.3 29, 354802.6 6689189.7 29, 354800.4 6689194.8 29))'),
            ('BATIMENT0000000302927498', 22.4, 'POLYGON Z ((354935.4 6689129.7 40.1, 354936.7 6689131.2 40.1, 354938.1 6689131.3 40.1, 354939.5 6689130.5 40.1, 354938 6689128.2 40.1, 354936.3 6689128 40.1, 354934.9 6689128.9 40.1, 354935.4 6689129.7 40.1))'),
            ('BATIMENT0000000302927396', 15.8, 'POLYGON Z ((354914.7 6689038.6 30.5, 354913.1 6689040.6 30.5, 354914.5 6689041.7 30.5, 354916.2 6689039.7 30.5, 354914.7 6689038.6 30.5))'),
            ('BATIMENT0000000302928272', 14.5, 'POLYGON Z ((354698 6689066.8 36.9, 354702.6 6689069.7 36.9, 354704.9 6689067.1 36.9, 354707.6 6689063.6 36.9, 354703.4 6689060.3 36.9, 354702.1 6689061.9 36.9, 354698 6689066.8 36.9))'),
            ('BATIMENT0000000302929191', 13.9, 'POLYGON Z ((354690.9 6689242.6 41.2, 354694 6689240.4 41.2, 354693.4 6689239.4 41.2, 354690.2 6689241.6 41.2, 354690.9 6689242.6 41.2))'),
            ('BATIMENT0000000302928031', 18.5, 'POLYGON Z ((354742.1 6689127.5 41.9, 354740.6 6689130.8 41.9, 354745.1 6689132.7 41.9, 354746.5 6689129.4 41.9, 354742.1 6689127.5 41.9))'),
            ('BATIMENT0000000302927486', 20.9, 'POLYGON Z ((354906 6689126.4 39.6, 354910.2 6689121.7 39.6, 354912 6689119.5 39.6, 354908.8 6689116.8 39.6, 354902.6 6689123.7 39.6, 354906 6689126.4 39.6))'),
            ('BATIMENT0000000302927394', 10.3, 'POLYGON Z ((354913.6 6689033.9 24.8, 354912.5 6689035.2 24.8, 354914.5 6689036.4 24.8, 354915.5 6689035.2 24.8, 354914.4 6689034.5 24.8, 354913.6 6689033.9 24.8))'),
            ('BATIMENT0000000302928103', 11.1, 'POLYGON Z ((354811.1 6689251.6 36, 354812.4 6689250.7 36, 354810.8 6689249.3 36, 354810 6689250.1 36, 354811.1 6689251.6 36))'),
            ('BATIMENT0000000302928276', 16.8, 'POLYGON Z ((354701.1 6689060.9 38.9, 354702.1 6689061.9 38.9, 354703.4 6689060.3 38.9, 354704.7 6689058.9 38.9, 354703.2 6689057.6 38.9, 354701.1 6689060.9 38.9))'),
            ('BATIMENT0000000302928101', 21.2, 'POLYGON Z ((354789.6 6689262.1 48.4, 354791.4 6689262.1 48.4, 354791.4 6689261.7 48.4, 354791.4 6689260.6 48.4, 354789.7 6689260.6 48.4, 354789.6 6689262.1 48.4))'),
            ('BATIMENT0000000302928347', 20.4, 'POLYGON Z ((354860 6689146.7 40.5, 354859 6689144.9 40.5, 354858 6689145.6 40.5, 354859.1 6689147.1 40.5, 354860 6689146.7 40.5))'),
            ('BATIMENT0000000302927485', 22.6, 'POLYGON Z ((354914.1 6689121.3 40.9, 354917.8 6689117.1 40.9, 354912.3 6689112.5 40.9, 354908.8 6689116.8 40.9, 354912 6689119.5 40.9, 354914.1 6689121.3 40.9))'),
            ('BATIMENT0000000302927388', 18.4, 'POLYGON Z ((354906.6 6689015.6 29.8, 354907.8 6689016.4 29.8, 354909.1 6689014.9 29.8, 354908.9 6689014.9 29.8, 354907.5 6689014.2 29.8, 354906.6 6689015.6 29.8))'),
            ('BATIMENT0000000302927574', 23.5, 'POLYGON Z ((354984.5 6689102.1 36.8, 354983.9 6689101.2 36.8, 354980.8 6689103.2 36.8, 354979.6 6689102.9 36.8, 354977.8 6689100.3 36.8, 354976.9 6689100.8 36.8, 354979.9 6689104.9 36.8, 354984.5 6689102.1 36.8))'),
            ('BATIMENT0000000302927488', 19.4, 'POLYGON Z ((354910.2 6689121.7 37.7, 354912.2 6689123.4 37.7, 354914.1 6689121.3 37.7, 354912 6689119.5 37.7, 354910.2 6689121.7 37.7))'),
            ('BATIMENT0000000302929187', 4.8, 'POLYGON Z ((354715.5102564104 6689270 33.7, 354716.7 6689269.2 33.7, 354712 6689262.5 33.7, 354711.6 6689262.7 33.7, 354710.1 6689263.7 33.7, 354703.6 6689267.9 33.7, 354703.4 6689267.8 33.7, 354700.3483870971 6689270 33.7, 354715.5102564104 6689270 33.7))'),
            ('BATIMENT0000000302928040', 16.5, 'POLYGON Z ((354831.8 6689199.8 40.2, 354833.3 6689201.8 40.2, 354837.4 6689199.1 40.2, 354836.3 6689197.3 40.2, 354831.8 6689199.8 40.2))'),
            ('BATIMENT0000000302927496', 18.9, 'POLYGON Z ((354925 6689100.7 36.5, 354923.4 6689102.6 36.5, 354925.7 6689105 36.5, 354927.4 6689103.3 36.5, 354925 6689100.7 36.5))'),
            ('BATIMENT0000000302927477', 14.0, 'POLYGON Z ((354966.9523316062 6689270 33.6, 354968.6 6689254.1 33.6, 354969.3 6689254.2 33.6, 354969.4 6689254 33.6, 354976 6689254.9 33.6, 354975.9 6689255.2 33.6, 354982.2 6689256.1 33.6, 354983.5 6689249.2 33.6, 354991.7 6689251.1 33.6, 354991.9 6689251.2 33.6, 354993.8 6689244.1 33.6, 354982.6 6689240.3 33.6, 354965.4 6689234.4 33.6, 354961.5 6689233.3 33.6, 354956.4 6689231.8 33.6, 354950.7 6689230.2 33.6, 354948 6689253.5 33.6, 354947.3 6689258.7 33.6, 354945.8991735537 6689270 33.6, 354966.9523316062 6689270 33.6))'),
            ('BATIMENT0000000302928019', 16.6, 'POLYGON Z ((354742.2 6689191.4 41.8, 354747.4 6689210.7 41.8, 354757.2 6689207.9 41.8, 354757.8 6689207.8 41.8, 354751.8 6689186 41.8, 354750.6 6689189 41.8, 354742.2 6689191.4 41.8))'),
            ('BATIMENT0000000302927494', 20.5, 'POLYGON Z ((354924.9 6689134.9 38.1, 354918.5 6689141.6 38.1, 354919.2 6689143.3 38.1, 354922.7 6689141 38.1, 354922.9 6689140 38.1, 354923.5 6689139.3 38.1, 354924.7 6689139 38.1, 354925.4 6689139.2 38.1, 354926.8 6689138.2 38.1, 354924.9 6689134.9 38.1))'),
            ('BATIMENT0000000302930228', 11.9, 'POLYGON Z ((355004.5 6689084.1 28.7, 355003.6 6689082.7 28.7, 355002.3 6689083.6 28.7, 355003.1 6689085 28.7, 355004.5 6689084.1 28.7))'),
            ('BATIMENT0000000302927479', 17.6, 'POLYGON Z ((355004.6 6689247.4 34.3, 354999.7 6689246 34.3, 354996.8 6689245.1 34.3, 354993.8 6689244.1 34.3, 354991.9 6689251.2 34.3, 354991.7 6689251.1 34.3, 354991.4 6689252.3 34.3, 354994.3 6689253 34.3, 354994.3 6689253.1 34.3, 354994.3 6689253.2 34.3, 354994.3 6689253.4 34.3, 354994.4 6689253.5 34.3, 354994.5 6689253.6 34.3, 354994.6 6689253.8 34.3, 354994.7 6689253.8 34.3, 354994.8 6689253.9 34.3, 355001.9 6689255.6 34.3, 355002.5 6689256.5 34.3, 355002 6689259.2 34.3, 355003.6 6689259.6 34.3, 355005.3 6689258.8 34.3, 355005.4 6689258.2 34.3, 355007.7 6689248 34.3, 355004.6 6689247.4 34.3))'),
            ('BATIMENT0000000302927738', 11.9, 'POLYGON Z ((354997.5 6689144.7 27.7, 355000.3 6689149 27.7, 355004.6 6689146.1 27.7, 355007.1 6689144.6 27.7, 355006.4 6689143.4 27.7, 355006.1 6689143.6 27.7, 355004.1 6689140.6 27.7, 354997.5 6689144.7 27.7))'),
            ('BATIMENT0000000302930227', 16.3, 'POLYGON Z ((355011.9 6689079.7 32.3, 355012.5 6689080.7 32.3, 355015.9 6689078.7 32.3, 355015.2 6689077.7 32.3, 355011.9 6689079.7 32.3))'),
            ('BATIMENT0000000029192601', 7.8, 'POLYGON Z ((354849.6 6688952.3 21.8, 354851.8 6688948.8 21.8, 354846.8 6688946.2 21.8, 354842 6688954.1 21.8, 354829.1 6688975.5 21.8, 354834.5 6688978.5 21.5, 354836.1 6688976.1 21.5, 354840.6 6688978 20.8, 354845.1 6688970.5 20.2, 354840.4 6688967.5 21.6, 354849.6 6688952.3 21.8))'),
            ('BATIMENT0000000302923030', 19.0, 'POLYGON Z ((354794.1 6688889.9 26, 354800.8 6688879.7 26, 354797.2 6688877.8 26, 354791.3 6688888.3 26, 354791.7 6688888.5 26, 354792.5 6688887.1 26, 354794.4 6688888.1 26, 354793.5 6688889.6 26, 354794.1 6688889.9 26))'),
            ('BATIMENT0000000302923031', 17.1, 'POLYGON Z ((354794.1 6688889.9 24, 354793.6 6688890.5 24, 354794.7 6688891.1 24, 354799.1 6688894.1 24, 354806 6688882.3 24, 354800.8 6688879.7 24, 354794.1 6688889.9 24))'),
            ('BATIMENT0000000302923032', 17.8, 'POLYGON Z ((354797.2 6688877.8 24.7, 354788.8 6688873.6 24.7, 354783.8 6688884.4 24.7, 354791.3 6688888.3 24.7, 354797.2 6688877.8 24.7))'),
            ('BATIMENT0000000302923033', 20.8, 'POLYGON Z ((354806 6688882.3 28, 354799.1 6688894.1 28, 354797.4 6688896.9 28, 354795.7 6688897.1 28, 354794 6688900.1 28, 354799.2 6688903.5 28, 354804.1 6688896.4 28, 354805.4 6688894.5 28, 354810.3 6688884.5 28, 354806 6688882.3 28))'),
            ('BATIMENT0000000302923034', 19.7, 'POLYGON Z ((354805.4 6688894.5 26.9, 354804.1 6688896.4 26.9, 354799.2 6688903.5 26.9, 354806.6 6688908.4 26.9, 354809.5 6688906 26.9, 354809.9 6688906.2 26.9, 354810.9 6688904.4 26.9, 354819.4 6688889.1 26.9, 354810.3 6688884.5 26.9, 354805.4 6688894.5 26.9), (354809.7 6688898.5 26.9, 354810.3 6688897.4 26.9, 354812.4 6688898.5 26.9, 354811.3 6688900.5 26.9, 354809.2 6688899.5 26.9, 354809.7 6688898.5 26.9))'),
            ('BATIMENT0000000302923038', 18.0, 'POLYGON Z ((354769.1 6688921.6 33.7, 354780.7 6688931.4 33.7, 354787.5 6688923.5 33.7, 354775.5 6688913.5 33.7, 354769.1 6688921.6 33.7))'),
            ('BATIMENT0000000302923039', 19.0, 'POLYGON Z ((354810.9 6688904.4 26, 354814.7 6688906.6 26, 354817 6688907.9 26, 354820.5 6688901.2 26, 354825.2 6688892.2 26, 354819.4 6688889.1 26, 354810.9 6688904.4 26))'),
            ('BATIMENT0000000302923040', 18.3, 'POLYGON Z ((354820.5 6688901.2 25.3, 354824.2 6688903.3 25.3, 354821 6688908.8 25.3, 354819.8 6688908.2 25.3, 354818.5 6688910.5 25.3, 354813.9 6688908 25.3, 354807.8 6688918.4 25.3, 354808 6688918.8 25.3, 354804.5 6688924.7 25.3, 354810.3 6688928 25.3, 354811.2 6688928.5 25.3, 354814.4 6688922.8 25.3, 354811.6 6688921.2 25.3, 354813.6 6688917.9 25.3, 354816.3 6688919.5 25.3, 354816.6 6688919 25.3, 354817.2 6688917.9 25.3, 354818.4 6688915.8 25.3, 354824.8 6688919.7 25.3, 354827.6 6688915.2 25.3, 354825.4 6688913.9 25.3, 354827.9 6688909.5 25.3, 354830.4 6688910.9 25.3, 354831.4 6688909.2 25.3, 354838.1 6688898.9 25.3, 354825.2 6688892.2 25.3, 354820.5 6688901.2 25.3))'),
            ('BATIMENT0000000302923041', 17.9, 'POLYGON Z ((354831.8 6688923.6 24.9, 354844.8 6688902.4 24.9, 354838.1 6688898.9 24.9, 354831.4 6688909.2 24.9, 354833 6688910.1 24.9, 354829.4 6688916.2 24.9, 354827.6 6688915.2 24.9, 354824.8 6688919.7 24.9, 354831.8 6688923.6 24.9))'),
            ('BATIMENT0000000302923043', 14.9, 'POLYGON Z ((354827.2 6688928.6 24, 354831.8 6688923.6 24, 354824.8 6688919.7 24, 354818.4 6688915.8 24, 354817.2 6688917.9 24, 354818.5 6688918.8 24, 354820.3 6688919.9 24, 354819.6 6688921 24, 354818.7 6688922.9 24, 354827.2 6688928.6 24))'),
            ('BATIMENT0000000302923045', 17.6, 'POLYGON Z ((354840.7 6688922.1 24.7, 354851.9 6688928.4 24.7, 354845.4 6688937.2 24.7, 354847.7 6688938.5 24.7, 354853.6 6688931.2 24.7, 354855.6 6688924.8 24.7, 354858.8 6688915.6 24.7, 354861.2 6688910.8 24.7, 354846.5 6688903.4 24.7, 354837.7 6688920.1 24.7, 354836 6688921.4 24.7, 354832.4 6688927.6 24.7, 354835.7 6688930 24.7, 354840.7 6688922.1 24.7))'),
            ('BATIMENT0000000302923046', 23.1, 'POLYGON Z ((354867.3 6688913.8 30.2, 354861.2 6688910.8 30.2, 354858.8 6688915.6 30.2, 354855.6 6688924.8 30.2, 354857.8 6688926 30.2, 354858.4 6688926.3 30.2, 354855.4 6688932.3 30.2, 354854.6 6688931.9 30.2, 354853.6 6688931.2 30.2, 354847.7 6688938.5 30.2, 354853.3 6688941.1 30.2, 354853.4 6688940.8 30.2, 354857 6688933.7 30.2, 354857.6 6688933.7 30.2, 354859.5 6688929.4 30.2, 354867.3 6688913.8 30.2))'),
            ('BATIMENT0000000302923048', 21.9, 'POLYGON Z ((354764.7 6688872.8 28.7, 354769.1 6688874.6 28.7, 354768.7 6688876 28.7, 354781.8 6688881.8 28.7, 354784.8 6688874.4 28.7, 354784.7 6688874.4 28.7, 354785.6 6688872.2 28.7, 354780.5546666663 6688870 28.7, 354765.9790123457 6688870 28.7, 354764.7 6688872.8 28.7))'),
            ('BATIMENT0000000302923049', 21.8, 'POLYGON Z ((354750.9599999998 6688870 28.7, 354747.9 6688875.1 28.7, 354755.9 6688879.7 28.7, 354758.3 6688875.4 28.7, 354759.2 6688875.8 28.7, 354760 6688874.8 28.7, 354759.1 6688874.3 28.7, 354760.6 6688871.9 28.7, 354762.2 6688871.7 28.7, 354764.7 6688872.8 28.7, 354765.9790123457 6688870 28.7, 354750.9599999998 6688870 28.7))'),
            ('BATIMENT0000000302923093', 18.3, 'POLYGON Z ((354706.5795918369 6688870 25.9, 354713.3 6688873.7 25.9, 354715.8371428573 6688870 25.9, 354706.5795918369 6688870 25.9))'),
            ('BATIMENT0000000302923094', 16.7, 'POLYGON Z ((354732.1714285715 6688870 23.7, 354731.6 6688871 23.7, 354730.0347826086 6688870 23.7, 354717.7797101449 6688870 23.7, 354717.2 6688871 23.7, 354719.3 6688872.3 23.7, 354720.3 6688870.4 23.7, 354724.4 6688872.9 23.7, 354722.2 6688876.5 23.7, 354721 6688878.7 23.7, 354714.8 6688875 23.7, 354711.1 6688881.2 23.7, 354716.8 6688883.2 23.7, 354717.9 6688884.2 23.7, 354718.2 6688883.7 23.7, 354721.8 6688885.5 23.7, 354728.5 6688880.3 23.7, 354736.6 6688874.5 23.7, 354739.3236842105 6688870 23.7, 354732.1714285715 6688870 23.7))'),
            ('BATIMENT0000000302923119', 20.7, 'POLYGON Z ((354680 6688911.966666667 35.2, 354681.6 6688910.1 35.2, 354680 6688908.681560284 35.2, 354680 6688911.966666667 35.2))'),
            ('BATIMENT0000000302923120', 8.5, 'POLYGON Z ((354696.4 6688881.6 17.2, 354694.4 6688884.1 17.2, 354699.6 6688888 17.2, 354701.7 6688885.5 17.2, 354696.4 6688881.6 17.2))'),
            ('BATIMENT0000000302923123', 16.3, 'POLYGON Z ((354683.6 6688899.2 27, 354681.5 6688901.8 27, 354685.9 6688905.2 27, 354687.9 6688902.7 27, 354683.6 6688899.2 27))'),
            ('BATIMENT0000000302923124', 26.3, 'POLYGON Z ((354697.7 6688939.3 41.8, 354698.2 6688939.7 41.8, 354708.2 6688927.7 41.8, 354708.4 6688927.8 41.8, 354710.9 6688924.8 41.8, 354713.3 6688927.1 41.8, 354713.9 6688927.6 41.8, 354714.5 6688928 41.8, 354715.2 6688928.3 41.8, 354715.7 6688928.4 41.8, 354716.3 6688928.3 41.8, 354717 6688928 41.8, 354717.5 6688927.5 41.8, 354726 6688917.4 41.8, 354739.3 6688928.2 41.8, 354732.6 6688936.1 41.8, 354734.5 6688937.6 41.8, 354739.2 6688941.1 41.8, 354744.4 6688933.6 41.8, 354752.6 6688922.9 41.8, 354728.5 6688902.5 41.8, 354697.7 6688939.3 41.8))'),
            ('BATIMENT0000000302923126', 4.1, 'POLYGON Z ((354680 6688889.917021276 14.4, 354684.2 6688882.5 14.4, 354680 6688880.182758621 14.4, 354680 6688889.917021276 14.4))'),
            ('BATIMENT0000000302923127', 6.5, 'POLYGON Z ((354683 6688871.3 14.7, 354680 6688876.517391304 14.7, 354680 6688880.182758621 14.7, 354684.2 6688882.5 14.7, 354688.8 6688874.6 14.7, 354689.4 6688873.6 14.7, 354683.6 6688870.4 14.7, 354683 6688871.3 14.7))'),
            ('BATIMENT0000000302923362', 9.5, 'POLYGON Z ((354810.3 6688928 24, 354806.4 6688934.9 24, 354817 6688940.8 24, 354821.6 6688934.4 24, 354811.2 6688928.5 24, 354810.3 6688928 24))'),
            ('BATIMENT0000000302923363', 12.3, 'POLYGON Z ((354821.6 6688934.4 23, 354827.2 6688928.6 23, 354818.7 6688922.9 23, 354815.7 6688920.6 23, 354814.4 6688922.8 23, 354811.2 6688928.5 23, 354821.6 6688934.4 23))'),
            ('BATIMENT0000000302923364', 17.4, 'POLYGON Z ((354780.7 6688931.4 33.7, 354792.6 6688941.3 33.7, 354796.4 6688936.1 33.7, 354796.6 6688936.3 33.7, 354798.7 6688933 33.7, 354787.5 6688923.5 33.7, 354780.7 6688931.4 33.7))'),
            ('BATIMENT0000000302923365', 19.0, 'POLYGON Z ((354792.6 6688941.3 33.7, 354807.3 6688953.9 33.7, 354813.3 6688945.6 33.7, 354798.7 6688933 33.7, 354796.6 6688936.3 33.7, 354796.4 6688936.1 33.7, 354792.6 6688941.3 33.7))'),
            ('BATIMENT0000000302923374', 7.9, 'POLYGON Z ((354680 6689011.566265061 27.4, 354681.7 6689013 27.4, 354690 6689003.4 27.4, 354696 6688996.2 27.4, 354690.7 6688991.6 27.4, 354689.3 6688990.5 27.4, 354687.5 6688989.1 27.4, 354681.7 6688996.2 27.4, 354683 6688997.1 27.4, 354680.9 6688999.8 27.4, 354680 6688998.969230769 27.4, 354680 6689011.566265061 27.4))'),
            ('BATIMENT0000000302923376', 8.5, 'POLYGON Z ((354680 6688977.162068966 26.4, 354680.2 6688976.9 26.4, 354680 6688976.729508197 26.4, 354680 6688977.162068966 26.4))'),
            ('BATIMENT0000000302923380', 19.6, 'POLYGON Z ((354681.1 6688996.9 38.5, 354681.7 6688996.2 38.5, 354687.5 6688989.1 38.5, 354680 6688982.85 38.5, 354680 6688995.986792454 38.5, 354681.1 6688996.9 38.5))'),
            ('BATIMENT0000000302923382', 8.2, 'POLYGON Z ((354690.7 6688991.6 26.2, 354696 6688996.2 26.2, 354696.9 6688996.8 26.2, 354700 6688993.4 26.2, 354693.5 6688988.2 26.2, 354692.1 6688989.8 26.2, 354690.7 6688991.6 26.2))'),
            ('BATIMENT0000000302923383', 19.9, 'POLYGON Z ((354714.1 6689011 39.1, 354727.5 6688995.7 39.1, 354727.3 6688989.7 39.1, 354713.2 6688978 39.1, 354705.1 6688987.3 39.1, 354706.4 6688988.5 39.1, 354711.6 6688992.8 39.1, 354711.3 6688995.6 39.1, 354707.4 6688999.8 39.1, 354700 6688993.4 39.1, 354696.9 6688996.8 39.1, 354704.5 6689003.1 39.1, 354714.1 6689011 39.1))'),
            ('BATIMENT0000000302923384', 21.6, 'POLYGON Z ((354680 6688967.185294117 37.7, 354686.7 6688972.9 37.7, 354685.5 6688974.3 37.7, 354680 6688981.003125 37.7, 354680 6688982.85 37.7, 354687.5 6688989.1 37.7, 354689.3 6688990.5 37.7, 354690.7 6688988.9 37.7, 354697 6688981.2 37.7, 354703.6 6688986.9 37.7, 354703.4 6688987.9 37.7, 354704.2 6688988.4 37.7, 354705.1 6688987.3 37.7, 354713.2 6688978 37.7, 354687.1 6688956.3 37.7, 354680 6688964.804395605 37.7, 354680 6688967.185294117 37.7), (354690 6688977.8 37.7, 354691.5 6688976 37.7, 354694.2 6688978.3 37.7, 354691.8 6688981.1 37.7, 354689.1 6688978.8 37.7, 354690 6688977.8 37.7))'),
            ('BATIMENT0000000302923387', 13.1, 'POLYGON Z ((354687.1 6688956.3 29.2, 354680 6688950.292307693 29.2, 354680 6688964.804395605 29.2, 354687.1 6688956.3 29.2))'),
            ('BATIMENT0000000302923389', 19.0, 'POLYGON Z ((354698.2 6688939.7 35.7, 354713.1 6688952.3 35.7, 354723 6688940.6 35.7, 354710.6 6688930.2 35.7, 354713.3 6688927.1 35.7, 354710.9 6688924.8 35.7, 354708.4 6688927.8 35.7, 354708.2 6688927.7 35.7, 354698.2 6688939.7 35.7))'),
            ('BATIMENT0000000302923390', 19.6, 'POLYGON Z ((354713.1 6688952.3 37.2, 354726.5 6688963.6 37.2, 354734.5 6688954.3 37.2, 354724.7 6688946.2 37.2, 354726.5 6688943.8 37.2, 354723 6688940.6 37.2, 354713.1 6688952.3 37.2))'),
            ('BATIMENT0000000302923391', 5.7, 'POLYGON Z ((354732.6 6688936.1 23.3, 354729.1 6688933.5 23.3, 354723.3 6688940.4 23.3, 354723 6688940.6 23.3, 354726.5 6688943.8 23.3, 354728.2 6688945.2 23.3, 354734.5 6688937.6 23.3, 354732.6 6688936.1 23.3))'),
            ('BATIMENT0000000302923392', 21.7, 'POLYGON Z ((354739.2 6688941.1 39.7, 354742.8 6688943.5 39.7, 354747.7 6688947.3 39.7, 354750 6688948.6 39.7, 354750.1 6688948.9 39.7, 354751 6688949.7 39.7, 354750.8 6688950 39.7, 354759.9 6688958.4 39.7, 354773.2 6688943.2 39.7, 354773 6688940.2 39.7, 354752.6 6688922.9 39.7, 354744.4 6688933.6 39.7, 354739.2 6688941.1 39.7))'),
            ('BATIMENT0000000302923393', 20.9, 'POLYGON Z ((354726.5 6688963.6 39.7, 354740.5 6688975.3 39.7, 354745.4 6688975 39.7, 354759.9 6688958.4 39.7, 354750.8 6688950 39.7, 354743 6688959.1 39.7, 354743.1 6688960 39.7, 354740.4 6688960.4 39.7, 354740.1 6688959.3 39.7, 354734.5 6688954.3 39.7, 354726.5 6688963.6 39.7))'),
            ('BATIMENT0000000302923435', 20.1, 'POLYGON Z ((354982.9 6688971.1 26.9, 354978.5 6688981.6 26.9, 354972.1 6688997.4 26.9, 354981.3 6689001.6 26.9, 354984.5 6688993.7 26.9, 354981.8 6688992.5 26.9, 354981.1 6688992.4 26.9, 354982.1 6688989.2 26.9, 354983 6688988.8 26.9, 354983.6 6688987.5 26.9, 354983.2 6688987.1 26.9, 354984.3 6688984.2 26.9, 354985.1 6688984.5 26.9, 354987.9 6688985.7 26.9, 354990.7 6688978.8 26.9, 354992 6688975.6 26.9, 354982.9 6688971.1 26.9))'),
            ('BATIMENT0000000302923436', 18.9, 'POLYGON Z ((354990.7 6688978.8 25.7, 354987.9 6688985.7 25.7, 354987.2 6688987.3 25.7, 354988.4 6688987.9 25.7, 354986.5 6688992.6 25.7, 354985.3 6688992.1 25.7, 354984.5 6688993.7 25.7, 354981.3 6689001.6 25.7, 354991.3 6689006.2 25.7, 354991.8 6689005.3 25.7, 354997.1 6688994.5 25.7, 354993.8 6688993.2 25.7, 354994.2 6688991.9 25.7, 354995 6688989.9 25.7, 354998.7 6688991.4 25.7, 355003.2 6688981 25.7, 354992 6688975.6 25.7, 354990.7 6688978.8 25.7), (354989.4 6688998.6 25.7, 354990.5 6688996.2 25.7, 354992.5 6688997.1 25.7, 354991.5 6688999.5 25.7, 354989.4 6688998.6 25.7))'),
            ('BATIMENT0000000302923437', 8.2, 'POLYGON Z ((354975.3 6688979.9 15.2, 354974 6688979.3 15.2, 354972.7 6688980.7 15.2, 354964.8 6688993.9 15.2, 354972.1 6688997.4 15.2, 354978.5 6688981.6 15.2, 354975.3 6688979.9 15.2))'),
            ('BATIMENT0000000302923438', 16.9, 'POLYGON Z ((354975.4 6688967.4 23.7, 354972.7 6688972.9 23.7, 354970.9 6688976.4 23.7, 354972.8 6688977.3 23.7, 354973.8 6688976.4 23.7, 354976.4 6688977.6 23.7, 354975.3 6688979.9 23.7, 354978.5 6688981.6 23.7, 354982.9 6688971.1 23.7, 354975.4 6688967.4 23.7))'),
            ('BATIMENT0000000302923439', 18.5, 'POLYGON Z ((354991.8 6689005.3 25.3, 354994.6 6689006.5 25.3, 354997.6 6689002.2 25.3, 355002.4 6688997.1 25.3, 355010 6688984.4 25.3, 355003.2 6688981 25.3, 354998.7 6688991.4 25.3, 354997.8 6688993.2 25.3, 354997.1 6688994.5 25.3, 354991.8 6689005.3 25.3))'),
            ('BATIMENT0000000302923442', 15.1, 'POLYGON Z ((354948.1 6688997.1 22, 354952.6 6688999.5 22, 354961.6 6688984.7 22, 354968 6688973.5 22, 354969.2 6688971.2 22, 354972.1 6688965.7 22, 354967.5 6688963.4 22, 354954.1 6688986.5 22, 354953.3 6688988 22, 354948.1 6688997.1 22))'),
            ('BATIMENT0000000302923443', 18.0, 'POLYGON Z ((354958.7 6688969.8 24.9, 354957.7 6688971.6 24.9, 354950.4 6688984.6 24.9, 354954.1 6688986.5 24.9, 354967.5 6688963.4 24.9, 354963.5 6688961.4 24.9, 354958.7 6688969.8 24.9))'),
            ('BATIMENT0000000302923446', 3.1, 'POLYGON Z ((354957.7 6688971.6 10, 354954 6688969.5 10, 354953.7 6688970.2 10, 354951.5 6688969.2 10, 354951.2 6688969.5 10, 354947.8 6688967.8 10, 354943 6688976.5 10, 354932.4 6688971 10, 354932.1 6688971.3 10, 354929.9 6688970.1 10, 354925.4 6688978.5 10, 354947 6688990.2 10, 354949.6 6688986.2 10, 354950.4 6688984.6 10, 354957.7 6688971.6 10))'),
            ('BATIMENT0000000302923447', 24.6, 'POLYGON Z ((354922.7 6688977.5 31.5, 354922.8 6688977.3 31.5, 354934.7 6688957.7 31.5, 354958.7 6688969.8 31.5, 354963.5 6688961.4 31.5, 354937 6688948.5 31.5, 354927.6 6688951.2 31.5, 354915 6688972.7 31.5, 354922.7 6688977.5 31.5))'),
            ('BATIMENT0000000302923448', 16.7, 'POLYGON Z ((354915 6688972.7 24.5, 354911.2 6688978.8 24.5, 354919 6688983.5 24.5, 354922.7 6688977.5 24.5, 354915 6688972.7 24.5))'),
            ('BATIMENT0000000302923449', 19.1, 'POLYGON Z ((354911.2 6688978.8 27.7, 354905.9 6688988 27.7, 354913.5 6688992.4 27.7, 354919 6688983.5 27.7, 354911.2 6688978.8 27.7))'),
            ('BATIMENT0000000302923450', 16.8, 'POLYGON Z ((354905.9 6688988 27.4, 354900.1 6688997.5 27.4, 354907.6 6689002.3 27.4, 354909.6 6688999.1 27.4, 354913.5 6688992.4 27.4, 354905.9 6688988 27.4))'),
            ('BATIMENT0000000302923452', 16.7, 'POLYGON Z ((354900.1 6688997.5 27.4, 354895.2 6689005.8 27.4, 354902.7 6689010.6 27.4, 354906.2 6689004.9 27.4, 354907.6 6689002.3 27.4, 354900.1 6688997.5 27.4))'),
            ('BATIMENT0000000302923453', 14.6, 'POLYGON Z ((354930.6 6689022.3 24.7, 354918.5 6689013.4 24.7, 354926.5 6689001.9 24.7, 354926.9 6689001.3 24.7, 354922.2 6688997.4 24.7, 354921.4 6688998.1 24.7, 354917.2 6689004.2 24.7, 354913.5 6689009.8 24.7, 354913.1 6689009.6 24.7, 354909.1 6689014.9 24.7, 354911.8 6689016.8 24.7, 354917.1 6689020.6 24.7, 354922.6 6689024.6 24.7, 354927.9 6689028.3 24.7, 354929.4 6689026.2 24.7, 354928.7 6689025.6 24.7, 354929 6689024.8 24.7, 354930.6 6689022.3 24.7))'),
            ('BATIMENT0000000302923454', 2.9, 'POLYGON Z ((354926.5 6689001.9 11.5, 354930.8 6689006.1 11.5, 354931.3 6689005.5 11.5, 354935.2 6688998.9 11.5, 354918.8 6688989.9 11.5, 354916.1 6688994.9 11.5, 354921.4 6688998.1 11.5, 354922.2 6688997.4 11.5, 354926.9 6689001.3 11.5, 354926.5 6689001.9 11.5))'),
            ('BATIMENT0000000302923455', 2.8, 'POLYGON Z ((354979.1 6689007.4 10.9, 354962 6688998.8 10.9, 354948.6 6689021.8 10.9, 354953.4 6689024.6 10.9, 354964.1 6689006.4 10.9, 354976.7 6689012.5 10.9, 354978.4 6689008.8 10.9, 354979.1 6689007.4 10.9))'),
            ('BATIMENT0000000302923482', 23.1, 'POLYGON Z ((354822.1 6689021.1 39, 354845 6689040.4 39, 354851.6 6689032.7 39, 354848.8 6689030.3 39, 354851.7 6689026.8 39, 354854.5 6689029.1 39, 354855 6689028.5 39, 354864.1 6689017.8 39, 354856.4 6689011.3 39, 354850.6 6689018.3 39, 354842.9 6689011.8 39, 354848.8 6689004.8 39, 354841.3 6688998.5 39, 354831.3 6689010.2 39, 354834.6 6689013 39, 354831.6 6689016.3 39, 354828.4 6689013.7 39, 354822.1 6689021.1 39))'),
            ('BATIMENT0000000302923483', 21.1, 'POLYGON Z ((354810.8 6689011.6 38, 354822.1 6689021.1 38, 354828.4 6689013.7 38, 354826.6 6689012.3 38, 354828.1 6689010.7 38, 354829.8 6689012 38, 354831.3 6689010.2 38, 354841.3 6688998.5 38, 354837.6 6688995.4 38, 354831.1 6689003 38, 354829.7 6689004.8 38, 354829.4 6689004.5 38, 354826.4 6689008.2 38, 354822.1 6689004.6 38, 354825.2 6689000.9 38, 354822.1 6688998.3 38, 354819 6689001.9 38, 354810.8 6689011.6 38))'),
            ('BATIMENT0000000302923484', 17.2, 'POLYGON Z ((354837.6 6688995.4 35.1, 354829.9 6688988.9 35.1, 354822.1 6688998.3 35.1, 354825.2 6689000.9 35.1, 354826.7 6688999.3 35.1, 354831.1 6689003 35.1, 354837.6 6688995.4 35.1))'),
            ('BATIMENT0000000302923485', 18.0, 'POLYGON Z ((354792.5 6688996.2 36, 354799.3 6688988 36, 354787.9 6688978.3 36, 354781 6688986.5 36, 354792.5 6688996.2 36))'),
            ('BATIMENT0000000302923486', 6.8, 'POLYGON Z ((354777.2 6688953.9 25.5, 354762.3 6688970.8 25.5, 354781 6688986.5 25.5, 354787.9 6688978.3 25.5, 354791.9 6688973.5 25.5, 354793.7 6688971.3 25.5, 354789.2 6688967.5 25.5, 354785 6688972.6 25.5, 354785.1 6688972.7 25.5, 354783.5 6688974.8 25.5, 354779.7 6688971.6 25.5, 354779.5 6688971.7 25.5, 354774.5 6688967.4 25.5, 354782.3 6688958.2 25.5, 354777.2 6688953.9 25.5))'),
            ('BATIMENT0000000302923487', 9.2, 'POLYGON Z ((354782.3 6688958.2 27.1, 354791 6688965.4 27.1, 354795.6 6688960 27.1, 354781.8 6688948.3 27.1, 354777.2 6688953.9 27.1, 354782.3 6688958.2 27.1))'),
            ('BATIMENT0000000302923488', 10.0, 'POLYGON Z ((354791 6688965.4 27.9, 354795.6 6688969.2 27.9, 354807.2 6688978.6 27.9, 354811.6 6688973.4 27.9, 354795.6 6688960 27.9, 354791 6688965.4 27.9))'),
            ('BATIMENT0000000302923535', 7.7, 'POLYGON Z ((354680 6688876.517391304 16.2, 354683 6688871.3 16.2, 354683.6 6688870.4 16.2, 354682.6864864856 6688870 16.2, 354680 6688870 16.2, 354680 6688876.517391304 16.2))'),
            ('BATIMENT0000000302923563', 18.4, 'POLYGON Z ((354792.5 6688996.2 36.3, 354810.8 6689011.6 36.3, 354819 6689001.9 36.3, 354813.7 6688997.6 36.3, 354806.9 6688992 36.3, 354817.8 6688978.7 36.3, 354811.6 6688973.4 36.3, 354807.2 6688978.6 36.3, 354803.3 6688983.2 36.3, 354799.3 6688988 36.3, 354792.5 6688996.2 36.3))'),
            ('BATIMENT0000000302923580', 8.6, 'POLYGON Z ((354943.9 6689013.6 17.2, 354950.3 6689002.8 17.2, 354944.6 6688999.3 17.2, 354938.2 6689009.8 17.2, 354943.9 6689013.6 17.2))'),
            ('BATIMENT0000000302927293', 16.4, 'POLYGON Z ((355020 6688989.5 23.2, 355012.2 6688985.6 23.2, 355009.6 6688990.1 23.2, 354997.2 6689007.3 23.2, 355001.2 6689009.5 23.2, 355005.9 6689008.2 23.2, 355006.9 6689005.7 23.2, 355002.5 6689003.2 23.2, 355002.9 6689002.7 23.2, 355003.8 6689001.9 23.2, 355005.4 6689002.7 23.2, 355005.8 6689002 23.2, 355007.9 6689003 23.2, 355007.3 6689004.6 23.2, 355011.4 6689006.7 23.2, 355015 6689000.3 23.2, 355020 6688991.334482759 23.2, 355020 6688989.5 23.2))'),
            ('BATIMENT0000000302927375', 21.5, 'POLYGON Z ((354681.7 6689013 42.1, 354698.9 6689027.5 42.1, 354700.2 6689027.1 42.1, 354714.1 6689011 42.1, 354704.5 6689003.1 42.1, 354698.6 6689009.8 42.1, 354696.6 6689010.2 42.1, 354696.5 6689009.5 42.1, 354690 6689003.4 42.1, 354681.7 6689013 42.1))'),
            ('BATIMENT0000000302927376', 19.2, 'POLYGON Z ((355001.2 6689009.5 27.2, 354998.2 6689010.4 27.2, 355001.5 6689020.2 27.2, 355011.1 6689017.5 27.2, 355007.8 6689007.6 27.2, 355005.9 6689008.2 27.2, 355001.2 6689009.5 27.2))'),
            ('BATIMENT0000000302927377', 18.9, 'POLYGON Z ((354998.2 6689010.4 27.6, 354985.5 6689014.2 27.6, 354988.9 6689023.8 27.6, 355001.5 6689020.2 27.6, 354998.2 6689010.4 27.6))'),
            ('BATIMENT0000000302927378', 19.5, 'POLYGON Z ((354985.5 6689014.2 28.7, 354975.3 6689018 28.7, 354979.2 6689026.9 28.7, 354988.9 6689023.8 28.7, 354985.5 6689014.2 28.7))'),
            ('BATIMENT0000000302927379', 19.4, 'POLYGON Z ((354975.3 6689018 29.1, 354962.4 6689024 29.1, 354967.2 6689032.5 29.1, 354972.2 6689029.9 29.1, 354979.2 6689026.9 29.1, 354975.3 6689018 29.1))'),
            ('BATIMENT0000000302927380', 19.7, 'POLYGON Z ((354962.4 6689024 29.9, 354952.6 6689029.7 29.9, 354958.8 6689037.8 29.9, 354962.9 6689035.3 29.9, 354967.2 6689032.5 29.9, 354962.4 6689024 29.9))'),
            ('BATIMENT0000000302927381', 18.5, 'POLYGON Z ((354952.6 6689029.7 30, 354941.4 6689039 30, 354948.5 6689046 30, 354953.9 6689041.5 30, 354958.8 6689037.8 30, 354952.6 6689029.7 30))'),
            ('BATIMENT0000000302927382', 17.2, 'POLYGON Z ((354941.4 6689039 30.2, 354939.6 6689037.3 30.2, 354935.8 6689041.7 30.2, 354925.3 6689053.7 30.2, 354931 6689058.2 30.2, 354937.3 6689057.7 30.2, 354943.3 6689051.4 30.2, 354948.5 6689046 30.2, 354941.4 6689039 30.2))'),
            ('BATIMENT0000000302927384', 3.0, 'POLYGON Z ((354930.5 6689030.2 15, 354932.8 6689031.9 15, 354934.8 6689028.6 15, 354929 6689024.8 15, 354928.7 6689025.6 15, 354929.4 6689026.2 15, 354927.9 6689028.3 15, 354930.5 6689030.2 15))'),
            ('BATIMENT0000000302927385', 3.4, 'POLYGON Z ((354934.8 6689028.6 15.1, 354936.3 6689026.3 15.1, 354930.6 6689022.3 15.1, 354929 6689024.8 15.1, 354934.8 6689028.6 15.1))'),
            ('BATIMENT0000000302927386', 14.7, 'POLYGON Z ((354905.7 6689024.3 28.2, 354903.7 6689026 28.2, 354906.1 6689027.8 28.2, 354908.9 6689030.2 28.2, 354917.1 6689020.6 28.2, 354911.8 6689016.8 28.2, 354910.7 6689018.4 28.2, 354905.7 6689024.3 28.2))'),
            ('BATIMENT0000000302927387', 14.9, 'POLYGON Z ((354922.3 6689038.7 26.3, 354930.5 6689030.2 26.3, 354927.9 6689028.3 26.3, 354922.6 6689024.6 26.3, 354914.4 6689034.5 26.3, 354915.5 6689035.2 26.3, 354919 6689037.8 26.3, 354919.6 6689036.6 26.3, 354922.3 6689038.7 26.3))'),
            ('BATIMENT0000000302927389', 16.4, 'POLYGON Z ((354892.2 6689010.4 27.9, 354885.8 6689021.2 27.9, 354886.3 6689023.7 27.9, 354896.7 6689032.4 27.9, 354902.4 6689027.2 27.9, 354903.7 6689026 27.9, 354905.7 6689024.3 27.9, 354910.7 6689018.4 27.9, 354907.8 6689016.4 27.9, 354906.6 6689015.6 27.9, 354907.5 6689014.2 27.9, 354906.9 6689013.5 27.9, 354902.7 6689010.6 27.9, 354898.5 6689017.1 27.9, 354892.2 6689010.4 27.9))'),
            ('BATIMENT0000000302927390', 11.8, 'POLYGON Z ((354895.2 6689005.8 24.7, 354892.2 6689010.4 24.7, 354898.5 6689017.1 24.7, 354902.7 6689010.6 24.7, 354895.2 6689005.8 24.7))'),
            ('BATIMENT0000000302927391', 10.9, 'POLYGON Z ((354938.2 6689009.8 21.5, 354932.2 6689019.8 21.5, 354938.2 6689023.1 21.5, 354943.9 6689013.6 21.5, 354938.2 6689009.8 21.5))'),
            ('BATIMENT0000000302927392', 12.4, 'POLYGON Z ((354924.6 6689046.1 26.5, 354927.6 6689042.8 26.5, 354922.3 6689038.7 26.5, 354919.6 6689036.6 26.5, 354919 6689037.8 26.5, 354915.5 6689035.2 26.5, 354914.5 6689036.4 26.5, 354912.5 6689035.2 26.5, 354913.6 6689033.9 26.5, 354909.5 6689030.6 26.5, 354907.6 6689033.3 26.5, 354911.9 6689036.3 26.5, 354914.7 6689038.6 26.5, 354916.2 6689039.7 26.5, 354924.6 6689046.1 26.5))'),
            ('BATIMENT0000000302927393', 15.1, 'POLYGON Z ((354896.7 6689032.4 30, 354903.6 6689038.3 30, 354907.6 6689033.3 30, 354909.5 6689030.6 30, 354908.9 6689030.2 30, 354906.1 6689027.8 30, 354904.9 6689029.2 30, 354902.4 6689027.2 30, 354896.7 6689032.4 30))'),
            ('BATIMENT0000000302927395', 16.3, 'POLYGON Z ((354903.6 6689038.3 31, 354904.1 6689038.8 31, 354904.5 6689038.6 31, 354907.4 6689042.4 31, 354919.8 6689051.8 31, 354924.6 6689046.1 31, 354916.2 6689039.7 31, 354914.5 6689041.7 31, 354913.1 6689040.6 31, 354914.7 6689038.6 31, 354911.9 6689036.3 31, 354907.6 6689033.3 31, 354903.6 6689038.3 31))'),
            ('BATIMENT0000000302927408', 17.6, 'POLYGON Z ((354680 6689050.125 38.4, 354692.6 6689035.8 38.4, 354692.7 6689034.5 38.4, 354680 6689023.738421053 38.4, 354680 6689050.125 38.4))'),
            ('BATIMENT0000000302927417', 22.2, 'POLYGON Z ((354870.3 6689061.7 37.8, 354890.5 6689078.8 37.8, 354898.4 6689069.7 37.8, 354895.7 6689067.7 37.8, 354897.8 6689065 37.8, 354900.3 6689067.1 37.8, 354901.1 6689066.4 37.8, 354909.6 6689056.3 37.8, 354904.3 6689051.8 37.8, 354895.8 6689061.9 37.8, 354885.3 6689053.8 37.8, 354893.9 6689043 37.8, 354889.1 6689039 37.8, 354880.2 6689049.7 37.8, 354879.2 6689051 37.8, 354880.3 6689051.8 37.8, 354880.8 6689055.1 37.8, 354879.9 6689056.2 37.8, 354876.9 6689053.8 37.8, 354870.3 6689061.7 37.8))'),
            ('BATIMENT0000000302927418', 22.1, 'POLYGON Z ((354845 6689040.4 37.4, 354870.3 6689061.7 37.4, 354876.9 6689053.8 37.4, 354877.2 6689053.4 37.4, 354874.1 6689050.9 37.4, 354877.2 6689047.2 37.4, 354880.2 6689049.7 37.4, 354889.1 6689039 37.4, 354881.6 6689032.6 37.4, 354873.2 6689042.7 37.4, 354863.1 6689034.5 37.4, 354871.6 6689024.1 37.4, 354864.1 6689017.8 37.4, 354855 6689028.5 37.4, 354857.7 6689030.7 37.4, 354855.1 6689033.8 37.4, 354852.4 6689031.6 37.4, 354851.6 6689032.7 37.4, 354845 6689040.4 37.4))'),
            ('BATIMENT0000000302927419', 18.3, 'POLYGON Z ((354913.4 6689086.9 36.2, 354924.4 6689074 36.2, 354923.9 6689068.3 36.2, 354909.6 6689056.3 36.2, 354901.1 6689066.4 36.2, 354903.4 6689068.3 36.2, 354903.2 6689068.8 36.2, 354904.4 6689069.8 36.2, 354906 6689067.2 36.2, 354910.4 6689070.5 36.2, 354908.4 6689073 36.2, 354912.2 6689076.2 36.2, 354910.9 6689077.5 36.2, 354907.2 6689081.7 36.2, 354913.4 6689086.9 36.2))'),
            ('BATIMENT0000000302927420', 18.7, 'POLYGON Z ((354890.5 6689078.8 36.6, 354888.5 6689081 36.6, 354899.5 6689090.3 36.6, 354893.3 6689097.6 36.6, 354900 6689103.1 36.6, 354913.4 6689086.9 36.6, 354907.2 6689081.7 36.6, 354910.9 6689077.5 36.6, 354902.1 6689070.3 36.6, 354903.2 6689068.8 36.6, 354903.4 6689068.3 36.6, 354901.1 6689066.4 36.6, 354900.3 6689067.1 36.6, 354898.4 6689069.7 36.6, 354890.5 6689078.8 36.6))'),
            ('BATIMENT0000000302927497', 16.2, 'POLYGON Z ((354953.2 6689112.3 33.2, 354947.9 6689104.3 33.2, 354946.7 6689104.2 33.2, 354933.8 6689118.6 33.2, 354938.3 6689123 33.2, 354953.2 6689112.3 33.2))'),
            ('BATIMENT0000000302927475', 22.6, 'POLYGON Z ((354965.4 6689234.4 40.6, 354982.6 6689240.3 40.6, 354987.5 6689226 40.6, 354971.7 6689219.2 40.6, 354965.4 6689234.4 40.6))'),
            ('BATIMENT0000000302927476', 20.9, 'POLYGON Z ((354987.5 6689226 37.6, 354982.6 6689240.3 37.6, 354993.8 6689244.1 37.6, 354996.8 6689245.1 37.6, 354997.1 6689244 37.6, 354996.1 6689243.5 37.6, 354996.6 6689242.4 37.6, 355000.7 6689244 37.6, 354999.7 6689246 37.6, 355004.6 6689247.4 37.6, 355007.5 6689241.5 37.6, 355004.2 6689240.2 37.6, 355006.6 6689234.4 37.6, 354987.5 6689226 37.6))'),
            ('BATIMENT0000000302927478', 22.2, 'POLYGON Z ((354971.7 6689219.2 40.9, 354956.5 6689212.8 40.9, 354949.2 6689229.7 40.9, 354950.7 6689230.2 40.9, 354956.4 6689231.8 40.9, 354956.8 6689230.6 40.9, 354954.1 6689229.7 40.9, 354954.7 6689228.1 40.9, 354954.4 6689226.8 40.9, 354955.5 6689226.1 40.9, 354957.1 6689227.5 40.9, 354957.6 6689227.9 40.9, 354958.6 6689227.9 40.9, 354959.1 6689227.7 40.9, 354961.5 6689228.8 40.9, 354962.8 6689228.6 40.9, 354963.1 6689229.8 40.9, 354962.4 6689230.6 40.9, 354961.5 6689233.3 40.9, 354965.4 6689234.4 40.9, 354971.7 6689219.2 40.9))'),
            ('BATIMENT0000000302927480', 8.2, 'POLYGON Z ((354934.3 6689269.4 31, 354939.2285714275 6689270 31, 354945.8991735537 6689270 31, 354947.3 6689258.7 31, 354948 6689253.5 31, 354933.7 6689254.4 31, 354934 6689259.6 31, 354930.4 6689259.8 31, 354930.5 6689263.9 31, 354934.1 6689263.8 31, 354934.3 6689269.4 31))'),
            ('BATIMENT0000000302928289', 14.4, 'POLYGON Z ((354784.9 6689128.6 36, 354809 6689138.9 36, 354811.6 6689134.1 36, 354792.7 6689118.4 36, 354784.9 6689128.6 36))'),
            ('BATIMENT0000000302927481', 14.6, 'POLYGON Z ((354978.5909090909 6689270 35.5, 354979 6689266 35.5, 354978.9 6689266 35.5, 354978 6689265.9 35.5, 354978.5 6689262.9 35.5, 354978.3 6689262.9 35.5, 354975.1 6689262.6 35.5, 354975.5 6689260.4 35.5, 354978.6 6689260.9 35.5, 354981.5 6689261.3 35.5, 354981.9 6689258.4 35.5, 354975.7 6689257.5 35.5, 354975.9 6689255.2 35.5, 354976 6689254.9 35.5, 354969.4 6689254 35.5, 354969.3 6689254.2 35.5, 354968.6 6689254.1 35.5, 354966.9523316062 6689270 35.5, 354978.5909090909 6689270 35.5))'),
            ('BATIMENT0000000302927482', 18.1, 'POLYGON Z ((354956.5 6689212.8 39.2, 354956.5 6689212.6 39.2, 354933.1 6689202.6 39.2, 354933 6689202.4 39.2, 354928.6 6689200.6 39.2, 354918.4 6689201.5 39.2, 354919 6689209.1 39.2, 354919.3 6689209.1 39.2, 354920.2 6689219.5 39.2, 354920 6689219.5 39.2, 354922.7 6689255 39.2, 354929.3 6689254.5 39.2, 354928.7 6689247.1 39.2, 354932.4 6689246.8 39.2, 354932.2 6689244.2 39.2, 354932.7 6689244 39.2, 354932.9 6689243.9 39.2, 354933.1 6689243.8 39.2, 354933.3 6689243.6 39.2, 354933.4 6689243.5 39.2, 354933.6 6689243.3 39.2, 354933.7 6689243.2 39.2, 354933.8 6689243 39.2, 354933.9 6689242.7 39.2, 354933.9 6689242.6 39.2, 354933.9 6689242.4 39.2, 354933.9 6689242.3 39.2, 354933.5 6689236.9 39.2, 354935.4 6689236.7 39.2, 354935 6689231.6 39.2, 354938.3 6689229.6 39.2, 354941.1 6689231.8 39.2, 354941.7 6689231 39.2, 354945.1 6689230 39.2, 354948.8 6689230.7 39.2, 354949.2 6689229.7 39.2, 354956.5 6689212.8 39.2))'),
            ('BATIMENT0000000302927483', 15.5, 'POLYGON Z ((354922.7 6689255 36.8, 354923.7 6689268.1 36.8, 354934.3 6689269.4 36.8, 354934.1 6689263.8 36.8, 354930.5 6689263.9 36.8, 354930.4 6689259.8 36.8, 354934 6689259.6 36.8, 354933.7 6689254.4 36.8, 354933.7 6689254.2 36.8, 354929.3 6689254.5 36.8, 354922.7 6689255 36.8))'),
            ('BATIMENT0000000302927484', 17.8, 'POLYGON Z ((355002.2028985507 6689270 35.5, 355004 6689263.8 35.5, 355005.3 6689258.8 35.5, 355003.6 6689259.6 35.5, 355002 6689259.2 35.5, 355000.6 6689266.4 35.5, 354979.1 6689263 35.5, 354978.9 6689266 35.5, 354979 6689266 35.5, 354978.5909090909 6689270 35.5, 355002.2028985507 6689270 35.5))'),
            ('BATIMENT0000000302927487', 21.6, 'POLYGON Z ((354911.8 6689103.7 39.6, 354904 6689112.6 39.6, 354908.8 6689116.8 39.6, 354912.3 6689112.5 39.6, 354917.8 6689117.1 39.6, 354914.1 6689121.3 39.6, 354918.8 6689125.2 39.6, 354926.9 6689116.4 39.6, 354918.8 6689109.5 39.6, 354917.9 6689108.6 39.6, 354917.1 6689109.5 39.6, 354917.3 6689111.2 39.6, 354916.7 6689112.1 39.6, 354914.1 6689110 39.6, 354916.4 6689107.3 39.6, 354911.8 6689103.7 39.6))'),
            ('BATIMENT0000000302927489', 19.7, 'POLYGON Z ((354904 6689112.6 38, 354902.3 6689114.6 38, 354901.9 6689114.4 38, 354893 6689125.1 38, 354894.1 6689136.8 38, 354897.5 6689137.5 38, 354902.3 6689139.4 38, 354906 6689142 38, 354907.8 6689143.9 38, 354912.2 6689138.9 38, 354910 6689137 38, 354909 6689136 38, 354918.8 6689125.2 38, 354914.1 6689121.3 38, 354912.2 6689123.4 38, 354910.2 6689121.7 38, 354906 6689126.4 38, 354902.6 6689123.7 38, 354908.8 6689116.8 38, 354904 6689112.6 38))'),
            ('BATIMENT0000000302927490', 21.5, 'POLYGON Z ((354917.8 6689096.7 39.1, 354911.8 6689103.7 39.1, 354916.4 6689107.3 39.1, 354917 6689106.4 39.1, 354919.2 6689106.5 39.1, 354920.5 6689107.8 39.1, 354918.8 6689109.5 39.1, 354926.9 6689116.4 39.1, 354931.7 6689111.1 39.1, 354925.7 6689105 39.1, 354924.9 6689106 39.1, 354922.4 6689104 39.1, 354923.4 6689102.6 39.1, 354917.8 6689096.7 39.1))'),
            ('BATIMENT0000000302927491', 18.7, 'POLYGON Z ((354931.7 6689111.1 36.3, 354939.5 6689102.4 36.3, 354943.9 6689097.6 36.3, 354935.8 6689085.4 36.3, 354936.3 6689085 36.3, 354932.4 6689079.2 36.3, 354926.9 6689085.7 36.3, 354927.4 6689086 36.3, 354917.8 6689096.7 36.3, 354923.4 6689102.6 36.3, 354925 6689100.7 36.3, 354927.7 6689097.7 36.3, 354929.2 6689101.2 36.3, 354927.4 6689103.3 36.3, 354925.7 6689105 36.3, 354931.7 6689111.1 36.3))'),
            ('BATIMENT0000000302927492', 20.4, 'POLYGON Z ((354907.8 6689143.9 38, 354908.3 6689144.4 38, 354910.8 6689147.4 38, 354912.8 6689150.7 38, 354914.4 6689155.4 38, 354925 6689154.6 38, 354933.5 6689148.9 38, 354926.8 6689138.2 38, 354925.4 6689139.2 38, 354924.7 6689139 38, 354923.5 6689139.3 38, 354922.9 6689140 38, 354922.7 6689141 38, 354919.2 6689143.3 38, 354918.5 6689141.6 38, 354924.9 6689134.9 38, 354922 6689131.8 38, 354913.8 6689140.5 38, 354912.8 6689139.4 38, 354912.2 6689138.9 38, 354907.8 6689143.9 38))'),
            ('BATIMENT0000000302927493', 20.0, 'POLYGON Z ((354922 6689131.8 37.6, 354924.9 6689134.9 37.6, 354926.8 6689138.2 37.6, 354933.5 6689148.9 37.6, 354948.4 6689139.5 37.6, 354938.3 6689123 37.6, 354933.8 6689118.6 37.6, 354922 6689131.8 37.6), (354931.3 6689129.3 37.6, 354933.5 6689127.8 37.6, 354934.9 6689128.9 37.6, 354936.3 6689128 37.6, 354938 6689128.2 37.6, 354939.5 6689130.5 37.6, 354938.1 6689131.3 37.6, 354936.7 6689131.2 37.6, 354935.4 6689129.7 37.6, 354933.6 6689131.4 37.6, 354934.6 6689133 37.6, 354933.6 6689134.4 37.6, 354932.8 6689133.7 37.6, 354931.2 6689131.6 37.6, 354931.3 6689129.3 37.6))'),
            ('BATIMENT0000000302927495', 22.8, 'POLYGON Z ((354938.3 6689123 39.5, 354948.4 6689139.5 39.5, 354962.8 6689130.4 39.5, 354963.2 6689127.6 39.5, 354953.2 6689112.3 39.5, 354938.3 6689123 39.5), (354942.7 6689123.5 39.5, 354944.8 6689122.2 39.5, 354946.2 6689123.2 39.5, 354945.5 6689125.4 39.5, 354948.6 6689126.6 39.5, 354948.2 6689127.8 39.5, 354946.1 6689128.9 39.5, 354942.7 6689123.5 39.5))'),
            ('BATIMENT0000000302927593', 21.3, 'POLYGON Z ((354987.9 6689183.8 39.2, 354989.9 6689179.2 39.2, 354989.8 6689179 39.2, 354991.7 6689172 39.2, 354986.5 6689164.1 39.2, 354977.2 6689169.8 39.2, 354978.5 6689171.9 39.2, 354979.2 6689172.4 39.2, 354978.5 6689174.6 39.2, 354973.8 6689175.9 39.2, 354971.9 6689172.9 39.2, 354969.1 6689174.6 39.2, 354968.8 6689174.9 39.2, 354969.3 6689175.7 39.2, 354970.7 6689177.8 39.2, 354978.5 6689181.2 39.2, 354979.2 6689181.4 39.2, 354980.1 6689178.8 39.2, 354982.1 6689179.6 39.2, 354981.6 6689181.5 39.2, 354987.9 6689183.8 39.2))'),
            ('BATIMENT0000000302927572', 21.6, 'POLYGON Z ((355009.4 6689075.6 34.9, 355009 6689075 34.9, 355004.6 6689077.8 34.9, 355007.4 6689082.2 34.9, 355004.5 6689084.1 34.9, 355003.1 6689085 34.9, 355002.3 6689083.6 34.9, 354997.1 6689075 34.9, 354993.3 6689077.5 34.9, 354999.3 6689087.5 34.9, 354996.7 6689089.1 34.9, 355005.5 6689103.6 34.9, 355020 6689094.619354839 34.9, 355020 6689092.440677966 34.9, 355015.1 6689084.8 34.9, 355012.5 6689080.7 34.9, 355011.9 6689079.7 34.9, 355009.4 6689075.6 34.9))'),
            ('BATIMENT0000000302927573', 20.4, 'POLYGON Z ((354991.9 6689090 33.6, 354992.9 6689089.2 33.6, 354995.7 6689093.5 33.6, 354989 6689097.7 33.6, 354986.5 6689094 33.6, 354987.3 6689093.5 33.6, 354986.8 6689092.7 33.6, 354987.6 6689092.2 33.6, 354985.3 6689088.6 33.6, 354983.8 6689089.5 33.6, 354978.6 6689092.8 33.6, 354978.8 6689093.1 33.6, 354981.7 6689097.6 33.6, 354983.9 6689101.2 33.6, 354984.5 6689102.1 33.6, 354991.3 6689112.8 33.6, 355005.5 6689103.6 33.6, 354996.7 6689089.1 33.6, 354995.7 6689087.5 33.6, 354993.3 6689083.4 33.6, 354989.2 6689086 33.6, 354991.9 6689090 33.6))'),
            ('BATIMENT0000000302927575', 24.2, 'POLYGON Z ((354978.8 6689093.1 39, 354971.6 6689097.8 39, 354974 6689101.5 39, 354984.1 6689117.4 39, 354991.3 6689112.8 39, 354984.5 6689102.1 39, 354979.9 6689104.9 39, 354976.9 6689100.8 39, 354977.8 6689100.3 39, 354981.7 6689097.6 39, 354978.8 6689093.1 39))'),
            ('BATIMENT0000000302927580', 16.2, 'POLYGON Z ((354905.9 6689197.7 37.4, 354882.4 6689199.6 37.4, 354882.4 6689201 37.4, 354882.8 6689201 37.4, 354883 6689204.1 37.4, 354878.9 6689204.4 37.4, 354878.5 6689204.4 37.4, 354879.1 6689212.5 37.4, 354879.4 6689212.5 37.4, 354880.6 6689227.4 37.4, 354880.3 6689227.5 37.4, 354882 6689248.8 37.4, 354881.8 6689248.9 37.4, 354883.5 6689269 37.4, 354889.6 6689268.5 37.4, 354889.7 6689269.3 37.4, 354909.5 6689267.7 37.4, 354909.5 6689266.9 37.4, 354915.4 6689266.3 37.4, 354913.8 6689246.4 37.4, 354913.6 6689246.3 37.4, 354911.8 6689225 37.4, 354910.7 6689210.2 37.4, 354911.1 6689210 37.4, 354910.5 6689201.9 37.4, 354910.1 6689201.9 37.4, 354906 6689202.2 37.4, 354905.7 6689199.2 37.4, 354905.9 6689199.1 37.4, 354905.9 6689197.7 37.4))'),
            ('BATIMENT0000000302927581', 15.2, 'POLYGON Z ((354839.7 6689251.5 39.7, 354836.8 6689265.3 39.7, 354840.6 6689270 39.7, 354852.9585365854 6689270 39.7, 354854.1 6689262.2 39.7, 354845.8 6689262.3 39.7, 354846 6689261 39.7, 354847.2 6689261.1 39.7, 354847.2 6689260.6 39.7, 354847.2 6689260.5 39.7, 354847.2 6689260.2 39.7, 354847.4 6689259.9 39.7, 354847.6 6689259.5 39.7, 354847.8 6689258.9 39.7, 354847.9 6689258.5 39.7, 354847.9 6689258.1 39.7, 354847.8 6689257.7 39.7, 354847.8 6689257.5 39.7, 354847.6 6689257.1 39.7, 354847.8 6689256.9 39.7, 354847.9 6689256.6 39.7, 354848 6689256.4 39.7, 354848 6689255.8 39.7, 354847 6689255.6 39.7, 354847.2 6689254.4 39.7, 354847.4 6689254.4 39.7, 354847.7 6689253 39.7, 354839.7 6689251.5 39.7))'),
            ('BATIMENT0000000302927582', 13.6, 'POLYGON Z ((354871.3860465115 6689270 35.7, 354875.2 6689266 35.7, 354871.7 6689222 35.7, 354864.1 6689222.6 35.7, 354862.9 6689222.6 35.7, 354860.3 6689222.5 35.7, 354859.5 6689222.5 35.7, 354858.6 6689226.7 35.7, 354858.1 6689229.5 35.7, 354857 6689234.6 35.7, 354854.7 6689234.6 35.7, 354854.8 6689236.2 35.7, 354855.5 6689242 35.7, 354856 6689246.6 35.7, 354856.1 6689249 35.7, 354855.9 6689250.4 35.7, 354855.3 6689254.6 35.7, 354855 6689257.1 35.7, 354854.1 6689262.2 35.7, 354852.9585365854 6689270 35.7, 354871.3860465115 6689270 35.7))'),
            ('BATIMENT0000000302927585', 7.0, 'POLYGON Z ((354845.8 6689262.3 31.7, 354854.1 6689262.2 31.7, 354855 6689257.1 31.7, 354849.6 6689256.1 31.7, 354848.8 6689260.4 31.7, 354847.2 6689261.1 31.7, 354846 6689261 31.7, 354845.8 6689262.3 31.7))'),
            ('BATIMENT0000000302927586', 18.5, 'POLYGON Z ((354845.8 6689221.1 40.7, 354839.7 6689251.5 40.7, 354847.7 6689253 40.7, 354848.5 6689248.9 40.7, 354848.8 6689247.2 40.7, 354849.3 6689245.4 40.7, 354849.5 6689243.8 40.7, 354849.8 6689242.3 40.7, 354849.6 6689242.3 40.7, 354849.9 6689241 40.7, 354851.1 6689241.1 40.7, 354851.1 6689240.8 40.7, 354851.1 6689240.5 40.7, 354850.9 6689240 40.7, 354851.5 6689239.3 40.7, 354851.8 6689238.9 40.7, 354851.9 6689238.5 40.7, 354852 6689238 40.7, 354852 6689237.6 40.7, 354851.8 6689237 40.7, 354851.9 6689236.7 40.7, 354852.1 6689236.3 40.7, 354852 6689235.8 40.7, 354851 6689235.6 40.7, 354851.2 6689234.4 40.7, 354851.4 6689234.4 40.7, 354852.7 6689228.4 40.7, 354853.3 6689225.5 40.7, 354853.7 6689223.7 40.7, 354853.2 6689222.4 40.7, 354845.8 6689221.1 40.7))'),
            ('BATIMENT0000000302927587', 21.1, 'POLYGON Z ((354863 6689222.2 43, 354862.9 6689222.6 43, 354864.1 6689222.6 43, 354864.1 6689222.2 43, 354863 6689222.2 43))'),
            ('BATIMENT0000000302927589', 19.5, 'POLYGON Z ((354852 6689211.5 40.7, 354851.1 6689212.1 40.7, 354850.3 6689212.8 40.7, 354849.5 6689213.5 40.7, 354848.8 6689214.3 40.7, 354848.1 6689215.1 40.7, 354847.5 6689216.3 40.7, 354847 6689217.4 40.7, 354846.5 6689218.6 40.7, 354846.4 6689218.8 40.7, 354846.1 6689219.9 40.7, 354845.8 6689221.1 40.7, 354853.2 6689222.4 40.7, 354853.7 6689223.7 40.7, 354855.2 6689223.8 40.7, 354855.7 6689222.2 40.7, 354857.6 6689220.9 40.7, 354858.1 6689221.9 40.7, 354858.8 6689221.5 40.7, 354859.3 6689222.1 40.7, 354860.3 6689222.1 40.7, 354860.3 6689222.5 40.7, 354862.9 6689222.6 40.7, 354863 6689222.2 40.7, 354864.1 6689222.2 40.7, 354864.1 6689222.6 40.7, 354871.7 6689222 40.7, 354871 6689212.3 40.7, 354871.2 6689212.3 40.7, 354870.6 6689205.2 40.7, 354860.3 6689206 40.7, 354851.9 6689211.2 40.7, 354852 6689211.5 40.7))'),
            ('BATIMENT0000000302927592', 24.0, 'POLYGON Z ((354986.5 6689164.1 41.3, 354980 6689154.1 41.3, 354962.3 6689165.5 41.3, 354964.6 6689168.7 41.3, 354961.7 6689169.3 41.3, 354961.9 6689172.1 41.3, 354959.5 6689172.6 41.3, 354960 6689177.5 41.3, 354967.4 6689172.3 41.3, 354969.1 6689174.6 41.3, 354971.9 6689172.9 41.3, 354972.4 6689172.6 41.3, 354971.2 6689170.5 41.3, 354971.1 6689169.3 41.3, 354971.5 6689169 41.3, 354971.8 6689168.4 41.3, 354971.7 6689167.9 41.3, 354973.9 6689166.7 41.3, 354975.2 6689167.1 41.3, 354975.5 6689168.1 41.3, 354976.6 6689170.1 41.3, 354977.2 6689169.8 41.3, 354986.5 6689164.1 41.3))'),
            ('BATIMENT0000000302927594', 21.0, 'POLYGON Z ((354954 6689147.1 39, 354951.2 6689148.9 39, 354951.1 6689148.8 39, 354942.7 6689154.3 39, 354942.8 6689154.4 39, 354951.1 6689167.4 39, 354953.8 6689165.8 39, 354956.1 6689169.5 39, 354956.8 6689169 39, 354961.3 6689166.1 39, 354962 6689165.6 39, 354959.8 6689162 39, 354962.4 6689160.4 39, 354954 6689147.1 39), (354956.1 6689159.9 39, 354957.4 6689159 39, 354959.3 6689162 39, 354953.7 6689165.5 39, 354952.4 6689163.4 39, 354952.3 6689161.7 39, 354952.9 6689161.8 39, 354953.3 6689161.6 39, 354953.9 6689161.1 39, 354954.6 6689161.1 39, 354955.2 6689160.9 39, 354955.9 6689160.3 39, 354956.1 6689159.9 39))'),
            ('BATIMENT0000000302927595', 22.3, 'POLYGON Z ((354964.4 6689140.3 39.1, 354964.5 6689140.4 39.1, 354954 6689147.1 39.1, 354962.4 6689160.4 39.1, 354959.8 6689162 39.1, 354962 6689165.6 39.1, 354962.3 6689165.5 39.1, 354980 6689154.1 39.1, 354972.2 6689142.1 39.1, 354972.3 6689141.9 39.1, 354970.2 6689138.6 39.1, 354969.9 6689138.8 39.1, 354967.9 6689138.3 39.1, 354967.8 6689138.1 39.1, 354964.4 6689140.3 39.1), (354964.9 6689152 39.1, 354965.5 6689151.1 39.1, 354967.8 6689154.8 39.1, 354967.5 6689155.3 39.1, 354967.6 6689155.6 39.1, 354969.9 6689159.3 39.1, 354967.2 6689161 39.1, 354963 6689154.4 39.1, 354963.6 6689152.9 39.1, 354964.9 6689152 39.1))'),
            ('BATIMENT0000000302927596', 22.0, 'POLYGON Z ((354965.8 6689184.3 40.5, 354968.4 6689185.7 40.5, 354960.8 6689203.9 40.5, 354971.6 6689208.7 40.5, 354971.7 6689208.8 40.5, 354975.8 6689210.6 40.5, 354976.5 6689210.2 40.5, 354987.9 6689183.8 40.5, 354981.6 6689181.5 40.5, 354981.2 6689182.4 40.5, 354981 6689183.2 40.5, 354978.1 6689182.1 40.5, 354978.5 6689181.2 40.5, 354970.7 6689177.8 40.5, 354969.3 6689175.7 40.5, 354965.8 6689184.3 40.5), (354970.3 6689191.5 40.5, 354971.6 6689188.7 40.5, 354973.6 6689189.5 40.5, 354973.9 6689189 40.5, 354975.4 6689189.6 40.5, 354973.2 6689195.3 40.5, 354971.4 6689197.1 40.5, 354968.2 6689195.6 40.5, 354969.1 6689193.3 40.5, 354969.5 6689193.4 40.5, 354970.3 6689191.5 40.5))'),
            ('BATIMENT0000000302927597', 22.1, 'POLYGON Z ((354926.4 6689175.9 41.2, 354927.4 6689186.1 41.2, 354927.7 6689186.2 41.2, 354928.1 6689190.2 41.2, 354931.6 6689191.8 41.2, 354931.7 6689191.6 41.2, 354948 6689198.4 41.2, 354955.5 6689180.5 41.2, 354954.8 6689180.8 41.2, 354954 6689180.4 41.2, 354954.5 6689178.8 41.2, 354960 6689178.2 41.2, 354960 6689177.5 41.2, 354959.5 6689172.6 41.2, 354961.9 6689172.1 41.2, 354961.7 6689169.3 41.2, 354961.3 6689166.1 41.2, 354956.8 6689169 41.2, 354957.2 6689172.5 41.2, 354954.9 6689173.1 41.2, 354954.2 6689172.4 41.2, 354948.4 6689173.6 41.2, 354948.8 6689178.7 41.2, 354948.5 6689179.1 41.2, 354948.5 6689179.4 41.2, 354948.4 6689179.7 41.2, 354948.3 6689180 41.2, 354948.2 6689180.3 41.2, 354948.1 6689180.6 41.2, 354948 6689180.8 41.2, 354947.8 6689181.1 41.2, 354947.6 6689181.3 41.2, 354947.4 6689181.5 41.2, 354947.2 6689181.7 41.2, 354946.9 6689181.9 41.2, 354946.4 6689182.2 41.2, 354946.2 6689182.3 41.2, 354945.8 6689182.5 41.2, 354945.5 6689182.6 41.2, 354945.1 6689182.7 41.2, 354944.7 6689182.7 41.2, 354944 6689182.8 41.2, 354943.7 6689182.7 41.2, 354943.3 6689182.7 41.2, 354942.9 6689182.6 41.2, 354942.6 6689182.5 41.2, 354942.2 6689182.4 41.2, 354941.9 6689182.2 41.2, 354941.6 6689182.1 41.2, 354941.3 6689181.8 41.2, 354941 6689181.6 41.2, 354940.8 6689181.3 41.2, 354940.6 6689181.1 41.2, 354940.3 6689180.8 41.2, 354940.2 6689180.5 41.2, 354940 6689180.1 41.2, 354939.9 6689179.8 41.2, 354939.6 6689179.7 41.2, 354939.2 6689174.5 41.2, 354926.4 6689175.9 41.2))'),
            ('BATIMENT0000000302927598', 21.4, 'POLYGON Z ((354960 6689177.5 40.4, 354960 6689178.2 40.4, 354960.4 6689180.9 40.4, 354959.4 6689182 40.4, 354955.5 6689180.5 40.4, 354948 6689198.4 40.4, 354951.2 6689199.8 40.4, 354951.2 6689200 40.4, 354960.8 6689203.9 40.4, 354968.4 6689185.7 40.4, 354965.8 6689184.3 40.4, 354969.3 6689175.7 40.4, 354968.8 6689174.9 40.4, 354969.1 6689174.6 40.4, 354967.4 6689172.3 40.4, 354960 6689177.5 40.4), (354958 6689185.2 40.4, 354958.8 6689183.3 40.4, 354964.3 6689185.7 40.4, 354963.4 6689188.1 40.4, 354963.3 6689190 40.4, 354962.1 6689190.8 40.4, 354960.9 6689189.1 40.4, 354959.6 6689188.5 40.4, 354959.4 6689188.9 40.4, 354956 6689187.4 40.4, 354955.8 6689186.1 40.4, 354958 6689185.2 40.4))'),
            ('BATIMENT0000000302927600', 22.4, 'POLYGON Z ((354929 6689163.2 41.1, 354928.9 6689163.1 41.1, 354925.7 6689165.1 41.1, 354926.1 6689169.1 41.1, 354925.8 6689169.2 41.1, 354926.4 6689175.9 41.1, 354939.2 6689174.5 41.1, 354948.4 6689173.6 41.1, 354954.2 6689172.4 41.1, 354953.6 6689171.4 41.1, 354951.1 6689167.4 41.1, 354942.8 6689154.4 41.1, 354929 6689163.2 41.1), (354944.6 6689169.5 41.1, 354946.1 6689168.7 41.1, 354947.7 6689169.3 41.1, 354948.2 6689171.1 41.1, 354943.5 6689172.5 41.1, 354943.3 6689171.5 41.1, 354944 6689171.2 41.1, 354944.4 6689170.9 41.1, 354944.6 6689170.2 41.1, 354944.6 6689169.5 41.1))'),
            ('BATIMENT0000000302928335', 8.4, 'POLYGON Z ((354771.9 6689088.6 30, 354779.2 6689079.9 30, 354775.2 6689076.5 30, 354767.9 6689085.3 30, 354771.9 6689088.6 30))'),
            ('BATIMENT0000000302927736', 23.4, 'POLYGON Z ((354995.3 6689120.7 38.4, 354980.9 6689129.9 38.4, 354980.6 6689129.8 38.4, 354977.2 6689132 38.4, 354977.5 6689132.3 38.4, 354976.9 6689134.7 38.4, 354976.6 6689134.8 38.4, 354978.9 6689138.3 38.4, 354979 6689138.1 38.4, 354985.7 6689148.4 38.4, 354995.7 6689142 38.4, 354993.3 6689138.4 38.4, 354993.9 6689136.7 38.4, 354994.1 6689136.6 38.4, 354993.9 6689136.3 38.4, 354996.6 6689134.5 38.4, 355000.6 6689135 38.4, 355003.1 6689138.9 38.4, 355005.6 6689136.9 38.4, 354995.3 6689120.7 38.4))'),
            ('BATIMENT0000000302927737', 20.6, 'POLYGON Z ((355008.5 6689112.1 35.6, 354995.3 6689120.7 35.6, 355005.6 6689136.9 35.6, 355009.5 6689134.2 35.6, 355007.2 6689130.7 35.6, 355004.4 6689129.8 35.6, 355004.7 6689128.8 35.6, 355006.6 6689128.6 35.6, 355008.3 6689127.6 35.6, 355009.1 6689126 35.6, 355009.9 6689126.2 35.6, 355010.6 6689126.1 35.6, 355013.1 6689130 35.6, 355013.3 6689129.9 35.6, 355015.6 6689128.4 35.6, 355014.9 6689126.9 35.6, 355016.8 6689125.5 35.6, 355008.5 6689112.1 35.6))'),
            ('BATIMENT0000000302927739', 20.5, 'POLYGON Z ((354985.7 6689148.4 37.4, 354993.4 6689160.4 37.4, 355003.5 6689153.9 37.4, 355002.6 6689152.4 37.4, 355006.5 6689149.8 37.4, 355006.7 6689149.7 37.4, 355005.4 6689147.4 37.4, 355004.6 6689146.1 37.4, 355000.3 6689149 37.4, 354997.5 6689144.7 37.4, 354995.7 6689142 37.4, 354985.7 6689148.4 37.4))'),
            ('BATIMENT0000000302927740', 22.6, 'POLYGON Z ((354993.4 6689160.4 40.5, 354999.6 6689170 40.5, 354999.4 6689170.1 40.5, 355001.6 6689173.7 40.5, 355005.4 6689174 40.5, 355005.5 6689173.9 40.5, 355014.3 6689174.9 40.5, 355015.5 6689165.9 40.5, 355015.9 6689165.8 40.5, 355016.9 6689158.6 40.5, 355015.6 6689156.3 40.5, 355015.3 6689156.1 40.5, 355008 6689156.6 40.5, 355010.6 6689159.5 40.5, 355011.6 6689159.8 40.5, 355012.7 6689162.9 40.5, 355012 6689163.8 40.5, 355011.1 6689163.1 40.5, 355010.4 6689162.8 40.5, 355009.5 6689162.9 40.5, 355009 6689162.1 40.5, 355007.6 6689161.1 40.5, 355005.5 6689160.5 40.5, 355006 6689158.3 40.5, 355006.9 6689158 40.5, 355006.2 6689155.2 40.5, 355007.5 6689154.7 40.5, 355006.5 6689149.8 40.5, 355002.6 6689152.4 40.5, 355003.5 6689153.9 40.5, 354993.4 6689160.4 40.5))'),
            ('BATIMENT0000000302927741', 22.7, 'POLYGON Z ((355007.5 6689181.1 39.2, 354999.1 6689180.1 39.2, 354997.4 6689181.2 39.2, 354991.4 6689195.2 39.2, 355002.2 6689199.7 39.2, 355003.2 6689200.1 39.2, 355005.3 6689195.2 39.2, 355009 6689196.8 39.2, 355011 6689192.6 39.2, 355011.6 6689192.9 39.2, 355013.4 6689189.1 39.2, 355013.5 6689188.9 39.2, 355006.5 6689188 39.2, 355007.5 6689181.1 39.2))'),
            ('BATIMENT0000000302927742', 23.0, 'POLYGON Z ((354991.4 6689195.2 39.2, 354985.7 6689208.9 39.2, 354985.5 6689208.8 39.2, 354983.6 6689213.3 39.2, 354983.9 6689214.1 39.2, 355001.5 6689221.5 39.2, 355009.3 6689202.7 39.2, 355006.9 6689201.6 39.2, 355005.1 6689200.9 39.2, 355002.4 6689207 39.2, 355003.1 6689210 39.2, 355002.1 6689210.1 39.2, 355001.3 6689208.5 39.2, 354999.2 6689207.5 39.2, 354997.8 6689208.1 39.2, 354997.2 6689206.9 39.2, 354998.2 6689206.3 39.2, 355000.6 6689200.8 39.2, 355001.1 6689200.7 39.2, 355001.6 6689200.7 39.2, 355001.8 6689200.3 39.2, 355002.2 6689199.7 39.2, 354991.4 6689195.2 39.2))'),
            ('BATIMENT0000000302928018', 19.2, 'POLYGON Z ((354735.4 6689164.9 43.9, 354742.2 6689191.4 43.9, 354750.6 6689189 43.9, 354751.8 6689186 43.9, 354751 6689183.3 43.9, 354753.3 6689182.7 43.9, 354756.5 6689175 43.9, 354753.1 6689176 43.9, 354752.5 6689174.1 43.9, 354748.7 6689175.1 43.9, 354745.2 6689162.7 43.9, 354741.1 6689163.6 43.9, 354739.2 6689164 43.9, 354735.4 6689164.9 43.9))'),
            ('BATIMENT0000000302928020', 12.3, 'POLYGON Z ((354818.5 6689153.1 35, 354795.4 6689143.3 35, 354788 6689160.4 35, 354782.1 6689157.9 35, 354781 6689160.5 35, 354775.9 6689172.3 35, 354765.5 6689168 35, 354770.6 6689156.1 35, 354771.7 6689153.7 35, 354766.6 6689151.6 35, 354764.1 6689157.3 35, 354756.5 6689175 35, 354753.3 6689182.7 35, 354759.5 6689180.9 35, 354799.2 6689197.7 35, 354800.4 6689194.8 35, 354802.6 6689189.7 35, 354808.7 6689175.5 35, 354809.3 6689175.6 35, 354814.8 6689175.2 35, 354815.2 6689170.8 35, 354811.6 6689169.2 35, 354818.5 6689153.1 35))'),
            ('BATIMENT0000000302928021', 8.6, 'POLYGON Z ((354741.1 6689163.6 32, 354745.2 6689162.7 32, 354749.7 6689152.3 32, 354748.4 6689151.8 32, 354747 6689151.3 32, 354746.5 6689152.3 32, 354744.2 6689151.3 32, 354743.5 6689151.3 32, 354743.1 6689151.8 32, 354742.2 6689151.7 32, 354741.8 6689152.7 32, 354740.5 6689152.5 32, 354739.5 6689153.3 32, 354738.8 6689154.8 32, 354739.8 6689156.3 32, 354740.5 6689157.2 32, 354740.5 6689158.4 32, 354740.6 6689159.3 32, 354741.9 6689159.8 32, 354740.9 6689161.3 32, 354740.5 6689162.3 32, 354741.1 6689163.6 32))'),
            ('BATIMENT0000000302928022', 18.4, 'POLYGON Z ((354760 6689128.1 41.7, 354733.5 6689116.7 41.7, 354724.3 6689138.2 41.7, 354731.7 6689165.6 41.7, 354735.4 6689164.9 41.7, 354739.2 6689164 41.7, 354736.3 6689153.3 41.7, 354735.2 6689152.4 41.7, 354734.4 6689150.7 41.7, 354734.3 6689148.5 41.7, 354734.6 6689148.4 41.7, 354734.7 6689147.5 41.7, 354735.3 6689147.4 41.7, 354735.6 6689144.6 41.7, 354749.2 6689150.1 41.7, 354750.4 6689150.6 41.7, 354753.2 6689144.2 41.7, 354760 6689128.1 41.7), (354742.1 6689127.5 41.7, 354746.5 6689129.4 41.7, 354745.1 6689132.7 41.7, 354743.2 6689137.1 41.7, 354741.6 6689140.9 41.7, 354737.1 6689139.1 41.7, 354738.7 6689135.3 41.7, 354740.6 6689130.8 41.7, 354742.1 6689127.5 41.7), (354750.2 6689137.6 41.7, 354753 6689138.8 41.7, 354751.2 6689143.2 41.7, 354748.4 6689142 41.7, 354750.2 6689137.6 41.7))'),
            ('BATIMENT0000000302928024', 20.0, 'POLYGON Z ((354747.4 6689210.7 47.2, 354752.5 6689230.1 47.2, 354762.2 6689227.1 47.2, 354759.5 6689217.2 47.2, 354760.8 6689216.4 47.2, 354761.3 6689215.4 47.2, 354760.9 6689214.3 47.2, 354760.3 6689213.6 47.2, 354759.5 6689213.4 47.2, 354758.5 6689213.7 47.2, 354757.2 6689207.9 47.2, 354747.4 6689210.7 47.2))'),
            ('BATIMENT0000000302928025', 20.2, 'POLYGON Z ((354762.2 6689227.1 47.3, 354752.5 6689230.1 47.3, 354758.3 6689252 47.3, 354758.4 6689252.4 47.3, 354758.6 6689252.8 47.3, 354758.7 6689253.1 47.3, 354758.9 6689253.5 47.3, 354759.2 6689253.8 47.3, 354759.4 6689254.1 47.3, 354759.7 6689254.4 47.3, 354760 6689254.6 47.3, 354760.3 6689254.9 47.3, 354760.7 6689255.1 47.3, 354761 6689255.2 47.3, 354761.5 6689255.4 47.3, 354761.9 6689255.4 47.3, 354762.4 6689255.5 47.3, 354762.8 6689255.5 47.3, 354763.2 6689255.4 47.3, 354763.7 6689255.3 47.3, 354764.2 6689255.2 47.3, 354764.6 6689255 47.3, 354765 6689254.8 47.3, 354765.4 6689254.6 47.3, 354765.8 6689254.3 47.3, 354766.1 6689254 47.3, 354769.8 6689251.6 47.3, 354768 6689247.8 47.3, 354767 6689247.8 47.3, 354765.7 6689247.6 47.3, 354765 6689246.6 47.3, 354765.1 6689244.8 47.3, 354765.5 6689244.3 47.3, 354766.7 6689243.7 47.3, 354762.2 6689227.1 47.3))'),
            ('BATIMENT0000000302928026', 19.3, 'POLYGON Z ((354834.4 6689159.9 40.7, 354818.5 6689153.1 40.7, 354811.6 6689169.2 40.7, 354815.2 6689170.8 40.7, 354814.8 6689175.2 40.7, 354823.9 6689174.8 40.7, 354834.4 6689159.9 40.7))'),
            ('BATIMENT0000000302928027', 16.9, 'POLYGON Z ((354833.3 6689201.8 37.7, 354838 6689208.1 37.7, 354859.1 6689194.9 37.7, 354857.4 6689169.8 37.7, 354834.4 6689159.9 37.7, 354823.9 6689174.8 37.7, 354814.8 6689175.2 37.7, 354821.1 6689178.6 37.7, 354822 6689195.6 37.7, 354825.1 6689195.5 37.7, 354828.3 6689195.5 37.7, 354830.2 6689197.8 37.7, 354830.7 6689195.7 37.7, 354832.6 6689195.8 37.7, 354834.2 6689196.9 37.7, 354836.1 6689196.8 37.7, 354836.3 6689197.3 37.7, 354837.4 6689199.1 37.7, 354833.3 6689201.8 37.7))'),
            ('BATIMENT0000000302928029', 20.1, 'POLYGON Z ((354825.1 6689195.5 42.6, 354822 6689195.6 42.6, 354809.3 6689196 42.6, 354807.4 6689197.3 42.6, 354808 6689198.3 42.6, 354808.9 6689199.9 42.6, 354821.1 6689218.8 42.6, 354838 6689208.1 42.6, 354833.3 6689201.8 42.6, 354831.8 6689199.8 42.6, 354830.2 6689197.8 42.6, 354828.3 6689195.5 42.6, 354825.1 6689195.5 42.6), (354823.6 6689198.4 42.6, 354825.8 6689198.3 42.6, 354826.7 6689199.5 42.6, 354823.1 6689201.8 42.6, 354822.2 6689201.2 42.6, 354821.4 6689201.5 42.6, 354821.1 6689202.3 42.6, 354821.2 6689203.8 42.6, 354820 6689204.2 42.6, 354819.2 6689205.9 42.6, 354818.7 6689205.6 42.6, 354818.6 6689202.8 42.6, 354816 6689198.8 42.6, 354823.6 6689198.4 42.6))'),
            ('BATIMENT0000000302928033', 16.0, 'POLYGON Z ((354773.8 6689134 39.7, 354760 6689128.1 39.7, 354753.2 6689144.2 39.7, 354755.6 6689145.2 39.7, 354757.6 6689140.6 39.7, 354764.2 6689143.4 39.7, 354762.2 6689148 39.7, 354767.1 6689150 39.7, 354773.8 6689134 39.7))'),
            ('BATIMENT0000000302928034', 19.6, 'POLYGON Z ((354795.4 6689143.3 42, 354773.8 6689134 42, 354767.1 6689150 42, 354766.6 6689151.6 42, 354771.7 6689153.7 42, 354773 6689150.7 42, 354783.4 6689155 42, 354782.1 6689157.9 42, 354788 6689160.4 42, 354795.4 6689143.3 42))'),
            ('BATIMENT0000000302928039', 11.7, 'POLYGON Z ((354764.1 6689157.3 35.6, 354766.6 6689151.6 35.6, 354767.1 6689150 35.6, 354762.2 6689148 35.6, 354760.6 6689150.1 35.6, 354758.5 6689152.7 35.6, 354757.9 6689154.6 35.6, 354764.1 6689157.3 35.6))'),
            ('BATIMENT0000000302928135', 15.8, 'POLYGON Z ((354735.7 6689204.9 41.1, 354732.5 6689192.6 41.1, 354717.7 6689202.8 41.1, 354718.4 6689203.6 41.1, 354719 6689204.2 41.1, 354722.7 6689201.7 41.1, 354728.1 6689210.3 41.1, 354735.7 6689204.9 41.1))'),
            ('BATIMENT0000000302928041', 21.3, 'POLYGON Z ((354766.7 6689243.7 45.2, 354765.5 6689244.3 45.2, 354765.1 6689244.8 45.2, 354765 6689246.6 45.2, 354765.7 6689247.6 45.2, 354767 6689247.8 45.2, 354768 6689247.8 45.2, 354769.8 6689251.6 45.2, 354779.6 6689245.4 45.2, 354774.3 6689236.7 45.2, 354771.6 6689232.8 45.2, 354767.1 6689236.6 45.2, 354768.7 6689242.9 45.2, 354766.7 6689243.7 45.2))'),
            ('BATIMENT0000000302928042', 17.4, 'POLYGON Z ((354796.5 6689208.4 41.3, 354808.5 6689227 41.3, 354821.1 6689218.8 41.3, 354808.9 6689199.9 41.3, 354796.5 6689208.4 41.3), (354805.5 6689214.2 41.3, 354810.9 6689210.4 41.3, 354813.8 6689214.8 41.3, 354808.3 6689218.4 41.3, 354805.5 6689214.2 41.3))'),
            ('BATIMENT0000000302928045', 20.7, 'POLYGON Z ((354779.6 6689245.4 44.6, 354798.2 6689233.7 44.6, 354793 6689225.2 44.6, 354786.9 6689228.8 44.6, 354786.2 6689227.8 44.6, 354783 6689229.9 44.6, 354783.5 6689230.7 44.6, 354774.3 6689236.7 44.6, 354779.6 6689245.4 44.6))'),
            ('BATIMENT0000000302928046', 18.1, 'POLYGON Z ((354798.2 6689233.7 42, 354808.5 6689227 42, 354796.5 6689208.4 42, 354795.7 6689207.4 42, 354794.7 6689208 42, 354785.7 6689213.7 42, 354786.1 6689214.2 42, 354789.3 6689219.1 42, 354790.1 6689220.1 42, 354796.4 6689216.8 42, 354797.5 6689218.8 42, 354797.5 6689219.4 42, 354797.6 6689220.3 42, 354792.1 6689223.5 42, 354793 6689225.2 42, 354798.2 6689233.7 42))'),
            ('BATIMENT0000000302928047', 10.1, 'POLYGON Z ((354773.6 6689203.8 36.1, 354768.2 6689205.3 36.1, 354766.7 6689205.7 36.1, 354775 6689220.5 36.1, 354776.4 6689219.7 36.1, 354777.7 6689219 36.1, 354780.7 6689217.3 36.1, 354779.5 6689214.7 36.1, 354773.6 6689203.8 36.1))'),
            ('BATIMENT0000000302928098', 11.6, 'POLYGON Z ((354792.9 6689266.2 37.7, 354803.5 6689267.1 37.7, 354804 6689262.4 37.7, 354801.3 6689258.1 37.7, 354800.1 6689256.3 37.7, 354795.2 6689259.3 37.7, 354795 6689259.9 37.7, 354793.9 6689261.9 37.7, 354793.5 6689262.2 37.7, 354793.1 6689262.5 37.7, 354793.1 6689262.8 37.7, 354792.9 6689266.2 37.7))'),
            ('BATIMENT0000000302928099', 20.2, 'POLYGON Z ((354803.5 6689267.1 44.8, 354822.8 6689268.7 44.8, 354823.1 6689268.4 44.8, 354827 6689249.1 44.8, 354818 6689247.5 44.8, 354814.2 6689252.3 44.8, 354812.4 6689250.7 44.8, 354811.1 6689251.6 44.8, 354807.8 6689253.9 44.8, 354801.3 6689258.1 44.8, 354804 6689262.4 44.8, 354803.5 6689267.1 44.8))'),
            ('BATIMENT0000000302928100', 18.5, 'POLYGON Z ((354809.2 6689237.5 43.7, 354794.2 6689246.9 43.7, 354800.1 6689256.3 43.7, 354801.3 6689258.1 43.7, 354807.8 6689253.9 43.7, 354806.7 6689252.2 43.7, 354807 6689251.8 43.7, 354807.2 6689251.5 43.7, 354807 6689250.9 43.7, 354810.3 6689248.7 43.7, 354808.3 6689246.9 43.7, 354813.1 6689243.8 43.7, 354809.2 6689237.5 43.7))'),
            ('BATIMENT0000000302928102', 20.4, 'POLYGON Z ((354779.2 6689256.3 46.2, 354775.5 6689258.8 46.2, 354774.7 6689260.1 46.2, 354774.6 6689260.4 46.2, 354774.5 6689260.7 46.2, 354774.5 6689261.4 46.2, 354774.5 6689261.7 46.2, 354774.6 6689262 46.2, 354774.6 6689262.3 46.2, 354774.7 6689262.6 46.2, 354774.8 6689262.9 46.2, 354775 6689263.1 46.2, 354775.1 6689263.4 46.2, 354775.3 6689263.7 46.2, 354775.5 6689263.9 46.2, 354775.7 6689264.1 46.2, 354775.9 6689264.2 46.2, 354776.2 6689264.4 46.2, 354776.4 6689264.5 46.2, 354776.7 6689264.6 46.2, 354777 6689264.7 46.2, 354777.5 6689264.9 46.2, 354777.8 6689264.9 46.2, 354792.9 6689266.2 46.2, 354793.1 6689262.8 46.2, 354793.1 6689262.5 46.2, 354793.5 6689262.2 46.2, 354793.9 6689261.9 46.2, 354795 6689259.9 46.2, 354795.2 6689259.3 46.2, 354800.1 6689256.3 46.2, 354794.2 6689246.9 46.2, 354779.2 6689256.3 46.2), (354789.6 6689262.1 46.2, 354789.7 6689260.6 46.2, 354791.4 6689260.6 46.2, 354791.4 6689261.7 46.2, 354791.4 6689262.1 46.2, 354789.6 6689262.1 46.2))'),
            ('BATIMENT0000000302928104', 20.2, 'POLYGON Z ((354827 6689249.1 43.8, 354830.3 6689231.3 43.8, 354830.6 6689231.3 43.8, 354831.3 6689227.4 43.8, 354828.7 6689225.7 43.8, 354828.5 6689225.3 43.8, 354824.9 6689227.5 43.8, 354825 6689227.7 43.8, 354809.2 6689237.5 43.8, 354813.1 6689243.8 43.8, 354808.3 6689246.9 43.8, 354810.3 6689248.7 43.8, 354810.8 6689249.3 43.8, 354812.4 6689250.7 43.8, 354814.2 6689252.3 43.8, 354818 6689247.5 43.8, 354827 6689249.1 43.8))'),
            ('BATIMENT0000000302928117', 9.9, 'POLYGON Z ((354683.8500000006 6689270 37.1, 354684 6689269.9 37.1, 354687.3 6689267.7 37.1, 354695.9 6689261.9 37.1, 354696 6689261.6 37.1, 354685.5 6689246.5 37.1, 354680 6689250.385321101 37.1, 354680 6689270 37.1, 354683.8500000006 6689270 37.1))'),
            ('BATIMENT0000000302928119', 17.0, 'POLYGON Z ((354717.9 6689245 45.1, 354705.6 6689232.2 45.1, 354696.1 6689239 45.1, 354697.1 6689239.9 45.1, 354697.7 6689239.3 45.1, 354699.7 6689241.4 45.1, 354697.2 6689243.4 45.1, 354699.7 6689245.9 45.1, 354700.2 6689245.4 45.1, 354702.1 6689243.9 45.1, 354710.2 6689252.3 45.1, 354717.9 6689245 45.1))'),
            ('BATIMENT0000000302928120', 16.8, 'POLYGON Z ((354732.5 6689260.3 44.8, 354717.9 6689245 44.8, 354710.2 6689252.3 44.8, 354719 6689261.5 44.8, 354717.2 6689263.2 44.8, 354716.7 6689263.7 44.8, 354720 6689267.1 44.8, 354724 6689264.3 44.8, 354724.4 6689264.9 44.8, 354725.4 6689264.3 44.8, 354732.5 6689260.3 44.8))'),
            ('BATIMENT0000000302928122', 16.1, 'POLYGON Z ((354740.9222222223 6689270 45, 354741 6689269.3 45, 354732.5 6689260.3 45, 354725.4 6689264.3 45, 354727 6689267.1 45, 354725.7 6689267.7 45, 354726.7999999999 6689270 45, 354740.9222222223 6689270 45))'),
            ('BATIMENT0000000302928124', 18.4, 'POLYGON Z ((354694.1 6689220.1 44.7, 354690.5 6689216.3 44.7, 354680 6689211.82 44.7, 354680 6689230.373684211 44.7, 354684.9 6689226.8 44.7, 354694.1 6689220.1 44.7))'),
            ('BATIMENT0000000302928133', 20.5, 'POLYGON Z ((354727.1 6689172.8 45.6, 354721.5 6689151.7 45.6, 354719 6689150.6 45.6, 354694.7 6689206.5 45.6, 354697.1 6689209 45.6, 354706.8 6689201.9 45.6, 354712.3 6689198 45.6, 354712.5 6689197.9 45.6, 354713.2 6689196.2 45.6, 354720.3 6689179.5 45.6, 354722.6 6689174.1 45.6, 354727.1 6689172.8 45.6))'),
            ('BATIMENT0000000302928134', 18.5, 'POLYGON Z ((354697.1 6689209 43.8, 354710.1 6689222.7 43.8, 354718.4 6689216.8 43.8, 354719.2 6689216.3 43.8, 354714.2 6689210.1 43.8, 354716.3 6689208.9 43.8, 354716.9 6689209.8 43.8, 354717.9 6689209.2 43.8, 354714.9 6689206 43.8, 354718.4 6689203.6 43.8, 354717.7 6689202.8 43.8, 354714.9 6689200.6 43.8, 354711.2 6689203.4 43.8, 354713.2 6689206.5 43.8, 354711.2 6689208 43.8, 354706.8 6689201.9 43.8, 354697.1 6689209 43.8))'),
            ('BATIMENT0000000302928137', 22.3, 'POLYGON Z ((354710.1 6689222.7 47.6, 354721.3 6689234.4 47.6, 354723.3 6689232.5 47.6, 354727.2 6689229.6 47.6, 354730.3 6689227.7 47.6, 354733.1 6689226.2 47.6, 354737.4 6689224.4 47.6, 354739.5 6689223.6 47.6, 354740.7 6689223.5 47.6, 354735.7 6689204.9 47.6, 354728.1 6689210.3 47.6, 354729.9 6689216 47.6, 354729.5 6689216 47.6, 354729.2 6689216.1 47.6, 354728.9 6689216.1 47.6, 354728.6 6689216.3 47.6, 354728.1 6689216.5 47.6, 354727.8 6689216.7 47.6, 354727.6 6689216.9 47.6, 354727.4 6689217.1 47.6, 354727.3 6689217.3 47.6, 354727.2 6689217.4 47.6, 354727.2 6689217.7 47.6, 354727.1 6689217.8 47.6, 354727.1 6689218 47.6, 354727.1 6689218.4 47.6, 354727.1 6689218.8 47.6, 354727.2 6689219.1 47.6, 354727.3 6689219.5 47.6, 354727.4 6689219.9 47.6, 354723.4 6689222.1 47.6, 354718.4 6689216.8 47.6, 354710.1 6689222.7 47.6))'),
            ('BATIMENT0000000302928270', 21.8, 'POLYGON Z ((354685.2 6689058.5 45, 354680 6689064.386792453 45, 354680 6689083.355828221 45, 354702.6 6689093.2 45, 354707.7 6689083.3 45, 354702.4 6689081.1 45, 354703.9 6689077.2 45, 354709.6 6689079.6 45, 354711.7 6689075.6 45, 354709.3 6689074 45, 354702.6 6689069.7 45, 354698 6689066.8 45, 354695 6689064.8 45, 354694.2 6689066 45, 354695.6 6689066.6 45, 354696.7 6689068.4 45, 354697.1 6689071 45, 354696.6 6689073.3 45, 354694.7 6689077.7 45, 354686.4 6689074.1 45, 354687.2 6689071.9 45, 354689.1 6689067.8 45, 354690.1 6689066.7 45, 354691 6689066.1 45, 354692.9 6689065.3 45, 354693.5 6689063.8 45, 354685.2 6689058.5 45))'),
            ('BATIMENT0000000302928271', 17.6, 'POLYGON Z ((354711.7 6689050.5 39.5, 354701.3 6689041.7 39.5, 354699.7 6689042.1 39.5, 354685.2 6689058.5 39.5, 354693.5 6689063.8 39.5, 354695 6689064.8 39.5, 354698 6689066.8 39.5, 354702.1 6689061.9 39.5, 354701.1 6689060.9 39.5, 354699.4 6689059.5 39.5, 354699.5 6689058.3 39.5, 354699 6689056.8 39.5, 354698 6689055.4 39.5, 354699.1 6689054.3 39.5, 354703.2 6689057.6 39.5, 354704.7 6689058.9 39.5, 354711.7 6689050.5 39.5))'),
            ('BATIMENT0000000302928273', 22.2, 'POLYGON Z ((354702.6 6689093.2 45.4, 354717.5 6689099.7 45.4, 354728.1 6689086.3 45.4, 354724.6 6689084 45.4, 354723.6 6689083.3 45.4, 354721.8 6689082.1 45.4, 354719.8 6689086.7 45.4, 354718.2 6689086.1 45.4, 354717.5 6689087.5 45.4, 354712.8 6689085.3 45.4, 354716 6689078.4 45.4, 354713.6 6689076.8 45.4, 354711.7 6689075.6 45.4, 354709.6 6689079.6 45.4, 354707.7 6689083.3 45.4, 354702.6 6689093.2 45.4))'),
            ('BATIMENT0000000302928278', 14.8, 'POLYGON Z ((354725.8 6689062.3 38.1, 354711.7 6689050.5 38.1, 354704.7 6689058.9 38.1, 354708.9 6689062.3 38.1, 354715 6689067.5 38.1, 354718.8 6689070.6 38.1, 354725.8 6689062.3 38.1))'),
            ('BATIMENT0000000302928280', 21.2, 'POLYGON Z ((354738.7 6689073 43.1, 354725.8 6689062.3 43.1, 354718.8 6689070.6 43.1, 354717.6 6689072 43.1, 354713.6 6689076.8 43.1, 354716 6689078.4 43.1, 354718.3 6689079.9 43.1, 354720.5 6689076.8 43.1, 354721.8 6689076.5 43.1, 354727.1 6689080.6 43.1, 354725.6 6689082.7 43.1, 354724.6 6689084 43.1, 354728.1 6689086.3 43.1, 354738.7 6689073 43.1))'),
            ('BATIMENT0000000302928281', 19.6, 'POLYGON Z ((354717.5 6689099.7 42.8, 354732.6 6689106.3 42.8, 354741.8 6689095.1 42.8, 354737.9 6689092.6 42.8, 354737.4 6689093.6 42.8, 354736.5 6689095.7 42.8, 354728.7 6689092.9 42.8, 354728.6 6689091.2 42.8, 354729.2 6689091.5 42.8, 354730.2 6689089.7 42.8, 354730.5 6689089.8 42.8, 354731.4 6689088.3 42.8, 354728.1 6689086.3 42.8, 354717.5 6689099.7 42.8))'),
            ('BATIMENT0000000302928283', 22.1, 'POLYGON Z ((354741.8 6689095.1 44.2, 354732.6 6689106.3 44.2, 354756.4 6689116.4 44.2, 354770.3 6689099.4 44.2, 354751.3 6689083.6 44.2, 354741.8 6689095.1 44.2), (354757.8 6689099.8 44.2, 354760.4 6689102 44.2, 354758.5 6689104 44.2, 354756.7 6689107.7 44.2, 354754 6689106.3 44.2, 354756.1 6689102 44.2, 354757.8 6689099.8 44.2), (354746.6 6689096.9 44.2, 354749 6689097.8 44.2, 354746.4 6689103.3 44.2, 354744.2 6689102.4 44.2, 354746.6 6689096.9 44.2))'),
            ('BATIMENT0000000302928284', 19.2, 'POLYGON Z ((354751.3 6689083.6 41.7, 354738.7 6689073 41.7, 354728.1 6689086.3 41.7, 354731.4 6689088.3 41.7, 354732.2 6689088.9 41.7, 354733 6689087.7 41.7, 354734.4 6689086.1 41.7, 354734.4 6689084.2 41.7, 354735.4 6689084.2 41.7, 354735.4 6689085.7 41.7, 354736.4 6689086.3 41.7, 354736.7 6689087.8 41.7, 354737.8 6689087.7 41.7, 354739.2 6689088.7 41.7, 354740.6 6689088.6 41.7, 354740.6 6689089.4 41.7, 354739 6689089.7 41.7, 354737.2 6689092.1 41.7, 354737.9 6689092.6 41.7, 354741.8 6689095.1 41.7, 354751.3 6689083.6 41.7))'),
            ('BATIMENT0000000302928286', 18.7, 'POLYGON Z ((354756.4 6689116.4 42, 354768.9 6689121.7 42, 354780 6689107.6 42, 354770.3 6689099.4 42, 354756.4 6689116.4 42))'),
            ('BATIMENT0000000302928287', 16.9, 'POLYGON Z ((354768.9 6689121.7 38.7, 354784.9 6689128.6 38.7, 354792.7 6689118.4 38.7, 354780 6689107.6 38.7, 354768.9 6689121.7 38.7))'),
            ('BATIMENT0000000302928329', 19.0, 'POLYGON Z ((354762.9 6689057.2 39, 354761.5 6689058.9 39, 354760.1 6689060.7 39, 354780.9 6689077.8 39, 354783.2 6689075 39, 354785.7 6689072 39, 354790.8 6689065.9 39, 354770 6689048.6 39, 354762.9 6689057.2 39), (354774.9 6689066.7 39, 354776.8 6689064.6 39, 354779.8 6689067.2 39, 354778.3 6689069 39, 354774.9 6689066.7 39))'),
            ('BATIMENT0000000302928330', 18.9, 'POLYGON Z ((354750.8 6689051 39.2, 354755.3 6689054.6 39.2, 354748.7 6689062.4 39.2, 354745.9 6689060.3 39.2, 354744.9 6689060.5 39.2, 354742.2 6689063.8 39.2, 354751.3 6689071.3 39.2, 354758.4 6689062.7 39.2, 354760.1 6689060.7 39.2, 354761.5 6689058.9 39.2, 354759.5 6689057.3 39.2, 354761 6689055.5 39.2, 354762.9 6689057.2 39.2, 354770 6689048.6 39.2, 354759.9 6689040.1 39.2, 354750.8 6689051 39.2))'),
            ('BATIMENT0000000302928331', 18.4, 'POLYGON Z ((354792.8 6689105.9 38.5, 354799.2 6689098.1 38.5, 354801.7 6689095 38.5, 354811.4 6689083.2 38.5, 354800.5 6689074.1 38.5, 354790.8 6689065.9 38.5, 354785.7 6689072 38.5, 354788.4 6689074.2 38.5, 354785.9 6689077.2 38.5, 354783.2 6689075 38.5, 354780.9 6689077.8 38.5, 354779.2 6689079.9 38.5, 354771.9 6689088.6 38.5, 354778.5 6689094.1 38.5, 354781.4 6689096.5 38.5, 354785.2 6689092.1 38.5, 354782.2 6689089.6 38.5, 354788.6 6689081.8 38.5, 354796.6 6689088.4 38.5, 354786.6 6689100.9 38.5, 354792.8 6689105.9 38.5))'),
            ('BATIMENT0000000302928332', 19.3, 'POLYGON Z ((354730.6 6689054.1 39, 354740.2 6689062.3 39, 354742.9 6689059 39, 354743.1 6689057.8 39, 354740.3 6689055.5 39, 354746.7 6689047.6 39, 354750.8 6689051 39, 354759.9 6689040.1 39, 354749.5 6689031.3 39, 354742.9 6689039.2 39, 354745.1 6689040.9 39, 354743.5 6689042.8 39, 354741.4 6689041.1 39, 354730.6 6689054.1 39))'),
            ('BATIMENT0000000302928333', 4.3, 'POLYGON Z ((354758.4 6689062.7 26, 354751.3 6689071.3 26, 354755.5 6689074.9 26, 354762.7 6689066.2 26, 354758.4 6689062.7 26))'),
            ('BATIMENT0000000302928334', 18.7, 'POLYGON Z ((354792.8 6689105.9 40.2, 354813.4 6689123 40.2, 354819.8 6689115.2 40.2, 354799.2 6689098.1 40.2, 354792.8 6689105.9 40.2))'),
            ('BATIMENT0000000302928336', 15.5, 'POLYGON Z ((354831.9 6689100.4 37.2, 354811.4 6689083.2 37.2, 354801.7 6689095 37.2, 354805.7 6689098.4 37.2, 354810.9 6689092.1 37.2, 354814.2 6689094.8 37.2, 354811.3 6689098.3 37.2, 354818.4 6689104.2 37.2, 354818.6 6689105.8 37.2, 354816.3 6689108.6 37.2, 354821.6 6689113 37.2, 354824 6689110.1 37.2, 354831.9 6689100.4 37.2))'),
            ('BATIMENT0000000302928337', 19.2, 'POLYGON Z ((354729.2 6689031.9 38.9, 354734.5 6689036.3 38.9, 354728.2 6689044 38.9, 354724.2 6689048.7 38.9, 354730.6 6689054.1 38.9, 354741.4 6689041.1 38.9, 354739.5 6689039.5 38.9, 354741 6689037.6 38.9, 354742.9 6689039.2 38.9, 354749.5 6689031.3 38.9, 354737.9 6689021.7 38.9, 354729.2 6689031.9 38.9))'),
            ('BATIMENT0000000302928339', 18.8, 'POLYGON Z ((354813.4 6689123 39, 354824.6 6689132.3 39, 354831.7 6689123.7 39, 354830.4 6689122.7 39, 354834.4 6689117.9 39, 354835.7 6689119 39, 354843.3 6689109.9 39, 354831.9 6689100.4 39, 354824 6689110.1 39, 354825.9 6689111.7 39, 354828.1 6689113.5 39, 354824.9 6689117.4 39, 354822.8 6689115.6 39, 354820.8 6689114 39, 354819.8 6689115.2 39, 354813.4 6689123 39))'),
            ('BATIMENT0000000302928340', 14.7, 'POLYGON Z ((354824.6 6689132.3 36.5, 354828.3 6689135.5 36.5, 354837.1 6689125.4 36.5, 354841.2 6689128.6 36.5, 354834.6 6689136.7 36.5, 354832.7 6689139.1 36.5, 354836.3 6689142.1 36.5, 354842 6689135.3 36.5, 354840.6 6689134.2 36.5, 354843.7 6689130.3 36.5, 354845.2 6689131.3 36.5, 354846.8 6689129.3 36.5, 354854.8 6689119.6 36.5, 354843.3 6689109.9 36.5, 354835.7 6689119 36.5, 354837.2 6689120.3 36.5, 354835 6689122.9 36.5, 354833.4 6689121.7 36.5, 354831.7 6689123.7 36.5, 354824.6 6689132.3 36.5))'),
            ('BATIMENT0000000302928341', 20.5, 'POLYGON Z ((354836.3 6689142.1 40.4, 354856.7 6689159.3 40.4, 354866.8 6689158.8 40.4, 354867.6 6689154.2 40.4, 354867.7 6689153.7 40.4, 354867.8 6689153.3 40.4, 354868.2 6689152.6 40.4, 354868.7 6689151.6 40.4, 354868.9 6689151.2 40.4, 354869.2 6689150.7 40.4, 354869.4 6689150.3 40.4, 354870 6689149.2 40.4, 354870.1 6689149 40.4, 354870.6 6689148.1 40.4, 354870.7 6689147.8 40.4, 354859.5 6689139.5 40.4, 354857.8 6689142 40.4, 354854.9 6689141.6 40.4, 354859 6689144.9 40.4, 354860 6689146.7 40.4, 354859.1 6689147.1 40.4, 354858 6689145.6 40.4, 354854.7 6689142.4 40.4, 354848.8 6689137.7 40.4, 354852.3 6689133.7 40.4, 354858.5 6689138.6 40.4, 354863.8 6689132.4 40.4, 354866.4 6689129.3 40.4, 354854.8 6689119.6 40.4, 354846.8 6689129.3 40.4, 354848.3 6689130.5 40.4, 354845.2 6689134.5 40.4, 354843.6 6689133.3 40.4, 354842 6689135.3 40.4, 354836.3 6689142.1 40.4))'),
            ('BATIMENT0000000302928342', 19.7, 'POLYGON Z ((354868.6 6689126.7 39.2, 354866.4 6689129.3 39.2, 354863.8 6689132.4 39.2, 354858.5 6689138.6 39.2, 354859.5 6689139.5 39.2, 354870.7 6689147.8 39.2, 354873.1 6689144.5 39.2, 354873.4 6689144.2 39.2, 354873.5 6689144 39.2, 354873.6 6689143.8 39.2, 354874.1 6689143.4 39.2, 354874.6 6689142.9 39.2, 354874.8 6689142.8 39.2, 354875.3 6689142.3 39.2, 354875.6 6689142.1 39.2, 354875.8 6689141.9 39.2, 354876.2 6689141.6 39.2, 354876.7 6689141.2 39.2, 354876.9 6689141 39.2, 354877.3 6689140.8 39.2, 354878 6689140.3 39.2, 354878.1 6689140.2 39.2, 354879.2 6689139.6 39.2, 354880.3 6689139 39.2, 354880.7 6689138.8 39.2, 354880.9 6689138.8 39.2, 354881.8 6689138.6 39.2, 354882 6689138.6 39.2, 354882.5 6689138.5 39.2, 354882.9 6689138.4 39.2, 354883 6689138.3 39.2, 354883.2 6689138.2 39.2, 354883.4 6689138.1 39.2, 354883.5 6689137.9 39.2, 354883.5 6689137.6 39.2, 354883 6689125.6 39.2, 354875 6689119.2 39.2, 354868.6 6689126.7 39.2), (354868.6 6689136.5 39.2, 354871.2 6689133.4 39.2, 354873.5 6689135.4 39.2, 354870.4 6689138.8 39.2, 354865.9 6689138.7 39.2, 354865.8 6689137.5 39.2, 354867.7 6689137.6 39.2, 354868.6 6689136.5 39.2))'),
            ('BATIMENT0000000302928343', 18.2, 'POLYGON Z ((354718.3 6689035.9 38.6, 354724.7 6689028.1 38.6, 354729.2 6689031.9 38.6, 354737.9 6689021.7 38.6, 354726.4 6689012 38.6, 354707.4 6689033.8 38.6, 354707.4 6689034.8 38.6, 354714.3 6689040.5 38.6, 354718.3 6689035.9 38.6))'),
            ('BATIMENT0000000302929167', 20.6, 'POLYGON Z ((355020 6689269.235820895 37.3, 355015.1 6689267.7 37.3, 355015.3 6689267.2 37.3, 355004 6689263.8 37.3, 355002.2028985507 6689270 37.3, 355020 6689270 37.3, 355020 6689269.235820895 37.3))'),
            ('BATIMENT0000000302929188', 20.1, 'POLYGON Z ((354726.7999999999 6689270 48, 354725.7 6689267.7 48, 354724.4 6689264.9 48, 354724 6689264.3 48, 354720 6689267.1 48, 354716.7 6689269.2 48, 354715.5102564104 6689270 48, 354726.7999999999 6689270 48))'),
            ('BATIMENT0000000302929189', 17.8, 'POLYGON Z ((354688.3 6689232.1 45.6, 354693.4 6689239.4 45.6, 354694 6689240.4 45.6, 354694 6689240.5 45.6, 354696.1 6689239 45.6, 354705.6 6689232.2 45.6, 354694.1 6689220.1 45.6, 354684.9 6689226.8 45.6, 354688.3 6689232.1 45.6))'),
            ('BATIMENT0000000302929190', 6.5, 'POLYGON Z ((354680 6689250.385321101 34.3, 354685.5 6689246.5 34.3, 354687.8 6689244.8 34.3, 354689.2 6689243.8 34.3, 354683.5 6689235.5 34.3, 354688.3 6689232.1 34.3, 354684.9 6689226.8 34.3, 354680 6689230.373684211 34.3, 354680 6689250.385321101 34.3))'),
            ('BATIMENT0000000302930087', 18.3, 'MULTIPOLYGON Z (((355011.1 6689017.5 25.2, 355020 6689014.9635 25.2, 355020 6689006.239285714 25.2, 355019.1 6689007.3 25.2, 355013.5 6689008.9 25.2, 355011.4 6689006.7 25.2, 355011 6689006.7 25.2, 355007.8 6689007.6 25.2, 355011.1 6689017.5 25.2)), ((355020 6688991.334482759 25.2, 355015 6689000.3 25.2, 355020 6689002.981159421 25.2, 355020 6688991.334482759 25.2)))'),
            ('BATIMENT0000000302930200', 19.8, 'POLYGON Z ((355017.2 6689238.9 36, 355006.6 6689234.4 36, 355004.2 6689240.2 36, 355007.5 6689241.5 36, 355004.6 6689247.4 36, 355007.7 6689248 36, 355005.4 6689258.2 36, 355010.3 6689259.2 36, 355011.8 6689252.8 36, 355011.6 6689252.7 36, 355017.2 6689238.9 36))'),
            ('BATIMENT0000000302930201', 21.8, 'MULTIPOLYGON Z (((355011.8 6689252.8 37.5, 355015.6 6689253.9 37.5, 355016.8 6689254.3 37.5, 355016.3 6689256.3 37.5, 355018 6689256.8 37.5, 355018.2 6689256.1 37.5, 355019.3 6689256.4 37.5, 355019.9 6689255.8 37.5, 355019.8 6689255.3 37.5, 355020 6689255.362857142 37.5, 355020 6689240.035135135 37.5, 355017.2 6689238.9 37.5, 355011.6 6689252.7 37.5, 355011.8 6689252.8 37.5)), ((355020 6689263.042990655 37.5, 355010 6689260.8 37.5, 355010.3 6689259.2 37.5, 355005.4 6689258.2 37.5, 355005.3 6689258.8 37.5, 355004 6689263.8 37.5, 355015.3 6689267.2 37.5, 355015.1 6689267.7 37.5, 355020 6689269.235820895 37.5, 355020 6689263.042990655 37.5)))'),
            ('BATIMENT0000000302930224', 17.4, 'POLYGON Z ((355020 6689069.724242424 30.6, 355018.4 6689067.3 30.6, 355019.2 6689065.7 30.6, 355020 6689065.877777778 30.6, 355020 6689056.682758621 30.6, 355019.2 6689056.6 30.6, 355018.5 6689058.1 30.6, 355016.4 6689057.9 30.6, 355012.7 6689069.3 30.6, 355013.8 6689069.8 30.6, 355014.2 6689072.2 30.6, 355009.4 6689075.6 30.6, 355011.9 6689079.7 30.6, 355015.2 6689077.7 30.6, 355015.9 6689078.7 30.6, 355018.4 6689082.7 30.6, 355015.1 6689084.8 30.6, 355020 6689092.440677966 30.6, 355020 6689069.724242424 30.6))'),
            ('BATIMENT0000000302930247', 21.8, 'POLYGON Z ((355013.9 6689130.9 36.8, 355009.5 6689134.2 36.8, 355005.6 6689136.9 36.8, 355003.1 6689138.9 36.8, 355004.1 6689140.6 36.8, 355006.1 6689143.6 36.8, 355006.4 6689143.4 36.8, 355012.9 6689139.1 36.8, 355013.7 6689140.3 36.8, 355012.2 6689141.2 36.8, 355012.9 6689142.5 36.8, 355013.9 6689141.8 36.8, 355019.9 6689139.5 36.8, 355020 6689139.75 36.8, 355020 6689137.490909091 36.8, 355019.9 6689137.5 36.8, 355019.7 6689135.4 36.8, 355016.9 6689130.9 36.8, 355018.3 6689129.3 36.8, 355017.5 6689126.4 36.8, 355016.8 6689125.5 36.8, 355014.9 6689126.9 36.8, 355015.6 6689128.4 36.8, 355013.3 6689129.9 36.8, 355013.9 6689130.9 36.8))'),
            ('BATIMENT0000000302930248', 6.4, 'POLYGON Z ((355018.3 6689129.3 20.2, 355020 6689129.3 20.2, 355020 6689126.381481482 20.2, 355017.5 6689126.4 20.2, 355018.3 6689129.3 20.2))'),
            ('BATIMENT0000000302930249', 6.3, 'POLYGON Z ((355020 6689105.223076923 19.2, 355019.3 6689105.6 19.2, 355018.8 6689105.5 19.2, 355008.5 6689112.1 19.2, 355016.8 6689125.5 19.2, 355017.5 6689126.4 19.2, 355020 6689126.381481482 19.2, 355020 6689119.53125 19.2, 355018.5 6689118.5 19.2, 355017.3 6689116.6 19.2, 355020 6689114.98 19.2, 355020 6689105.223076923 19.2))'),
            ('BATIMENT0000000302930250', 19.9, 'POLYGON Z ((355013.9 6689141.8 34.9, 355012.9 6689142.5 34.9, 355005.4 6689147.4 34.9, 355006.7 6689149.7 34.9, 355006.5 6689149.8 34.9, 355007.5 6689154.7 34.9, 355008 6689156.6 34.9, 355015.3 6689156.1 34.9, 355015.6 6689156.3 34.9, 355020 6689155.792307693 34.9, 355020 6689147.508955223 34.9, 355014.7 6689148.3 34.9, 355014.3 6689145.6 34.9, 355018.4 6689145.1 34.9, 355020 6689145.442857143 34.9, 355020 6689139.75 34.9, 355019.9 6689139.5 34.9, 355013.9 6689141.8 34.9))'),
            ('BATIMENT0000000302930251', 16.8, 'POLYGON Z ((355014.3 6689174.9 32.4, 355020 6689175.488387097 32.4, 355020 6689166.354054054 32.4, 355015.9 6689165.8 32.4, 355015.5 6689165.9 32.4, 355014.3 6689174.9 32.4))'),
            ('BATIMENT0000000302930252', 16.2, 'MULTIPOLYGON Z (((355020 6689182.634343434 32, 355015.4 6689182.1 32, 355014.6 6689189.2 32, 355017.2 6689189.5 32, 355016.8 6689193 32, 355020 6689192.85116279 32, 355020 6689182.634343434 32)), ((355020 6689200.88852459 32, 355015.6 6689200.6 32, 355015.3 6689203.8 32, 355020 6689204.92238806 32, 355020 6689200.88852459 32)))'),
            ('BATIMENT0000000302930253', 15.2, 'POLYGON Z ((355015.4 6689182.1 31.6, 355007.5 6689181.1 31.6, 355006.5 6689188 31.6, 355013.5 6689188.9 31.6, 355013.4 6689189.1 31.6, 355014.6 6689189.2 31.6, 355015.4 6689182.1 31.6))'),
            ('BATIMENT0000000302930254', 22.6, 'POLYGON Z ((355001.5 6689221.5 38.2, 355020 6689229.460159362 38.2, 355020 6689217.188 38.2, 355018.6 6689216.6 38.2, 355015.2 6689216.2 38.2, 355014.9 6689214.8 38.2, 355016.8 6689213.1 38.2, 355019.1 6689207.7 38.2, 355020 6689208.033333333 38.2, 355020 6689204.92238806 38.2, 355015.3 6689203.8 38.2, 355010 6689203 38.2, 355009.3 6689202.7 38.2, 355001.5 6689221.5 38.2))'),
            ('BATIMENT0000000302927578', 25.6, 'POLYGON Z ((354961.7 6689109.6 38.8, 354970.7 6689122.8 38.8, 354973.4 6689124.4 38.8, 354984.1 6689117.4 38.8, 354974 6689101.5 38.8, 354971.9 6689102.9 38.8, 354971.2 6689103.4 38.8, 354974.2 6689108 38.8, 354973.3 6689109.5 38.8, 354971.3 6689110.9 38.8, 354968.5 6689106.8 38.8, 354970.8 6689105.2 38.8, 354970.1 6689104.1 38.8, 354969.8 6689103.8 38.8, 354961.5 6689109.3 38.8, 354961.7 6689109.6 38.8))'),
            ('BATIMENT0000000302923035', 11.4, 'POLYGON Z ((354782.3 6688889.3 25.9, 354777.3 6688890.3 25.9, 354773.5 6688892.8 25.9, 354774 6688895.1 25.9, 354773.6 6688895.1 25.9, 354772.3 6688895.4 25.9, 354772 6688894.9 25.9, 354771.3 6688895 25.9, 354771.5 6688895.8 25.9, 354770.2 6688896 25.9, 354769.9 6688895.1 25.9, 354762 6688900.5 25.9, 354762.1 6688900.8 25.9, 354762.3 6688903.4 25.9, 354760.7 6688905.3 25.9, 354758.6 6688905.4 25.9, 354756.6 6688903.9 25.9, 354756.1 6688901.4 25.9, 354757.8 6688899.5 25.9, 354735.5 6688882.7 25.9, 354735.4 6688882.8 25.9, 354732.5 6688886.5 25.9, 354730.9 6688885.4 25.9, 354727.5 6688887.9 25.9, 354727.6 6688889.9 25.9, 354754.8 6688910.6 25.9, 354756.9 6688910.8 25.9, 354759.3 6688907.9 25.9, 354761.1 6688907.3 25.9, 354762.8 6688908.5 25.9, 354762.8 6688909.5 25.9, 354764.1 6688910.7 25.9, 354765.3 6688910.5 25.9, 354766 6688913.9 25.9, 354765 6688914.3 25.9, 354765.4 6688918.6 25.9, 354765.7 6688918.9 25.9, 354769.1 6688921.6 25.9, 354775.5 6688913.5 25.9, 354776.3 6688912.6 25.9, 354776.2 6688912.3 25.9, 354777.7 6688910.4 25.9, 354777.5 6688910.1 25.9, 354779 6688908 25.9, 354787 6688914.4 25.9, 354788.1 6688912.6 25.9, 354789.3 6688913.4 25.9, 354791.4 6688914.9 25.9, 354797.1 6688906.6 25.9, 354799.2 6688903.5 25.9, 354794 6688900.1 25.9, 354795.7 6688897.1 25.9, 354794 6688896 25.9, 354792.2 6688894.9 25.9, 354790.4 6688893.8 25.9, 354790.3 6688892.2 25.9, 354788.9 6688891.3 25.9, 354789.6 6688889.5 25.9, 354787 6688888.4 25.9, 354782.3 6688889.3 25.9))'),
            ('BATIMENT0000000302928132', 7.9, 'POLYGON Z ((354713.6 6689199.4 33.2, 354714.9 6689200.6 33.2, 354717.7 6689202.8 33.2, 354732.5 6689192.6 33.2, 354727.1 6689172.8 33.2, 354722.6 6689174.1 33.2, 354720.3 6689179.5 33.2, 354723.1 6689180.7 33.2, 354724.3 6689185.4 33.2, 354723.3 6689186.1 33.2, 354721.2 6689187.8 33.2, 354716.9 6689197.7 33.2, 354714.7 6689196.8 33.2, 354713.2 6689196.2 33.2, 354712.5 6689197.9 33.2, 354712.3 6689198 33.2, 354713.6 6689199.4 33.2))'),
            ('BATIMENT0000000302927699', 11.7, 'POLYGON Z ((354962.5 6689091.3 28.5, 354959.3 6689082.5 28.5, 355005.9 6689064.4 28.5, 355002.4 6689055.4 28.5, 354954.7 6689074.2 28.5, 354957.8 6689082 28.5, 354949.1 6689083.8 28.5, 354956.3 6689095.1 28.5, 354962.5 6689091.3 28.5))'),
            ('BATIMENT0000000302927700', 6.7, 'POLYGON Z ((354956.3 6689095.1 23.6, 354958.8 6689098.8 23.6, 354964.7 6689094.9 23.6, 354962.5 6689091.3 23.6, 354956.3 6689095.1 23.6))'),
            ('BATIMENT0000000302927659', 6.7, 'POLYGON Z ((355020 6689039.85 16.5, 355019.4 6689040 16.5, 355019.7 6689041.5 16.5, 355015.9 6689042.6 16.5, 355015.6 6689042.3 16.5, 355015.8 6689041.7 16.5, 355015.4 6689041.4 16.5, 355015.1 6689042 16.5, 355011.9 6689039.9 16.5, 355012.2 6689039.5 16.5, 355011.7 6689039.2 16.5, 355011.4 6689039.6 16.5, 355008.2 6689037.7 16.5, 355008.5 6689037.3 16.5, 355007.9 6689036.8 16.5, 355007.6 6689037.2 16.5, 355004.8 6689035.5 16.5, 355004.8 6689035.2 16.5, 355004.5 6689034.7 16.5, 355004 6689034.9 16.5, 355002.3 6689033.8 16.5, 355000.4 6689036.5 16.5, 354998.8 6689035.8 16.5, 354987.3 6689039.2 16.5, 354987 6689039 16.5, 354986.3 6689039 16.5, 354987.9 6689044.2 16.5, 354988.2 6689044.3 16.5, 355000.2 6689041.9 16.5, 355017.7 6689052.9 16.5, 355019.7 6689050.5 16.5, 355020 6689050.406603774 16.5, 355020 6689039.85 16.5))'),
            ('BATIMENT0000000302923036', 6.7, 'POLYGON Z ((354797.1 6688906.6 18.2, 354803.5 6688911.1 18.2, 354806.6 6688908.4 18.2, 354799.2 6688903.5 18.2, 354797.1 6688906.6 18.2))'),
            ('BATIMENT0000000302923118', 28.2, 'POLYGON Z ((354701.7 6688885.5 41.4, 354699.6 6688888 41.4, 354688.3 6688902.3 41.4, 354687.9 6688902.7 41.4, 354685.9 6688905.2 41.4, 354681.6 6688910.1 41.4, 354680 6688911.966666667 41.4, 354680 6688924.414225942 41.4, 354697.7 6688939.3 41.4, 354728.5 6688902.5 41.4, 354704.2 6688882.3 41.4, 354701.7 6688885.5 41.4), (354698.9 6688902.7 41.4, 354702.9 6688897.8 41.4, 354714.8 6688907.7 41.4, 354708.2 6688915.9 41.4, 354706.7 6688914.7 41.4, 354698.7 6688924.5 41.4, 354688 6688915.4 41.4, 354694.4 6688907.2 41.4, 354694.8 6688907.5 41.4, 354698.9 6688902.7 41.4))'),
            ('BATIMENT0000000302923122', 9.8, 'POLYGON Z ((354704.2 6688882.3 18.5, 354698.2 6688879 18.5, 354696.4 6688881.6 18.5, 354701.7 6688885.5 18.5, 354704.2 6688882.3 18.5))'),
            ('BATIMENT0000000302923445', 4.0, 'POLYGON Z ((354925.4 6688978.5 12.4, 354924 6688977.9 12.4, 354921.6 6688982.6 12.4, 354944.3 6688994.8 12.4, 354947 6688990.2 12.4, 354925.4 6688978.5 12.4))'),
            ('BATIMENT0000000302927599', 17.4, 'POLYGON Z ((354956.1 6689169.5 37.4, 354953.8 6689165.8 37.4, 354951.1 6689167.4 37.4, 354953.6 6689171.4 37.4, 354956.2 6689169.7 37.4, 354956.1 6689169.5 37.4))'),
            ('BATIMENT0000000302928036', 3.3, 'POLYGON Z ((354809.3 6689175.6 27.5, 354808.7 6689175.5 27.5, 354802.6 6689189.7 27.5, 354809.1 6689189.3 27.5, 354809.3 6689175.6 27.5))'),
            ('BATIMENT0000000302928030', 16.2, 'POLYGON Z ((354738.7 6689135.3 40.1, 354737.1 6689139.1 40.1, 354741.6 6689140.9 40.1, 354743.2 6689137.1 40.1, 354738.7 6689135.3 40.1))'),
            ('BATIMENT0000000302928274', 13.7, 'POLYGON Z ((354709.3 6689074 37.7, 354711.7 6689075.6 37.7, 354713.6 6689076.8 37.7, 354717.6 6689072 37.7, 354714.1 6689068.9 37.7, 354713.6 6689068.6 37.7, 354711.1 6689071.8 37.7, 354709.3 6689074 37.7))'),
            ('BATIMENT0000000302928277', 13.6, 'POLYGON Z ((354708.9 6689062.3 36.9, 354704.7 6689058.9 36.9, 354703.4 6689060.3 36.9, 354707.6 6689063.6 36.9, 354708.9 6689062.3 36.9))'),
            ('BATIMENT0000000302928279', 14.1, 'POLYGON Z ((354717.6 6689072 37.9, 354718.8 6689070.6 37.9, 354715 6689067.5 37.9, 354714.1 6689068.9 37.9, 354717.6 6689072 37.9))'),
            ('BATIMENT0000000302928346', 13.7, 'POLYGON Z ((354834.6 6689136.7 35.9, 354833.6 6689136 35.9, 354831.7 6689138.3 35.9, 354832.7 6689139.1 35.9, 354834.6 6689136.7 35.9))'),
            ('BATIMENT0000000302928348', 15.6, 'POLYGON Z ((354845.2 6689131.3 37.8, 354843.7 6689130.3 37.8, 354840.6 6689134.2 37.8, 354842 6689135.3 37.8, 354843.6 6689133.3 37.8, 354845.2 6689131.3 37.8))'),
            ('BATIMENT0000000302928354', 12.7, 'POLYGON Z ((354685.5 6689096.1 38.1, 354680 6689108.992473118 38.1, 354680 6689153.2 38.1, 354687.8 6689156.5 38.1, 354692.4 6689158.5 38.1, 354692.9 6689157.6 38.1, 354694.7 6689158.4 38.1, 354696.4 6689154.6 38.1, 354705.4 6689158.5 38.1, 354725 6689113.2 38.1, 354715 6689108.8 38.1, 354711.8 6689115.5 38.1, 354707.5 6689113.6 38.1, 354697.1 6689109.1 38.1, 354692.7 6689107.3 38.1, 354695.6 6689100.4 38.1, 354685.5 6689096.1 38.1))'),
            ('BATIMENT0000000302923441', 14.9, 'POLYGON Z ((354972.7 6688972.9 21.7, 354975.4 6688967.4 21.7, 354972.1 6688965.7 21.7, 354969.2 6688971.2 21.7, 354972.7 6688972.9 21.7))'),
            ('BATIMENT0000002209617002', None, 'POLYGON Z ((354745.5 6688886.6 -1000, 354759.5 6688897 -1000, 354760.1 6688896.8 -1000, 354776.2 6688884.6 -1000, 354774.7 6688883.2 -1000, 354771.1 6688881.5 -1000, 354761.6 6688888.7 -1000, 354758.7 6688889.2 -1000, 354748.9 6688882.1 -1000, 354745.5 6688886.6 -1000))')
            ]
        _df = DataFrame(data=_rawData, columns=('ID', 'HAUTEUR', 'geometry'))
        _df.geometry = _df.geometry.apply(lambda g: loads(g)) 
        return GeoDataFrame(_df, crs='epsg:2154')

    @staticmethod
    def districtGraslinInNantesTrees():
        _rawData = [
            (1655091483, 'POINT (354695.2113528537 6689168.569643417)'),
            (1655091542, 'POINT (354692.8245936075 6689179.989896608)'),
            (1655091603, 'POINT (354688.5791650632 6689186.410727716)'),
            (1655091613, 'POINT (354682.5521281994 6689194.403354734)'),
            (1937451436, 'POINT (354770.7397752265 6688993.042484771)'),
            (1937451458, 'POINT (354790.8606589965 6689008.756969644)'),
            (1937451469, 'POINT (354751.109551963 6689016.731410504)'),
            (1937451497, 'POINT (354771.7980699734 6689033.870535889)'),
            (1937451525, 'POINT (354852.437903517 6689061.70524129)'),
            (1937451548, 'POINT (354871.8154967141 6689077.029047958)'),
            (1937451563, 'POINT (354832.3473500602 6689084.252265594)'),
            (1937451582, 'POINT (354853.1830421018 6689101.060472787)'),
            (1961183507, 'POINT (354758.4278567361 6688976.54242483)'),
            (1961183517, 'POINT (354762.1750139792 6688979.719140174)'),
            (1961183521, 'POINT (354755.2937338342 6688980.684747941)'),
            (1961183528, 'POINT (354759.0408905205 6688983.861461356)'),
            (1961183533, 'POINT (354754.8146238491 6688990.748425889)'),
            (1961183542, 'POINT (354759.7503971715 6688994.813227894)'),
            (1961183547, 'POINT (354764.6868055364 6688998.889123245)'),
            (1961183578, 'POINT (354746.3580402397 6689002.486480635)'),
            (1961183585, 'POINT (354769.6225656653 6689002.953933524)'),
            (1961183592, 'POINT (354750.7014253767 6689006.140499815)'),
            (1961183599, 'POINT (354736.8151256329 6689003.049808635)'),
            (1961183604, 'POINT (354774.5583192022 6689007.018747945)'),
            (1961183610, 'POINT (354740.9609805979 6689006.303576801)'),
            (1961183615, 'POINT (354733.6734766988 6689007.192580645)'),
            (1961183618, 'POINT (354779.4947077554 6689011.094655712)'),
            (1961183622, 'POINT (354755.5944193595 6689010.2522788)'),
            (1961183624, 'POINT (354737.8268871449 6689010.445909417)'),
            (1961183627, 'POINT (354784.4304480989 6689015.159478409)'),
            (1961183629, 'POINT (354760.4880483872 6689014.375151067)'),
            (1961183632, 'POINT (354765.3885854026 6689018.486500978)'),
            (1961183664, 'POINT (354770.2815595734 6689022.598292179)'),
            (1961183671, 'POINT (354789.3668234416 6689019.235394457)'),
            (1961183678, 'POINT (354795.8952780293 6689024.621120458)'),
            (1961183683, 'POINT (354775.1745271447 6689026.710087447)'),
            (1961183698, 'POINT (354780.0750443412 6689030.821449591)'),
            (1961183702, 'POINT (354786.1998089426 6689036.174890448)'),
            (1961183747, 'POINT (354836.0600350258 6689058.658322955)'),
            (1961183762, 'POINT (354840.8627534589 6689062.652999546)'),
            (1961183769, 'POINT (354845.6654655932 6689066.647680055)'),
            (1961183777, 'POINT (354828.1698431704 6689068.917072852)'),
            (1961183782, 'POINT (354850.4688129128 6689070.65345371)'),
            (1961183796, 'POINT (354837.7652898876 6689076.996005505)'),
            (1961183804, 'POINT (354859.7080195763 6689078.341353173)'),
            (1961183843, 'POINT (354864.4394942568 6689082.284536736)'),
            (1961183859, 'POINT (354887.8693172134 6689084.56758715)'),
            (1961183865, 'POINT (354869.1703213622 6689086.216634878)'),
            (1961183871, 'POINT (354851.3295931966 6689088.416914748)'),
            (1961183877, 'POINT (354892.0281429175 6689088.310261283)'),
            (1961183881, 'POINT (354884.7276178931 6689088.710280662)'),
            (1961183920, 'POINT (354895.2666944143 6689091.216060735)'),
            (1961183924, 'POINT (354889.0216715032 6689092.300488618)'),
            (1961183932, 'POINT (354873.9017838024 6689090.159826047)'),
            (1961183935, 'POINT (354856.1190914282 6689092.445745879)'),
            (1961183939, 'POINT (354878.6325986841 6689094.091931795)'),
            (1961183943, 'POINT (354860.9085833307 6689096.474580908)'),
            (1961183946, 'POINT (354883.3640488841 6689098.035130572)'),
            (1961183956, 'POINT (354865.6905127679 6689100.503856922)'),
            (1961183960, 'POINT (354870.4799920174 6689104.532699742)'),
            (1961183965, 'POINT (354874.8232299446 6689108.186810518)'),
            (1961183970, 'POINT (354866.5033590466 6689109.313396323)'),
            (1961183994, 'POINT (354871.1486886183 6689113.995904894)'),
            (1961183997, 'POINT (354861.6546376974 6689114.745364667)'),
            (1961184005, 'POINT (354869.3876886268 6689121.430020862)'),
            (1961184008, 'POINT (354866.6538977867 6689118.862206142)'),
            (3645277788, 'POINT (354869.320098764 6688870.835717993)'),
            (3645277789, 'POINT (354878.2550702859 6688875.225610798)'),
            (3645277790, 'POINT (354854.1119337931 6688878.057417245)'),
            (3645277791, 'POINT (354887.1900283559 6688879.615517054)'),
            (3645277792, 'POINT (354863.2371008007 6688882.458538558)'),
            (3645280093, 'POINT (354896.1243315949 6688883.994347539)'),
            (3645280094, 'POINT (354872.3698104196 6688886.85923682)'),
            (3645280095, 'POINT (354905.3010677301 6688888.370295525)'),
            (3645280096, 'POINT (354881.494949831 6688891.260386198)'),
            (3645280097, 'POINT (354913.9941805064 6688892.774227297)'),
            (3645280098, 'POINT (354890.6276318424 6688895.661112544)'),
            (3645280099, 'POINT (354922.929084784 6688897.16418735)'),
            (3645280100, 'POINT (354899.7527436573 6688900.062289985)'),
            (3645280101, 'POINT (354931.8633342949 6688901.543071629)'),
            (3645280102, 'POINT (354908.8853980612 6688904.46304442)'),
            (3645280103, 'POINT (354940.7982116842 6688905.933058579)'),
            (3645280104, 'POINT (354917.0283751727 6688908.531628738)'),
            (3645280105, 'POINT (354949.7330756213 6688910.323058981)'),
            (3645280106, 'POINT (354926.1534468783 6688912.932846761)'),
            (3645280107, 'POINT (354958.6679261063 6688914.713072831)'),
            (3645280108, 'POINT (355017.1084582445 6688944.501387749)'),
            (3645280110, 'POINT (355002.2254348428 6688950.658041175)'),
            (3645280112, 'POINT (355011.2597004192 6688955.064632991)'),
            (4524050783, 'POINT (354707.9230648418 6689113.248108857)'),
            (4524050784, 'POINT (354695.7866833569 6689108.164774528)'),
            (4687035226, 'POINT (354787.8671398876 6689208.080496858)'),
            (4687035227, 'POINT (354782.5416626995 6689209.200850855)'),
            (4687035228, 'POINT (354778.7302807597 6689206.484024755)'),
            (4703259528, 'POINT (354720.7946205814 6689212.128541369)'),
            (5578627658, 'POINT (354832.967569707 6689072.956537222)'),
            (5578627659, 'POINT (354842.5630037121 6689081.035477702)'),
            (5788113829, 'POINT (354766.3568106871 6689268.049965823)')
            ]
        _df = DataFrame(
            data=_rawData,
            columns=('osm_id', 'geometry')
            )
        _df.geometry = _df.geometry.apply(lambda g: loads(g)) 

        return GeoDataFrame(_df, crs='epsg:2154')

    @staticmethod
    def districtRoyaleInNantesBuildings():
        _rawData = [
            ('BATIMENT0000000302930447', 14.4, 'POLYGON Z ((355097.9 6689182 25.3, 355098.2 6689184.2 25.3, 355099.3 6689183.9 25.3, 355098.9 6689180.8 25.3, 355097.7 6689181 25.3, 355097.9 6689182 25.3))'),
            ('BATIMENT0000000302930451', 12.6, 'POLYGON Z ((355101.4 6689213.3 23.4, 355103.2 6689212.6 23.4, 355102.3 6689209.8 23.4, 355099.1 6689210.7 23.4, 355101.4 6689213.3 23.4))'),
            ('BATIMENT0000000302930798', 17.8, 'POLYGON Z ((355073.7 6689276 32.6, 355072.9 6689278.8 32.6, 355075.8 6689279.6 32.6, 355076.6 6689276.8 32.6, 355073.7 6689276 32.6))'),
            ('BATIMENT0000000302930800', 15.7, 'POLYGON Z ((355093.2 6689285.4 30.5, 355093.3 6689289.2 30.5, 355094.4 6689289.3 30.5, 355095.9 6689289.4 30.5, 355096 6689285.4 30.5, 355093.2 6689285.4 30.5))'),
            ('BATIMENT0000000302930814', 18.8, 'POLYGON Z ((355150.5 6689185.6 25.5, 355151 6689184.1 25.5, 355150.2 6689183.7 25.5, 355150.1 6689183.6 25.5, 355150 6689183.2 25.5, 355150 6689183 25.5, 355150 6689182.9 25.5, 355150 6689182.8 25.5, 355150.1 6689182.7 25.5, 355150.2 6689182.6 25.5, 355150.3 6689182.5 25.5, 355150.5 6689182.5 25.5, 355150.6 6689182.5 25.5, 355150.7 6689182.5 25.5, 355150.9 6689182.5 25.5, 355151.5 6689182.7 25.5, 355152.1 6689180.9 25.5, 355153 6689180.5 25.5, 355153.2 6689179.7 25.5, 355149.7 6689182 25.5, 355149.6 6689182.1 25.5, 355150.5 6689185.6 25.5))'),
            ('BATIMENT0000000302930827', 13.8, 'POLYGON Z ((355208.8 6689217.2 22.3, 355211 6689216 22.3, 355211.2 6689215.5 22.3, 355210.1 6689213.7 22.3, 355207.3 6689215.3 22.3, 355208.3 6689217.1 22.3, 355208.8 6689217.2 22.3))'),
            ('BATIMENT0000000302930980', 12.7, 'POLYGON Z ((355202.5 6689403.5 23.2, 355202.5 6689404 23.2, 355204.9 6689403.9 23.2, 355204.8 6689403.5 23.2, 355202.5 6689403.5 23.2))'),
            ('BATIMENT0000000302931075', 19.8, 'POLYGON Z ((355256.8 6689205.7 27.8, 355255.1 6689208.2 27.8, 355253.7 6689210.6 27.8, 355256.1 6689212.1 27.8, 355258.5 6689208.4 27.8, 355259.2 6689207.1 27.8, 355256.8 6689205.7 27.8))'),
            ('BATIMENT0000000302931041', 18.3, 'POLYGON Z ((355183.9 6689246.1 27.3, 355182.6 6689244.3 27.3, 355181 6689245.9 27.3, 355182.3 6689247.9 27.3, 355183.9 6689246.1 27.3))'),
            ('BATIMENT0000000302931093', 9.2, 'POLYGON Z ((355247.7 6689227 16.5, 355244.6 6689225.7 16.5, 355241.4 6689230.8 16.5, 355244.2 6689232.7 16.5, 355247.7 6689227 16.5))'),
            ('BATIMENT0000000302931222', 10.5, 'POLYGON Z ((355174.5 6689384.2 21.6, 355170.8 6689392.5 21.6, 355172.3 6689393.1 21.6, 355175.9 6689384.8 21.6, 355176.9 6689382.5 21.6, 355175.4 6689381.9 21.6, 355174.5 6689384.2 21.6))'),
            ('BATIMENT0000000302931373', 15.4, 'POLYGON Z ((355303.4 6689229.1 23.2, 355301.6 6689232 23.2, 355310.4 6689238.2 23.2, 355312.4 6689235.3 23.2, 355303.4 6689229.1 23.2))'),
            ('BATIMENT0000000302931476', 12.7, 'POLYGON Z ((355068.4 6689330.7 28.6, 355066.9 6689330.3 28.6, 355065.4 6689334.6 28.6, 355066.9 6689335.2 28.6, 355068.4 6689330.7 28.6))'),
            ('BATIMENT0000000302931793', 0.0, 'POLYGON Z ((355302 6689178 -1000, 355299.7 6689182.4 -1000, 355298.4 6689184.8 -1000, 355300.8 6689186.1 -1000, 355302 6689183.7 -1000, 355304.3 6689184.9 -1000, 355305.5 6689182.7 -1000, 355306.7 6689180.4 -1000, 355302 6689178 -1000))'),
            ('BATIMENT0000000302931794', 0.0, 'POLYGON Z ((355316.3 6689194.1 -1000, 355317.5 6689191.8 -1000, 355319.8 6689187.4 -1000, 355315.4 6689185 -1000, 355314.2 6689187.3 -1000, 355311.8 6689191.8 -1000, 355316.1 6689194 -1000, 355316.3 6689194.1 -1000))'),
            ('BATIMENT0000000302931838', 6.1, 'POLYGON Z ((355045.3 6689400.5 22.6, 355055.6 6689401.7 22.6, 355058.5 6689384.1 22.6, 355047.8 6689382.5 22.6, 355045.3 6689400.5 22.6))'),
            ('BATIMENT0000000302931851', 26.7, 'POLYGON Z ((355228.5 6689420.5 36.8, 355229.6 6689420.4 36.8, 355229.7 6689428.7 36.8, 355228.5 6689428.8 36.8, 355228.5 6689429.1 36.8, 355239.4 6689428.9 36.8, 355239.7 6689442.6 36.8, 355241.6 6689444.5 36.8, 355243.7 6689444.8 36.8, 355245.4 6689444.8 36.8, 355247.3 6689444.4 36.8, 355249.2 6689442.9 36.8, 355249.6 6689428.7 36.8, 355261.2 6689428.4 36.8, 355261.2 6689428.1 36.8, 355259.7 6689428 36.8, 355259.6 6689419.9 36.8, 355261 6689419.9 36.8, 355261 6689418.7 36.8, 355259.2 6689418.8 36.8, 355259.1 6689417.2 36.8, 355249.6 6689417.5 36.8, 355250.5 6689389 36.8, 355249 6689389 36.8, 355248.9 6689386.9 36.8, 355249.3 6689386.8 36.8, 355249.4 6689386.3 36.8, 355250.4 6689386.1 36.8, 355250.3 6689385.1 36.8, 355249.4 6689385 36.8, 355249.4 6689384.5 36.8, 355248.9 6689384.4 36.8, 355248.9 6689383.7 36.8, 355247.9 6689383.7 36.8, 355247.9 6689384.6 36.8, 355247.5 6689384.5 36.8, 355245.8 6689386 36.8, 355245.8 6689386.9 36.8, 355242.1 6689387 36.8, 355242.2 6689386.3 36.8, 355240.9 6689384.7 36.8, 355240.5 6689384.7 36.8, 355240.6 6689383.9 36.8, 355239.5 6689383.9 36.8, 355239.5 6689384.7 36.8, 355238.8 6689384.7 36.8, 355238.9 6689385.4 36.8, 355237.8 6689385.4 36.8, 355237.9 6689386.4 36.8, 355238.7 6689386.4 36.8, 355238.8 6689387.1 36.8, 355239.3 6689387 36.8, 355239.3 6689389.2 36.8, 355237.7 6689389.2 36.8, 355237.9 6689394.6 36.8, 355238.8 6689394.7 36.8, 355239.3 6689417.5 36.8, 355230.1 6689417.4 36.8, 355230.2 6689419.3 36.8, 355228.4 6689419.5 36.8, 355228.5 6689420.5 36.8))'),
            ('BATIMENT0000000302931852', 15.5, 'POLYGON Z ((355228.5 6689429.9 25.6, 355230.4 6689429.8 25.6, 355230.5 6689434 25.6, 355229 6689434.1 25.6, 355229 6689435.1 25.6, 355230.4 6689435.1 25.6, 355230.5 6689439.2 25.6, 355229.2 6689439.2 25.6, 355229.2 6689440.2 25.6, 355230.5 6689440.3 25.6, 355230.6 6689442.5 25.6, 355231.2 6689442.4 25.6, 355231.2 6689444.5 25.6, 355230.5 6689444.5 25.6, 355230.4 6689445.1 25.6, 355229.7 6689445 25.6, 355229.8 6689445.9 25.6, 355230.3 6689445.9 25.6, 355230.1 6689448.2 25.6, 355229.4 6689448.2 25.6, 355229.4 6689449.2 25.6, 355230.2 6689449.1 25.6, 355231.3 6689450.5 25.6, 355230.9 6689451.3 25.6, 355231.5 6689451.7 25.6, 355232 6689451.2 25.6, 355234.2 6689451.7 25.6, 355233.6 6689452.3 25.6, 355234.6 6689453.1 25.6, 355235.1 6689452.6 25.6, 355235.8 6689454.4 25.6, 355235.2 6689455.2 25.6, 355235.9 6689455.8 25.6, 355236.5 6689455.3 25.6, 355238 6689456.2 25.6, 355238 6689457 25.6, 355238.9 6689457.1 25.6, 355238.9 6689456.5 25.6, 355240.4 6689455.9 25.6, 355241.4 6689457 25.6, 355240.9 6689456.9 25.6, 355240.9 6689457.620342058 25.6, 355249.5982897081 6689457.620342058 25.6, 355249.7 6689457.6 25.6, 355249.9 6689456.8 25.6, 355249.4 6689456.7 25.6, 355249.9 6689455.4 25.6, 355252.2 6689456.1 25.6, 355252.2 6689456.8 25.6, 355253.1 6689456.7 25.6, 355253.1 6689455.7 25.6, 355254.3 6689454.7 25.6, 355255.1 6689455.2 25.6, 355255.5 6689454.3 25.6, 355254.9 6689454 25.6, 355255.5 6689452 25.6, 355256.1 6689452.4 25.6, 355256.8 6689451.7 25.6, 355256.4 6689451.3 25.6, 355258.4 6689450.3 25.6, 355258.9 6689451 25.6, 355259.7 6689450.4 25.6, 355259.2 6689449.6 25.6, 355260.1 6689448.1 25.6, 355261.1 6689448.1 25.6, 355261.1 6689447 25.6, 355260.1 6689447 25.6, 355260 6689444.9 25.6, 355260.6 6689445 25.6, 355260.6 6689444.1 25.6, 355259.7 6689444.1 25.6, 355259.6 6689439.6 25.6, 355260.9 6689439.5 25.6, 355260.8 6689438.5 25.6, 355259.5 6689438.5 25.6, 355259.5 6689434.5 25.6, 355260.7 6689434.5 25.6, 355260.7 6689433.6 25.6, 355259.4 6689433.6 25.6, 355259.4 6689429.4 25.6, 355261.3 6689429.4 25.6, 355261.2 6689428.4 25.6, 355249.6 6689428.7 25.6, 355249.2 6689442.9 25.6, 355247.3 6689444.4 25.6, 355245.4 6689444.8 25.6, 355243.7 6689444.8 25.6, 355241.6 6689444.5 25.6, 355239.7 6689442.6 25.6, 355239.4 6689428.9 25.6, 355228.5 6689429.1 25.6, 355228.5 6689429.9 25.6))'),
            ('BATIMENT0000000302931853', 15.5, 'POLYGON Z ((355228.7 6689391 25.6, 355229.9 6689392.2 25.6, 355229.9 6689394 25.6, 355228.7 6689394 25.6, 355228.7 6689394.8 25.6, 355229.4 6689394.8 25.6, 355229.4 6689396.3 25.6, 355229.9 6689396.3 25.6, 355230 6689399.8 25.6, 355228.7 6689399.8 25.6, 355228.8 6689401 25.6, 355230.1 6689400.9 25.6, 355230.1 6689404.7 25.6, 355228.8 6689404.8 25.6, 355228.8 6689405.8 25.6, 355229.1 6689405.9 25.6, 355229.4 6689409.3 25.6, 355228.9 6689409.4 25.6, 355228.9 6689410.6 25.6, 355230.1 6689410.5 25.6, 355230.2 6689414.2 25.6, 355228.8 6689414.3 25.6, 355228.9 6689415.2 25.6, 355230.1 6689415.2 25.6, 355230.1 6689417.4 25.6, 355239.3 6689417.5 25.6, 355238.8 6689394.7 25.6, 355237.9 6689394.6 25.6, 355237.7 6689389.2 25.6, 355235.7 6689389.2 25.6, 355235.8 6689388.3 25.6, 355234.6 6689388.3 25.6, 355234.6 6689389.3 25.6, 355234.1 6689389.3 25.6, 355233.6 6689390.8 25.6, 355232 6689390.7 25.6, 355231.9 6689389.4 25.6, 355231.1 6689389.4 25.6, 355230.1 6689388.7 25.6, 355229.1 6689388.7 25.6, 355228.7 6689389.7 25.6, 355228.7 6689391 25.6))'),
            ('BATIMENT0000000302931854', 15.5, 'POLYGON Z ((355249.6 6689417.5 25.6, 355259.1 6689417.2 25.6, 355259 6689414.8 25.6, 355260.3 6689414.8 25.6, 355260.3 6689413.7 25.6, 355259 6689413.7 25.6, 355258.9 6689410 25.6, 355260.2 6689409.9 25.6, 355260.2 6689408.9 25.6, 355258.9 6689408.9 25.6, 355258.8 6689405.1 25.6, 355260.1 6689405.1 25.6, 355260.1 6689404.1 25.6, 355258.7 6689404.1 25.6, 355258.6 6689400.4 25.6, 355260 6689400.2 25.6, 355260.1 6689399.2 25.6, 355258.6 6689399.2 25.6, 355258.4 6689395.6 25.6, 355259 6689395.5 25.6, 355259 6689394.3 25.6, 355259.9 6689394.2 25.6, 355259.9 6689393.4 25.6, 355258.5 6689393.4 25.6, 355258.4 6689391.5 25.6, 355259.2 6689390.7 25.6, 355259.1 6689390.5 25.6, 355259.8 6689390 25.6, 355259.8 6689388.9 25.6, 355258.8 6689388 25.6, 355258 6689388 25.6, 355257.4 6689388.9 25.6, 355256.6 6689388.9 25.6, 355256.6 6689390.3 25.6, 355255 6689390.3 25.6, 355254.5 6689389 25.6, 355254.1 6689389 25.6, 355254 6689387.9 25.6, 355252.9 6689388 25.6, 355252.9 6689389 25.6, 355250.5 6689389 25.6, 355249.6 6689417.5 25.6))'),
            ('BATIMENT0000000302930459', 13.2, 'POLYGON Z ((355127.3 6689181.9 20.4, 355095.7 6689199.1 20.4, 355094.2 6689196.3 20.4, 355074.1 6689207.3 20.4, 355079.1 6689216.5 20.4, 355099.2 6689205.7 20.4, 355097.8 6689202.9 20.4, 355128.2 6689186.4 20.4, 355127.3 6689181.9 20.4))'),
            ('BATIMENT0000000302931788', 9.0, 'POLYGON Z ((355268.6 6689161 15.6, 355262.5714209689 6689157.620342058 15.6, 355261.8252679682 6689157.620342058 15.6, 355260.8 6689159.5 15.6, 355267.4 6689163.1 15.6, 355268.6 6689161 15.6))'),
            ('BATIMENT0000000302931096', 16.4, 'POLYGON Z ((355209.8 6689249.4 24.7, 355211.6 6689247.1 24.7, 355209.7 6689245.6 24.7, 355207.8 6689248 24.7, 355209.8 6689249.4 24.7))'),
            ('BATIMENT0000000302930975', 7.2, 'POLYGON Z ((355225.1 6689313.5 16, 355220.9 6689311.6 16, 355215.1 6689324.9 16, 355219.4 6689326.7 16, 355225.1 6689313.5 16))'),
            ('BATIMENT0000000302931802', 6.9, 'POLYGON Z ((355312.7 6689163.9 13.2, 355305.8 6689160.3 13.2, 355304.7 6689162.6 13.2, 355311.5 6689166.2 13.2, 355312.7 6689163.9 13.2))'),
            ('BATIMENT0000000302931393', 10.4, 'POLYGON Z ((355328.4 6689300 16.5, 355325.8 6689298.7 16.5, 355324.8 6689300.6 16.5, 355325.4 6689303.7 16.5, 355326.3 6689304.1 16.5, 355328.4 6689300 16.5))'),
            ('BATIMENT0000000302931087', 16.9, 'POLYGON Z ((355248.4 6689197.1 24, 355244.9 6689201.4 24, 355246.9 6689203 24, 355250.3 6689198.7 24, 355248.4 6689197.1 24))'),
            ('BATIMENT0000000302931077', 11.9, 'POLYGON Z ((355233.1 6689243.8 19.7, 355234.3 6689244.5 19.7, 355234.9 6689244.5 19.7, 355235.1 6689244.6 19.7, 355239.7 6689239.3 19.7, 355237.1 6689237.6 19.7, 355233.1 6689243.8 19.7))'),
            ('BATIMENT0000000302931084', 19.0, 'POLYGON Z ((355240.9 6689207.8 26.2, 355240 6689207.8 26.2, 355239.3 6689208.2 26.2, 355237.5 6689210.6 26.2, 355237.5 6689211.3 26.2, 355237.5 6689212 26.2, 355238.8 6689213.1 26.2, 355242.2 6689208.8 26.2, 355240.9 6689207.8 26.2))'),
            ('BATIMENT0000000302931088', 7.5, 'POLYGON Z ((355252.4 6689192.1 14.5, 355249 6689196.2 14.5, 355251 6689197.8 14.5, 355254.4 6689193.6 14.5, 355252.4 6689192.1 14.5))'),
            ('BATIMENT0000000302931392', 16.7, 'POLYGON Z ((355315.4 6689293.7 22.7, 355314.5 6689293.3 22.7, 355311 6689291.6 22.7, 355309.2 6689295.6 22.7, 355311 6689296.3 22.7, 355311.5 6689295.4 22.7, 355314 6689296.6 22.7, 355314.5 6689295.7 22.7, 355315.4 6689293.7 22.7))'),
            ('BATIMENT0000000302930822', 11.2, 'POLYGON Z ((355207.4 6689196.7 18, 355205.6 6689198 18, 355209.3 6689202.7 18, 355211.1 6689201.2 18, 355207.4 6689196.7 18))'),
            ('BATIMENT0000000302931803', 7.6, 'POLYGON Z ((355323.6 6689169.6 14, 355322.4 6689171.8 14, 355329.1 6689175.5 14, 355330.2 6689173.2 14, 355323.6 6689169.6 14))'),
            ('BATIMENT0000000302931092', 12.7, 'POLYGON Z ((355241.4 6689230.8 20.2, 355237.9 6689236.3 20.2, 355240.6 6689238.2 20.2, 355244.2 6689232.7 20.2, 355241.4 6689230.8 20.2))'),
            ('BATIMENT0000000302930815', 3.5, 'POLYGON Z ((355205.6 6689198 10.3, 355207.4 6689196.7 10.3, 355203 6689191.5 10.3, 355201.5 6689192.8 10.3, 355205.1 6689197.4 10.3, 355205.6 6689198 10.3))'),
            ('BATIMENT0000000302931098', 16.2, 'POLYGON Z ((355230.5 6689223.5 23.7, 355234.4 6689218.6 23.7, 355232.3 6689217 23.7, 355228.4 6689222 23.7, 355230.5 6689223.5 23.7))'),
            ('BATIMENT0000000302931090', 6.5, 'POLYGON Z ((355256.3 6689187.2 13.5, 355253.1 6689191.2 13.5, 355255.1 6689192.7 13.5, 355258.3 6689188.7 13.5, 355256.3 6689187.2 13.5))'),
            ('BATIMENT0000000302930829', 13.6, 'POLYGON Z ((355201.5 6689221.1 21, 355203.6 6689220 21, 355203.8 6689219.5 21, 355202.8 6689217.8 21, 355200.1 6689219.3 21, 355201.1 6689221 21, 355201.5 6689221.1 21))'),
            ('BATIMENT0000000302931081', 9.9, 'POLYGON Z ((355239.7 6689239.3 17.7, 355235.1 6689244.6 17.7, 355235.9 6689244.8 17.7, 355236.5 6689244.1 17.7, 355237.4 6689244.5 17.7, 355240.6 6689239.9 17.7, 355239.7 6689239.3 17.7))'),
            ('BATIMENT0000000302931083', 13.5, 'POLYGON Z ((355244.8 6689202.8 20.7, 355244 6689202.9 20.7, 355243.5 6689203.1 20.7, 355241.3 6689205.8 20.7, 355241.3 6689206.4 20.7, 355241.4 6689207 20.7, 355242.8 6689208.1 20.7, 355246.2 6689203.8 20.7, 355244.8 6689202.8 20.7))'),
            ('BATIMENT0000000302930828', 13.8, 'POLYGON Z ((355205.2 6689219.3 21, 355207.3 6689217.9 21, 355207.5 6689217.5 21, 355206.5 6689215.7 21, 355205.5 6689216.3 21, 355203.7 6689217.3 21, 355204.8 6689219.2 21, 355205.2 6689219.3 21))'),
            ('BATIMENT0000000302930813', 18.1, 'POLYGON Z ((355147.1 6689186 24.7, 355147.1 6689186.2 24.7, 355147.1 6689186.7 24.7, 355147.1 6689187.2 24.7, 355147.2 6689187.4 24.7, 355147.2 6689187.6 24.7, 355147.3 6689188.3 24.7, 355147.9 6689188.2 24.7, 355148 6689188.6 24.7, 355150.4 6689188 24.7, 355150.7 6689187.3 24.7, 355150.3 6689186 24.7, 355150.5 6689185.6 24.7, 355150.1 6689183.6 24.7, 355149.8 6689182.6 24.7, 355149.6 6689182.1 24.7, 355149.7 6689182 24.7, 355153.2 6689179.7 24.7, 355153.3 6689179.3 24.7, 355151.9 6689177.3 24.7, 355151.5 6689177.6 24.7, 355151.3 6689177.2 24.7, 355151.2 6689177.2 24.7, 355150.7 6689177.7 24.7, 355150.6 6689177.7 24.7, 355150.6 6689177.8 24.7, 355150.5 6689178 24.7, 355150.2 6689178.3 24.7, 355149.9 6689178.6 24.7, 355149.6 6689179 24.7, 355149.3 6689179.5 24.7, 355149.1 6689179.8 24.7, 355148.8 6689180.2 24.7, 355148.4 6689181 24.7, 355148.3 6689181.3 24.7, 355148.1 6689181.7 24.7, 355148 6689182.1 24.7, 355147.7 6689182.9 24.7, 355147.6 6689183.2 24.7, 355147.4 6689183.8 24.7, 355147.4 6689184 24.7, 355147.3 6689184.5 24.7, 355147.2 6689185 24.7, 355147.2 6689185.2 24.7, 355147.1 6689185.5 24.7, 355147.1 6689186 24.7))'),
            ('BATIMENT0000000302930825', 15.1, 'POLYGON Z ((355213.6 6689213.5 22.2, 355214.5 6689211.5 22.2, 355214.1 6689210.7 22.2, 355212.3 6689210 22.2, 355211.4 6689212 22.2, 355211.1 6689212.7 22.2, 355213 6689213.6 22.2, 355213.6 6689213.5 22.2))'),
            ('BATIMENT0000000302931089', 14.8, 'POLYGON Z ((355220.8 6689231.5 22.5, 355222.8 6689233.1 22.5, 355225.3 6689230 22.5, 355223.4 6689228.4 22.5, 355220.8 6689231.5 22.5))'),
            ('BATIMENT0000000302930983', 4.0, 'POLYGON Z ((355218.6 6689378.7 13.2, 355220.9 6689378.6 13.2, 355220.9 6689376.1 13.2, 355219.6 6689376.1 13.2, 355219.6 6689375.8 13.2, 355218.5 6689375.9 13.2, 355218.6 6689378.7 13.2))'),
            ('BATIMENT0000000302930826', 16.2, 'POLYGON Z ((355213.8 6689207.1 23.2, 355212.4 6689205.7 23.2, 355211.8 6689205.7 23.2, 355210.4 6689207.1 23.2, 355212.2 6689209 23.2, 355213.8 6689207.6 23.2, 355213.8 6689207.1 23.2))'),
            ('BATIMENT0000000302931479', 11.9, 'POLYGON Z ((355090.7 6689351.8 26, 355090.1 6689359.2 26, 355089.5 6689365.7 26, 355092.2 6689365.2 26, 355094.3 6689357.7 26, 355096.1 6689351.7 26, 355090.8 6689350.7 26, 355090.7 6689351.8 26))'),
            ('BATIMENT0000000302931386', 10.1, 'POLYGON Z ((355325.8 6689298.7 16.2, 355315.4 6689293.7 16.2, 355314.5 6689295.7 16.2, 355324.8 6689300.6 16.2, 355325.8 6689298.7 16.2))'),
            ('BATIMENT0000000302931094', 16.9, 'POLYGON Z ((355234.7 6689218.2 24.2, 355237.2 6689215.1 24.2, 355235.1 6689213.4 24.2, 355233.4 6689215.5 24.2, 355233.7 6689215.8 24.2, 355233 6689216.8 24.2, 355234.7 6689218.2 24.2))'),
            ('BATIMENT0000000302930820', 18.6, 'POLYGON Z ((355154.8 6689213.2 25.7, 355153 6689206.4 25.7, 355152 6689206.6 25.7, 355153.7 6689213.4 25.7, 355154.8 6689213.2 25.7))'),
            ('BATIMENT0000000302931827', 27.3, 'POLYGON Z ((355061.5096039561 6689457.620342058 46.5, 355062.1 6689454.4 46.5, 355038.6529586877 6689450.372836417 46.5, 355038.6529586877 6689457.620342058 46.5, 355061.5096039561 6689457.620342058 46.5))'),
            ('BATIMENT0000000302931829', 25.1, 'POLYGON Z ((355080.8288314421 6689457.620342058 42.7, 355062.1 6689454.4 42.7, 355061.5096039561 6689457.620342058 42.7, 355080.8288314421 6689457.620342058 42.7))'),
            ('BATIMENT0000000302931036', 2.1, 'POLYGON Z ((355200.6 6689227.7 9.699999999999999, 355200.2 6689228.4 9.699999999999999, 355202.8 6689230.9 9.699999999999999, 355203.4 6689230.2 9.699999999999999, 355203.4 6689229.5 9.699999999999999, 355203.2 6689229 9.699999999999999, 355201.7 6689227.8 9.699999999999999, 355201.2 6689227.7 9.699999999999999, 355200.6 6689227.7 9.699999999999999))'),
            ('BATIMENT0000000302931408', 19.2, 'POLYGON Z ((355299.4 6689322.2 25.2, 355303.9 6689324.3 25.2, 355306.5 6689318.8 25.2, 355304.8 6689317.9 25.2, 355306.5 6689314.2 25.2, 355308.8 6689309.2 25.2, 355306.6 6689307.7 25.2, 355305.9 6689308.9 25.2, 355299.4 6689322.2 25.2))'),
            ('BATIMENT0000000302931038', 20.9, 'POLYGON Z ((355181.8 6689248.4 29.2, 355178.3 6689252.2 29.2, 355179.1 6689252.9 29.2, 355182.6 6689249.2 29.2, 355181.8 6689248.4 29.2))'),
            ('BATIMENT0000000302931409', 18.6, 'POLYGON Z ((355311.5 6689316.4 25.2, 355306.5 6689314.2 25.2, 355304.8 6689317.9 25.2, 355306.5 6689318.8 25.2, 355303.9 6689324.3 25.2, 355305.8 6689325.1 25.2, 355308.3 6689319.7 25.2, 355309.7 6689320.2 25.2, 355311.5 6689316.4 25.2))'),
            ('BATIMENT0000000302930458', 14.3, 'POLYGON Z ((355071.1 6689212.5 26.4, 355052.2 6689222.6 26.4, 355054.2 6689226.5 26.4, 355073 6689216.3 26.4, 355071.1 6689212.5 26.4))'),
            ('BATIMENT0000000302931468', 11.7, 'POLYGON Z ((355041.7 6689336.2 27.4, 355038.6529586877 6689346.513062904 27.4, 355038.6529586877 6689349.535516801 27.4, 355048.5 6689351.1 27.4, 355046.6 6689356.6 27.4, 355046.9 6689356.7 27.4, 355063.4 6689362.8 27.4, 355068.9 6689346.7 27.4, 355069.5 6689345 27.4, 355063 6689342.6 27.4, 355062.5 6689342.5 27.4, 355062.6 6689340.2 27.4, 355043.5 6689330.9 27.4, 355041.7 6689336.2 27.4))'),
            ('BATIMENT0000000302931387', 17.4, 'POLYGON Z ((355295.6 6689278.6 24.9, 355293.8 6689282.3 24.9, 355298.1 6689284.4 24.9, 355300 6689280.8 24.9, 355295.6 6689278.6 24.9))'),
            ('BATIMENT0000000302930457', 16.4, 'POLYGON Z ((355101.9328820939 6689157.620342058 24, 355102 6689157.9 24, 355102.8570162745 6689157.620342058 24, 355101.9328820939 6689157.620342058 24))'),
            ('BATIMENT0000000302930971', 17.3, 'POLYGON Z ((355131.8 6689236.9 25.2, 355133.5 6689238.7 25.2, 355134.8 6689238.8 25.2, 355136.9 6689238 25.2, 355137.3 6689235 25.2, 355131.8 6689236.9 25.2))'),
            ('BATIMENT0000000302930819', 14.7, 'POLYGON Z ((355172.1 6689209.1 22.5, 355168.3 6689213.8 22.5, 355170.2 6689216.9 22.5, 355175.6 6689215.1 22.5, 355172.1 6689209.1 22.5))'),
            ('BATIMENT0000000029192227', 3.4, 'POLYGON Z ((355154.1 6689442.1 18.9, 355156.3 6689442.9 18.9, 355158.9 6689442.5 18.9, 355160.9 6689441 18.9, 355161.8 6689438.5 18.9, 355161.3 6689435.9 18.7, 355159.5 6689434.1 18.6, 355158.4 6689431.9 17.8, 355154 6689432.3 17.8, 355153.7 6689435 18.6, 355152.4 6689437.1 18.8, 355152.5 6689439.8 19, 355154.1 6689442.1 18.9))'),
            ('BATIMENT0000000302930902', 11.0, 'POLYGON Z ((355285.2 6689446.6 20, 355290.2 6689447.5 20, 355290.9 6689441.9 20, 355285.9 6689440.9 20, 355285.2 6689446.6 20))'),
            ('BATIMENT0000000302931376', 6.6, 'POLYGON Z ((355310.9 6689249.5 14.4, 355323.3 6689253.8 14.4, 355325.9 6689246.2 14.4, 355313.6 6689242.1 14.4, 355310.9 6689249.5 14.4))'),
            ('BATIMENT0000000302930452', 14.4, 'POLYGON Z ((355090.1 6689227.5 25.9, 355093.6 6689227.2 25.9, 355091.3 6689212.6 25.9, 355088 6689213.1 25.9, 355090.1 6689227.5 25.9))'),
            ('BATIMENT0000000029192554', 2.1, 'POLYGON Z ((355225.5 6689174.4 9.199999999999999, 355232.5 6689181.6 9.300000000000001, 355241.5 6689172.7 9.199999999999999, 355228.4 6689160 9.300000000000001, 355225.4 6689163 9.300000000000001, 355219.8 6689168.7 9.300000000000001, 355225.5 6689174.4 9.199999999999999))'),
            ('BATIMENT0000000302930395', 18.8, 'POLYGON Z ((355246.7 6689323.6 25.8, 355249.1 6689346.9 25.8, 355262.8 6689346 25.8, 355261.8 6689331.1 25.8, 355267.2 6689318.5 25.8, 355253 6689312 25.8, 355246.7 6689323.6 25.8), (355249.5 6689332.4 25.8, 355253.7 6689332 25.8, 355253.8 6689332.8 25.8, 355254.8 6689332.7 25.8, 355255.1 6689335.5 25.8, 355249.9 6689336 25.8, 355249.5 6689332.4 25.8))'),
            ('BATIMENT0000000302930396', 20.3, 'POLYGON Z ((355262.8 6689346 28.1, 355267.1 6689346.6 28.1, 355270.4 6689347 28.1, 355281.8 6689348.4 28.1, 355289.6 6689328.8 28.1, 355267.2 6689318.5 28.1, 355261.8 6689331.1 28.1, 355262.8 6689346 28.1))'),
            ('BATIMENT0000000302930397', 19.2, 'POLYGON Z ((355246.7 6689323.6 26.2, 355234.6 6689345.8 26.2, 355235.8 6689347.7 26.2, 355249.1 6689346.9 26.2, 355246.7 6689323.6 26.2))'),
            ('BATIMENT0000000302930398', 15.7, 'POLYGON Z ((355288 6689352.2 23.2, 355298.5 6689332.9 23.2, 355289.6 6689328.8 23.2, 355281.8 6689348.4 23.2, 355288 6689352.2 23.2))'),
            ('BATIMENT0000000302930399', 20.5, 'POLYGON Z ((355288 6689352.2 28, 355291.4 6689354.3 28, 355293.9 6689355.8 28, 355298 6689348.1 28, 355298.8 6689346.4 28, 355299.5 6689346.7 28, 355300.7 6689344.5 28, 355306.2 6689336.4 28, 355298.5 6689332.9 28, 355288 6689352.2 28), (355294.6 6689346 28, 355297 6689341.5 28, 355298.5 6689342.3 28, 355296.3 6689346.8 28, 355295.7 6689346.5 28, 355294.6 6689346 28))'),
            ('BATIMENT0000000302930400', 16.6, 'POLYGON Z ((355298 6689348.1 23.7, 355293.9 6689355.8 23.7, 355293.8 6689356 23.7, 355298.7 6689359.2 23.7, 355302.8 6689352.3 23.7, 355303.6 6689350.9 23.7, 355311 6689338.5 23.7, 355306.2 6689336.4 23.7, 355300.7 6689344.5 23.7, 355302.7 6689345.6 23.7, 355300.8 6689349.5 23.7, 355298 6689348.1 23.7))'),
            ('BATIMENT0000000302930401', 17.6, 'POLYGON Z ((355303.6 6689350.9 24.5, 355302.8 6689352.3 24.5, 355298.7 6689359.2 24.5, 355304.9 6689363.2 24.5, 355305 6689362.9 24.5, 355310.7 6689351.6 24.5, 355316.1 6689340.8 24.5, 355311 6689338.5 24.5, 355303.6 6689350.9 24.5), (355304.9 6689353.3 24.5, 355306.5 6689350.2 24.5, 355309.3 6689351.1 24.5, 355307.5 6689354.5 24.5, 355304.9 6689353.3 24.5))'),
            ('BATIMENT0000000302930402', 18.1, 'POLYGON Z ((355305 6689362.9 25, 355308.4 6689365.2 25, 355313.7 6689354.8 25, 355312.6 6689354.3 25, 355314.3 6689351.2 25, 355315.3 6689351.7 25, 355320.1 6689342.6 25, 355316.1 6689340.8 25, 355310.7 6689351.6 25, 355305 6689362.9 25))'),
            ('BATIMENT0000000302930403', 17.8, 'POLYGON Z ((355308.4 6689365.2 24.7, 355311.9 6689367.4 24.7, 355317.9 6689355 24.7, 355323.4 6689344.1 24.7, 355320.1 6689342.6 24.7, 355315.3 6689351.7 24.7, 355316.4 6689352.3 24.7, 355315 6689355.4 24.7, 355313.7 6689354.8 24.7, 355308.4 6689365.2 24.7))'),
            ('BATIMENT0000000302930404', 15.0, 'POLYGON Z ((355311.9 6689367.4 22, 355321.3 6689368.3 22, 355325.1 6689360.9 22, 355318.9 6689357.9 22, 355319.7 6689355.9 22, 355317.9 6689355 22, 355311.9 6689367.4 22))'),
            ('BATIMENT0000000302930405', 19.4, 'POLYGON Z ((355325.1 6689360.9 26.1, 355329.4 6689352.8 26.1, 355329.6 6689352.7 26.1, 355332.1 6689348.1 26.1, 355323.4 6689344.1 26.1, 355317.9 6689355 26.1, 355319.7 6689355.9 26.1, 355318.9 6689357.9 26.1, 355325.1 6689360.9 26.1))'),
            ('BATIMENT0000000302930441', 20.9, 'POLYGON Z ((355054.9 6689167.3 34.8, 355058.5 6689166 34.8, 355056.5 6689160.1 34.8, 355055.8474584364 6689157.620342058 34.8, 355041.7071563683 6689157.620342058 34.8, 355041.9 6689167.6 34.8, 355054.7 6689167 34.8, 355054.9 6689167.3 34.8))'),
            ('BATIMENT0000000302930442', 16.9, 'POLYGON Z ((355054.9 6689167.3 27.4, 355054.7 6689167 27.4, 355041.9 6689167.6 27.4, 355042.6 6689199.6 27.4, 355049.2 6689199 27.4, 355049.2 6689199.3 27.4, 355057.4 6689196.5 27.4, 355059.5 6689202.5 27.4, 355068 6689199.6 27.4, 355080.9 6689195 27.4, 355090.9 6689190.6 27.4, 355094.1 6689182.9 27.4, 355097.9 6689182 27.4, 355097.7 6689181 27.4, 355097.3 6689177.2 27.4, 355097.2 6689176.9 27.4, 355092.3 6689178.2 27.4, 355091.7 6689176.2 27.4, 355081.8 6689179 27.4, 355081.1 6689176.1 27.4, 355081.3 6689176 27.4, 355080 6689170.9 27.4, 355080.9 6689170.7 27.4, 355078 6689161.8 27.4, 355055.3 6689168.5 27.4, 355054.9 6689167.3 27.4))'),
            ('BATIMENT0000000302930443', 14.9, 'POLYGON Z ((355058.5 6689166 22.2, 355072.1 6689161.5 22.2, 355072.8 6689161.3 22.2, 355087 6689158.3 22.2, 355087.8 6689158.1 22.2, 355087.6685868653 6689157.620342058 22.2, 355055.8474584364 6689157.620342058 22.2, 355056.5 6689160.1 22.2, 355058.5 6689166 22.2))'),
            ('BATIMENT0000000302930446', 17.5, 'POLYGON Z ((355134.4 6689172.6 24.7, 355116.8 6689178.4 24.7, 355117.8 6689180.7 24.7, 355113.1 6689182.8 24.7, 355113 6689182.6 24.7, 355110.2 6689183.7 24.7, 355109.1 6689180.9 24.7, 355099.3 6689184.2 24.7, 355099.3 6689183.9 24.7, 355098.2 6689184.2 24.7, 355097.9 6689182 24.7, 355094.1 6689182.9 24.7, 355090.9 6689190.6 24.7, 355080.9 6689195 24.7, 355068 6689199.6 24.7, 355069.1 6689201.9 24.7, 355058.5 6689207.5 24.7, 355058.7 6689208.6 24.7, 355056.8 6689209.5 24.7, 355056.7 6689207.3 24.7, 355059.4 6689206 24.7, 355059.2 6689202.6 24.7, 355059.5 6689202.5 24.7, 355057.4 6689196.5 24.7, 355049.2 6689199.3 24.7, 355049.2 6689199 24.7, 355042.6 6689199.6 24.7, 355043 6689226.8 24.7, 355043.3 6689227.4 24.7, 355043.5 6689227.3 24.7, 355045.5 6689230.9 24.7, 355045.4 6689231.1 24.7, 355045.8 6689231.8 24.7, 355090.1 6689227.5 24.7, 355088 6689213.1 24.7, 355091.3 6689212.6 24.7, 355093.6 6689227.2 24.7, 355098.2 6689226.6 24.7, 355099.2 6689226.2 24.7, 355099.1 6689225.3 24.7, 355108.1 6689223.8 24.7, 355106 6689218.1 24.7, 355111.4 6689216.2 24.7, 355110.1 6689210.1 24.7, 355109.4 6689207.5 24.7, 355106.2 6689208.4 24.7, 355106.2 6689208.7 24.7, 355107 6689211 24.7, 355103.2 6689212.6 24.7, 355101.4 6689213.3 24.7, 355099.1 6689210.7 24.7, 355102.3 6689209.8 24.7, 355104 6689209.3 24.7, 355102.4 6689204.2 24.7, 355114.8 6689200.7 24.7, 355113.2 6689195 24.7, 355120.5 6689193.3 24.7, 355125.7 6689192.4 24.7, 355138.7 6689188.2 24.7, 355135.8 6689177.5 24.7, 355134.4 6689172.6 24.7), (355127.3 6689181.9 24.7, 355128.2 6689186.4 24.7, 355097.8 6689202.9 24.7, 355099.2 6689205.7 24.7, 355079.1 6689216.5 24.7, 355074.1 6689207.3 24.7, 355094.2 6689196.3 24.7, 355095.7 6689199.1 24.7, 355127.3 6689181.9 24.7), (355071.1 6689212.5 24.7, 355073 6689216.3 24.7, 355054.2 6689226.5 24.7, 355052.2 6689222.6 24.7, 355071.1 6689212.5 24.7))'),
            ('BATIMENT0000000302930448', 19.0, 'POLYGON Z ((355116.7 6689161.6 26, 355089.8 6689169.1 26, 355090.1 6689170.4 26, 355091.7 6689176.2 26, 355092.3 6689178.2 26, 355097.2 6689176.9 26, 355097.3 6689177.2 26, 355098.3 6689176.9 26, 355098.9 6689180.8 26, 355099.3 6689183.9 26, 355099.3 6689184.2 26, 355109.1 6689180.9 26, 355111.9 6689180 26, 355113 6689182.6 26, 355113.1 6689182.8 26, 355117.8 6689180.7 26, 355116.8 6689178.4 26, 355134.4 6689172.6 26, 355130.2131390846 6689157.620342058 26, 355127.0002911435 6689157.620342058 26, 355116.7 6689161.6 26), (355115.2 6689165.6 26, 355117.5 6689165 26, 355120.5 6689174.6 26, 355118.1 6689175.5 26, 355117.6 6689174 26, 355112.7 6689175.4 26, 355113.2 6689177.5 26, 355110.7 6689178 26, 355107.9 6689167.3 26, 355110.4 6689166.8 26, 355110.9 6689168 26, 355115.5 6689166.8 26, 355115.2 6689165.6 26))'),
            ('BATIMENT0000000302930449', 17.4, 'POLYGON Z ((355140.1 6689193.3 24.5, 355138.7 6689188.2 24.5, 355125.7 6689192.4 24.5, 355126.3 6689194.5 24.5, 355125.5 6689194.8 24.5, 355125.4 6689195.4 24.5, 355124.1 6689195.7 24.5, 355124.3 6689196.5 24.5, 355121.6 6689197.3 24.5, 355120.5 6689193.3 24.5, 355113.2 6689195 24.5, 355114.8 6689200.7 24.5, 355118.5 6689199.6 24.5, 355140.1 6689193.3 24.5))'),
            ('BATIMENT0000000302930450', 16.2, 'POLYGON Z ((355109.4 6689207.5 23.5, 355110.1 6689210.1 23.5, 355114.2 6689208.9 23.5, 355113.6 6689206.8 23.5, 355119.9 6689204.9 23.5, 355119.5 6689203.1 23.5, 355118.5 6689199.6 23.5, 355114.8 6689200.7 23.5, 355102.4 6689204.2 23.5, 355104 6689209.3 23.5, 355106.2 6689208.7 23.5, 355106.2 6689208.4 23.5, 355109.4 6689207.5 23.5))'),
            ('BATIMENT0000000302930453', 18.7, 'POLYGON Z ((355108.1 6689223.8 26, 355144.5 6689213.3 26, 355144.9 6689212.7 26, 355142.1 6689201.7 26, 355123.5 6689206.4 26, 355124.2 6689209.6 26, 355116.1 6689211.7 26, 355115.4 6689208.6 26, 355114.2 6689208.9 26, 355110.1 6689210.1 26, 355111.4 6689216.2 26, 355106 6689218.1 26, 355108.1 6689223.8 26))'),
            ('BATIMENT0000000302930454', 18.3, 'POLYGON Z ((355123.5 6689206.4 25.4, 355142.1 6689201.7 25.4, 355140.1 6689193.3 25.4, 355118.5 6689199.6 25.4, 355119.5 6689203.1 25.4, 355120.7 6689202.8 25.4, 355121.8 6689206.8 25.4, 355123.5 6689206.4 25.4))'),
            ('BATIMENT0000000302930455', 19.2, 'POLYGON Z ((355110.076987622 6689157.620342058 26.5, 355108.2 6689158.2 26.5, 355108.9 6689160.9 26.5, 355102.5 6689162.9 26.5, 355101.7 6689160.2 26.5, 355090.7 6689163.5 26.5, 355091.7 6689167 26.5, 355090.4 6689167.5 26.5, 355090.1 6689166.3 26.5, 355089.3 6689166.5 26.5, 355088.8 6689164.7 26.5, 355081.5 6689166.6 26.5, 355083.1 6689172.4 26.5, 355090.1 6689170.4 26.5, 355089.8 6689169.1 26.5, 355116.7 6689161.6 26.5, 355127.0002911435 6689157.620342058 26.5, 355110.076987622 6689157.620342058 26.5))'),
            ('BATIMENT0000000302930456', 20.4, 'MULTIPOLYGON Z (((355087.6685868653 6689157.620342058 27.7, 355087.8 6689158.1 27.7, 355089.5341479426 6689157.620342058 27.7, 355087.6685868653 6689157.620342058 27.7)), ((355092.6893097058 6689157.620342058 27.7, 355092.8 6689158.1 27.7, 355080.2 6689161.4 27.7, 355081.5 6689166.6 27.7, 355088.8 6689164.7 27.7, 355088.6 6689164.2 27.7, 355090.7 6689163.5 27.7, 355101.7 6689160.2 27.7, 355108.2 6689158.2 27.7, 355110.076987622 6689157.620342058 27.7, 355102.8570162745 6689157.620342058 27.7, 355102 6689157.9 27.7, 355101.9328820939 6689157.620342058 27.7, 355092.6893097058 6689157.620342058 27.7)))'),
            ('BATIMENT0000000302930460', 15.1, 'POLYGON Z ((355083.7 6689175.5 25.6, 355081.3 6689176 25.6, 355081.1 6689176.1 25.6, 355081.8 6689179 25.6, 355091.7 6689176.2 25.6, 355090.1 6689170.4 25.6, 355083.1 6689172.4 25.6, 355083.7 6689175.5 25.6))'),
            ('BATIMENT0000000302930792', 20.4, 'POLYGON Z ((355053.8 6689254.6 35.1, 355042.1 6689249.5 35.1, 355041.1 6689249.8 35.1, 355038.6529586877 6689260.811685906 35.1, 355038.6529586877 6689262.54706612 35.1, 355039.5 6689262.9 35.1, 355039.7 6689262.5 35.1, 355051.9 6689266.5 35.1, 355053.8 6689254.6 35.1))'),
            ('BATIMENT0000000302930793', 21.7, 'POLYGON Z ((355071.2 6689261.9 35.2, 355053.8 6689254.6 35.2, 355051.9 6689266.5 35.2, 355063.5 6689270.1 35.2, 355063.3 6689270.8 35.2, 355070.3 6689273.9 35.2, 355071.2 6689261.9 35.2))'),
            ('BATIMENT0000000302930794', 17.1, 'POLYGON Z ((355039.5 6689262.9 32.5, 355039.4 6689264.2 32.5, 355038.6529586877 6689270.459690996 32.5, 355038.6529586877 6689289.888502342 32.5, 355050.3 6689297.4 32.5, 355057.9 6689284.4 32.5, 355059.5 6689281.5 32.5, 355063.3 6689270.8 32.5, 355063.5 6689270.1 32.5, 355051.9 6689266.5 32.5, 355039.7 6689262.5 32.5, 355039.5 6689262.9 32.5))'),
            ('BATIMENT0000000302930795', 16.3, 'POLYGON Z ((355084.1 6689267.5 29.2, 355071.2 6689261.9 29.2, 355070.3 6689273.9 29.2, 355067.8 6689283.6 29.2, 355059.5 6689281.5 29.2, 355057.9 6689284.4 29.2, 355066.6 6689287.3 29.2, 355067.2 6689285.6 29.2, 355071 6689286.4 29.2, 355072.7 6689279.6 29.2, 355072.9 6689278.8 29.2, 355073.7 6689276 29.2, 355076.6 6689276.8 29.2, 355075.8 6689279.6 29.2, 355080.6 6689280.9 29.2, 355084.1 6689267.5 29.2))'),
            ('BATIMENT0000000302930796', 20.4, 'POLYGON Z ((355101 6689274.9 32.5, 355084.1 6689267.5 32.5, 355080.6 6689280.9 32.5, 355079 6689287.5 32.5, 355084.7 6689288.3 32.5, 355085.4 6689284.2 32.5, 355092.7 6689285.6 32.5, 355092.8 6689285.3 32.5, 355093.2 6689282.8 32.5, 355094 6689278.3 32.5, 355094.6 6689276.1 32.5, 355101 6689276 32.5, 355101 6689274.9 32.5))'),
            ('BATIMENT0000000302930797', 9.1, 'POLYGON Z ((355050.3 6689297.4 24.7, 355059 6689303 24.7, 355062 6689296.9 24.7, 355063.1 6689294.7 24.7, 355066.6 6689287.3 24.7, 355057.9 6689284.4 24.7, 355050.3 6689297.4 24.7))'),
            ('BATIMENT0000000302930799', 11.6, 'POLYGON Z ((355068.1 6689307.2 25.5, 355084.1 6689312.6 25.5, 355084.7 6689310.7 25.5, 355084.4 6689310.7 25.5, 355087.9 6689296.3 25.5, 355089.7 6689288.5 25.5, 355093.3 6689289.2 25.5, 355093.2 6689285.4 25.5, 355092.8 6689285.3 25.5, 355092.7 6689285.6 25.5, 355085.4 6689284.2 25.5, 355084.7 6689288.3 25.5, 355079 6689287.5 25.5, 355078.1 6689291 25.5, 355084.9 6689292.1 25.5, 355083.7 6689297.3 25.5, 355084.3 6689297.4 25.5, 355082.8 6689302.2 25.5, 355072.7 6689299.1 25.5, 355072.9 6689298.7 25.5, 355071.2 6689298 25.5, 355068.1 6689307.2 25.5))'),
            ('BATIMENT0000000302930801', 18.4, 'POLYGON Z ((355101 6689276 30, 355094.6 6689276.1 30, 355094 6689278.3 30, 355093.2 6689282.8 30, 355092.8 6689285.3 30, 355093.2 6689285.4 30, 355096 6689285.4 30, 355095.9 6689289.4 30, 355109.2 6689290.3 30, 355109.1 6689289.2 30, 355103.6 6689288.3 30, 355103.7 6689286.6 30, 355105.6 6689286.4 30, 355106.2 6689285.8 30, 355106.2 6689283.9 30, 355108.9 6689283.7 30, 355109.1 6689283.6 30, 355108.9 6689278.3 30, 355101 6689274.9 30, 355101 6689276 30))'),
            ('BATIMENT0000000302930802', 15.7, 'POLYGON Z ((355059 6689303 31.1, 355062.8 6689305.4 31.1, 355068.1 6689307.2 31.1, 355071.2 6689298 31.1, 355066.7 6689296.2 31.1, 355065.8 6689298.5 31.1, 355062 6689296.9 31.1, 355059 6689303 31.1))'),
            ('BATIMENT0000000302930803', 19.8, 'POLYGON Z ((355118.8 6689298.5 31, 355119.2 6689291 31, 355109.2 6689290.3 31, 355095.9 6689289.4 31, 355094.4 6689289.3 31, 355093.4 6689296.6 31, 355096.3 6689297.2 31, 355096.2 6689297.8 31, 355103.5 6689298.4 31, 355118.8 6689298.5 31))'),
            ('BATIMENT0000000302930804', 20.4, 'POLYGON Z ((355092.8 6689305.7 31.9, 355096.3 6689306.6 31.9, 355096.7 6689302.6 31.9, 355107.9 6689303.5 31.9, 355107.8 6689308.9 31.9, 355108.1 6689309 31.9, 355108 6689309.9 31.9, 355108.7 6689310.1 31.9, 355112.3 6689311 31.9, 355112.3 6689311.6 31.9, 355118.3 6689311.8 31.9, 355118.8 6689298.5 31.9, 355103.5 6689298.4 31.9, 355096.2 6689297.8 31.9, 355096.2 6689299.3 31.9, 355096 6689302 31.9, 355093.6 6689301.7 31.9, 355092.8 6689305.7 31.9))'),
            ('BATIMENT0000000302930805', 16.7, 'POLYGON Z ((355090.4 6689314.6 29, 355100.5 6689319.6 29, 355102.1 6689313.8 29, 355103.5 6689308.5 29, 355096.3 6689306.6 29, 355092.8 6689305.7 29, 355090.8 6689312.7 29, 355090.4 6689314.6 29))'),
            ('BATIMENT0000000302930806', 14.9, 'POLYGON Z ((355108.7 6689310.1 26.8, 355107.6 6689314.5 26.8, 355102.1 6689313.8 26.8, 355100.5 6689319.6 26.8, 355108.8 6689322.1 26.8, 355117.4 6689323.2 26.8, 355118.3 6689311.8 26.8, 355112.3 6689311.6 26.8, 355112.3 6689311 26.8, 355108.7 6689310.1 26.8))'),
            ('BATIMENT0000000302930807', 18.3, 'POLYGON Z ((355119.2 6689291 29.2, 355119.3 6689282.9 29.2, 355108.9 6689278.3 29.2, 355109.1 6689283.6 29.2, 355108.9 6689283.7 29.2, 355109.1 6689289.2 29.2, 355109.2 6689290.3 29.2, 355119.2 6689291 29.2))'),
            ('BATIMENT0000000302930808', 14.8, 'POLYGON Z ((355084.7 6689310.7 29.5, 355090.8 6689312.7 29.5, 355092.8 6689305.7 29.5, 355093.6 6689301.7 29.5, 355094 6689299.5 29.5, 355094.1 6689298.4 29.5, 355087.9 6689296.3 29.5, 355084.4 6689310.7 29.5, 355084.7 6689310.7 29.5))'),
            ('BATIMENT0000000302930809', 18.8, 'POLYGON Z ((355177 6689167.2 25.2, 355159 6689179.5 25.2, 355158.7 6689179.7 25.2, 355161.9 6689184 25.2, 355165.6 6689181.1 25.2, 355167.6 6689183.9 25.2, 355172.9 6689182.1 25.2, 355176.6 6689179.3 25.2, 355179.6 6689176.6 25.2, 355181.4 6689175 25.2, 355182.9 6689173.2 25.2, 355177 6689167.2 25.2))'),
            ('BATIMENT0000000302930810', 18.7, 'POLYGON Z ((355161.2 6689170.5 25, 355162.7 6689172.7 25, 355157 6689176.7 25, 355159 6689179.5 25, 355177 6689167.2 25, 355172.4 6689162.6 25, 355161.2 6689170.5 25), (355157.9 6689176.9 25, 355160.2 6689175.1 25, 355161.6 6689176.9 25, 355159.5 6689178.8 25, 355157.9 6689176.9 25))'),
            ('BATIMENT0000000302930816', 18.2, 'POLYGON Z ((355200.2 6689191.4 25, 355185.9 6689203.5 25, 355187.1 6689205.1 25, 355184.3 6689207 25, 355178.5 6689211.6 25, 355181.6 6689215.5 25, 355188.1 6689210.2 25, 355195.3 6689204.7 25, 355205.1 6689197.4 25, 355201.5 6689192.8 25, 355200.2 6689191.4 25))'),
            ('BATIMENT0000000302930817', 16.8, 'POLYGON Z ((355184.3 6689207 25.4, 355180.8 6689202.7 25.4, 355175.2 6689207.6 25.4, 355172.7 6689204.8 25.4, 355163.2 6689211.9 25.4, 355164.2 6689213.6 25.4, 355158.7 6689216.8 25.4, 355155.2 6689219 25.4, 355159.5 6689231.9 25.4, 355163.2 6689230.3 25.4, 355167.5 6689228.3 25.4, 355170.6 6689226.2 25.4, 355173.8 6689222.8 25.4, 355173.8 6689221.8 25.4, 355178.7 6689217.9 25.4, 355181.6 6689215.5 25.4, 355178.5 6689211.6 25.4, 355184.3 6689207 25.4), (355172.1 6689209.1 25.4, 355175.6 6689215.1 25.4, 355170.2 6689216.9 25.4, 355168.3 6689213.8 25.4, 355172.1 6689209.1 25.4))'),
            ('BATIMENT0000000302930818', 19.3, 'POLYGON Z ((355158.6 6689216.5 26.1, 355157.9 6689213.7 26.1, 355150.5 6689185.6 26.1, 355150.3 6689186 26.1, 355150.7 6689187.3 26.1, 355150.4 6689188 26.1, 355148 6689188.6 26.1, 355147.9 6689188.2 26.1, 355147.3 6689188.3 26.1, 355147.5 6689189.1 26.1, 355147.5 6689189.2 26.1, 355152 6689206.6 26.1, 355153 6689206.4 26.1, 355154.8 6689213.2 26.1, 355153.7 6689213.4 26.1, 355155 6689218.4 26.1, 355155.9 6689218.1 26.1, 355158.6 6689216.5 26.1))'),
            ('BATIMENT0000000302930821', 14.5, 'POLYGON Z ((355178.7 6689217.9 23.3, 355173.8 6689221.8 23.3, 355173.8 6689222.8 23.3, 355170.6 6689226.2 23.3, 355167.5 6689228.3 23.3, 355163.2 6689230.3 23.3, 355159.5 6689231.9 23.3, 355162.2 6689239.8 23.3, 355174.6 6689235.4 23.3, 355182 6689232.5 23.3, 355183.3 6689232 23.3, 355191.4 6689227.8 23.3, 355186.6 6689220.9 23.3, 355181.8 6689224.1 23.3, 355181.6 6689223.5 23.3, 355181.3 6689223 23.3, 355178.7 6689217.9 23.3))'),
            ('BATIMENT0000000302930823', 15.2, 'POLYGON Z ((355205.1 6689197.4 23.2, 355195.3 6689204.7 23.2, 355188.1 6689210.2 23.2, 355181.6 6689215.5 23.2, 355178.7 6689217.9 23.2, 355181.3 6689223 23.2, 355208.7 6689205.1 23.2, 355209.2 6689204.7 23.2, 355209.4 6689204.8 23.2, 355210.3 6689203.9 23.2, 355209.3 6689202.7 23.2, 355205.6 6689198 23.2, 355205.1 6689197.4 23.2))'),
            ('BATIMENT0000000302930824', 18.6, 'POLYGON Z ((355206.5 6689215.7 25.6, 355207.3 6689215.3 25.6, 355210.1 6689213.7 25.6, 355210.8 6689213.3 25.6, 355211.1 6689212.7 25.6, 355211.4 6689212 25.6, 355212.3 6689210 25.6, 355212.5 6689209.4 25.6, 355212.2 6689209 25.6, 355210.4 6689207.1 25.6, 355209.4 6689206 25.6, 355200.3 6689211.8 25.6, 355195.5 6689215.1 25.6, 355198.5 6689220.2 25.6, 355200.1 6689219.3 25.6, 355202.8 6689217.8 25.6, 355203.7 6689217.3 25.6, 355205.5 6689216.3 25.6, 355206.5 6689215.7 25.6))'),
            ('BATIMENT0000000302930830', 10.5, 'POLYGON Z ((355195.5 6689215.1 17.7, 355186.6 6689220.9 17.7, 355191.4 6689227.8 17.7, 355196.2 6689224.4 17.7, 355198.7 6689222.4 17.7, 355199.1 6689221.2 17.7, 355198.5 6689220.2 17.7, 355195.5 6689215.1 17.7))'),
            ('BATIMENT0000000302930831', 18.5, 'POLYGON Z ((355126.1 6689390.6 32.2, 355127.8 6689389.5 32.2, 355115.2 6689364.4 32.2, 355114.3 6689364.1 32.2, 355096.3 6689382.8 32.2, 355097.8 6689384.3 32.2, 355100.9 6689387.5 32.2, 355107.9 6689380.3 32.2, 355110.2 6689384.9 32.2, 355108.8 6689385.7 32.2, 355108.4 6689386.6 32.2, 355110.4 6689390.5 32.2, 355111.1 6689390.9 32.2, 355111.5 6689390.7 32.2, 355112.1 6689391.6 32.2, 355113.3 6689391 32.2, 355116.4 6689397 32.2, 355116.5 6689397.1 32.2, 355117.3 6689396.6 32.2, 355126.1 6689390.6 32.2))'),
            ('BATIMENT0000000302930832', 19.5, 'POLYGON Z ((355158.3 6689260.4 28.5, 355133.6 6689271.5 28.5, 355133.5 6689271.4 28.5, 355128.8 6689273.5 28.5, 355128.7 6689276.8 28.5, 355133.3 6689279 28.5, 355133.4 6689278.8 28.5, 355145.6 6689284.2 28.5, 355145.5 6689284.4 28.5, 355150.1 6689286.4 28.5, 355150.8 6689285.4 28.5, 355151.1 6689285.1 28.5, 355151.2 6689284.9 28.5, 355151.8 6689284.1 28.5, 355152.3 6689283.4 28.5, 355152.7 6689282.9 28.5, 355153 6689282.6 28.5, 355153.1 6689282.5 28.5, 355153.3 6689282.3 28.5, 355153.7 6689281.8 28.5, 355154 6689281.5 28.5, 355154.1 6689281.4 28.5, 355154.4 6689281.1 28.5, 355154.7 6689280.8 28.5, 355155.1 6689280.4 28.5, 355155.6 6689279.9 28.5, 355155.7 6689279.8 28.5, 355155.9 6689279.7 28.5, 355156 6689279.5 28.5, 355156.7 6689279 28.5, 355157.2 6689278.5 28.5, 355157.7 6689278.1 28.5, 355157.8 6689278 28.5, 355158 6689277.8 28.5, 355158.4 6689277.6 28.5, 355158.5 6689277.4 28.5, 355159.1 6689277.1 28.5, 355159.4 6689276.8 28.5, 355160 6689276.5 28.5, 355160.5 6689276.3 28.5, 355164.6 6689274.6 28.5, 355162.7 6689269.5 28.5, 355162.2 6689269.6 28.5, 355159 6689260.7 28.5, 355158.3 6689260.4 28.5))'),
            ('BATIMENT0000000302930895', 7.3, 'POLYGON Z ((355064.5 6689388.1 22.8, 355063.5 6689395.2 22.8, 355076 6689397 22.8, 355078.6 6689397.3 22.8, 355079.5 6689390.3 22.8, 355064.5 6689388.1 22.8))'),
            ('BATIMENT0000000302930901', 15.1, 'POLYGON Z ((355299.8 6689449.2 23, 355301.3 6689438.5 23, 355300.1 6689436.7 23, 355274.1 6689429.9 23, 355270.9 6689432.6 23, 355270.9 6689438.3 23, 355284.3 6689440.7 23, 355285.9 6689440.9 23, 355290.9 6689441.9 23, 355290.2 6689447.5 23, 355292.8 6689447.9 23, 355299.8 6689449.2 23))'),
            ('BATIMENT0000000302930960', 14.4, 'POLYGON Z ((355127.2 6689225.4 22.7, 355110.1 6689230.4 22.7, 355111.9 6689238.9 22.7, 355132.2 6689232.2 22.7, 355131.2 6689228.8 22.7, 355128.7 6689229.5 22.7, 355128.5 6689228.8 22.7, 355128.2 6689227.7 22.7, 355127.4 6689225.4 22.7, 355127.2 6689225.4 22.7))'),
            ('BATIMENT0000000302930961', 18.4, 'POLYGON Z ((355132.2 6689232.2 26, 355111.9 6689238.9 26, 355111.7 6689239 26, 355111.7 6689239.5 26, 355112.8 6689245.6 26, 355113.8 6689248.8 26, 355114.5 6689248.6 26, 355150.8 6689236.3 26, 355148.3 6689226.5 26, 355132.2 6689232.2 26), (355131.8 6689236.9 26, 355137.3 6689235 26, 355136.9 6689238 26, 355134.8 6689238.8 26, 355133.5 6689238.7 26, 355131.8 6689236.9 26))'),
            ('BATIMENT0000000302930962', 21.3, 'POLYGON Z ((355146.9 6689221.4 28.6, 355145.7 6689217 28.6, 355145.4 6689216.8 28.6, 355126.2 6689222.3 28.6, 355127.2 6689225.4 28.6, 355127.4 6689225.4 28.6, 355128.2 6689227.7 28.6, 355130.5 6689227 28.6, 355131.8 6689226.9 28.6, 355132 6689227.5 28.6, 355146.9 6689221.4 28.6))'),
            ('BATIMENT0000000302930963', 19.8, 'POLYGON Z ((355148.3 6689226.5 27.2, 355146.9 6689221.4 27.2, 355132 6689227.5 27.2, 355132.1 6689227.9 27.2, 355131.8 6689228.7 27.2, 355131.2 6689228.8 27.2, 355132.2 6689232.2 27.2, 355148.3 6689226.5 27.2))'),
            ('BATIMENT0000000302930964', 17.5, 'POLYGON Z ((355110.1 6689230.4 27.2, 355098.2 6689233.8 27.2, 355098.1 6689234 27.2, 355096.1 6689234.6 27.2, 355095.1 6689235.8 27.2, 355095.2 6689237.3 27.2, 355095.3 6689237.9 27.2, 355095.2 6689238 27.2, 355096.5 6689247.5 27.2, 355099.1 6689264.5 27.2, 355112.9 6689270.3 27.2, 355110.9 6689259.3 27.2, 355106.5 6689259.8 27.2, 355105.5 6689252.8 27.2, 355107.1 6689252.5 27.2, 355107.1 6689252.3 27.2, 355106.9 6689250.7 27.2, 355112.5 6689250 27.2, 355112.5 6689247.8 27.2, 355110.6 6689248.1 27.2, 355109.3 6689239.9 27.2, 355111.7 6689239.5 27.2, 355111.7 6689239 27.2, 355111.9 6689238.9 27.2, 355110.1 6689230.4 27.2))'),
            ('BATIMENT0000000302930965', 18.8, 'POLYGON Z ((355112.9 6689270.3 28.7, 355120.8 6689273.7 28.7, 355118.7 6689267.4 28.7, 355115.6 6689258.1 28.7, 355115.4 6689258.2 28.7, 355112.2 6689258.3 28.7, 355111.6 6689255.9 28.7, 355110.8 6689255.6 28.7, 355111.6 6689254.4 28.7, 355114.4 6689254.4 28.7, 355114.5 6689254.7 28.7, 355116.1 6689254.2 28.7, 355115 6689250.8 28.7, 355112.3 6689251.4 28.7, 355112.2 6689251.3 28.7, 355107.1 6689252.3 28.7, 355107.1 6689252.5 28.7, 355105.5 6689252.8 28.7, 355106.5 6689259.8 28.7, 355110.9 6689259.3 28.7, 355112.9 6689270.3 28.7))'),
            ('BATIMENT0000000302930966', 15.8, 'POLYGON Z ((355124.7 6689271.9 25, 355129.8 6689269.4 25, 355127.8 6689262.9 25, 355123.8 6689263.8 25, 355123.3 6689262.5 25, 355124.3 6689260.9 25, 355124.5 6689260.6 25, 355124.4 6689260.2 25, 355124.2 6689260.3 25, 355122.8 6689256.6 25, 355121.3 6689252.4 25, 355116.1 6689254.2 25, 355114.5 6689254.7 25, 355115.4 6689258.2 25, 355115.6 6689258.1 25, 355118.7 6689267.4 25, 355122.8 6689266.2 25, 355123.3 6689268.9 25, 355124.3 6689268.9 25, 355124.7 6689271.9 25))'),
            ('BATIMENT0000000302930967', 16.9, 'POLYGON Z ((355120.8 6689273.7 27, 355124.7 6689271.9 27, 355124.3 6689268.9 27, 355123.3 6689268.9 27, 355122.8 6689266.2 27, 355118.7 6689267.4 27, 355120.8 6689273.7 27))'),
            ('BATIMENT0000000302930968', 13.0, 'POLYGON Z ((355129.8 6689269.4 21.5, 355135.6 6689266.6 21.5, 355131.7 6689254.5 21.5, 355131.6 6689254.2 21.5, 355127.8 6689255.3 21.5, 355128.8 6689258.3 21.5, 355127.2 6689259.1 21.5, 355128.8 6689262.6 21.5, 355127.8 6689262.9 21.5, 355129.8 6689269.4 21.5))'),
            ('BATIMENT0000000302930969', 14.3, 'POLYGON Z ((355136.2 6689247.2 22, 355121.3 6689252.4 22, 355122.8 6689256.6 22, 355127.8 6689255.3 22, 355131.6 6689254.2 22, 355131.7 6689254.5 22, 355139.8 6689251.5 22, 355138.4 6689250.5 22, 355129.6 6689253.5 22, 355129.1 6689252.2 22, 355130.1 6689252.1 22, 355137.2 6689249.6 22, 355138 6689249.4 22, 355140.2 6689248.3 22, 355141.1 6689251.1 22, 355144.8 6689249.8 22, 355144.9 6689249.4 22, 355153.9 6689246.1 22, 355152.2 6689241.5 22, 355139.3 6689246 22, 355136.2 6689247.2 22))'),
            ('BATIMENT0000000302930970', 14.9, 'POLYGON Z ((355152.2 6689241.5 22.5, 355150.8 6689236.3 22.5, 355114.5 6689248.6 22.5, 355115 6689250.8 22.5, 355116.1 6689254.2 22.5, 355121.3 6689252.4 22.5, 355136.2 6689247.2 22.5, 355139.3 6689246 22.5, 355152.2 6689241.5 22.5))'),
            ('BATIMENT0000000302930972', 9.9, 'POLYGON Z ((355122.8 6689256.6 18.5, 355124.2 6689260.3 18.5, 355124.4 6689260.2 18.5, 355127.2 6689259.1 18.5, 355128.8 6689258.3 18.5, 355127.8 6689255.3 18.5, 355122.8 6689256.6 18.5))'),
            ('BATIMENT0000000302930973', 18.0, 'POLYGON Z ((355135.6 6689266.6 25.8, 355146.7 6689260.7 25.8, 355144.8 6689256.3 25.8, 355156 6689251.4 25.8, 355153.9 6689246.1 25.8, 355144.9 6689249.4 25.8, 355144.8 6689249.8 25.8, 355141.1 6689251.1 25.8, 355139.8 6689251.5 25.8, 355131.7 6689254.5 25.8, 355135.6 6689266.6 25.8))'),
            ('BATIMENT0000000302930974', 14.6, 'POLYGON Z ((355146.7 6689260.7 22.5, 355157.9 6689256.2 22.5, 355156 6689251.4 22.5, 355144.8 6689256.3 22.5, 355146.7 6689260.7 22.5))'),
            ('BATIMENT0000000302930976', 21.3, 'POLYGON Z ((355219.2 6689327.1 29.5, 355216.9 6689332.6 29.5, 355216.6 6689332.5 29.5, 355212.1 6689342.9 29.5, 355222.3 6689347.4 29.5, 355227.7 6689337.5 29.5, 355227.3 6689337.3 29.5, 355230.2 6689332 29.5, 355219.2 6689327.1 29.5))'),
            ('BATIMENT0000000302930977', 21.0, 'POLYGON Z ((355230.2 6689332 29.5, 355237.5 6689318.4 29.5, 355237.8 6689318.4 29.5, 355242.9 6689308.7 29.5, 355229.4 6689302.7 29.5, 355225 6689313 29.5, 355225.2 6689313.1 29.5, 355225.1 6689313.5 29.5, 355219.4 6689326.7 29.5, 355219.2 6689327.1 29.5, 355230.2 6689332 29.5))'),
            ('BATIMENT0000000302930978', 15.8, 'POLYGON Z ((355202.8 6689384.9 25.1, 355202.5 6689403.5 25.1, 355204.8 6689403.5 25.1, 355219.3 6689403.6 25.1, 355218.7 6689384.4 25.1, 355202.8 6689384.9 25.1), (355213.3 6689393.5 25.1, 355217.6 6689393.4 25.1, 355217.6 6689398.4 25.1, 355213.3 6689398.7 25.1, 355213.3 6689397.5 25.1, 355213.9 6689396.7 25.1, 355213.8 6689394.8 25.1, 355213.3 6689393.5 25.1))'),
            ('BATIMENT0000000302930979', 16.2, 'POLYGON Z ((355204.8 6689403.5 25.7, 355204.9 6689403.9 25.7, 355202.5 6689404 25.7, 355202.3 6689414.8 25.7, 355204.8 6689414.8 25.7, 355206.8 6689414.9 25.7, 355206.8 6689415.2 25.7, 355219.4 6689415.4 25.7, 355219.3 6689410.1 25.7, 355219.8 6689409.8 25.7, 355220.4 6689409.8 25.7, 355219.8 6689403.6 25.7, 355219.3 6689403.6 25.7, 355204.8 6689403.5 25.7))'),
            ('BATIMENT0000000302930981', 19.3, 'POLYGON Z ((355205 6689366.2 28.2, 355202.8 6689366.1 28.2, 355202.8 6689384.9 28.2, 355218.7 6689384.4 28.2, 355218.6 6689379.5 28.2, 355215 6689379.5 28.2, 355214.5 6689378.9 28.2, 355214.1 6689378.5 28.2, 355213.5 6689378.5 28.2, 355213.6 6689376.9 28.2, 355215.5 6689376.9 28.2, 355215.5 6689375.7 28.2, 355218.5 6689375.7 28.2, 355218.8 6689368.2 28.2, 355211.7 6689367.6 28.2, 355208.1 6689366.6 28.2, 355205 6689366.2 28.2))'),
            ('BATIMENT0000000302930982', 21.3, 'POLYGON Z ((355218.8 6689368.2 30, 355218.6 6689361 30, 355218.9 6689360.8 30, 355218.7 6689355.7 30, 355208 6689351.1 30, 355204.5 6689362.4 30, 355205.2 6689362.6 30, 355205 6689366.2 30, 355208.1 6689366.6 30, 355211.7 6689367.6 30, 355218.8 6689368.2 30))'),
            ('BATIMENT0000000302930984', 20.8, 'POLYGON Z ((355136.5522952367 6689157.620342058 27.1, 355138.8 6689165.3 27.1, 355140.2 6689170.9 27.1, 355141.7 6689175.9 27.1, 355142 6689176.4 27.1, 355153.6 6689169.6 27.1, 355169.5 6689160 27.1, 355167.0623016203 6689157.620342058 27.1, 355136.5522952367 6689157.620342058 27.1))'),
            ('BATIMENT0000000302930985', 17.3, 'POLYGON Z ((355082 6689234.4 30, 355077.8 6689235.1 30, 355070.6 6689235.3 30, 355070.3 6689251.2 30, 355082 6689256.2 30, 355082 6689234.4 30))'),
            ('BATIMENT0000000302930986', 14.3, 'POLYGON Z ((355082 6689256.2 26.9, 355094 6689261.2 26.9, 355094.6 6689260.3 26.9, 355092.5 6689246.8 26.9, 355088 6689247.5 26.9, 355087.5 6689244.2 26.9, 355092.1 6689243.5 26.9, 355090.9 6689235.1 26.9, 355087.7 6689233.5 26.9, 355082 6689234.4 26.9, 355082 6689256.2 26.9))'),
            ('BATIMENT0000000302930987', 19.1, 'POLYGON Z ((355070.6 6689235.3 32.5, 355058.5 6689236.5 32.5, 355057.2 6689245.6 32.5, 355070.3 6689251.2 32.5, 355070.6 6689235.3 32.5))'),
            ('BATIMENT0000000302930988', 20.4, 'POLYGON Z ((355058.5 6689236.5 34.8, 355045.2 6689237.8 34.8, 355044.5 6689238.2 34.8, 355044.1 6689238.8 34.8, 355044.3 6689239.7 34.8, 355044.6 6689240.3 34.8, 355057.2 6689245.6 34.8, 355058.5 6689236.5 34.8))'),
            ('BATIMENT0000000302930989', 13.3, 'POLYGON Z ((355174.9533825993 6689157.620342058 21.3, 355175.1 6689157.8 21.3, 355175.2 6689157.8 21.3, 355176.7 6689158.5 21.3, 355176.8 6689158.6 21.3, 355178.0374626631 6689157.620342058 21.3, 355174.9533825993 6689157.620342058 21.3))'),
            ('BATIMENT0000000302930990', 17.9, 'POLYGON Z ((355171.2 6689354.2 28, 355179.9 6689357.9 28, 355185.9 6689343.9 28, 355177.3 6689340.2 28, 355171.2 6689354.2 28))'),
            ('BATIMENT0000000302930991', 21.2, 'POLYGON Z ((355177.3 6689340.2 30.2, 355164.3 6689334.7 30.2, 355162.4 6689339.2 30.2, 355162.6 6689339.3 30.2, 355158.2 6689349.4 30.2, 355167.7 6689353.4 30.2, 355167.9 6689352.8 30.2, 355171.2 6689354.2 30.2, 355177.3 6689340.2 30.2))'),
            ('BATIMENT0000000302930992', 20.4, 'POLYGON Z ((355179.9 6689357.9 29.2, 355183.3 6689359.3 29.2, 355183 6689360 29.2, 355192.6 6689364.1 29.2, 355197 6689353.8 29.2, 355197.2 6689353.8 29.2, 355199 6689349.4 29.2, 355185.9 6689343.9 29.2, 355179.9 6689357.9 29.2))'),
            ('BATIMENT0000000302930993', 16.4, 'POLYGON Z ((355121.5 6689348.9 25.5, 355123 6689358.2 25.5, 355134.3 6689355.7 25.5, 355134.7 6689355.5 25.5, 355134 6689348.6 25.5, 355121.5 6689348.9 25.5))'),
            ('BATIMENT0000000302930994', 14.4, 'POLYGON Z ((355122.4 6689339.4 24.4, 355121.5 6689348.9 24.4, 355134 6689348.6 24.4, 355134.5 6689340.8 24.4, 355122.4 6689339.4 24.4))'),
            ('BATIMENT0000000302930995', 13.3, 'POLYGON Z ((355123 6689358.2 23.3, 355124.4 6689362.7 23.3, 355126.4 6689366.8 23.3, 355135.1 6689364.1 23.3, 355137 6689363.4 23.3, 355134.3 6689355.7 23.3, 355123 6689358.2 23.3))'),
            ('BATIMENT0000000302930996', 18.3, 'POLYGON Z ((355123.2 6689330.1 27.5, 355122.4 6689339.4 27.5, 355134.5 6689340.8 27.5, 355135 6689332 27.5, 355123.2 6689330.1 27.5))'),
            ('BATIMENT0000000302930997', 12.8, 'POLYGON Z ((355126.4 6689366.8 22.8, 355130.5 6689375.5 22.8, 355139 6689371 22.8, 355135.1 6689364.1 22.8, 355126.4 6689366.8 22.8))'),
            ('BATIMENT0000000302930998', 16.7, 'POLYGON Z ((355124.3 6689318.6 26.7, 355123.2 6689330.1 26.7, 355135 6689332 26.7, 355135.4 6689325.7 26.7, 355124.3 6689318.6 26.7))'),
            ('BATIMENT0000000302930999', 21.5, 'POLYGON Z ((355126.3 6689303.2 30.7, 355126 6689312.5 30.7, 355124.3 6689318.6 30.7, 355135.4 6689325.7 30.7, 355138 6689319.7 30.7, 355148.3 6689313.1 30.7, 355147.2 6689308.5 30.7, 355146.8 6689304.9 30.7, 355136.9 6689303.6 30.7, 355136.9 6689305 30.7, 355132.7 6689304.9 30.7, 355132.8 6689303.4 30.7, 355126.3 6689303.2 30.7))'),
            ('BATIMENT0000000302931000', 21.0, 'POLYGON Z ((355146.8 6689304.9 30.2, 355146.7 6689301.8 30.2, 355146.7 6689301.1 30.2, 355146.7 6689300.6 30.2, 355146.8 6689299.7 30.2, 355146.8 6689299.4 30.2, 355146.9 6689298.7 30.2, 355147 6689298.2 30.2, 355147.1 6689297.4 30.2, 355147.2 6689296.8 30.2, 355147.4 6689296.2 30.2, 355147.4 6689296 30.2, 355147.5 6689295.6 30.2, 355147.6 6689295.4 30.2, 355147.7 6689295 30.2, 355137.3 6689290.7 30.2, 355137.5 6689290.2 30.2, 355129.6 6689286.7 30.2, 355126.8 6689288.8 30.2, 355126.3 6689303.2 30.2, 355132.8 6689303.4 30.2, 355133 6689299.9 30.2, 355134.8 6689299.9 30.2, 355135.6 6689299.4 30.2, 355137.1 6689299.5 30.2, 355136.9 6689303.6 30.2, 355146.8 6689304.9 30.2))'),
            ('BATIMENT0000000302931001', 23.9, 'POLYGON Z ((355130.5 6689375.5 33.5, 355133.3 6689377.9 33.5, 355139.4 6689389.4 33.5, 355139.1 6689389.5 33.5, 355142.1 6689395 33.5, 355142.3 6689395 33.5, 355152.1 6689409.1 33.5, 355162.3 6689398.9 33.5, 355153.9 6689389.7 33.5, 355153.9 6689389.5 33.5, 355150 6689385.3 33.5, 355149.9 6689385.4 33.5, 355142.9 6689377.9 33.5, 355139 6689371 33.5, 355130.5 6689375.5 33.5))'),
            ('BATIMENT0000000302931002', 19.2, 'POLYGON Z ((355152.1 6689409.1 29.2, 355161 6689417.5 29.2, 355171.4 6689408.7 29.2, 355162.3 6689398.9 29.2, 355152.1 6689409.1 29.2))'),
            ('BATIMENT0000000302931003', 13.8, 'POLYGON Z ((355161 6689417.5 24.5, 355167 6689423 24.5, 355172.7 6689410 24.5, 355171.4 6689408.7 24.5, 355161 6689417.5 24.5))'),
            ('BATIMENT0000000302931004', 22.7, 'POLYGON Z ((355257.9 6689282.8 30.3, 355261.8 6689276 30.3, 355262 6689276.1 30.3, 355267.8 6689266.8 30.3, 355255.4 6689258.4 30.3, 355249.3 6689268.5 30.3, 355252.3 6689270.4 30.3, 355248.3 6689277.2 30.3, 355257.9 6689282.8 30.3))'),
            ('BATIMENT0000000302931005', 22.3, 'POLYGON Z ((355248.3 6689277.2 30.2, 355243.7 6689284.5 30.2, 355240.7 6689282.9 30.2, 355234.9 6689292.8 30.2, 355248.6 6689299 30.2, 355253.6 6689290.5 30.2, 355253.5 6689290.3 30.2, 355257.9 6689282.8 30.2, 355248.3 6689277.2 30.2))'),
            ('BATIMENT0000000302931033', 22.5, 'POLYGON Z ((355195.5 6689249.3 30.2, 355203.4 6689231.4 30.2, 355202.8 6689230.9 30.2, 355200.2 6689228.4 30.2, 355199.4 6689227.9 30.2, 355181.2 6689238 30.2, 355185.9 6689243.9 30.2, 355185.5 6689244.3 30.2, 355191.7 6689247.5 30.2, 355195.5 6689249.3 30.2))'),
            ('BATIMENT0000000302931034', 21.5, 'POLYGON Z ((355172.3 6689268 30, 355174.2 6689273.4 30, 355177.2 6689273.1 30, 355180.3 6689273 30, 355182.3 6689273.2 30, 355184.6 6689273.6 30, 355186.8 6689268.8 30, 355186.6 6689268.8 30, 355189.2 6689262.7 30, 355189.5 6689262.7 30, 355195.5 6689249.3 30, 355191.7 6689247.5 30, 355172.3 6689268 30))'),
            ('BATIMENT0000000302931035', 18.5, 'POLYGON Z ((355181.2 6689238 27.5, 355180.4 6689237 27.5, 355176 6689238.3 27.5, 355181 6689245.9 27.5, 355182.6 6689244.3 27.5, 355183.9 6689246.1 27.5, 355185.5 6689244.3 27.5, 355185.9 6689243.9 27.5, 355181.2 6689238 27.5))'),
            ('BATIMENT0000000302931037', 22.0, 'POLYGON Z ((355169.8 6689261.1 30.2, 355172.3 6689268 30.2, 355191.7 6689247.5 30.2, 355185.5 6689244.3 30.2, 355183.9 6689246.1 30.2, 355182.3 6689247.9 30.2, 355181.8 6689248.4 30.2, 355182.6 6689249.2 30.2, 355179.1 6689252.9 30.2, 355178.3 6689252.2 30.2, 355169.8 6689261.1 30.2))'),
            ('BATIMENT0000000302931039', 17.6, 'POLYGON Z ((355176 6689238.3 26.7, 355171.9 6689240 26.7, 355176.3 6689248.4 26.7, 355167.7 6689255.1 26.7, 355169.8 6689261.1 26.7, 355178.3 6689252.2 26.7, 355181.8 6689248.4 26.7, 355182.3 6689247.9 26.7, 355181 6689245.9 26.7, 355176 6689238.3 26.7))'),
            ('BATIMENT0000000302931040', 17.6, 'POLYGON Z ((355171.9 6689240 26.2, 355164 6689243.1 26.2, 355163.7 6689243.8 26.2, 355167.7 6689255.1 26.2, 355176.3 6689248.4 26.2, 355171.9 6689240 26.2))'),
            ('BATIMENT0000000302931042', 14.2, 'POLYGON Z ((355325.4 6689393.8 21.2, 355320 6689393.8 21.2, 355319.7 6689402.7 21.2, 355313.9 6689401.5 21.2, 355312.5 6689412.5 21.2, 355329.4 6689414.6 21.2, 355333.1 6689397.4 21.2, 355325.3 6689395.7 21.2, 355325.4 6689393.8 21.2))'),
            ('BATIMENT0000000302931043', 14.9, 'POLYGON Z ((355320 6689393.8 22, 355315.8 6689393.8 22, 355314.7 6689395.3 22, 355313.9 6689401.5 22, 355319.7 6689402.7 22, 355320 6689393.8 22))'),
            ('BATIMENT0000000302931044', 13.4, 'POLYGON Z ((355312.5 6689412.5 21.2, 355311.9 6689417.2 21.2, 355328.5 6689418.8 21.2, 355329.4 6689414.6 21.2, 355312.5 6689412.5 21.2))'),
            ('BATIMENT0000000302931045', 18.3, 'POLYGON Z ((355333.1 6689397.4 25.2, 355334.1 6689393.1 25.2, 355333.1 6689392.1 25.2, 355325.5 6689391.9 25.2, 355325.4 6689393.8 25.2, 355325.3 6689395.7 25.2, 355333.1 6689397.4 25.2))'),
            ('BATIMENT0000000302931046', 13.7, 'POLYGON Z ((355311.9 6689417.2 21.4, 355311.3 6689421.6 21.4, 355327.7 6689422.4 21.4, 355328.5 6689418.8 21.4, 355311.9 6689417.2 21.4))'),
            ('BATIMENT0000000302931047', 16.4, 'POLYGON Z ((355311.3 6689421.6 23.1, 355310.7 6689426.4 23.1, 355326.4 6689428.3 23.1, 355327.7 6689422.4 23.1, 355311.3 6689421.6 23.1))'),
            ('BATIMENT0000000302931048', 19.1, 'POLYGON Z ((355310.7 6689426.4 26, 355310 6689432.1 26, 355325.4 6689433.2 26, 355326.4 6689428.3 26, 355310.7 6689426.4 26))'),
            ('BATIMENT0000000302931072', 19.9, 'POLYGON Z ((355276.1 6689210 26.7, 355281.7 6689201.3 26.7, 355265.9 6689191.5 26.7, 355258.6 6689203 26.7, 355258.2 6689202.7 26.7, 355256.4 6689205.4 26.7, 355256.8 6689205.7 26.7, 355259.2 6689207.1 26.7, 355260 6689207.5 26.7, 355263.4 6689202.3 26.7, 355273.3 6689208.3 26.7, 355276.1 6689210 26.7))'),
            ('BATIMENT0000000302931073', 22.7, 'POLYGON Z ((355250.7 6689198.2 29.7, 355250.3 6689198.7 29.7, 355246.9 6689203 29.7, 355246.7 6689203.2 29.7, 355255.1 6689208.2 29.7, 355256.8 6689205.7 29.7, 355256.4 6689205.4 29.7, 355258.2 6689202.7 29.7, 355255.2 6689201 29.7, 355255.3 6689200.8 29.7, 355250.7 6689198.2 29.7))'),
            ('BATIMENT0000000302931074', 21.8, 'POLYGON Z ((355265.9 6689191.5 28.6, 355259.4 6689187.4 28.6, 355258.3 6689188.7 28.6, 355255.1 6689192.7 28.6, 355254.4 6689193.6 28.6, 355251 6689197.8 28.6, 355250.7 6689198.2 28.6, 355255.3 6689200.8 28.6, 355255.2 6689201 28.6, 355258.2 6689202.7 28.6, 355258.6 6689203 28.6, 355265.9 6689191.5 28.6))'),
            ('BATIMENT0000000302931078', 16.7, 'POLYGON Z ((355235 6689246.3 24, 355238.3 6689248.6 24, 355238.1 6689249 24, 355234.7 6689254.1 24, 355243.5 6689260 24, 355245.3 6689259.7 24, 355247.2 6689259.1 24, 355262.5 6689235.9 24, 355262.3 6689235.7 24, 355257.8 6689242 24, 355248.9 6689254.2 24, 355237.7 6689246.5 24, 355237.3 6689245.9 24, 355236.8 6689245.3 24, 355235.9 6689245 24, 355235.1 6689244.6 24, 355234.9 6689244.9 24, 355234.2 6689245.8 24, 355235 6689246.3 24))'),
            ('BATIMENT0000000302931079', 22.3, 'POLYGON Z ((355221.3 6689235 30.2, 355211.6 6689247.1 30.2, 355209.8 6689249.4 30.2, 355204.3 6689256.3 30.2, 355213.6 6689263 30.2, 355215.6 6689264.3 30.2, 355218 6689265.6 30.2, 355219.5 6689263.1 30.2, 355221.3 6689264.4 30.2, 355227.2 6689256.5 30.2, 355234.7 6689246.7 30.2, 355235 6689246.3 30.2, 355234.2 6689245.8 30.2, 355233.1 6689244.9 30.2, 355232.6 6689244.4 30.2, 355231.8 6689243.9 30.2, 355232.2 6689243.3 30.2, 355221.3 6689235 30.2))'),
            ('BATIMENT0000000302931080', 20.1, 'POLYGON Z ((355226.5 6689228.5 28.1, 355225.3 6689230 28.1, 355222.8 6689233.1 28.1, 355221.3 6689235 28.1, 355232.2 6689243.3 28.1, 355231.8 6689243.9 28.1, 355232.6 6689244.4 28.1, 355233.1 6689243.8 28.1, 355237.1 6689237.6 28.1, 355237.9 6689236.3 28.1, 355231.9 6689232.1 28.1, 355231.7 6689232.3 28.1, 355226.5 6689228.5 28.1))'),
            ('BATIMENT0000000302931082', 20.0, 'POLYGON Z ((355230.5 6689223.5 28, 355226.5 6689228.5 28, 355231.7 6689232.3 28, 355231.9 6689232.1 28, 355237.9 6689236.3 28, 355241.4 6689230.8 28, 355230.5 6689223.5 28))'),
            ('BATIMENT0000000302931085', 8.2, 'POLYGON Z ((355242.5 6689208.4 15.2, 355242.2 6689208.8 15.2, 355238.8 6689213.1 15.2, 355237.2 6689215.1 15.2, 355234.7 6689218.2 15.2, 355234.4 6689218.6 15.2, 355244.6 6689225.7 15.2, 355247.7 6689227 15.2, 355247.8 6689227 15.2, 355250.8 6689228.9 15.2, 355250.6 6689229.3 15.2, 355251.3 6689229.8 15.2, 355259.4 6689218.5 15.2, 355242.5 6689208.4 15.2))'),
            ('BATIMENT0000000302931086', 20.1, 'POLYGON Z ((355246.7 6689203.2 28, 355246.2 6689203.8 28, 355242.8 6689208.1 28, 355242.5 6689208.4 28, 355259.4 6689218.5 28, 355261.5 6689215.6 28, 355256.1 6689212.1 28, 355253.7 6689210.6 28, 355255.1 6689208.2 28, 355246.7 6689203.2 28))'),
            ('BATIMENT0000000302931095', 20.1, 'POLYGON Z ((355208.2 6689278.3 28.2, 355226.8 6689285.9 28.2, 355231.9 6689277.4 28.2, 355228 6689275 28.2, 355227.8 6689275.1 28.2, 355216.4 6689268.5 28.2, 355218 6689265.6 28.2, 355215.6 6689264.3 28.2, 355212.1 6689268.6 28.2, 355208.2 6689278.3 28.2))'),
            ('BATIMENT0000000302931097', 22.5, 'POLYGON Z ((355204.3 6689256.3 31, 355199.5 6689262.3 31, 355199.2 6689262.2 31, 355192.8 6689270.4 31, 355192.3 6689271.8 31, 355208.2 6689278.3 31, 355212.1 6689268.6 31, 355215.6 6689264.3 31, 355213.6 6689263 31, 355204.3 6689256.3 31))'),
            ('BATIMENT0000000302931099', 20.1, 'POLYGON Z ((355234.4 6689218.6 28, 355230.5 6689223.5 28, 355241.4 6689230.8 28, 355244.6 6689225.7 28, 355234.4 6689218.6 28))'),
            ('BATIMENT0000000302931100', 14.8, 'POLYGON Z ((355189.2 6689386.5 24.2, 355189.1 6689386.4 24.2, 355187.1 6689391.1 24.2, 355187.1 6689391.4 24.2, 355179.5 6689409.1 24.2, 355189.3 6689419.7 24.2, 355195.8 6689417.3 24.2, 355195.9 6689413.1 24.2, 355196.2 6689412.9 24.2, 355196.2 6689408.3 24.2, 355195.9 6689408.2 24.2, 355196.1 6689392.9 24.2, 355196.3 6689392.7 24.2, 355196.3 6689387.9 24.2, 355196.1 6689387.6 24.2, 355196.2 6689380.7 24.2, 355192.2 6689379.5 24.2, 355189.2 6689386.5 24.2), (355187.8 6689407.2 24.2, 355189.2 6689406.4 24.2, 355190.6 6689407.1 24.2, 355190.6 6689409 24.2, 355189.9 6689410.1 24.2, 355189.6 6689409.6 24.2, 355188.6 6689409.5 24.2, 355188.3 6689410 24.2, 355187.7 6689409.5 24.2, 355187.8 6689407.2 24.2))'),
            ('BATIMENT0000000302931214', 13.0, 'POLYGON Z ((355169.4 6689432.6 22.7, 355166.6 6689446.9 22.7, 355195.8 6689452.2 22.7, 355195.8 6689435.3 22.7, 355177.7 6689415.6 22.7, 355176.9 6689415.3 22.7, 355169.4 6689432.6 22.7), (355177.6 6689438.5 22.7, 355181.3 6689430 22.7, 355183.2 6689430.8 22.7, 355181.6 6689434.6 22.7, 355183 6689437.4 22.7, 355187.5 6689438.2 22.7, 355187.1 6689440.2 22.7, 355177.6 6689438.5 22.7))'),
            ('BATIMENT0000000302931216', 16.6, 'POLYGON Z ((355338.6529586877 6689351.016750163 23.6, 355334.5 6689349.1 23.6, 355331.1 6689355.5 23.6, 355338.6529586877 6689357.425263979 23.6, 355338.6529586877 6689351.016750163 23.6))'),
            ('BATIMENT0000000302931217', 21.4, 'POLYGON Z ((355331.1 6689355.5 28, 355328 6689363 28, 355325.6 6689369.8 28, 355338.6 6689369.7 28, 355338.6529586877 6689369.472473786 28, 355338.6529586877 6689357.425263979 28, 355331.1 6689355.5 28))'),
            ('BATIMENT0000000302931218', 22.3, 'POLYGON Z ((355338.6 6689369.7 29, 355325.6 6689369.8 29, 355325.7 6689372.1 29, 355325.7 6689384.7 29, 355332 6689384.9 29, 355335.3 6689385.1 29, 355338.6 6689369.7 29))'),
            ('BATIMENT0000000302931219', 9.9, 'POLYGON Z ((355167.1 6689393.3 21, 355165.9 6689394.4 21, 355173.9 6689403.1 21, 355175.7 6689402.9 21, 355184.4 6689382.9 21, 355173.4 6689378.2 21, 355167.1 6689393.3 21), (355174.5 6689384.2 21, 355175.4 6689381.9 21, 355176.9 6689382.5 21, 355175.9 6689384.8 21, 355172.3 6689393.1 21, 355170.8 6689392.5 21, 355174.5 6689384.2 21))'),
            ('BATIMENT0000000302931220', 17.3, 'POLYGON Z ((355169.7 6689369.8 26.6, 355152.7 6689362.5 26.6, 355147.1 6689374.6 26.6, 355152.1 6689379.9 26.6, 355152.2 6689379.8 26.6, 355160.7 6689388.8 26.6, 355160.7 6689389.1 26.6, 355165.9 6689394.4 26.6, 355167.1 6689393.3 26.6, 355173.4 6689378.2 26.6, 355167.3 6689375.6 26.6, 355169.7 6689369.8 26.6))'),
            ('BATIMENT0000000302931221', 12.6, 'POLYGON Z ((355184.4 6689382.9 22, 355186.9 6689377 22, 355169.7 6689369.8 22, 355167.3 6689375.6 22, 355173.4 6689378.2 22, 355184.4 6689382.9 22))'),
            ('BATIMENT0000000302931267', 19.5, 'POLYGON Z ((355204.8 6689435.2 29, 355204.9 6689453.8 29, 355220 6689456.6 29, 355219.9 6689435.5 29, 355204.8 6689435.2 29))'),
            ('BATIMENT0000000302931268', 21.7, 'POLYGON Z ((355152 6689320 30.7, 355140 6689327.4 30.7, 355138.7 6689349.2 30.7, 355148.9 6689353.7 30.7, 355157.5 6689333.1 30.7, 355157.8 6689333.3 30.7, 355159.7 6689328.7 30.7, 355156.6 6689326 30.7, 355156.4 6689325.8 30.7, 355156.4 6689325.7 30.7, 355156.3 6689325.7 30.7, 355156.1 6689325.4 30.7, 355156 6689325.4 30.7, 355155.7 6689325.1 30.7, 355155.6 6689325 30.7, 355155.5 6689324.9 30.7, 355155.4 6689324.8 30.7, 355155.2 6689324.6 30.7, 355155.2 6689324.5 30.7, 355155.1 6689324.5 30.7, 355155 6689324.3 30.7, 355154.9 6689324.3 30.7, 355154.7 6689324 30.7, 355154.5 6689323.8 30.7, 355154.5 6689323.7 30.7, 355154.3 6689323.5 30.7, 355152 6689320 30.7))'),
            ('BATIMENT0000000302931374', 6.9, 'POLYGON Z ((355301.6 6689232 14.7, 355301.1 6689232.9 14.7, 355301.3 6689233 14.7, 355296.5 6689240.6 14.7, 355298.2 6689245.2 14.7, 355310.9 6689249.5 14.7, 355313.6 6689242.1 14.7, 355310.8 6689241.1 14.7, 355310.4 6689238.2 14.7, 355301.6 6689232 14.7))'),
            ('BATIMENT0000000302931375', 16.6, 'POLYGON Z ((355334.6 6689225.6 23.6, 355323 6689220.6 23.6, 355323.1 6689220.2 23.6, 355312.1 6689215.3 23.6, 355311.8 6689215.6 23.6, 355311.6 6689215.5 23.6, 355308.2 6689220.9 23.6, 355308.3 6689221 23.6, 355303.4 6689229.1 23.6, 355312.4 6689235.3 23.6, 355314.7 6689231.6 23.6, 355329.4 6689237.8 23.6, 355334.6 6689225.6 23.6))'),
            ('BATIMENT0000000302931377', 17.1, 'POLYGON Z ((355338.6529586877 6689227.306508921 24, 355334.6 6689225.6 24, 355329.4 6689237.8 24, 355338.6529586877 6689241.743884031 24, 355338.6529586877 6689227.306508921 24))'),
            ('BATIMENT0000000302931379', 6.6, 'POLYGON Z ((355335.3 6689257.9 14.2, 355338.6529586877 6689259.03525373 14.2, 355338.6529586877 6689250.687155249 14.2, 355338.1 6689250.5 14.2, 355335.3 6689257.9 14.2))'),
            ('BATIMENT0000000302931381', 6.4, 'POLYGON Z ((355323.3 6689253.8 14.2, 355335.3 6689257.9 14.2, 355338.1 6689250.5 14.2, 355325.9 6689246.2 14.2, 355323.3 6689253.8 14.2))'),
            ('BATIMENT0000000302931384', 18.6, 'POLYGON Z ((355290 6689252.9 26.1, 355289.4 6689253 26.1, 355288.9 6689253.1 26.1, 355288.6 6689253.4 26.1, 355288.1 6689253.8 26.1, 355287.3 6689255.1 26.1, 355277.6 6689269.2 26.1, 355293.9 6689277.7 26.1, 355295.6 6689278.6 26.1, 355300 6689280.8 26.1, 355301.8 6689281.8 26.1, 355307.7 6689284.8 26.1, 355305.2 6689288.9 26.1, 355311 6689291.6 26.1, 355314.5 6689293.3 26.1, 355316.1 6689290 26.1, 355317 6689290.4 26.1, 355330.1 6689296.5 26.1, 355328.4 6689300 26.1, 355338.3 6689304.6 26.1, 355338.6529586877 6689303.916611902 26.1, 355338.6529586877 6689284.363732786 26.1, 355338.5 6689284.3 26.1, 355338.6529586877 6689283.943096396 26.1, 355338.6529586877 6689269.638215465 26.1, 355331.2 6689267 26.1, 355291 6689252.9 26.1, 355290 6689252.9 26.1))'),
            ('BATIMENT0000000302931385', 17.6, 'POLYGON Z ((355285.5 6689291.3 25.1, 355293.9 6689277.7 25.1, 355277.6 6689269.2 25.1, 355277.4 6689269.5 25.1, 355277.1 6689269.3 25.1, 355268.7 6689283.7 25.1, 355274 6689286.7 25.1, 355281 6689290.8 25.1, 355284.6 6689292.7 25.1, 355285.5 6689291.3 25.1))'),
            ('BATIMENT0000000302931388', 14.7, 'POLYGON Z ((355338.3 6689304.6 21, 355338.6529586877 6689304.839208968 21, 355338.6529586877 6689303.916611902 21, 355338.3 6689304.6 21))'),
            ('BATIMENT0000000302931389', 19.6, 'POLYGON Z ((355301.8 6689281.8 26.4, 355294.8 6689293.8 26.4, 355297.2 6689295.2 26.4, 355300.6 6689296.9 26.4, 355302.4 6689293.5 26.4, 355303.2 6689291.9 26.4, 355305.2 6689288.9 26.4, 355307.7 6689284.8 26.4, 355301.8 6689281.8 26.4))'),
            ('BATIMENT0000000302931394', 12.7, 'POLYGON Z ((355311 6689291.6 18.7, 355305.2 6689288.9 18.7, 355303.2 6689291.9 18.7, 355302.4 6689293.5 18.7, 355306.9 6689295.8 18.7, 355323.1 6689303.9 18.7, 355324.1 6689302 18.7, 355323.9 6689301.2 18.7, 355314 6689296.6 18.7, 355311.5 6689295.4 18.7, 355311 6689296.3 18.7, 355309.2 6689295.6 18.7, 355311 6689291.6 18.7))'),
            ('BATIMENT0000000302931396', 17.6, 'POLYGON Z ((355326.3 6689304.1 23.7, 355325.9 6689305.3 23.7, 355335.5 6689311.1 23.7, 355338.6529586877 6689312.379461496 23.7, 355338.6529586877 6689304.839208968 23.7, 355338.3 6689304.6 23.7, 355328.4 6689300 23.7, 355326.3 6689304.1 23.7), (355336.1 6689308.6 23.7, 355336.8 6689307.1 23.7, 355338.4 6689307.7 23.7, 355337.7 6689309.2 23.7, 355336.1 6689308.6 23.7))'),
            ('BATIMENT0000000302931397', 19.5, 'POLYGON Z ((355275.9 6689311.4 26.8, 355290 6689317.9 26.8, 355293.5 6689309.3 26.8, 355294.9 6689305.9 26.8, 355295.6 6689306.2 26.8, 355300.6 6689296.9 26.8, 355297.2 6689295.2 26.8, 355296.1 6689297.6 26.8, 355287.3 6689295.2 26.8, 355285.5 6689291.3 26.8, 355284.6 6689292.7 26.8, 355282.9 6689296.3 26.8, 355278.7 6689304.9 26.8, 355275.9 6689311.4 26.8))'),
            ('BATIMENT0000000302931398', 14.3, 'POLYGON Z ((355302.4 6689293.5 21.9, 355300.6 6689296.9 21.9, 355295.6 6689306.2 21.9, 355294.9 6689305.9 21.9, 355293.5 6689309.3 21.9, 355298.5 6689311.5 21.9, 355299.5 6689309.2 21.9, 355301.5 6689310 21.9, 355302.8 6689307.3 21.9, 355303.1 6689307.4 21.9, 355307.2 6689299.5 21.9, 355306.7 6689299.2 21.9, 355306.8 6689298.8 21.9, 355305.7 6689298.2 21.9, 355306.9 6689295.8 21.9, 355302.4 6689293.5 21.9))'),
            ('BATIMENT0000000302931399', 17.1, 'POLYGON Z ((355268.7 6689283.7 24.7, 355257.5 6689302.9 24.7, 355275.9 6689311.4 24.7, 355278.7 6689304.9 24.7, 355275.5 6689303.7 24.7, 355279.5 6689294.9 24.7, 355282.9 6689296.3 24.7, 355284.6 6689292.7 24.7, 355281 6689290.8 24.7, 355279.4 6689293.8 24.7, 355272.3 6689289.8 24.7, 355274 6689286.7 24.7, 355268.7 6689283.7 24.7))'),
            ('BATIMENT0000000302931401', 11.5, 'POLYGON Z ((355322.8 6689311.2 19.1, 355325.9 6689305.3 19.1, 355323.1 6689303.9 19.1, 355306.9 6689295.8 19.1, 355305.7 6689298.2 19.1, 355306.8 6689298.8 19.1, 355306.7 6689299.2 19.1, 355307.2 6689299.5 19.1, 355310 6689300.9 19.1, 355309 6689302.9 19.1, 355321.1 6689309.4 19.1, 355320.8 6689310.1 19.1, 355322.8 6689311.2 19.1))'),
            ('BATIMENT0000000302931402', 19.3, 'POLYGON Z ((355338.6529586877 6689312.379461496 25, 355335.5 6689311.1 25, 355325.9 6689305.3 25, 355322.8 6689311.2 25, 355321 6689314.7 25, 355324.5 6689316.6 25, 355323.3 6689318.6 25, 355326.5 6689320.6 25, 355327.1 6689319.8 25, 355328.7 6689320.6 25, 355326.5 6689324.4 25, 355328.9 6689325.2 25, 355329.5 6689324.1 25, 355331.9 6689318.2 25, 355338.6529586877 6689320.203625105 25, 355338.6529586877 6689312.379461496 25))'),
            ('BATIMENT0000000302931403', 20.0, 'POLYGON Z ((355294.6 6689320 26.1, 355299.4 6689322.2 26.1, 355305.9 6689308.9 26.1, 355303.1 6689307.4 26.1, 355302.8 6689307.3 26.1, 355301.5 6689310 26.1, 355299.5 6689309.2 26.1, 355298.5 6689311.5 26.1, 355294.6 6689320 26.1))'),
            ('BATIMENT0000000302931407', 20.1, 'POLYGON Z ((355305.8 6689325.1 25.7, 355318.9 6689331.2 25.7, 355321.6 6689325.4 25.7, 355318.3 6689323.9 25.7, 355319.8 6689320.5 25.7, 355320.5 6689320.8 25.7, 355321.5 6689318.1 25.7, 355321.3 6689317.2 25.7, 355313.5 6689312.3 25.7, 355311.5 6689316.4 25.7, 355309.7 6689320.2 25.7, 355308.3 6689319.7 25.7, 355305.8 6689325.1 25.7))'),
            ('BATIMENT0000000302931410', 16.9, 'POLYGON Z ((355290 6689317.9 24.5, 355294.6 6689320 24.5, 355298.5 6689311.5 24.5, 355293.5 6689309.3 24.5, 355290 6689317.9 24.5))'),
            ('BATIMENT0000000302931411', 21.1, 'MULTIPOLYGON Z (((355338.6529586877 6689320.203625105 27, 355331.9 6689318.2 27, 355329.5 6689324.1 27, 355334.2 6689325.9 27, 355334.7 6689324.6 27, 355338.6529586877 6689326.046204397 27, 355338.6529586877 6689320.203625105 27)), ((355338.6529586877 6689326.511715674 27, 355338.3 6689327.5 27, 355338.6529586877 6689327.642864231 27, 355338.6529586877 6689326.511715674 27)))'),
            ('BATIMENT0000000302931412', 20.8, 'POLYGON Z ((355318.9 6689331.2 26.7, 355338.6529586877 6689340.213486003 26.7, 355338.6529586877 6689327.642864231 26.7, 355338.3 6689327.5 26.7, 355337.4 6689327.2 26.7, 355336.6 6689329.3 26.7, 355334.5 6689328.4 26.7, 355335.2 6689326.4 26.7, 355334.2 6689325.9 26.7, 355329.5 6689324.1 26.7, 355328.9 6689325.2 26.7, 355327.8 6689328.8 26.7, 355326 6689328 26.7, 355326.1 6689327.7 26.7, 355321.6 6689325.4 26.7, 355318.9 6689331.2 26.7))'),
            ('BATIMENT0000000302931469', 12.1, 'POLYGON Z ((355061.2 6689372.5 27.2, 355075.5 6689374.4 27.2, 355077.8 6689348.8 27.2, 355076.3 6689348.4 27.2, 355070.7 6689347.1 27.2, 355068.9 6689346.7 27.2, 355063.4 6689362.8 27.2, 355063.8 6689363 27.2, 355061.2 6689372.5 27.2))'),
            ('BATIMENT0000000302931470', 17.7, 'POLYGON Z ((355042.7 6689369.7 32.6, 355061.2 6689372.5 32.6, 355063.8 6689363 32.6, 355063.4 6689362.8 32.6, 355046.9 6689356.7 32.6, 355045.6 6689361.4 32.6, 355045.3 6689361.4 32.6, 355044.9 6689362.9 32.6, 355044.6 6689363 32.6, 355042.7 6689369.7 32.6))'),
            ('BATIMENT0000000302931471', 21.0, 'POLYGON Z ((355038.6529586877 6689369.162102104 38.4, 355042.7 6689369.7 38.4, 355044.6 6689363 38.4, 355044.9 6689362.9 38.4, 355045.3 6689361.4 38.4, 355045.6 6689361.4 38.4, 355046.9 6689356.7 38.4, 355046.6 6689356.6 38.4, 355048.5 6689351.1 38.4, 355038.6529586877 6689349.535516801 38.4, 355038.6529586877 6689369.162102104 38.4))'),
            ('BATIMENT0000000302931472', 18.3, 'POLYGON Z ((355038.6529586877 6689346.513062904 36, 355041.7 6689336.2 36, 355038.6529586877 6689335.864545911 36, 355038.6529586877 6689346.513062904 36))'),
            ('BATIMENT0000000302931473', 17.1, 'POLYGON Z ((355079 6689319.4 32, 355071 6689316.8 32, 355066.9 6689330.3 32, 355068.4 6689330.7 32, 355070.6 6689331.5 32, 355069.9 6689334 32, 355068.7 6689333.7 32, 355067.8 6689336.8 32, 355068.8 6689337.1 32, 355068.2 6689338.8 32, 355064.5 6689337.6 32, 355063 6689342.6 32, 355069.5 6689345 32, 355068.9 6689346.7 32, 355070.7 6689347.1 32, 355075.2 6689331.6 32, 355079 6689319.4 32))'),
            ('BATIMENT0000000302931474', 13.5, 'POLYGON Z ((355071 6689316.8 29.8, 355064.6 6689314.2 29.8, 355064.4 6689314.8 29.8, 355060 6689313.4 29.8, 355059 6689312.5 29.8, 355058.8 6689312.8 29.8, 355044.1 6689301.5 29.8, 355044.2 6689301.2 29.8, 355043.1 6689300.4 29.8, 355042.6 6689299.8 29.8, 355042.4 6689300 29.8, 355042.2 6689299.8 29.8, 355038.6529586877 6689301.891844876 29.8, 355038.6529586877 6689335.864545911 29.8, 355041.7 6689336.2 29.8, 355043.5 6689330.9 29.8, 355062.6 6689340.2 29.8, 355062.5 6689342.5 29.8, 355063 6689342.6 29.8, 355064.5 6689337.6 29.8, 355065.4 6689334.6 29.8, 355066.9 6689330.3 29.8, 355071 6689316.8 29.8))'),
            ('BATIMENT0000000302931475', 14.1, 'POLYGON Z ((355075.2 6689331.6 28.2, 355070.7 6689347.1 28.2, 355076.3 6689348.4 28.2, 355077.8 6689348.8 28.2, 355078.9 6689349 28.2, 355090.7 6689351.8 28.2, 355090.8 6689350.7 28.2, 355091.2 6689345.6 28.2, 355091.8 6689340.1 28.2, 355092.3 6689333.5 28.2, 355093.2 6689324 28.2, 355079 6689319.4 28.2, 355075.2 6689331.6 28.2), (355079.6 6689338.7 28.2, 355081.4 6689333.3 28.2, 355083.2 6689333.8 28.2, 355082.4 6689336.6 28.2, 355088 6689338.1 28.2, 355088 6689340.6 28.2, 355086 6689340.5 28.2, 355085.7 6689343.2 28.2, 355087.8 6689343.3 28.2, 355087.6 6689346.3 28.2, 355082 6689344.8 28.2, 355081.5 6689345.4 28.2, 355078 6689343.7 28.2, 355079.6 6689338.7 28.2))'),
            ('BATIMENT0000000302931477', 11.1, 'POLYGON Z ((355075.5 6689374.4 25.5, 355088.6 6689376.5 25.5, 355096.4 6689368 25.5, 355092.2 6689365.2 25.5, 355089.5 6689365.7 25.5, 355090.1 6689359.2 25.5, 355090.7 6689351.8 25.5, 355078.9 6689349 25.5, 355077.8 6689348.8 25.5, 355075.5 6689374.4 25.5))'),
            ('BATIMENT0000000302931478', 8.2, 'POLYGON Z ((355096.1 6689351.7 22.5, 355097.4 6689347.6 22.5, 355098.9 6689347.9 22.5, 355100.1 6689341.1 22.5, 355093.6 6689340.3 22.5, 355091.8 6689340.1 22.5, 355091.2 6689345.6 22.5, 355090.8 6689350.7 22.5, 355096.1 6689351.7 22.5))'),
            ('BATIMENT0000000302931480', 17.4, 'POLYGON Z ((355100.1 6689341.1 30.8, 355098.9 6689347.9 30.8, 355097.4 6689347.6 30.8, 355096.1 6689351.7 30.8, 355094.3 6689357.7 30.8, 355092.2 6689365.2 30.8, 355096.4 6689368 30.8, 355101.8 6689371.3 30.8, 355113.1 6689359.8 30.8, 355114.8 6689343.3 30.8, 355113 6689342.7 30.8, 355107.2 6689341.8 30.8, 355105.1 6689341.5 30.8, 355100.2 6689340.8 30.8, 355100.1 6689341.1 30.8), (355097.3 6689361.3 30.8, 355100.9 6689350.9 30.8, 355105.8 6689352.6 30.8, 355100.5 6689362.6 30.8, 355097.3 6689361.3 30.8))'),
            ('BATIMENT0000000302931481', 16.5, 'POLYGON Z ((355102.7 6689326.2 30.1, 355093.2 6689324 30.1, 355092.3 6689333.5 30.1, 355094.4 6689333.8 30.1, 355093.6 6689340.3 30.1, 355100.1 6689341.1 30.1, 355100.2 6689340.8 30.1, 355102.7 6689326.2 30.1))'),
            ('BATIMENT0000000302931482', 18.8, 'POLYGON Z ((355107.6 6689327.3 32, 355102.7 6689326.2 32, 355100.2 6689340.8 32, 355105.1 6689341.5 32, 355105.2 6689340.5 32, 355107.6 6689327.3 32))'),
            ('BATIMENT0000000302931483', 20.6, 'POLYGON Z ((355113 6689342.7 33.4, 355113.5 6689331 33.4, 355111.7 6689328.3 33.4, 355107.6 6689327.3 33.4, 355105.2 6689340.5 33.4, 355107.3 6689340.9 33.4, 355107.2 6689341.8 33.4, 355113 6689342.7 33.4))'),
            ('BATIMENT0000000302931484', 17.6, 'POLYGON Z ((355277.3 6689352.9 24.9, 355267.9 6689369.6 24.9, 355269.8 6689371.1 24.9, 355270 6689387.7 24.9, 355270.6 6689387.8 24.9, 355296.2 6689367.9 24.9, 355291.2 6689360.9 24.9, 355277.8 6689352.8 24.9, 355277.3 6689352.9 24.9), (355277.3 6689367.2 24.9, 355278.1 6689366.6 24.9, 355281.1 6689370.9 24.9, 355275.7 6689374.7 24.9, 355274.6 6689373.2 24.9, 355275.2 6689372 24.9, 355278 6689369.9 24.9, 355277 6689368.6 24.9, 355278 6689368 24.9, 355277.3 6689367.2 24.9))'),
            ('BATIMENT0000000302931485', 18.5, 'POLYGON Z ((355272.1 6689390.4 25.5, 355287.3 6689382.6 25.5, 355301.7 6689375.5 25.5, 355296.2 6689367.9 25.5, 355270.6 6689387.8 25.5, 355272.1 6689390.4 25.5))'),
            ('BATIMENT0000000302931486', 12.8, 'POLYGON Z ((355270 6689387.7 22, 355270.4 6689414.5 22, 355280.2 6689414 22, 355280.3 6689411.3 22, 355280.5 6689402.5 22, 355284.3 6689401.9 22, 355289.7 6689401.2 22, 355287.8 6689395.7 22, 355290.2 6689394.8 22, 355289.1 6689391.6 22, 355286.7 6689392.4 22, 355285.3 6689388.8 22, 355273.1 6689392.4 22, 355272.1 6689390.4 22, 355270.6 6689387.8 22, 355270 6689387.7 22), (355277.1 6689395.3 22, 355279.9 6689394.4 22, 355281.6 6689399.1 22, 355277.3 6689400.7 22, 355277.1 6689395.3 22))'),
            ('BATIMENT0000000302931487', 17.7, 'POLYGON Z ((355287.3 6689382.6 24.6, 355289.3 6689387.8 24.6, 355301.4 6689384.8 24.6, 355304.7 6689383.9 24.6, 355305.2 6689383.7 24.6, 355301.7 6689375.5 24.6, 355287.3 6689382.6 24.6))'),
            ('BATIMENT0000000302931488', 13.2, 'POLYGON Z ((355306.3 6689408.6 20.2, 355307.2 6689408.4 20.2, 355307.6 6689398.7 20.2, 355306 6689398.9 20.2, 355302.7 6689399.5 20.2, 355289.7 6689401.2 20.2, 355284.3 6689401.9 20.2, 355280.5 6689402.5 20.2, 355280.3 6689411.3 20.2, 355296 6689409.6 20.2, 355306.3 6689408.6 20.2))'),
            ('BATIMENT0000000302931489', 12.8, 'POLYGON Z ((355304 6689413.1 19.7, 355304.5 6689410.1 19.7, 355306.3 6689408.6 19.7, 355296 6689409.6 19.7, 355296.1 6689413.4 19.7, 355304 6689413.1 19.7))'),
            ('BATIMENT0000000302931490', 16.8, 'POLYGON Z ((355302.9 6689421.9 23.7, 355304 6689413.1 23.7, 355296.1 6689413.4 23.7, 355290.3 6689413.6 23.7, 355290.1 6689420.5 23.7, 355302.9 6689421.9 23.7))'),
            ('BATIMENT0000000302931491', 19.8, 'POLYGON Z ((355270.4 6689414.5 27.2, 355270.5 6689418.2 27.2, 355273 6689421.5 27.2, 355285.2 6689424.8 27.2, 355285.5 6689419.9 27.2, 355285.7 6689413.9 27.2, 355280.2 6689414 27.2, 355270.4 6689414.5 27.2))'),
            ('BATIMENT0000000302931492', 15.3, 'POLYGON Z ((355285.2 6689424.8 22.8, 355300.9 6689429 22.8, 355302.3 6689427.4 22.8, 355302.9 6689421.9 22.8, 355290.1 6689420.5 22.8, 355285.5 6689419.9 22.8, 355285.2 6689424.8 22.8))'),
            ('BATIMENT0000000302931671', 8.2, 'POLYGON Z ((355087.1 6689391.4 22.5, 355086.1 6689398.4 22.5, 355105 6689401.2 22.5, 355106 6689394.1 22.5, 355095.7 6689392.6 22.5, 355087.1 6689391.4 22.5))'),
            ('BATIMENT0000000302931672', 18.5, 'POLYGON Z ((355309.2 6689439.1 25.6, 355306.7584114972 6689457.620342058 25.6, 355319.8928990145 6689457.620342058 25.6, 355323.4 6689441.4 25.6, 355322.5 6689439.7 25.6, 355309.2 6689439.1 25.6))'),
            ('BATIMENT0000000302931787', 8.4, 'POLYGON Z ((355288.5 6689166.4 14.7, 355281.7 6689162.7 14.7, 355280.4 6689165.1 14.7, 355278.3 6689164 14.7, 355277.2 6689166.1 14.7, 355276 6689165.5 14.7, 355272.6 6689163.7 14.7, 355270.3 6689168.1 14.7, 355276.9 6689171.7 14.7, 355290.2 6689178.9 14.7, 355292.5 6689174.4 14.7, 355290.6 6689173.3 14.7, 355291.9 6689170.9 14.7, 355287.5 6689168.4 14.7, 355288.5 6689166.4 14.7))'),
            ('BATIMENT0000000302931795', 0.0, 'POLYGON Z ((355326.4 6689190.8 -1000, 355325.3 6689193 -1000, 355322.9 6689191.7 -1000, 355320.6 6689196.2 -1000, 355327.4 6689199.8 -1000, 355328.5 6689197.7 -1000, 355330.8 6689198.9 -1000, 355329.6 6689201 -1000, 355334 6689203.4 -1000, 355335.2 6689201.3 -1000, 355337.3 6689202.4 -1000, 355338.6529586877 6689199.806829182 -1000, 355338.6529586877 6689197.248925625 -1000, 355326.4 6689190.8 -1000))'),
            ('BATIMENT0000000302931837', 25.6, 'POLYGON Z ((355038.6529586877 6689424.198498073 41.6, 355142.9 6689442.7 41.6, 355144.8 6689432.4 41.6, 355099.1 6689424.5 41.6, 355098.2 6689422.2 41.6, 355096.8 6689420.6 41.6, 355095.1 6689420.5 41.6, 355094.2 6689420.9 41.6, 355092.6 6689423.2 41.6, 355074.8 6689419.9 41.6, 355072.1 6689418.7 41.6, 355072.1 6689417.5 41.6, 355071 6689416.1 41.6, 355068.7 6689416 41.6, 355066.2 6689418.8 41.6, 355039.9 6689414.1 41.6, 355038.6529586877 6689412.619138441 41.6, 355038.6529586877 6689424.198498073 41.6))'),
            ('BATIMENT0000000302931839', 8.3, 'POLYGON Z ((355038.6529586877 6689412.619138441 22.6, 355039.9 6689414.1 22.6, 355066.2 6689418.8 22.6, 355068.7 6689416 22.6, 355071 6689416.1 22.6, 355072.1 6689417.5 22.6, 355072.1 6689418.7 22.6, 355074.8 6689419.9 22.6, 355092.6 6689423.2 22.6, 355094.2 6689420.9 22.6, 355095.1 6689420.5 22.6, 355096.8 6689420.6 22.6, 355098.2 6689422.2 22.6, 355099.1 6689424.5 22.6, 355144.8 6689432.4 22.6, 355145.5 6689429 22.6, 355126.1 6689390.6 22.6, 355117.3 6689396.6 22.6, 355115.7 6689405.7 22.6, 355115.3 6689405.6 22.6, 355114.9 6689405.5 22.6, 355114.4 6689405.5 22.6, 355114 6689405.5 22.6, 355113.5 6689405.6 22.6, 355113.1 6689405.6 22.6, 355112.7 6689405.7 22.6, 355112.3 6689405.9 22.6, 355111.9 6689406 22.6, 355111.5 6689406.1 22.6, 355110.8 6689406.5 22.6, 355110.5 6689406.8 22.6, 355110.2 6689407 22.6, 355109.9 6689407.3 22.6, 355109.7 6689407.6 22.6, 355109.1 6689408.4 22.6, 355108.8 6689408.9 22.6, 355108.5 6689409.4 22.6, 355108.3 6689410 22.6, 355108.1 6689410.5 22.6, 355108 6689411.1 22.6, 355055.6 6689401.7 22.6, 355045.3 6689400.5 22.6, 355047.8 6689382.5 22.6, 355038.6529586877 6689381.181124276 22.6, 355038.6529586877 6689412.619138441 22.6))'),
            ('BATIMENT0000000302931855', 12.7, 'POLYGON Z ((355280.8 6689454.4 22.2, 355291.3 6689455.5 22.2, 355292.8 6689447.9 22.2, 355290.2 6689447.5 22.2, 355285.2 6689446.6 22.2, 355285.9 6689440.9 22.2, 355284.3 6689440.7 22.2, 355283.9 6689446.6 22.2, 355281.4 6689446.4 22.2, 355280.8 6689454.4 22.2))'),
            ('BATIMENT0000000302931856', 26.9, 'POLYGON Z ((355298.6092445574 6689457.620342058 35.7, 355299.8 6689449.2 35.7, 355292.8 6689447.9 35.7, 355291.3 6689455.5 35.7, 355280.8 6689454.4 35.7, 355281.4 6689446.4 35.7, 355283.9 6689446.6 35.7, 355284.3 6689440.7 35.7, 355270.9 6689438.3 35.7, 355271.1195493416 6689457.620342058 35.7, 355298.6092445574 6689457.620342058 35.7))'),
            ('BATIMENT0000000302931076', 14.0, 'POLYGON Z ((355240.6 6689239.9 22, 355237.4 6689244.5 22, 355236.5 6689244.1 22, 355235.9 6689244.8 22, 355235.1 6689244.6 22, 355235.9 6689245 22, 355236.8 6689245.3 22, 355237.3 6689245.9 22, 355237.7 6689246.5 22, 355248.9 6689254.2 22, 355257.8 6689242 22, 355262.3 6689235.7 22, 355262.5 6689235.9 22, 355266.5 6689229.7 22, 355274.5 6689217.6 22, 355273.3 6689216.7 22, 355275 6689214.1 22, 355274.1 6689213.5 22, 355274.5 6689212.9 22, 355276.1 6689210 22, 355273.3 6689208.3 22, 355271.5 6689211.1 22, 355268.9 6689214.9 22, 355268 6689214.2 22, 355264 6689211.8 22, 355258.5 6689208.4 22, 355256.1 6689212.1 22, 355261.5 6689215.6 22, 355262.5 6689216.3 22, 355262 6689218.5 22, 355263.4 6689219.5 22, 355260.9 6689223.1 22, 355259 6689225.5 22, 355254.4 6689231.7 22, 355252.8 6689230.5 22, 355252.6 6689230.6 22, 355252.4 6689231 22, 355251.3 6689229.8 22, 355250.6 6689229.3 22, 355248.5 6689227.9 22, 355244.7 6689233 22, 355240.6 6689238.2 22, 355239.7 6689239.3 22, 355240.6 6689239.9 22))'),
            ('BATIMENT0000000302930811', 17.8, 'POLYGON Z ((355153.2 6689179.7 26.3, 355153 6689180.5 26.3, 355152.1 6689180.9 26.3, 355151.5 6689182.7 26.3, 355150.9 6689182.5 26.3, 355150.7 6689182.5 26.3, 355150.6 6689182.5 26.3, 355150.5 6689182.5 26.3, 355150.3 6689182.5 26.3, 355150.2 6689182.6 26.3, 355150.1 6689182.7 26.3, 355150 6689182.8 26.3, 355150 6689182.9 26.3, 355150 6689183 26.3, 355150 6689183.2 26.3, 355150.1 6689183.6 26.3, 355150.2 6689183.7 26.3, 355151 6689184.1 26.3, 355150.5 6689185.6 26.3, 355157.9 6689213.7 26.3, 355158.6 6689216.5 26.3, 355158.7 6689216.8 26.3, 355164.2 6689213.6 26.3, 355163.2 6689211.9 26.3, 355172.7 6689204.8 26.3, 355175.2 6689207.6 26.3, 355180.8 6689202.7 26.3, 355184.3 6689207 26.3, 355187.1 6689205.1 26.3, 355185.9 6689203.5 26.3, 355200.2 6689191.4 26.3, 355199.7 6689190.9 26.3, 355198 6689189 26.3, 355194.1 6689186.3 26.3, 355192.8 6689183.7 26.3, 355189.5 6689180.2 26.3, 355188.8 6689179.5 26.3, 355188.6 6689179.4 26.3, 355188.5 6689179.3 26.3, 355188.4 6689179.3 26.3, 355188 6689179.1 26.3, 355187.9 6689179.1 26.3, 355187.7 6689179 26.3, 355187.7 6689178.9 26.3, 355187.6 6689178.9 26.3, 355187.3 6689178.7 26.3, 355187.2 6689178.7 26.3, 355187.1 6689178.6 26.3, 355186.9 6689178.5 26.3, 355186.8 6689178.4 26.3, 355186.7 6689178.3 26.3, 355186.4 6689178.1 26.3, 355186.1 6689177.8 26.3, 355186 6689177.7 26.3, 355185.9 6689177.6 26.3, 355183.1 6689174.1 26.3, 355183.4 6689173.7 26.3, 355182.9 6689173.2 26.3, 355181.4 6689175 26.3, 355179.6 6689176.6 26.3, 355176.6 6689179.3 26.3, 355172.9 6689182.1 26.3, 355167.6 6689183.9 26.3, 355165.6 6689181.1 26.3, 355161.9 6689184 26.3, 355158.7 6689179.7 26.3, 355159 6689179.5 26.3, 355157 6689176.7 26.3, 355155.4 6689174.3 26.3, 355152.5 6689176.2 26.3, 355151.8 6689176.7 26.3, 355151.5 6689176.9 26.3, 355151.4 6689177.1 26.3, 355151.3 6689177.2 26.3, 355151.5 6689177.6 26.3, 355151.9 6689177.3 26.3, 355153.3 6689179.3 26.3, 355153.2 6689179.7 26.3))')
            ]
        _df = DataFrame(data=_rawData, columns=('ID', 'HAUTEUR', 'geometry'))
        _df.geometry = _df.geometry.apply(lambda g: loads(g)) 
        return GeoDataFrame(_df, crs='epsg:2154')

    @staticmethod
    def districtRoyaleInNantesPaths():
        _rawData = [
            (1, 'LINESTRING Z (355194 6689177 0, 355217 6689206 0, 355212 6689220 0, 355174 6689238 0, 355161 6689243 0, 355159 6689258 0, 355126 6689273 0, 355119 6689356 0, 355156 6689428 0)'),
            (2, 'LINESTRING Z (355194 6689177 0, 355217 6689206 0, 355203 6689246 0, 355190 6689270 0, 355144 6689372 0, 355147 6689379 0, 355177 6689410 0, 355169 6689426 0, 355160 6689428 0)'),
            (3, 'LINESTRING (355194 6689177 0, 355217 6689206 0, 355203 6689246 0, 355190 6689270 0, 355199 6689329 0, 355202 6689350 0, 355177 6689410 0, 355169 6689426 0, 355160 6689428 0)')
            ]
        _df = DataFrame(data=_rawData, columns=('gid', 'geometry'))
        _df.geometry = _df.geometry.apply(lambda g: loads(g)) 
        return GeoDataFrame(_df, crs='epsg:2154')

    @staticmethod
    def districtRoyaleInNantesRoads():
        _rawData = [
            ('TRONROUT0000000029473565', 3.0, 'LINESTRING Z (355303.8244259574 6689457.620342058 7.846725225140379, 355306.1 6689434.6 7)'),
            ('TRONROUT0000000029473702', 3.0, 'LINESTRING Z (355306.1 6689434.6 7, 355311.2 6689395 6.7, 355310.6 6689388.1 6.7)'),
            ('TRONROUT0000000029473742', 3.0, 'LINESTRING Z (355200.7 6689432.9 9, 355176.3 6689410.3 9.300000000000001)'),
            ('TRONROUT0000000029474116', 3.0, 'LINESTRING Z (355162 6689255.7 7.8, 355127.2 6689272.5 9.5, 355123.2 6689279.4 9.5)'),
            ('TRONROUT0000000029474824', 4.0, 'LINESTRING Z (355158.9556484892 6689457.620342058 15.8200793517613, 355158.9 6689457.1 15.8)'),
            ('TRONROUT0000000029474826', 3.0, 'LINESTRING Z (355200.5 6689373.1 8.800000000000001, 355197.6 6689373.1 8.800000000000001, 355192.7 6689371.8 8.9)'),
            ('TRONROUT0000000301054080', 4.0, 'LINESTRING Z (355242.1 6689273.3 7.7, 355224 6689265.1 8)'),
            ('TRONROUT0000000029473546', 3.0, 'LINESTRING Z (355200.5 6689373.1 8.800000000000001, 355200.7 6689432.9 9)'),
            ('TRONROUT0000000029473908', 3.0, 'LINESTRING Z (355140.7 6689182.4 6.5, 355149.1 6689213.4 6.7)'),
            ('TRONROUT0000000029474485', 5.0, 'LINESTRING Z (355162.7 6689327.3 8.699999999999999, 355182.4 6689336.3 8.699999999999999, 355205 6689344.8 8.4)'),
            ('TRONROUT0000000029473755', 3.0, 'LINESTRING Z (355162.7 6689327.3 8.699999999999999, 355152.1 6689353.8 8.9)'),
            ('TRONROUT0000000029474030', 3.0, 'LINESTRING Z (355173.1 6689159.4 6.5, 355140.7 6689182.4 6.5)'),
            ('TRONROUT0000000029474092', 3.0, 'LINESTRING Z (355226.3 6689355 8.199999999999999, 355227 6689354.9 7.9, 355266.9 6689350.1 7.8)'),
            ('TRONROUT0000000029474185', 4.0, 'LINESTRING Z (355089.2 6689383.2 14, 355084.7 6689383.4 14, 355038.6529586877 6689376.216374211 15.93957896323012)'),
            ('TRONROUT0000000029474833', 3.0, 'LINESTRING Z (355266.1 6689424.1 7.6, 355264.6 6689368.9 8.300000000000001, 355266.9 6689350.1 7.8)'),
            ('TRONROUT0000000029474873', 4.0, 'LINESTRING Z (355295 6689191.8 6.3, 355265 6689174.1 6.7)'),
            ('TRONROUT0000000029475031', 4.0, 'LINESTRING Z (355038.8 6689295.5 16.1, 355038.6529586877 6689295.411049083 16.10544597452644)'),
            ('TRONROUT0000000029475285', 3.0, 'LINESTRING Z (355266.9821142647 6689457.620342058 9.635648303132527, 355266.1 6689424.1 7.6)'),
            ('TRONROUT0000000029475289', 3.0, 'LINESTRING Z (355338.6529586877 6689390.915649814 6.9, 355334.1 6689410.8 6.9, 355329.7 6689437.4 7)'),
            ('TRONROUT0000000227876288', 4.0, 'LINESTRING Z (355338.6529586877 6689210.16090451 6.284256128939598, 355318.6 6689204.6 6.2, 355311.6 6689203.7 5.9)'),
            ('TRONROUT0000000228331537', None, 'LINESTRING Z (355079.2 6689161 -1000, 355081.7 6689170.5 -1000, 355082.4 6689174.6 -1000)'),
            ('TRONROUT0000000326872124', 5.0, 'LINESTRING Z (355242.1 6689273.3 7.7, 355255.4 6689252.8 7.4)'),
            ('TRONROUT0000000029473709', None, 'LINESTRING Z (355038.6529586877 6689230.97198792 14.49725164495367, 355088.7 6689204.5 11.9)'),
            ('TRONROUT0000000295265261', 5.0, 'LINESTRING Z (355162.7 6689327.3 8.699999999999999, 355156.8 6689321.6 8.699999999999999, 355153.3 6689317.2 8.699999999999999, 355152.3 6689315.3 8.6)'),
            ('TRONROUT0000000029473484', None, 'LINESTRING Z (355091.3 6689230.7 11.2, 355088.7 6689204.5 11.9)'),
            ('TRONROUT0000000029473650', 3.0, 'LINESTRING Z (355286.8 6689245.1 6.7, 355338.6529586877 6689264.261905545 6.594714804695004)'),
            ('TRONROUT0000000029473699', 3.0, 'LINESTRING Z (355176.3 6689410.3 9.300000000000001, 355148.6 6689381.1 8.9, 355143.5 6689374.6 8.6)'),
            ('TRONROUT0000000029473892', 4.0, 'LINESTRING Z (355038.7 6689242.9 14.7, 355096.8 6689268 11.2)'),
            ('TRONROUT0000000029473960', 3.0, 'LINESTRING Z (355329.7 6689437.4 7, 355325.9876715753 6689457.620342058 7.473914266985602)'),
            ('TRONROUT0000000029474013', 4.0, 'LINESTRING Z (355038.6529586877 6689436.756936433 19.34034653805583, 355139.1 6689453.8 15.8)'),
            ('TRONROUT0000000029474258', 3.0, 'LINESTRING Z (355205 6689344.8 8.4, 355209.7 6689347.4 8.4, 355226.3 6689355 8.199999999999999)'),
            ('TRONROUT0000000029474328', 5.0, 'LINESTRING Z (355187.3 6689276.6 8.6, 355197.5 6689280.4 8.6, 355212.9 6689288.4 8.6, 355226.8 6689297.1 8)'),
            ('TRONROUT0000000029474453', 4.0, 'LINESTRING Z (355118.1 6689358.8 12.9, 355120 6689327.3 12.6)'),
            ('TRONROUT0000000029474899', 3.0, 'LINESTRING Z (355311.6 6689203.7 5.9, 355286.8 6689245.1 6.7)'),
            ('TRONROUT0000000029475015', 5.0, 'LINESTRING Z (355150.8 6689422 14.7, 355168.6 6689427 13.7)'),
            ('TRONROUT0000000029475023', 5.0, 'LINESTRING Z (355265 6689174.1 6.7, 355258 6689182.1 6.4, 355225.8 6689216.7 7.2)'),
            ('TRONROUT0000000029475068', 5.0, 'LINESTRING Z (355255.4 6689252.8 7.4, 355295 6689191.8 6.3)'),
            ('TRONROUT0000000029475230', 3.0, 'LINESTRING Z (355152.1 6689353.8 8.9, 355143.5 6689374.6 8.6)'),
            ('TRONROUT0000000321100661', None, 'LINESTRING Z (355338.6529586877 6689328.719453427 6.930810880156301, 355324.4 6689322.7 7, 355322.3 6689317.7 7.1, 355319.1 6689314.2 7.2, 355316.2 6689310.1 7.3, 355307.6 6689304.2 7.5)'),
            ('TRONROUT0000000029473782', 4.0, 'LINESTRING Z (355150.8 6689422 14.7, 355134.6 6689393.3 13.2, 355118.1 6689358.8 12.9)'),
            ('TRONROUT0000000029474451', 4.0, 'LINESTRING Z (355279.3 6689318.9 7.6, 355250.5 6689306 7.7)'),
            ('TRONROUT0000000029474951', 3.0, 'LINESTRING Z (355171.6309732622 6689157.620342058 6.5, 355173.1 6689159.4 6.5)'),
            ('TRONROUT0000000029475115', None, 'LINESTRING Z (355168.6 6689427 13.7, 355176.3 6689410.3 9.300000000000001)'),
            ('TRONROUT0000000029475262', 3.0, 'LINESTRING Z (355335.5 6689343.5 7.3, 355323.2 6689368.6 7.4, 355315.1 6689370 7.2, 355305.2 6689371.7 7)'),
            ('TRONROUT0000000029473899', 3.0, 'LINESTRING Z (355162 6689255.7 7.8, 355169.7 6689276.7 8.5)'),
            ('TRONROUT0000000029473599', 5.0, 'LINESTRING Z (355205 6689344.8 8.4, 355213.9 6689323.9 8.4, 355221.8 6689305.1 8.4, 355226.8 6689297.1 8)'),
            ('TRONROUT0000000029474150', 3.0, 'LINESTRING Z (355137.7301562341 6689457.620342058 15.8152204862878, 355139.1 6689453.8 15.8)'),
            ('TRONROUT0000000029474478', 3.0, 'LINESTRING Z (355125.8 6689221.2 7.5, 355091.3 6689230.7 11.2)'),
            ('TRONROUT0000000029474501', 3.0, 'LINESTRING Z (355176.3 6689410.3 9.300000000000001, 355192.7 6689371.8 8.9)'),
            ('TRONROUT0000000029474545', 4.0, 'LINESTRING Z (355144.3 6689454.7 15.9, 355150.8 6689422 14.7)'),
            ('TRONROUT0000000029474790', 3.0, 'LINESTRING Z (355306.1 6689434.6 7, 355329.7 6689437.4 7)'),
            ('TRONROUT0000000029474817', 3.0, 'LINESTRING Z (355266.1 6689424.1 7.6, 355306.1 6689434.6 7)'),
            ('TRONROUT0000000029474976', 5.0, 'LINESTRING Z (355169.7 6689276.7 8.5, 355177.6 6689275.6 8.6, 355182.7 6689275.8 8.6, 355187.3 6689276.6 8.6)'),
            ('TRONROUT0000000200678091', None, 'LINESTRING Z (355149.1 6689213.4 6.7, 355135 6689218.7 6.6, 355125.8 6689221.2 7.5)'),
            ('TRONROUT0000000295266736', 4.0, 'LINESTRING Z (355123.2 6689279.4 9.5, 355152.9 6689292.2 9)'),
            ('TRONROUT0000000029473794', 3.0, 'LINESTRING Z (355157.7 6689243.4 6.8, 355162 6689255.7 7.8)'),
            ('TRONROUT0000000029473634', 3.0, 'LINESTRING Z (355134.1976910056 6689157.620342058 6.7, 355137.4 6689170 6.7, 355139.7 6689179.3 6.5)'),
            ('TRONROUT0000000029473766', 4.0, 'LINESTRING Z (355335.5 6689343.5 7.3, 355338.6529586877 6689344.939933889 7.275173553640895)'),
            ('TRONROUT0000000029473776', 3.0, 'LINESTRING Z (355310.6 6689388.1 6.7, 355308.8 6689379.1 6.7, 355305.2 6689371.7 7)'),
            ('TRONROUT0000000029473905', 3.0, 'LINESTRING Z (355275.3 6689264.3 7, 355250.5 6689306 7.7)'),
            ('TRONROUT0000000029473945', 4.0, 'LINESTRING Z (355335.5 6689343.5 7.3, 355324.6 6689338.7 7.3, 355279.3 6689318.9 7.6)'),
            ('TRONROUT0000000029474206', 4.0, 'LINESTRING Z (355200.7 6689432.9 9, 355201.067133793 6689457.620342058 9)'),
            ('TRONROUT0000000029474221', 3.0, 'LINESTRING Z (355091.3 6689230.7 11.2, 355038.6529586877 6689234.596080855 14.596583310469)'),
            ('TRONROUT0000000029474257', 5.0, 'LINESTRING Z (355225.8 6689216.7 7.2, 355217.1 6689226.4 8.1, 355197 6689257.6 8.4, 355187.3 6689276.6 8.6)'),
            ('TRONROUT0000000029474341', 4.0, 'LINESTRING Z (355123.2 6689279.4 9.5, 355120 6689327.3 12.6)'),
            ('TRONROUT0000000029474350', 4.0, 'LINESTRING Z (355096.8 6689268 11.2, 355121.2 6689278.5 9.6, 355123.2 6689279.4 9.5)'),
            ('TRONROUT0000000029474441', 3.0, 'LINESTRING Z (355096.8 6689268 11.2, 355091.3 6689230.7 11.2)'),
            ('TRONROUT0000000029474473', 4.0, 'LINESTRING Z (355120 6689327.3 12.6, 355084.9 6689318 14.5, 355062.7 6689310 15.1, 355038.8 6689295.5 16.1)'),
            ('TRONROUT0000000029474740', 4.0, 'LINESTRING Z (355144.3 6689454.7 15.9, 355158.9 6689457.1 15.8)'),
            ('TRONROUT0000000029474747', 4.0, 'LINESTRING Z (355226.8 6689297.1 8, 355242.1 6689273.3 7.7)'),
            ('TRONROUT0000000029475156', 4.0, 'LINESTRING Z (355265 6689174.1 6.7, 355247.4 6689163.6 6.9, 355241.4203420584 6689157.620342058 6.956679222195298)'),
            ('TRONROUT0000000029475267', 3.0, 'LINESTRING Z (355310.6 6689388.1 6.7, 355338.6529586877 6689389.384114306 6.897556047096359)'),
            ('TRONROUT0000000029475269', 4.0, 'LINESTRING Z (355158.9 6689457.1 15.8, 355162.2 6689457.5 15.6)'),
            ('TRONROUT0000000227876295', 4.0, 'LINESTRING Z (355311.6 6689203.7 5.9, 355301.7 6689195.8 6.3, 355295 6689191.8 6.3)'),
            ('TRONROUT0000000228331536', None, 'LINESTRING Z (355091.5664349967 6689157.620342058 -1000, 355090.3 6689158.1 -1000, 355079.2 6689161 -1000)'),
            ('TRONROUT0000000326872123', 3.0, 'LINESTRING Z (355286.8 6689245.1 6.7, 355275.3 6689264.3 7)'),
            ('TRONROUT0000002007790876', None, 'LINESTRING Z (355224.5 6689389.8 9.4, 355224.5 6689383.4 9.1)'),
            ('TRONROUT0000000029474107', 3.0, 'LINESTRING Z (355149.1 6689213.4 6.7, 355157.7 6689243.4 6.8)'),
            ('TRONROUT0000000029473474', None, 'LINESTRING Z (355079.2 6689161 -1000, 355071.6 6689162.5 -1000, 355056.9 6689167.1 -1000)'),
            ('TRONROUT0000000029473566', 3.0, 'LINESTRING Z (355162.2 6689457.5 15.6, 355166.4 6689431.7 15, 355168.6 6689427 13.7)'),
            ('TRONROUT0000000029473786', 4.0, 'LINESTRING Z (355038.6529586877 6689243.128377984 14.7, 355038.7 6689242.9 14.7)'),
            ('TRONROUT0000000029473877', 5.0, 'LINESTRING Z (355173.1 6689159.4 6.5, 355178.2 6689164.5 6.5, 355225.8 6689216.2 7.2, 355225.8 6689216.7 7.2)'),
            ('TRONROUT0000000029474094', 5.0, 'LINESTRING Z (355225.8 6689216.7 7.4, 355200 6689224 7.2)'),
            ('TRONROUT0000000029474216', 3.0, 'LINESTRING Z (355305.2 6689371.7 7, 355301.8 6689365.9 7.3, 355291 6689357.1 7.9, 355284.3 6689352.9 7.9, 355278.6 6689350.6 7.9, 355269.9 6689350.3 7.7, 355266.9 6689350.1 7.8)'),
            ('TRONROUT0000000119652106', 3.0, 'LINESTRING Z (355143.5 6689374.6 8.6, 355138.6 6689362.7 8.699999999999999, 355136.3 6689350.2 8.699999999999999, 355136.7 6689338 8.699999999999999, 355138.2 6689325.1 8.699999999999999, 355140 6689322.9 8.699999999999999, 355150.4 6689315.9 8.699999999999999, 355152.3 6689315.3 8.5)'),
            ('TRONROUT0000000357587957', None, 'LINESTRING Z (355038.6529586877 6689192.282110721 15.0642214417708, 355052.6 6689191.9 14.3, 355075 6689183.8 13.5, 355081.8 6689194.7 12.7, 355088.7 6689204.5 11.9)'),
            ('TRONROUT0000002007790875', 5.0, 'LINESTRING Z (355224.9 6689432.9 11.1, 355224.5 6689389.8 9.4)'),
            ('TRONROUT0000000029473465', None, 'LINESTRING Z (355279.3 6689318.9 -1000, 355266.9 6689350.1 -1000)'),
            ('TRONROUT0000000029473672', None, 'LINESTRING Z (355200 6689224 7.2, 355180.3 6689235.5 6.9, 355157.7 6689243.4 6.8)'),
            ('TRONROUT0000000029473649', 3.0, 'LINESTRING Z (355250.5 6689306 7.7, 355228.6 6689347.2 7.7, 355226.9 6689352.6 8.1, 355226.3 6689355 8.199999999999999)'),
            ('TRONROUT0000000029473716', 4.0, 'LINESTRING Z (355118.1 6689358.8 12.9, 355093.7 6689381 13.9, 355089.2 6689383.2 14)'),
            ('TRONROUT0000000029473785', 4.0, 'LINESTRING Z (355139.1 6689453.8 15.8, 355144.3 6689454.7 15.9)'),
            ('TRONROUT0000000029474189', 5.0, 'LINESTRING Z (355311.6 6689203.7 5.9, 355327.4 6689212.3 6, 355338.6529586877 6689217.926479343 6.258688705459872)'),
            ('TRONROUT0000000029474370', 5.0, 'LINESTRING Z (355338.6529586877 6689170.01737122 6.727834453450368, 355314.8473678057 6689157.620342058 6.542496808175509)'),
            ('TRONROUT0000000029474916', 3.0, 'LINESTRING Z (355192.7 6689371.8 8.9, 355152.1 6689353.8 8.9)'),
            ('TRONROUT0000000029474934', 4.0, 'LINESTRING Z (355250.5 6689306 7.7, 355238.5 6689299.6 7.7, 355226.8 6689297.1 8)'),
            ('TRONROUT0000000029475266', 5.0, 'LINESTRING Z (355224.5 6689383.4 9.1, 355224.2 6689373.6 8.800000000000001, 355224.7 6689365.9 8.5, 355225.1 6689360 8.6, 355226.3 6689355 8.199999999999999)'),
            ('TRONROUT0000000200678098', 4.0, 'LINESTRING Z (355162.2 6689457.5 15.6, 355162.9799091075 6689457.620342058 15.56528594477074)'),
            ('TRONROUT0000000326872122', None, 'LINESTRING Z (355255.4 6689252.8 7.4, 355275.3 6689264.3 7)'),
            ('TRONROUT0000000029474652', 3.0, 'LINESTRING Z (355139.7 6689179.3 6.5, 355140.7 6689182.4 6.5)'),
            ('TRONROUT0000000295265262', 5.0, 'LINESTRING Z (355152.3 6689315.3 8.5, 355150.6 6689308.6 8.6, 355150.4 6689300.3 8.6, 355151.6 6689294.5 8.6, 355152.9 6689292.2 9)'),
            ('TRONROUT0000000029474134', 5.0, 'LINESTRING Z (355224.9 6689432.9 11.1, 355225.5224546561 6689457.620342058 12.34490931226951)'),
            ('TRONROUT0000000029475096', None, 'LINESTRING Z (355200.7 6689432.9 9, 355224.9 6689432.9 11.1)'),
            ('TRONROUT0000000029473555', None, 'LINESTRING Z (355088.7 6689204.5 11.9, 355139.7 6689179.3 6.5)'),
            ('TRONROUT0000000029473713', 3.0, 'LINESTRING Z (355200.5 6689373.1 8.800000000000001, 355202 6689363 8.699999999999999, 355204.8 6689351.1 8.300000000000001, 355205 6689344.8 8.4)'),
            ('TRONROUT0000000029474056', 4.0, 'LINESTRING Z (355038.6529586877 6689242.879572026 14.70244159060784, 355038.7 6689242.9 14.7)'),
            ('TRONROUT0000000029474482', 5.0, 'LINESTRING Z (355152.9 6689292.2 9, 355156.9 6689286.4 9.1, 355160.9 6689282.3 9, 355165.9 6689278.2 8.6, 355169.7 6689276.7 8.5)'),
            ('TRONROUT0000000029475217', 4.0, 'LINESTRING Z (355038.6529586877 6689238.995571079 14.65295868769531, 355038.7 6689242.9 14.7)')
            ]
        _df = DataFrame(data=_rawData, columns=('ID', 'LARGEUR', 'geometry'))
        _df.geometry = _df.geometry.apply(lambda g: loads(g)) 
        return GeoDataFrame(_df, crs='epsg:2154')

    @staticmethod
    def ensaNantesBuildings():
        _rawData = [
            ('BATIMENT0000000327821795', 8, 'POLYGON Z ((355378.1 6688348.1 15.2, 355385.3 6688348.8 15.2, 355391.7 6688349.6 15.2, 355395 6688349.881707317 15.2, 355395 6688344.474528302 15.2, 355378.9 6688342.5 15.2, 355378.1 6688348.1 15.2))'),
            ('BATIMENT0000000302930045', 11, 'POLYGON Z ((355376.9 6688435.4 17.7, 355376.5 6688440.4 17.7, 355390.5 6688442 17.7, 355391 6688436.5 17.7, 355376.9 6688435.4 17.7))'),
            ('BATIMENT0000000302929704', 13, 'POLYGON Z ((355292.3 6688512.4 18.6, 355305.7 6688517 18.6, 355339.1 6688509 18.6, 355340.1 6688508.7 18.6, 355343.2 6688470.5 18.6, 355344 6688460.1 18.6, 355332.1 6688458.8 18.6, 355329.3 6688485.1 18.6, 355295.3 6688481.5 18.6, 355293.7 6688497.9 18.6, 355293.3 6688502.6 18.6, 355292.3 6688512.4 18.6))'),
            ('BATIMENT0000000302929708', 8, 'POLYGON Z ((355347.2 6688427 13.3, 355358.9 6688428 13.3, 355360.4 6688414.6 13.3, 355342.8 6688412.9 13.3, 355341.2 6688426.3 13.3, 355347.2 6688427 13.3))'),
            ('BATIMENT0000000302929761', 11, 'POLYGON Z ((355297.7 6688389.3 16.3, 355298.8 6688378.4 16.3, 355299.4 6688370.7 16.3, 355300 6688364.8 16.3, 355299.5 6688364.8 16.3, 355299.7 6688363.4 16.3, 355296.6 6688363.1 16.3, 355296.5 6688363.8 16.3, 355289.6 6688363.2 16.3, 355288.7 6688374.2 16.3, 355287 6688377 16.3, 355297.7 6688389.3 16.3))'),
            ('BATIMENT0000000302929763', 13, 'POLYGON Z ((355298.8 6688378.4 18.3, 355297.7 6688389.3 18.3, 355302.2 6688394.4 18.3, 355304.3 6688394.6 18.3, 355305 6688381.7 18.3, 355305.1 6688380.9 18.3, 355302 6688380.7 18.3, 355302.5 6688378.4 18.3, 355298.8 6688378.4 18.3))'),
            ('BATIMENT0000000302930052', 11, 'POLYGON Z ((355372.8 6688485.6 17.8, 355386.4 6688486.9 17.8, 355387.6 6688473.9 17.8, 355379.1 6688473 17.8, 355373.9 6688472.3 17.8, 355372.9 6688484.2 17.8, 355372.8 6688485.6 17.8), (355377.6 6688481.9 17.8, 355378 6688477.7 17.8, 355380 6688477.8 17.8, 355379.8 6688479.3 17.8, 355379 6688479.2 17.8, 355378.9 6688480.2 17.8, 355379.9 6688480.4 17.8, 355379.7 6688482 17.8, 355377.6 6688481.9 17.8))'),
            ('BATIMENT0000000302930053', 12, 'POLYGON Z ((355372.5 6688489.7 18.8, 355371.9 6688497.3 18.8, 355371.6 6688500.2 18.8, 355381.7 6688497.8 18.8, 355385.9 6688492.8 18.8, 355386.4 6688486.9 18.8, 355372.8 6688485.6 18.8, 355372.6 6688487.9 18.8, 355376.1 6688488 18.8, 355375.8 6688490.1 18.8, 355372.5 6688489.7 18.8))'),
            ('BATIMENT0000000302930066', 11, 'POLYGON Z ((355217.4 6688333.5 17, 355213.8 6688333.2 17, 355213.5 6688339.5 17, 355217 6688339.8 17, 355217.4 6688333.5 17))'),
            ('BATIMENT0000000302930067', 10, 'POLYGON Z ((355213.8 6688333.2 16.5, 355200.8823529406 6688332 16.5, 355195.4628571428 6688332 16.5, 355191.6 6688384 16.5, 355209.8 6688385.7 16.5, 355211.1 6688369.8 16.5, 355211.4 6688367.8 16.5, 355213 6688346.4 16.5, 355213.5 6688339.5 16.5, 355213.8 6688333.2 16.5))'),
            ('BATIMENT0000000302930068', 8, 'POLYGON Z ((355217 6688339.8 14.7, 355213.5 6688339.5 14.7, 355213 6688346.4 14.7, 355211.4 6688367.8 14.7, 355211.1 6688369.8 14.7, 355209.8 6688385.7 14.7, 355231.6 6688387.7 14.7, 355262.8 6688362.9 14.7, 355264.8 6688341.8 14.7, 355261.2 6688337.6 14.7, 355217.4 6688333.5 14.7, 355217 6688339.8 14.7), (355227.4 6688355.1 14.7, 355227.7 6688352.8 14.7, 355242.9 6688354.1 14.7, 355246.1 6688354.4 14.7, 355247.9 6688354.5 14.7, 355255.8 6688355.2 14.7, 355257.5 6688355.4 14.7, 355257 6688360.1 14.7, 355243.3 6688371.3 14.7, 355226.3 6688369.3 14.7, 355227.4 6688355.1 14.7))'),
            ('BATIMENT0000000302929766', 7, 'POLYGON Z ((355306.8 6688365.7 13.3, 355306.3 6688369.9 13.3, 355317.1 6688370.9 13.3, 355317.6 6688366.8 13.3, 355306.8 6688365.7 13.3))'),
            ('BATIMENT0000000302929633', 15, 'POLYGON Z ((355189 6688441.260869565 21, 355237.8 6688415.8 21, 355238.9 6688413 21, 355230.2 6688402.8 21, 355189 6688398.853058216 21, 355189 6688441.260869565 21))'),
            ('BATIMENT0000000302929698', 10, 'POLYGON Z ((355299.8 6688434.5 15.9, 355297.4 6688434.6 15.9, 355291.4 6688426.2 15.9, 355301.2 6688419.6 15.9, 355302.2 6688409 15.9, 355300.5 6688408.9 15.9, 355284.3 6688421.1 15.9, 355299.1 6688441.5 15.9, 355299.8 6688434.5 15.9))'),
            ('BATIMENT0000000302929699', 23, 'POLYGON Z ((355325.8 6688427.7 28.8, 355300.6 6688426.1 28.8, 355299.8 6688434.5 28.8, 355299.1 6688441.5 28.8, 355298.9 6688443.9 28.8, 355324.1 6688446.3 28.8, 355324.9 6688436.9 28.8, 355325.8 6688427.7 28.8))'),
            ('BATIMENT0000000302929709', 7, 'POLYGON Z ((355327.2 6688411.4 12.6, 355326 6688424.8 12.6, 355330.2 6688425.3 12.6, 355330.5 6688421.1 12.6, 355333.9 6688421.3 12.6, 355334.4 6688416.9 12.6, 355337.4 6688417.1 12.6, 355337.9 6688412.5 12.6, 355327.2 6688411.4 12.6))'),
            ('BATIMENT0000000302929767', 12, 'POLYGON Z ((355305 6688381.7 17.8, 355304.3 6688394.6 17.8, 355315 6688395.6 17.8, 355315.9 6688384.8 17.8, 355316.1 6688381.8 17.8, 355309.3 6688380.9 17.8, 355309 6688382.2 17.8, 355305 6688381.7 17.8))'),
            ('BATIMENT0000000302929752', 13, 'POLYGON Z ((355277.8 6688340.5 19.1, 355291.7 6688341.6 19.1, 355292.6 6688341.7 19.1, 355293.3 6688333.7 19.1, 355294.5 6688333.8 19.1, 355294.6125 6688332 19.1, 355278.4538461538 6688332 19.1, 355277.8 6688340.5 19.1))'),
            ('BATIMENT0000000302929753', 13, 'POLYGON Z ((355291.1 6688345.3 19.4, 355291.7 6688341.6 19.4, 355277.8 6688340.5 19.4, 355277 6688350 19.4, 355290.6 6688351.1 19.4, 355290.8 6688348 19.4, 355286.4 6688348.4 19.4, 355286.8 6688345.3 19.4, 355291.1 6688345.3 19.4))'),
            ('BATIMENT0000000302929759', 13, 'POLYGON Z ((355290.3 6688354.7 19.2, 355290.6 6688351.1 19.2, 355277 6688350 19.2, 355276.1 6688362 19.2, 355289.6 6688363.2 19.2, 355289.8 6688360 19.2, 355286.7 6688359.9 19.2, 355287.1 6688357.5 19.2, 355287.4 6688354.3 19.2, 355290.3 6688354.7 19.2))'),
            ('BATIMENT0000000302929768', 11, 'POLYGON Z ((355326.2 6688386.1 17, 355321 6688385.7 17, 355321 6688383.7 17, 355321 6688380.8 17, 355318.6 6688380.5 17, 355318.1 6688385.3 17, 355315.9 6688384.8 17, 355315 6688395.6 17, 355325.6 6688396.6 17, 355326.2 6688386.1 17))'),
            ('BATIMENT0000000302929779', 12, 'POLYGON Z ((355276.1 6688362 17.5, 355275.9 6688364.3 17.5, 355287 6688377 17.5, 355288.7 6688374.2 17.5, 355289.6 6688363.2 17.5, 355276.1 6688362 17.5))'),
            ('BATIMENT0000000302929780', 7, 'POLYGON Z ((355327.4 6688371.9 13.4, 355327.8 6688367.8 13.4, 355317.6 6688366.8 13.4, 355317.1 6688370.9 13.4, 355327.4 6688371.9 13.4))'),
            ('BATIMENT0000000302929781', 8, 'POLYGON Z ((355327.4 6688371.9 13.7, 355327.3 6688373.6 13.7, 355326.4 6688385 13.7, 355326.2 6688386.1 13.7, 355325.6 6688396.6 13.7, 355337.3 6688397.6 13.7, 355338.3 6688383.8 13.7, 355339.6 6688369.4 13.7, 355327.8 6688367.8 13.7, 355327.4 6688371.9 13.7), (355329.5 6688384.7 13.7, 355329.9 6688378.8 13.7, 355335.1 6688379.5 13.7, 355334.6 6688385.7 13.7, 355335.5 6688386 13.7, 355335.4 6688387.1 13.7, 355328.7 6688386.5 13.7, 355329.5 6688384.7 13.7))'),
            ('BATIMENT0000000302929782', 8, 'POLYGON Z ((355338.3 6688383.8 13.5, 355337.3 6688397.6 13.5, 355347.8 6688398.6 13.5, 355348.8 6688384.9 13.5, 355338.3 6688383.8 13.5))'),
            ('BATIMENT0000000302929788', 18, 'POLYGON Z ((355391.7 6688349.6 24, 355389.4 6688376.9 24, 355395 6688377.25443038 24, 355395 6688349.881707317 24, 355391.7 6688349.6 24))'),
            ('BATIMENT0000000302929789', 8, 'POLYGON Z ((355356.3 6688390.4 13.2, 355355.8 6688399.3 13.2, 355363 6688400 13.2, 355363.8 6688391 13.2, 355356.3 6688390.4 13.2))'),
            ('BATIMENT0000000302929792', 5, 'POLYGON Z ((355380.65 6688332 11.4, 355380 6688337 11.4, 355388.8 6688338.1 11.4, 355389.4578431373 6688332 11.4, 355380.65 6688332 11.4))'),
            ('BATIMENT0000000302929796', 11, 'POLYGON Z ((355392.3305555556 6688332 17.1, 355392 6688335.4 17.1, 355390.8 6688335.1 17.1, 355390.5 6688338.1 17.1, 355395 6688338.614285714 17.1, 355395 6688332 17.1, 355392.3305555556 6688332 17.1))'),
            ('BATIMENT0000000302929976', 18, 'POLYGON Z ((355242.5 6688510.8 24.6, 355243.7 6688509 24.6, 355246.4 6688504 24.6, 355248.8 6688498.8 24.6, 355250.4 6688494.7 24.6, 355255.8 6688431.1 24.6, 355248.6 6688422.3 24.6, 355224 6688435.2 24.6, 355192.2 6688451.9 24.6, 355189 6688487.1 24.6, 355189 6688505.951485149 24.6, 355217.6 6688508.5 24.6, 355242.5 6688510.8 24.6))'),
            ('BATIMENT0000000302929977', 23, 'POLYGON Z ((355242.5 6688510.8 29.9, 355249.1 6688511.4 29.9, 355250.4 6688494.7 29.9, 355248.8 6688498.8 29.9, 355246.4 6688504 29.9, 355243.7 6688509 29.9, 355242.5 6688510.8 29.9))'),
            ('BATIMENT0000000302929978', 13, 'POLYGON Z ((355189 6688542.039047619 19.3, 355215.2 6688536.3 19.3, 355221.6 6688534.9 19.3, 355222.7 6688522.4 19.3, 355216.5 6688521.9 19.3, 355189 6688519.38366013 19.3, 355189 6688542.039047619 19.3))'),
            ('BATIMENT0000000302930051', 13, 'POLYGON Z ((355372.9 6688484.2 18.7, 355362 6688483.3 18.7, 355364.9 6688448.5 18.7, 355363.2 6688448.4 18.7, 355363 6688449.9 18.7, 355353.8 6688449.1 18.7, 355353.1 6688456.9 18.7, 355354.1 6688457 18.7, 355353.8 6688461.2 18.7, 355352.8 6688461.1 18.7, 355349.7 6688498.4 18.7, 355364.9 6688499.7 18.7, 355365.1 6688496.7 18.7, 355371.9 6688497.3 18.7, 355372.5 6688489.7 18.7, 355372.6 6688487.9 18.7, 355372.8 6688485.6 18.7, 355372.9 6688484.2 18.7))'),
            ('BATIMENT0000000302930039', 6, 'POLYGON Z ((355307.2 6688358.8 11.6, 355333.4 6688361.3 11.6, 355334.4 6688350.7 11.6, 355308.2 6688348.2 11.6, 355307.2 6688358.8 11.6))'),
            ('BATIMENT0000000302930042', 6, 'POLYGON Z ((355306.9 6688338.2 11.2, 355335.3 6688340.8 11.2, 355336.1224299065 6688332 11.2, 355307.4740740741 6688332 11.2, 355306.9 6688338.2 11.2))'),
            ('BATIMENT0000000302930046', 11, 'POLYGON Z ((355389.5 6688416.4 17.7, 355388 6688425.5 17.7, 355386.9 6688430.5 17.7, 355380 6688429.8 17.7, 355378.7 6688429.6 17.7, 355377.4 6688429.5 17.7, 355376.9 6688435.4 17.7, 355391 6688436.5 17.7, 355392.5 6688420.3 17.7, 355389.5 6688416.4 17.7))'),
            ('BATIMENT0000000302930047', 12, 'POLYGON Z ((355378.6 6688415.4 18.3, 355369.5 6688414.5 18.3, 355366.6 6688448.6 18.3, 355375.8 6688449.2 18.3, 355375.9 6688448.3 18.3, 355376.3 6688443.4 18.3, 355376.3 6688443 18.3, 355372.6 6688442.7 18.3, 355373.2 6688435.1 18.3, 355375.4 6688435.3 18.3, 355375.9 6688429.1 18.3, 355373.8 6688428.9 18.3, 355374.1 6688424.5 18.3, 355377.8 6688424.8 18.3, 355378.6 6688415.4 18.3))'),
            ('BATIMENT0000000302930048', 13, 'POLYGON Z ((355375.9 6688448.3 19.4, 355375.8 6688449.2 19.4, 355375.7 6688450.9 19.4, 355389.6 6688452.2 19.4, 355390.5 6688442 19.4, 355376.5 6688440.4 19.4, 355376.3 6688443 19.4, 355376.3 6688443.4 19.4, 355380.9 6688443.9 19.4, 355381.5 6688442.6 19.4, 355382.1 6688442.6 19.4, 355381.7 6688450.1 19.4, 355380.9 6688450 19.4, 355380.7 6688448.8 19.4, 355375.9 6688448.3 19.4))'),
            ('BATIMENT0000000302930049', 12, 'POLYGON Z ((355380 6688429.8 18.1, 355386.9 6688430.5 18.1, 355388 6688425.5 18.1, 355389.5 6688416.4 18.1, 355378.6 6688415.4 18.1, 355377.8 6688424.8 18.1, 355377.4 6688429.5 18.1, 355378.7 6688429.6 18.1, 355379.3 6688424.4 18.1, 355383.5 6688424.8 18.1, 355383.4 6688427.3 18.1, 355380.3 6688426.9 18.1, 355380 6688429.8 18.1))'),
            ('BATIMENT0000000302930050', 13, 'POLYGON Z ((355375.3 6688455.7 19.4, 355374.8 6688461.2 19.4, 355388.7 6688462.2 19.4, 355389.6 6688452.2 19.4, 355375.7 6688450.9 19.4, 355375.5 6688453.1 19.4, 355379.9 6688453.9 19.4, 355380.2 6688452.7 19.4, 355381.1 6688452.8 19.4, 355380.6 6688460 19.4, 355379.3 6688459.9 19.4, 355378.8 6688458.8 19.4, 355376.9 6688458.8 19.4, 355377.2 6688455.8 19.4, 355375.3 6688455.7 19.4))'),
            ('BATIMENT0000000302930055', 11, 'POLYGON Z ((355374.1 6688469.7 17.5, 355373.9 6688472.3 17.5, 355379.1 6688473 17.5, 355387.6 6688473.9 17.5, 355388.7 6688462.2 17.5, 355374.8 6688461.2 17.5, 355374.3 6688467.7 17.5, 355375.8 6688467.8 17.5, 355377.8 6688468.1 17.5, 355377.8 6688469.1 17.5, 355377.7 6688471 17.5, 355375.8 6688471 17.5, 355375.9 6688469.8 17.5, 355374.1 6688469.7 17.5))'),
            ('BATIMENT0000000302930183', 8, 'POLYGON Z ((355363 6688400 13.4, 355385.8 6688402 13.4, 355386.9 6688393 13.4, 355363.8 6688391 13.4, 355363 6688400 13.4))'),
            ('BATIMENT0000000302930184', 18, 'POLYGON Z ((355385.8 6688402 23.8, 355391.1 6688402.5 23.8, 355395 6688398.504878049 23.8, 355395 6688377.25443038 23.8, 355389.4 6688376.9 23.8, 355386.9 6688393 23.8, 355385.8 6688402 23.8))'),
            ('BATIMENT0000000302929786', 5, 'POLYGON Z ((355368.1 6688347 10.5, 355364.6 6688381.1 10.5, 355381.9 6688382.5 10.5, 355382.5 6688376.5 10.5, 355382.6 6688374.4 10.5, 355376.9 6688374.1 10.5, 355376.9 6688376.5 10.5, 355370.6 6688375.8 10.5, 355372.2 6688355.4 10.5, 355373.6 6688353 10.5, 355384.6 6688353.9 10.5, 355385.3 6688348.8 10.5, 355378.1 6688348.1 10.5, 355368.1 6688347 10.5))')
            ]
        _df = DataFrame(data=_rawData, columns=('ID', 'HAUTEUR', 'geometry'))
        _df.geometry = _df.geometry.apply(lambda g: loads(g)) 
        return GeoDataFrame(_df, crs='epsg:2154')

    @staticmethod
    def ensaNantesRoads():
        _rawData = [
            ('TRONROUT0000000029473510', 2.5, 2.5, 'Route à 1 chaussée', 'NC', 'PONT HAUDAUDINE', 'PONT HAUDAUDINE', '4', 'Autre', 'NC', 'NR', 'Non', 'NC', 'Non', 'Pont', '10.5', 'NC', '2', '1', 'Double', None, None, '44109', '44109', '44109#096', '44109#096', 'NR', 'NR', 'Classique', '0.0', '0.0', '0.0', '0.0', 'NR', '8.7', '8.7', 'LINESTRING Z (355394.3 6688515.8 8.699999999999999, 355393.4 6688522.8 8, 355392.7 6688529.3 7.5, 355391.4 6688540.1 9.9, 355390.0525757576 6688557.039047619 10.92660894663398)'),
            ('TRONROUT0000000295265066', 1.5, 1.0, 'Sentier', 'NC', None, None, 'NC', 'Autre', 'NC', 'NR', 'Non', 'NC', 'Non', 'NC', '0.0', 'NC', '0', '0', 'NC', None, None, '44109', '44109', 'NR', 'NR', 'NR', 'NR', 'NR', '0.0', '0.0', '0.0', '0.0', 'NR', '6.0', '6.9', 'LINESTRING Z (355191.5 6688548.6 6, 355183.5501725326 6688557.039047619 6.183457556939865)'),
            ('TRONROUT0000000224176720', 1.5, 2.5, 'Route à 1 chaussée', 'NC', 'R DE LA SAVONNERIE', 'R DE LA SAVONNERIE', '5', 'Autre', 'NC', 'NR', 'Non', 'NC', 'Non', 'NC', '3.0', 'NC', '1', '0', 'Double', None, None, '44109', '44109', '44109#0IE', '44109#0IE', '44200', '44200', 'Classique', '0.0', '0.0', '0.0', '0.0', 'NR', '5.9', '6.9', 'LINESTRING Z (355185.4 6688391 5.9, 355191.5 6688323.2 6.9)'),
            ('TRONROUT0000000029473528', 2.5, 2.5, 'Route à 1 chaussée', 'NC', 'PL DES ERABLES', 'PL DES ERABLES', '5', 'Autre', 'NC', 'NR', 'Non', 'NC', 'Non', 'NC', '4.0', 'NC', '2', '0', 'Inverse', None, None, '44109', '44109', '44109#0IJ', '44109#0IJ', '44200', '44200', 'Classique', '0.0', '0.0', '0.0', '0.0', 'NR', '8.1', '8.5', 'LINESTRING Z (355183.2 6688449.4 8.1, 355176.2 6688453.6 8.1, 355174 6688454.48 7.974285714291957)'),
            ('TRONROUT0000000029474175', 2.5, 2.5, 'Route à 1 chaussée', 'NC', 'PL DES ERABLES', 'PL DES ERABLES', '5', 'Autre', 'NC', 'NR', 'Non', 'NC', 'Non', 'NC', '4.0', 'NC', '2', '0', 'Direct', None, None, '44109', '44109', '44109#0IJ', '44109#0IJ', '44200', '44200', 'Classique', '0.0', '0.0', '0.0', '0.0', 'NR', '8.6', '8.5', 'LINESTRING Z (355178.5 6688510.1 8.6, 355174.5 6688510 8.6, 355174 6688509.988970588 8.596323529411713)'),
            ('TRONROUT0000000029474240', 2.5, 2.5, 'Route à 1 chaussée', 'NC', 'R DES ARCHITECTES', 'R DES ARCHITECTES', '5', 'Autre', 'NC', 'NR', 'Non', 'NC', 'Non', 'NC', '4.0', 'NC', '2', '0', 'Double', None, None, '44109', '44109', '44109#0IL', '44109#0IL', '44200', '44200', 'Classique', '0.0', '0.0', '0.0', '0.0', 'NR', '7.5', '8.1', 'LINESTRING Z (355253.5 6688410.1 7.5, 355249.2 6688414.2 7.5, 355219.4 6688430.3 7.3, 355183.2 6688449.4 8.1)'),
            ('TRONROUT0000000029475231', 2.5, 2.5, 'Route à 1 chaussée', 'NC', 'PONT HAUDAUDINE', 'PONT HAUDAUDINE', '4', 'Autre', 'NC', 'NR', 'Non', 'NC', 'Non', 'NC', '10.5', 'NC', '2', '0', 'Double', None, None, '44109', '44109', '44109#096', '44109#096', 'NR', 'NR', 'Classique', '0.0', '0.0', '0.0', '0.0', 'NR', '7.9', '8.7', 'LINESTRING Z (355395.2 6688501 7.9, 355394.3 6688515.8 8.699999999999999)'),
            ('TRONROUT0000000222675267', 2.5, 2.5, 'Route à 1 chaussée', 'NC', 'PL DES ERABLES', 'PL DES ERABLES', '5', 'Autre', 'NC', 'NR', 'Non', 'NC', 'Non', 'NC', '4.0', 'NC', '2', '0', 'Direct', None, None, '44109', '44109', '44109#0IJ', '44109#0IJ', '44200', '44200', 'Classique', '0.0', '0.0', '0.0', '0.0', 'NR', '8.1', '8.6', 'LINESTRING Z (355183.2 6688449.4 8.1, 355182.7 6688455.2 8, 355182.5 6688459.8 8, 355182 6688465 7.9, 355181.6 6688471 7.8, 355181 6688477.4 7.7, 355181 6688485 9.199999999999999, 355180.4 6688491 9.1, 355180.1 6688496.4 8.9, 355179.7 6688501.1 8.800000000000001, 355179 6688505.2 8.699999999999999, 355178.5 6688510.1 8.6)'),
            ('TRONROUT0000000224176721', 2.5, 2.5, 'Route à 1 chaussée', 'NC', 'R LA TOUR D\'AUVERGNE', 'R LA TOUR D\'AUVERGNE', '5', 'Autre', 'NC', 'NR', 'Non', 'NC', 'Non', 'NC', '4.0', 'NC', '2', '0', 'Double', None, None, '44109', '44109', '441094812', '441094812', '44200', '44200', 'Classique', '0.0', '0.0', '0.0', '0.0', 'NR', '6.5', '5.8', 'LINESTRING Z (355174 6688389.86 5.97347826086955, 355185.4 6688391 5.8)'),
            ('TRONROUT0000000029474203', 2.5, 2.5, 'Route à 1 chaussée', 'NC', 'R ALAIN BARBE TORTE', 'R ALAIN BARBE TORTE', '5', 'Autre', 'NC', 'NR', 'Non', 'NC', 'Non', 'NC', '4.0', 'NC', '2', '0', 'Double', None, None, '44109', '44109', '441090068', '441090068', '44200', '44200', 'Classique', '21.0', '0.0', '21.0', '0.0', 'NR', '6.6', '7.4', 'LINESTRING Z (355255.8 6688514.9 6.6, 355256.6 6688502.5 6.6, 355258.1 6688486.8 6.6, 355261.1 6688472.5 7, 355265.2 6688416.3 7.4)'),
            ('TRONROUT0000000039836663', 2.5, 2.5, 'Route à 1 chaussée', 'NC', 'R PIERRE LANDAIS', 'R PIERRE LANDAIS', '5', 'Autre', 'NC', 'NR', 'Non', 'NC', 'Non', 'NC', '4.0', 'NC', '2', '0', 'Direct', None, None, '44109', '44109', '441096608', '441096608', '44200', '44200', 'Classique', '5.0', '0.0', '9.0', '0.0', 'NR', '6.8', '6.8', 'LINESTRING Z (355191.5 6688323.2 6.8, 355174 6688321.422958057 6.8)'),
            ('TRONROUT0000000222675270', 2.5, 2.5, 'Route à 1 chaussée', 'NC', 'R ALAIN BARBE TORTE', 'R ALAIN BARBE TORTE', '5', 'Autre', 'NC', 'NR', 'Non', 'NC', 'Non', 'NC', '4.0', 'NC', '2', '0', 'Double', None, None, '44109', '44109', '441090068', '441090068', '44200', '44200', 'Classique', '21.0', '0.0', '21.0', '0.0', 'NR', '6.6', '6.6', 'LINESTRING Z (355254.6 6688533.6 6.6, 355255.8 6688514.9 6.6)'),
            ('TRONROUT0000000224176718', 2.5, 2.5, 'Route à 1 chaussée', 'NC', 'QU FRANCOIS MITTERRAND', 'QU FRANCOIS MITTERRAND', '5', 'Autre', 'NC', 'NR', 'Non', 'NC', 'Non', 'NC', '4.0', 'NC', '2', '0', 'Double', 'QU FERNAND CROUAN', 'QU FERNAND CROUAN', '44109', '44109', '441093315', '441093315', '44200', '44200', 'Linéaire', '8.0', '0.0', '8.0', '0.0', 'NR', '6.1', '6.1', 'LINESTRING Z (355175 6688552.8 6.1, 355174 6688553.058064516 6.1)'),
            ('TRONROUT0000000224176722', 2.5, 2.5, 'Route à 1 chaussée', 'NC', 'R PIERRE LANDAIS', 'R PIERRE LANDAIS', '5', 'Autre', 'NC', 'NR', 'Non', 'NC', 'Non', 'NC', '4.0', 'NC', '2', '0', 'Direct', None, None, '44109', '44109', '441096608', '441096608', '44200', '44200', 'Classique', '1.0', '0.0', '3.0', '0.0', 'NR', '7.0', '6.8', 'LINESTRING Z (355271.4 6688330.2 7, 355218.5 6688325.4 6.9, 355191.5 6688323.2 6.8)'),
            ('TRONROUT0000000222675268', 2.5, 2.5, 'Sentier', 'NC', 'QU FRANCOIS MITTERRAND', 'QU FRANCOIS MITTERRAND', 'NC', 'Autre', 'NC', 'NR', 'Non', 'NC', 'Non', 'NC', '0.0', 'NC', '0', '0', 'NC', 'QU FERNAND CROUAN', 'QU FERNAND CROUAN', '44109', '44109', '441093315', '441093315', '44200', '44200', 'Linéaire', '0.0', '0.0', '0.0', '0.0', 'NR', '6.0', '6.1', 'LINESTRING Z (355191.5 6688548.6 6, 355175 6688552.8 6.1)'),
            ('TRONROUT0000000295264885', 2.5, 2.5, 'Sentier', 'NC', 'QU FRANCOIS MITTERRAND', 'QU FRANCOIS MITTERRAND', 'NC', 'Autre', 'NC', 'NR', 'Non', 'NC', 'Non', 'NC', '0.0', 'NC', '0', '0', 'NC', 'QU FERNAND CROUAN', 'QU FERNAND CROUAN', '44109', '44109', '441093315', '441093315', '44200', '44200', 'Linéaire', '6.0', '0.0', '6.0', '0.0', 'NR', '7.0', '6.0', 'LINESTRING Z (355254.6 6688533.6 7, 355226 6688539.9 6.8, 355220.3 6688541.8 6.6, 355217.1 6688543 6.6, 355196.7 6688547.3 6.1, 355191.5 6688548.6 6)'),
            ('TRONROUT0000000029473545', 2.5, 2.5, 'Route à 1 chaussée', 'NC', 'PL FRANCOIS II', 'PL FRANCOIS II', '5', 'Autre', 'NC', 'NR', 'Non', 'NC', 'Non', 'NC', '7.0', 'NC', '2', '0', 'Direct', None, None, '44109', '44109', '441093304', '441093304', '44200', '44200', 'Linéaire', '0.0', '4.0', '0.0', '4.0', 'NR', '1.9', '3.1', 'LINESTRING Z (355267 6688386.1 1.9, 355268.8 6688386.2 1.6, 355272.4 6688387.6 0.8, 355275.6 6688390.1 0.5, 355276.9 6688391.3 0.2, 355278 6688393.2 0, 355280 6688399.1 3.1)'),
            ('TRONROUT0000000029473581', 2.5, 2.5, 'Route à 1 chaussée', 'NC', 'QU FRANCOIS MITTERRAND', 'QU FRANCOIS MITTERRAND', '5', 'Autre', 'NC', 'NR', 'Non', 'NC', 'Non', 'NC', '4.0', 'NC', '2', '0', 'Double', 'QU FERNAND CROUAN', 'QU FERNAND CROUAN', '44109', '44109', '441093315', '441093315', '44200', '44200', 'Linéaire', '0.0', '2.0', '0.0', '1.0', 'NR', '7.1', '7.9', 'LINESTRING Z (355345.8 6688511.9 7.1, 355395.2 6688501 7.9)'),
            ('TRONROUT0000000029473631', 2.5, 2.5, 'Route à 1 chaussée', 'NC', 'R LA TOUR D\'AUVERGNE', 'R LA TOUR D\'AUVERGNE', '5', 'Autre', 'NC', 'NR', 'Non', 'NC', 'Non', 'NC', '4.0', 'NC', '2', '0', 'Double', None, None, '44109', '44109', '441094812', '441094812', '44200', '44200', 'Classique', '0.0', '31.0', '0.0', '31.0', 'NR', '5.8', '6.7', 'LINESTRING Z (355185.4 6688391 5.8, 355219.1 6688393.6 5.5, 355251.6 6688396.4 6.7)'),
            ('TRONROUT0000000029473669', 2.5, 2.5, 'Route à 1 chaussée', 'NC', 'PL FRANCOIS II', 'PL FRANCOIS II', '5', 'Autre', 'NC', 'NR', 'Non', 'NC', 'Non', 'NC', '7.0', 'NC', '2', '0', 'Direct', None, None, '44109', '44109', '441093304', '441093304', '44200', '44200', 'Linéaire', '0.0', '2.0', '0.0', '2.0', 'NR', '6.4', '6.6', 'LINESTRING Z (355265.2 6688416.3 6.4, 355262.4 6688416.5 6.8, 355258.6 6688415.1 6.6, 355255.6 6688412.9 6.7, 355253.5 6688410.1 6.6)'),
            ('TRONROUT0000000029473834', 2.5, 2.5, 'Route à 1 chaussée', 'NC', 'PL FRANCOIS II', 'PL FRANCOIS II', '5', 'Autre', 'NC', 'NR', 'Non', 'NC', 'Non', 'NC', '7.0', 'NC', '2', '0', 'Direct', None, None, '44109', '44109', '441093304', '441093304', '44200', '44200', 'Linéaire', '0.0', '2.0', '0.0', '2.0', 'NR', '6.6', '4.8', 'LINESTRING Z (355253.5 6688410.1 6.6, 355252.8 6688409.5 6.6, 355250.8 6688405.7 6.5, 355250.1 6688401.3 5.7, 355251.6 6688396.4 4.8)'),
            ('TRONROUT0000000029473851', 2.5, 2.5, 'Route à 1 chaussée', 'NC', 'PL FRANCOIS II', 'PL FRANCOIS II', '5', 'Autre', 'NC', 'NR', 'Non', 'NC', 'Non', 'NC', '7.0', 'NC', '2', '0', 'Direct', None, None, '44109', '44109', '441093304', '441093304', '44200', '44200', 'Linéaire', '0.0', '4.0', '0.0', '4.0', 'NR', '3.1', '6.4', 'LINESTRING Z (355280 6688399.1 3.1, 355280.7 6688400.9 5.9, 355281.2 6688403.7 6.1, 355280.3 6688407 6.2, 355278.3 6688410 6.3, 355275 6688412.6 6.4, 355271.1 6688414.8 6.3, 355266.5 6688416.2 6.3, 355265.2 6688416.3 6.4)'),
            ('TRONROUT0000000029474443', 2.5, 2.5, 'Route à 1 chaussée', 'NC', 'QU ANDRE RHUYS', 'QU ANDRE RHUYS', '5', 'Autre', 'NC', 'NR', 'Non', 'NC', 'Non', 'NC', '4.0', 'NC', '2', '0', 'Double', None, None, '44109', '44109', '441090297', '441090297', '44200', '44200', 'Linéaire', '0.0', '9.0', '0.0', '5.0', 'NR', '7.9', '6.4', 'LINESTRING Z (355395.2 6688501 7.9, 355410 6688497.517647059 7.716072908036401)'),
            ('TRONROUT0000000029474516', 2.5, 2.5, 'Route à 1 chaussée', 'NC', 'PL FRANCOIS II', 'PL FRANCOIS II', '5', 'Autre', 'NC', 'NR', 'Non', 'NC', 'Non', 'NC', '7.0', 'NC', '2', '0', 'Direct', None, None, '44109', '44109', '441093304', '441093304', '44200', '44200', 'Linéaire', '0.0', '4.0', '0.0', '4.0', 'NR', '4.8', '1.9', 'LINESTRING Z (355251.6 6688396.4 4.8, 355253.5 6688392.9 3.9, 355256.7 6688389.6 3.1, 355260.4 6688387.2 2.4, 355264.6 6688386 2.3, 355267 6688386.1 1.9)'),
            ('TRONROUT0000000320084035', 2.5, 2.5, 'Route à 1 chaussée', 'NC', 'QU FRANCOIS MITTERRAND', 'QU FRANCOIS MITTERRAND', '5', 'Autre', 'NC', 'NR', 'Non', 'NC', 'Non', 'NC', '4.0', 'NC', '2', '0', 'Double', 'QU FERNAND CROUAN', 'QU FERNAND CROUAN', '44109', '44109', '441093315', '441093315', '44200', '44200', 'Linéaire', '0.0', '4.0', '0.0', '2.0', 'NR', '7.0', '7.1', 'LINESTRING Z (355254.6 6688533.6 7, 355303.6 6688521.3 6.6, 355345.8 6688511.9 7.1)'),
            ('TRONROUT0000000029473587', 2.5, 2.5, 'Route à 1 chaussée', 'NC', 'R LOUIS BLANC', 'R LOUIS BLANC', '4', 'Autre', 'NC', 'NR', 'Non', 'NC', 'Non', 'NC', '10.5', 'NC', '2', '0', 'Double', None, None, '44109', '44109', '441095064', '441095064', '44200', '44200', 'Classique', '15.0', '16.0', '21.0', '28.0', 'NR', '6.9', '7.7', 'LINESTRING Z (355404.2 6688410.4 6.9, 355407.1 6688376.6 7.2, 355410 6688342.145238095 7.545238095240976)'),
            ('TRONROUT0000000029473618', 2.5, 2.5, 'Route à 1 chaussée', 'NC', 'R LA TOUR D\'AUVERGNE', 'R LA TOUR D\'AUVERGNE', '5', 'Autre', 'NC', 'NR', 'Non', 'NC', 'Non', 'NC', '4.0', 'NC', '2', '0', 'Double', None, None, '44109', '44109', '441094812', '441094812', '44200', '44200', 'Classique', '21.0', '20.0', '25.0', '22.0', 'NR', '6.9', '7.2', 'LINESTRING Z (355366.3 6688407.1 6.9, 355301.7 6688401.5 6.9, 355280 6688399.1 7.2)'),
            ('TRONROUT0000000029473632', 2.5, 2.5, 'Route à 1 chaussée', 'NC', 'R ALAIN BARBE TORTE', 'R ALAIN BARBE TORTE', '5', 'Autre', 'NC', 'NR', 'Non', 'NC', 'Non', 'NC', '4.0', 'NC', '2', '0', 'Double', None, None, '44109', '44109', '441090068', '441090068', '44200', '44200', 'Classique', '13.0', '8.0', '9.0', '8.0', 'NR', '7.0', '7.0', 'LINESTRING Z (355267 6688386.1 7, 355267.1 6688377.6 6.9, 355271.4 6688330.2 7)'),
            ('TRONROUT0000000029473721', 2.5, 2.5, 'Route à 1 chaussée', 'NC', 'R LA TOUR D\'AUVERGNE', 'R LA TOUR D\'AUVERGNE', '5', 'Autre', 'NC', 'NR', 'Non', 'NC', 'Non', 'NC', '4.0', 'NC', '2', '0', 'Double', None, None, '44109', '44109', '441094812', '441094812', '44200', '44200', 'Classique', '7.0', '10.0', '17.0', '14.0', 'NR', '6.5', '6.9', 'LINESTRING Z (355410 6688410.908506945 6.87986111111116, 355404.2 6688410.4 6.9)'),
            ('TRONROUT0000000029474731', 2.5, 2.5, 'Route à 1 chaussée', 'NC', 'R ALAIN BARBE TORTE', 'R ALAIN BARBE TORTE', '5', 'Autre', 'NC', 'NR', 'Non', 'NC', 'Non', 'NC', '7.0', 'NC', '2', '0', 'Double', None, None, '44109', '44109', '441090068', '441090068', '44200', '44200', 'Classique', '12.0', '19.0', '10.0', '15.0', 'NR', '7.0', '7.3', 'LINESTRING Z (355271.4 6688330.2 7, 355272.2330097088 6688317 7.064077669903525)'),
            ('TRONROUT0000000029475019', 2.5, 2.5, 'Route à 1 chaussée', 'NC', 'R LOUIS BLANC', 'R LOUIS BLANC', '4', 'Autre', 'NC', 'NR', 'Non', 'NC', 'Non', 'NC', '10.5', 'NC', '2', '0', 'Double', None, None, '44109', '44109', '441095064', '441095064', '44200', '44200', 'Classique', '1.0', '4.0', '7.0', '14.0', 'NR', '7.9', '6.9', 'LINESTRING Z (355395.2 6688501 7.9, 355404.2 6688410.4 6.9)'),
            ('TRONROUT0000000320084037', 2.5, 2.5, 'Route à 1 chaussée', 'NC', 'R LA TOUR D\'AUVERGNE', 'R LA TOUR D\'AUVERGNE', '5', 'Autre', 'NC', 'NR', 'Non', 'NC', 'Non', 'NC', '4.0', 'NC', '2', '0', 'Double', None, None, '44109', '44109', '441094812', '441094812', '44200', '44200', 'Classique', '19.0', '16.0', '19.0', '18.0', 'NR', '6.9', '6.9', 'LINESTRING Z (355404.2 6688410.4 6.9, 355366.3 6688407.1 6.9)'),
            ('TRONROUT0000000222675265', 5.0, 2.5, 'Route à 1 chaussée', 'NC', None, None, '5', 'Autre', 'NC', 'NR', 'Non', 'NC', 'Non', 'NC', '4.0', 'NC', '2', '0', 'Double', None, None, '44109', '44109', 'NR', 'NR', 'NR', 'NR', 'Classique', '0.0', '0.0', '0.0', '0.0', 'NR', '8.6', '6.1', 'LINESTRING Z (355178.5 6688510.1 8.6, 355175 6688552.8 6.1)'),
            ('TRONROUT0000000222675269', 5.0, 2.5, 'Route à 1 chaussée', 'NC', 'R LANOUE BRAS DE FER', 'R LANOUE BRAS DE FER', '5', 'Autre', 'NC', 'NR', 'Non', 'NC', 'Non', 'NC', '4.0', 'NC', '2', '0', 'Double', None, None, '44109', '44109', '441094796', '441094796', '44200', '44200', 'Classique', '0.0', '0.0', '0.0', '0.0', 'NR', '8.6', '6.6', 'LINESTRING Z (355178.5 6688510.1 8.6, 355255.8 6688514.9 6.6)'),
            ('TRONROUT0000000320084036', 5.0, 2.5, 'Route à 1 chaussée', 'NC', 'PAS DE L\'IMPRIMERIE', 'PAS DE L\'IMPRIMERIE', '5', 'Autre', 'NC', 'NR', 'Non', 'NC', 'Non', 'NC', '4.0', 'NC', '2', '0', 'Double', None, None, '44109', '44109', 'NR', 'NR', 'NR', 'NR', 'Classique', '0.0', '0.0', '0.0', '0.0', 'NR', '7.0', '6.9', 'LINESTRING Z (355351.3 6688433.6 7, 355363.3 6688434.5 6.9, 355366.3 6688407.1 6.9)'),
            ('TRONROUT0000000320084038', 5.0, 2.5, 'Sentier', 'NC', 'PAS DE L\'IMPRIMERIE', 'PAS DE L\'IMPRIMERIE', 'NC', 'Autre', 'NC', 'NR', 'Non', 'NC', 'Non', 'NC', '0.0', 'NC', '0', '0', 'NC', None, None, '44109', '44109', 'NR', 'NR', 'NR', 'NR', 'Classique', '0.0', '0.0', '0.0', '0.0', 'NR', '7.1', '7.0', 'LINESTRING Z (355345.8 6688511.9 7.1, 355351.3 6688433.6 7)'),
            ('TRONROUT0000000029474604', 5.0, 2.5, 'Route à 1 chaussée', 'NC', 'PL DE LA REPUBLIQUE', 'PL DE LA REPUBLIQUE', '5', 'Autre', 'NC', 'NR', 'Non', 'NC', 'Non', 'NC', '3.0', 'NC', '1', '0', 'Direct', None, None, '44109', '44109', '441097276', '441097276', '44200', '44200', 'Linéaire', '0.0', '1.0', '0.0', '3.0', 'NR', '7.4', '7.5', 'LINESTRING Z (355410 6688325.037500001 7.4, 355403.715037594 6688317 7.4)')
            ]
        _df = DataFrame(data=_rawData, columns=[
            'ID', 'PREC_PLANI', 'PREC_ALTI', 'NATURE', 'NUMERO', 'NOM_VOIE_G',
            'NOM_VOIE_D', 'IMPORTANCE', 'CL_ADMIN', 'GESTION', 'MISE_SERV',
            'IT_VERT', 'IT_EUROP', 'FICTIF', 'FRANCHISST', 'LARGEUR', 'NOM_ITI',
            'NB_VOIES', 'POS_SOL', 'SENS', 'ALIAS_G', 'ALIAS_D', 'INSEECOM_G',
            'INSEECOM_D', 'CODEVOIE_G', 'CODEVOIE_D', 'CODEPOST_G', 'CODEPOST_D',
            'TYP_ADRES', 'BORNEDEB_G', 'BORNEDEB_D', 'BORNEFIN_G', 'BORNEFIN_D',
            'ETAT', 'Z_INI', 'Z_FIN', 'geometry'])
        _df.geometry = _df.geometry.apply(lambda g: loads(g))
        for _fieldname in ['LARGEUR', 'BORNEDEB_G', 'BORNEDEB_D', 'BORNEFIN_G', 'BORNEFIN_D', 'Z_INI', 'Z_FIN']:
            _df[_fieldname] = _df[_fieldname].astype(float)
        for _fieldname in ['NB_VOIES', 'POS_SOL']:
            _df[_fieldname] = _df[_fieldname].astype(int)
        return GeoDataFrame(_df, crs='epsg:2154')

    @staticmethod
    def ensaNantesTrees():
        _rawData = [
            ('Larix', 'decidua', '5.5 m', '6-10 m', 17.0, '6503094', 'POINT (355345.4265547934 6688506.44948356)'),
            ('Betula', 'verrucosa', '5.5 m', '0-5 m', 5.0, '6503455', 'POINT (355258.844440129 6688500.961984504)'),
            ('Quercus', 'robur', '5.5 m', '0-5 m', 4.0, '6504443', 'POINT (355342.703136137 6688410.522459004)'),
            ('Quercus', 'robur', '5.5 m', '6-10 m', 9.0, '6504444', 'POINT (355357.8443094885 6688412.007470774)'),
            ('Quercus', 'robur', '5.5 m', '0-5 m', 3.0, '6504445', 'POINT (355378.4466366756 6688414.117335526)'),
            ('Prunus', 'sp', '5.5 m', '6-10 m', 13.0, '6504446', 'POINT (355382.3826479648 6688406.650631208)'),
            ('Prunus', 'sp', '5.5 m', '6-10 m', 14.0, '6504447', 'POINT (355374.8339665656 6688406.142773321)'),
            ('Prunus', 'sp', '5.5 m', '6-10 m', 12.0, '6504448', 'POINT (355368.0817087357 6688405.268668492)'),
            ('Prunus', 'sp', '5.5 m', '6-10 m', 16.0, '6504449', 'POINT (355354.6811196086 6688404.009248156)'),
            ('Prunus', 'sp', '5.5 m', '6-10 m', 16.0, '6504450', 'POINT (355345.8324866063 6688403.392107639)'),
            ('Prunus', 'sp', '5.5 m', '6-10 m', 16.0, '6504451', 'POINT (355328.8800487901 6688401.592148742)'),
            ('Prunus', 'sp', '5.5 m', '6-10 m', 16.0, '6504452', 'POINT (355314.332168769 6688400.561946942)'),
            ('Prunus', 'sp', '5.5 m', '0-5 m', 9.0, '6504453', 'POINT (355305.1791953855 6688399.387707062)'),
            ('Liquidambar', 'styraciflua', '5.5 m', '16-20 m', 27.0, '6503171', 'POINT (355402.3206735904 6688322.679369161)'),
            ('Koelreuteria', 'paniculata', '5.5 m', '6-10 m', 16.0, '6503203', 'POINT (355184.0847714964 6688446.743659912)'),
            ('Acer', 'negundo', '5.5 m', '6-10 m', 15.0, '6503217', 'POINT (355183.647508496 6688504.444711548)'),
            ('Acer', 'negundo', '5.5 m', '6-10 m', 20.0, '6503218', 'POINT (355184.166228288 6688497.00594948)'),
            ('Acer', 'negundo', '5.5 m', '6-10 m', 19.0, '6503219', 'POINT (355184.5724822176 6688490.477436834)'),
            ('Acer', 'negundo', '5.5 m', '6-10 m', 15.0, '6503220', 'POINT (355185.1965999826 6688483.707319627)'),
            ('Acer', 'negundo', '5.5 m', '6-10 m', 17.0, '6503221', 'POINT (355185.7084153832 6688477.867435764)'),
            ('Acer', 'negundo', '5.5 m', '6-10 m', 15.0, '6503222', 'POINT (355186.3441789497 6688470.077974583)'),
            ('Acer', 'negundo', '5.5 m', '6-10 m', 12.0, '6503223', 'POINT (355186.7635126515 6688465.148176744)'),
            ('Acer', 'negundo', '5.5 m', '6-10 m', 14.0, '6503224', 'POINT (355187.0639223526 6688460.339262908)'),
            ('Quercus', 'robur', '5.5 m', '0-5 m', 3.0, '6504485', 'POINT (355304.2018211054 6688406.950131067)'),
            ('Quercus', 'robur', '5.5 m', '0-5 m', 4.0, '6504486', 'POINT (355316.582236908 6688408.097981722)'),
            ('Prunus', 'avium', '5.5 m', '6-10 m', 22.0, '6503247', 'POINT (355254.3256648652 6688424.984952416)'),
            ('Prunus', 'avium', '5.5 m', '6-10 m', 17.0, '6503248', 'POINT (355252.7940713239 6688420.990428664)'),
            ('Prunus', 'avium', '5.5 m', '6-10 m', 18.0, '6503249', 'POINT (355243.7890477881 6688412.250553689)'),
            ('Prunus', 'avium', '5.5 m', '6-10 m', 22.0, '6503250', 'POINT (355242.8409564095 6688406.292702506)'),
            ('Prunus', 'avium', '5.5 m', '6-10 m', 24.0, '6503251', 'POINT (355237.3332126389 6688404.858826444)'),
            ('Prunus', 'avium', '5.5 m', '6-10 m', 24.0, '6503252', 'POINT (355237.207728291 6688389.521157583)'),
            ('Prunus', 'avium', '5.5 m', '6-10 m', 23.0, '6503253', 'POINT (355243.0496438963 6688390.272802042)'),
            ('Prunus', 'avium', '5.5 m', '6-10 m', 23.0, '6503254', 'POINT (355249.4033747813 6688385.184562725)'),
            ('Prunus', 'avium', '5.5 m', '6-10 m', 23.0, '6503255', 'POINT (355255.4311273969 6688380.558649936)'),
            ('Prunus', 'avium', '5.5 m', '6-10 m', 25.0, '6503256', 'POINT (355258.4568785183 6688372.979477745)'),
            ('Prunus', 'avium', '5.5 m', '6-10 m', 25.0, '6503257', 'POINT (355274.287731833 6688375.707930178)'),
            ('Prunus', 'avium', '5.5 m', '6-10 m', 26.0, '6503258', 'POINT (355273.9820716163 6688381.096459782)'),
            ('Prunus', 'avium', '5.5 m', '6-10 m', 27.0, '6503259', 'POINT (355279.6581343997 6688387.225497947)'),
            ('Prunus', 'avium', '5.5 m', '6-10 m', 27.0, '6503260', 'POINT (355285.4307476004 6688394.163150174)'),
            ('Prunus', 'avium', '5.5 m', '6-10 m', 23.0, '6503261', 'POINT (355290.3468517925 6688394.122953558)'),
            ('Prunus', 'avium', '5.5 m', '6-10 m', 23.0, '6503262', 'POINT (355286.491362982 6688411.43174471)'),
            ('Prunus', 'avium', '5.5 m', '6-10 m', 21.0, '6503263', 'POINT (355280.3173192 6688411.61213107)'),
            ('Prunus', 'avium', '5.5 m', '6-10 m', 26.0, '6503264', 'POINT (355278.9951643652 6688417.338729162)'),
            ('Prunus', 'avium', '5.5 m', '6-10 m', 23.0, '6503265', 'POINT (355271.5404804081 6688418.548835431)'),
            ('Prunus', 'avium', '5.5 m', '6-10 m', 21.0, '6503266', 'POINT (355269.781535167 6688424.62874716)'),
            ('Fraxinus', 'excelsior', '5.5 m', '6-10 m', 15.0, '6504376', 'POINT (355176.1927372587 6688516.636724089)'),
            ('Quercus', 'robur', '5.5 m', '11-15 m', 21.0, '6504392', 'POINT (355227.4208155124 6688400.023498422)'),
            ('Prunus', 'maackii', '5.5 m', '0-5 m', 16.0, '6504393', 'POINT (355228.2963071818 6688392.222084661)'),
            ('Prunus', 'subhirtella', '5.5 m', '0-5 m', 24.0, '6504394', 'POINT (355216.1375157258 6688391.292259285)'),
            ('Quercus', 'robur', '5.5 m', '0-5 m', 4.0, '6504487', 'POINT (355323.6732445246 6688408.849405356)'),
            ('Quercus', 'robur', '5.5 m', '0-5 m', 4.0, '6504488', 'POINT (355332.0431568563 6688409.580379305)'),
            ('Quercus', 'robur', '5.5 m', '11-15 m', 24.0, '6504395', 'POINT (355192.8381951794 6688396.638964815)'),
            ('Quercus', 'robur', '5.5 m', '11-15 m', 25.0, '6504396', 'POINT (355207.7386592286 6688398.016027095)'),
            ('Prunus', 'subhirtella', '5.5 m', '0-5 m', 22.0, '6504397', 'POINT (355202.1745089137 6688389.687694112)'),
            ('Prunus', 'maackii', '5.5 m', '0-5 m', 17.0, '6504398', 'POINT (355188.4180471327 6688388.900836068)'),
            ('Prunus', 'serrulata', '5.5 m', '6-10 m', 22.0, '6504399', 'POINT (355176.1726156583 6688387.152322765)'),
            ('Quercus', 'robur', '5.5 m', '11-15 m', 19.0, '6504411', 'POINT (355185.2632980069 6688396.590981571)'),
            ('Quercus', 'robur', '5.5 m', '11-15 m', 21.0, '6504412', 'POINT (355215.5189569482 6688398.741829951)'),
            ('Koelreuteria', 'paniculata', '5.5 m', '6-10 m', 17.0, '6503758', 'POINT (355196.7431162335 6688440.334807208)'),
            ('Koelreuteria', 'paniculata', '5.5 m', '6-10 m', 14.0, '6503759', 'POINT (355209.1798366485 6688433.707928441)'),
            ('Koelreuteria', 'paniculata', '5.5 m', '6-10 m', 14.0, '6503760', 'POINT (355221.2459507499 6688426.974160755)'),
            ('Koelreuteria', 'paniculata', '5.5 m', '6-10 m', 13.0, '6503761', 'POINT (355234.2459063362 6688420.79234495)'),
            ('Populus', 'nigra', '5.5 m', '11-15 m', 23.0, '6503407', 'POINT (355379.8845813656 6688516.590057508)'),
            ('Quercus', 'rubra', '5.5 m', '0-5 m', 17.0, '6503412', 'POINT (355347.0282892206 6688519.017116451)'),
            ('Metasequoïa', 'glyptostroboïdes', '5.5 m', '6-10 m', 17.0, '6503413', 'POINT (355231.438276105 6688539.307975003)'),
            ('Metasequoïa', 'glyptostroboïdes', '5.5 m', '11-15 m', 27.0, '6503414', 'POINT (355237.2316332031 6688534.124391289)'),
            ('Metasequoïa', 'glyptostroboïdes', '5.5 m', '6-10 m', 15.0, '6503415', 'POINT (355241.5109676206 6688538.086456191)'),
            ('Metasequoïa', 'glyptostroboïdes', '5.5 m', '11-15 m', 37.0, '6503416', 'POINT (355244.3184906206 6688533.147123788)'),
            ('Betula', 'verrucosa', '5.5 m', '6-10 m', 5.0, '6503421', 'POINT (355258.5765903096 6688497.53670043)'),
            ('Betula', 'verrucosa', '5.5 m', '11-15 m', 16.0, '6503422', 'POINT (355259.240110863 6688495.582711187)'),
            ('Betula', 'verrucosa', '5.5 m', '11-15 m', 14.0, '6503423', 'POINT (355259.0014828264 6688493.286356054)'),
            ('Betula', 'verrucosa', '5.5 m', '11-15 m', 15.0, '6503424', 'POINT (355259.6595262063 6688490.662904995)'),
            ('EMPLACEMENT CONSERVE', 'VIDE', 'Z.N.R.', 'Z.N.R', 0.0, '6503425', 'POINT (355259.1829684256 6688488.598325909)'),
            ('Betula', 'verrucosa', '5.5 m', '16-20 m', 20.0, '6503426', 'POINT (355260.4644311212 6688476.676626176)'),
            ('Betula', 'verrucosa', '5.5 m', '11-15 m', 13.0, '6503427', 'POINT (355260.8822489314 6688469.118777257)'),
            ('EMPLACEMENT CONSERVE', 'VIDE', 'Z.N.R.', 'Z.N.R', 0.0, '6503428', 'POINT (355261.4188153713 6688467.525560963)'),
            ('Betula', 'verrucosa', '5.5 m', '6-10 m', 5.0, '6503429', 'POINT (355261.1792880988 6688465.119294235)'),
            ('Betula', 'verrucosa', '5.5 m', '6-10 m', 5.0, '6503430', 'POINT (355261.9270967111 6688462.475123979)'),
            ('EMPLACEMENT CONSERVE', 'VIDE', 'Z.N.R.', 'Z.N.R', 0.0, '6503431', 'POINT (355262.3364943861 6688453.888102501)'),
            ('Betula', 'verrucosa', '5.5 m', '6-10 m', 10.0, '6503432', 'POINT (355263.1342634048 6688451.243523762)'),
            ('Betula', 'verrucosa', '5.5 m', '6-10 m', 5.0, '6503433', 'POINT (355262.8538685676 6688448.727672219)'),
            ('Betula', 'verrucosa', '5.5 m', '16-20 m', 15.0, '6503434', 'POINT (355263.2957648337 6688446.555657144)'),
            ('Betula', 'verrucosa', '5.5 m', '11-15 m', 16.0, '6503435', 'POINT (355263.930547226 6688438.646292115)'),
            ('Betula', 'verrucosa', '5.5 m', '6-10 m', 13.0, '6503436', 'POINT (355270.1953347632 6688364.060001295)'),
            ('Betula', 'verrucosa', '5.5 m', '6-10 m', 11.0, '6503437', 'POINT (355271.6726520408 6688350.427960434)'),
            ('Betula', 'verrucosa', '5.5 m', '6-10 m', 14.0, '6503438', 'POINT (355272.4126876125 6688341.948155071)'),
            ('Betula', 'verrucosa', '5.5 m', '6-10 m', 10.0, '6503439', 'POINT (355273.1833159755 6688335.986243592)'),
            ('Betula', 'verrucosa', '5.5 m', '11-15 m', 18.0, '6503440', 'POINT (355274.2060471926 6688324.196564693)'),
            ('Liquidambar', 'styraciflua', '5.5 m', '11-15 m', 35.0, '6504550', 'POINT (355409.9558042372 6688389.937327192)'),
            ('Liquidambar', 'styraciflua', '5.5 m', '16-20 m', 42.0, '6504551', 'POINT (355406.4748114917 6688426.149125609)'),
            ('Liquidambar', 'styraciflua', '5.5 m', '16-20 m', 40.0, '6504552', 'POINT (355405.6487528123 6688436.328383768)'),
            ('Liquidambar', 'styraciflua', '5.5 m', '16-20 m', 40.0, '6504553', 'POINT (355404.6958217875 6688446.878406915)'),
            ('Liquidambar', 'styraciflua', '5.5 m', '16-20 m', 36.0, '6504554', 'POINT (355403.7609129389 6688457.188459496)'),
            ('Liquidambar', 'styraciflua', '5.5 m', '11-15 m', 40.0, '6504555', 'POINT (355402.8160937526 6688467.508585809)'),
            ('Liquidambar', 'styraciflua', '5.5 m', '6-10 m', 24.0, '6504556', 'POINT (355401.871192812 6688477.818720216)'),
            ('Liquidambar', 'styraciflua', '5.5 m', '16-20 m', 36.0, '6504557', 'POINT (355388.3949832175 6688494.186928874)'),
            ('Liquidambar', 'styraciflua', '5.5 m', '16-20 m', 33.0, '6504558', 'POINT (355389.0908996474 6688483.978756651)'),
            ('Liquidambar', 'styraciflua', '5.5 m', '16-20 m', 34.0, '6504559', 'POINT (355390.029650761 6688474.138326491)'),
            ('Liquidambar', 'styraciflua', '5.5 m', '6-10 m', 10.0, '6504560', 'POINT (355391.1091902583 6688464.406664231)'),
            ('Liquidambar', 'styraciflua', '5.5 m', '16-20 m', 35.0, '6504561', 'POINT (355392.0649008043 6688454.196367968)'),
            ('Liquidambar', 'styraciflua', '5.5 m', '16-20 m', 36.0, '6504562', 'POINT (355393.1306059941 6688443.995165025)'),
            ('Liquidambar', 'styraciflua', '5.5 m', '16-20 m', 39.0, '6504563', 'POINT (355393.9865031864 6688437.462975182)'),
            ('Liquidambar', 'styraciflua', '5.5 m', '11-15 m', 26.0, '6504564', 'POINT (355397.3051258918 6688398.504529515)'),
            ('EMPLACEMENT CONSERVE', 'VIDE', '> 5.5 m', 'Z.N.R', 35.0, '6504565', 'POINT (355398.1401139323 6688388.195294388)'),
            ('Liquidambar', 'styraciflua', '5.5 m', '11-15 m', 28.0, '6504566', 'POINT (355399.2167921605 6688378.113913747)'),
            ('Liquidambar', 'styraciflua', '5.5 m', '11-15 m', 31.0, '6504567', 'POINT (355399.9566008321 6688368.385029871)'),
            ('Liquidambar', 'styraciflua', '5.5 m', '11-15 m', 26.0, '6504568', 'POINT (355401.1104362272 6688357.963268838)'),
            ('Liquidambar', 'styraciflua', '5.5 m', '6-10 m', 15.0, '6504569', 'POINT (355402.0570538803 6688347.862966559)'),
            ('Liquidambar', 'styraciflua', '5.5 m', '11-15 m', 31.0, '6504570', 'POINT (355403.0048977674 6688337.912543846)'),
            ('Liquidambar', 'styraciflua', '5.5 m', '11-15 m', 30.0, '6504571', 'POINT (355403.7236595186 6688328.053928033)'),
            ('Magnolia', 'sp', '5.5 m', '6-10 m', 16.0, '6504747', 'POINT (355258.89683293 6688326.600061896)'),
            ('Magnolia', 'sp', '5.5 m', '6-10 m', 15.0, '6504750', 'POINT (355257.8118159043 6688335.662260671)'),
            ('Acer', 'negundo', '5.5 m', '6-10 m', 17.0, '6504907', 'POINT (355180.5280265937 6688540.873389263)'),
            ('Acer', 'negundo', '5.5 m', '11-15 m', 16.0, '6504908', 'POINT (355181.1513268879 6688534.003352175)'),
            ('Acer', 'negundo', '5.5 m', '6-10 m', 14.0, '6504909', 'POINT (355181.5194927157 6688527.704981425)'),
            ('Acer', 'negundo', '5.5 m', '6-10 m', 17.0, '6504910', 'POINT (355182.1627771702 6688520.834780996)')
            ]
        _df = DataFrame(
            data=_rawData,
            columns=('genre', 'espece', 'hauteurFut', 'hauteur', 'DIAMETRE', 'MI_PRINX', 'geometry')
            )
        _df.geometry = _df.geometry.apply(lambda g: loads(g)) 

        return GeoDataFrame(_df, crs='epsg:2154')

    @staticmethod
    def singleBuildingInNantes():
        _geom = loads('POLYGON Z ((353904.8 6695053.6 46.2, 353898.4 6695053.2 46.2, \
353896.7 6695050.7 46.2, 353884 6695049.8 46.2, 353880.9 6695052.6 46.2, 353880.6 6695054.3 46.2, \
353872.8 6695053.5 46.2, 353871.9 6695061 46.2, 353868.6 6695060.9 46.2, 353868.9 6695065.8 46.2, \
353869 6695068.4 46.2, 353869.6 6695075.7 46.2, 353872 6695075.9 46.2, 353872.4 6695074 46.2, \
353874.2 6695074.2 46.2, 353874.2 6695075.4 46.2, 353880.2 6695076 46.2, 353880.4 6695074.8 46.2, \
353891 6695075.8 46.2, 353891.4 6695074 46.2, 353894.3 6695074.3 46.2, 353894.1 6695076.1 46.2, \
353901.3 6695076.9 46.2, 353900.9 6695079.8 46.2, 353908.7 6695080.5 46.2, 353908.7 6695081.3 46.2, \
353911.2 6695081.5 46.2, 353911.3 6695080.8 46.2, 353917.8 6695081.6 46.2, 353918.7 6695073.6 46.2, \
353917 6695073.4 46.2, 353917.1 6695071.3 46.2, 353918.9 6695071.5 46.2, 353919.2 6695068.4 46.2, \
353918.3 6695068.2 46.2, 353919.1 6695060.8 46.2, 353920.2 6695060.9 46.2, 353920.5 6695058.5 46.2, \
353917.2 6695058.2 46.2, 353917.7 6695053.9 46.2, 353919.3 6695054 46.2, 353919.7 6695052 46.2, \
353927.3 6695052.6 46.2, 353927.9 6695043.3 46.2, 353922.4 6695040.6 46.2, 353923.7 6695038.8 46.2, \
353930.1 6695038.4 46.2, 353932.9 6695031.7 46.2, 353930 6695030.5 46.2, 353932.1 6695025.5 46.2, \
353941.2 6695028.9 46.2, 353943.2 6695022.3 46.2, 353939.9 6695021.1 46.2, 353942.6 6695014 46.2, \
353934.8 6695011.1 46.2, 353933.6 6695013.9 46.2, 353926.8 6695011.2 46.2, 353925.4 6695014.9 46.2, \
353918.5 6695012.3 46.2, 353916.9 6695013.2 46.2, 353916.1 6695011.7 46.2, 353914.5 6695012.4 46.2, \
353909.3 6695001 46.2, 353902 6695004.3 46.2, 353902.4 6695005.1 46.2, 353894.5 6695008.9 46.2, \
353897.8 6695015.9 46.2, 353896.2 6695016.7 46.2, 353897.6 6695019.9 46.2, 353899.3 6695019.2 46.2, \
353902 6695025.3 46.2, 353906.9 6695023.1 46.2, 353908.3 6695026 46.2, 353911.8 6695024.4 46.2, \
353917.4 6695026.8 46.2, 353911.7 6695040.1 46.2, 353911.6 6695040.1 46.2, 353911.6 6695040.2 46.2, \
353911.7 6695040.3 46.2, 353911.8 6695040.3 46.2, 353911.9 6695040.4 46.2, 353912 6695040.4 46.2, \
353912.3 6695040.4 46.2, 353912.5 6695040.4 46.2, 353912.8 6695040.4 46.2, 353912.8 6695040.3 46.2, \
353913.2 6695040.3 46.2, 353913.2 6695040.4 46.2, 353913.3 6695040.4 46.2, 353913.4 6695040.4 46.2, \
353913.5 6695040.4 46.2, 353913.6 6695040.4 46.2, 353913.7 6695040.5 46.2, 353913.8 6695040.6 46.2, \
353914 6695040.6 46.2, 353914 6695040.7 46.2, 353914.1 6695040.8 46.2, 353914.2 6695040.8 46.2, \
353914.5 6695041 46.2, 353914.5 6695041.1 46.2, 353914.7 6695041.3 46.2, 353914.8 6695041.3 46.2, \
353914.8 6695041.4 46.2, 353915 6695041.6 46.2, 353915 6695041.7 46.2, 353915.1 6695041.8 46.2, \
353915.2 6695042 46.2, 353915.2 6695042.1 46.2, 353915.2 6695042.2 46.2, 353915.3 6695042.2 46.2, \
353915.3 6695042.3 46.2, 353915.3 6695042.4 46.2, 353915.4 6695042.6 46.2, 353915.4 6695042.7 46.2, \
353915.4 6695042.9 46.2, 353915.4 6695043.2 46.2, 353915.4 6695043.3 46.2, 353915.4 6695043.4 46.2, \
353915.4 6695043.5 46.2, 353915.4 6695043.6 46.2, 353915.3 6695043.7 46.2, 353915.3 6695043.8 46.2, \
353915.3 6695044 46.2, 353915.2 6695044.1 46.2, 353915.2 6695044.2 46.2, 353915.1 6695044.3 46.2, \
353915 6695044.4 46.2, 353914.9 6695044.5 46.2, 353914.8 6695044.6 46.2, 353913.7 6695044.9 46.2, \
353905.3 6695049.2 46.2, 353904.8 6695053.6 46.2))')
        return GeoDataFrame([{'ID': 'BATIMENT0000000302909608', 'HAUTEUR': 4.1, 'geometry': _geom}], crs='epsg:2154')
