"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import typing
import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class LogBuffer(google.protobuf.message.Message):
    """since this is becoming a more serious thing than what we initially were building we need to make it
    more production ready and the first step is to log a buffer object instead of the individual log object.
    we create a message called LogBuffer which is nothing but an array of _LogObject which in turn is
    either a RunLog or a LiveLog object.
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    AGENT_TOKEN_FIELD_NUMBER: builtins.int
    RUN_LOGS_FIELD_NUMBER: builtins.int
    LIVE_LOGS_FIELD_NUMBER: builtins.int
    agent_token: typing.Text
    """this is like the experiment_id in runs where an agent tries to connect and server gives it a
    one time token with which all the incoming logs will be identified with
    """

    @property
    def run_logs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___RunLog]:
        """this can either contain one or the other"""
        pass
    @property
    def live_logs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ServingHTTPLog]: ...
    def __init__(self,
        *,
        agent_token: typing.Text = ...,
        run_logs: typing.Optional[typing.Iterable[global___RunLog]] = ...,
        live_logs: typing.Optional[typing.Iterable[global___ServingHTTPLog]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["agent_token",b"agent_token","live_logs",b"live_logs","run_logs",b"run_logs"]) -> None: ...
global___LogBuffer = LogBuffer

class ServingHTTPLog(google.protobuf.message.Message):
    """LiveLog is an individual call event which is created by the user agent whenever a certain API is called.
    it contains some basic information as in any other general monitoring solution.
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    PATH_FIELD_NUMBER: builtins.int
    METHOD_FIELD_NUMBER: builtins.int
    STATUS_CODE_FIELD_NUMBER: builtins.int
    LATENCY_MS_FIELD_NUMBER: builtins.int
    TIMESTAMP_FIELD_NUMBER: builtins.int
    path: typing.Text
    """the endpoint ie. /api/monitoring/"""

    method: typing.Text
    """the method ie. GET, POST, PUT, DELETE"""

    status_code: builtins.int
    """the status code ie. 200, 404, 500"""

    latency_ms: builtins.float
    """the latency in milli-seconds"""

    @property
    def timestamp(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """the timestamp when this event was created"""
        pass
    def __init__(self,
        *,
        path: typing.Text = ...,
        method: typing.Text = ...,
        status_code: builtins.int = ...,
        latency_ms: builtins.float = ...,
        timestamp: typing.Optional[google.protobuf.timestamp_pb2.Timestamp] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["timestamp",b"timestamp"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["latency_ms",b"latency_ms","method",b"method","path",b"path","status_code",b"status_code","timestamp",b"timestamp"]) -> None: ...
global___ServingHTTPLog = ServingHTTPLog

class ListDeploymentsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    WORKSPACE_ID_FIELD_NUMBER: builtins.int
    SERVING_ID_OR_NAME_FIELD_NUMBER: builtins.int
    PAGE_NO_FIELD_NUMBER: builtins.int
    workspace_id: typing.Text
    serving_id_or_name: typing.Text
    """used specifically for searching, if empty, it will return all the projects"""

    page_no: builtins.int
    def __init__(self,
        *,
        workspace_id: typing.Text = ...,
        serving_id_or_name: typing.Text = ...,
        page_no: builtins.int = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["page_no",b"page_no","serving_id_or_name",b"serving_id_or_name","workspace_id",b"workspace_id"]) -> None: ...
global___ListDeploymentsRequest = ListDeploymentsRequest

class ListDeploymentsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    class Serving(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        SERVING_ID_FIELD_NUMBER: builtins.int
        SERVING_NAME_FIELD_NUMBER: builtins.int
        TOTAL_MODELS_FIELD_NUMBER: builtins.int
        serving_id: typing.Text
        """the unique ID for this serving"""

        serving_name: typing.Text
        """the usermodifiable name of the serving"""

        total_models: builtins.int
        """the total number of models in this serving group"""

        def __init__(self,
            *,
            serving_id: typing.Text = ...,
            serving_name: typing.Text = ...,
            total_models: builtins.int = ...,
            ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["serving_id",b"serving_id","serving_name",b"serving_name","total_models",b"total_models"]) -> None: ...

    WORKSPACE_ID_FIELD_NUMBER: builtins.int
    SERVING_FIELD_NUMBER: builtins.int
    TOTAL_PAGES_FIELD_NUMBER: builtins.int
    workspace_id: typing.Text
    @property
    def serving(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ListDeploymentsResponse.Serving]: ...
    total_pages: builtins.int
    def __init__(self,
        *,
        workspace_id: typing.Text = ...,
        serving: typing.Optional[typing.Iterable[global___ListDeploymentsResponse.Serving]] = ...,
        total_pages: builtins.int = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["serving",b"serving","total_pages",b"total_pages","workspace_id",b"workspace_id"]) -> None: ...
global___ListDeploymentsResponse = ListDeploymentsResponse

class ListServingsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    WORKSPACE_ID_FIELD_NUMBER: builtins.int
    DEPLOYMENT_ID_FIELD_NUMBER: builtins.int
    RUN_ID_FIELD_NUMBER: builtins.int
    PAGE_NO_FIELD_NUMBER: builtins.int
    DESC_FIELD_NUMBER: builtins.int
    workspace_id: typing.Text
    """the workspace this is part of"""

    deployment_id: typing.Text
    """the unique ID for this project"""

    run_id: typing.Text
    """for searching"""

    page_no: builtins.int
    desc: builtins.bool
    def __init__(self,
        *,
        workspace_id: typing.Text = ...,
        deployment_id: typing.Text = ...,
        run_id: typing.Text = ...,
        page_no: builtins.int = ...,
        desc: builtins.bool = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["deployment_id",b"deployment_id","desc",b"desc","page_no",b"page_no","run_id",b"run_id","workspace_id",b"workspace_id"]) -> None: ...
global___ListServingsRequest = ListServingsRequest

class ListServingsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    MODEL_IDS_FIELD_NUMBER: builtins.int
    KEYS_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    TOTAL_PAGES_FIELD_NUMBER: builtins.int
    @property
    def model_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[typing.Text]:
        """the list of runs in this project"""
        pass
    @property
    def keys(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[typing.Text]:
        """the list of chart-keys for this run"""
        pass
    @property
    def created_at(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """time when these runs were created"""
        pass
    total_pages: builtins.int
    """the total number of pages"""

    def __init__(self,
        *,
        model_ids: typing.Optional[typing.Iterable[typing.Text]] = ...,
        keys: typing.Optional[typing.Iterable[typing.Text]] = ...,
        created_at: typing.Optional[typing.Iterable[builtins.int]] = ...,
        total_pages: builtins.int = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["created_at",b"created_at","keys",b"keys","model_ids",b"model_ids","total_pages",b"total_pages"]) -> None: ...
global___ListServingsResponse = ListServingsResponse

class Serving(google.protobuf.message.Message):
    """the Big Serving Object"""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    class _Status:
        ValueType = typing.NewType('ValueType', builtins.int)
        V: typing_extensions.TypeAlias = ValueType
    class _StatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Serving._Status.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        NOT_SET: Serving._Status.ValueType  # 0
        """When created and added to DB but no further action taken"""

        RUNNING: Serving._Status.ValueType  # 1
        """When the first on_serving_log has been called"""

        COMPLETED: Serving._Status.ValueType  # 2
        """When there is a graceful exit on_serving_end has been called"""

    class Status(_Status, metaclass=_StatusEnumTypeWrapper):
        pass

    NOT_SET: Serving.Status.ValueType  # 0
    """When created and added to DB but no further action taken"""

    RUNNING: Serving.Status.ValueType  # 1
    """When the first on_serving_log has been called"""

    COMPLETED: Serving.Status.ValueType  # 2
    """When there is a graceful exit on_serving_end has been called"""


    WORKSPACE_ID_FIELD_NUMBER: builtins.int
    AGENT_FIELD_NUMBER: builtins.int
    AGENT_TOKEN_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    CONFIG_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    UPDATED_AT_FIELD_NUMBER: builtins.int
    workspace_id: typing.Text
    @property
    def agent(self) -> global___AgentDetails:
        """the agent details"""
        pass
    agent_token: typing.Text
    """the unique ID of this agent from the MongoDB backend"""

    created_at: builtins.int
    """same as InitRunRequest.created_at"""

    config: typing.Text
    """the jsonified config string"""

    status: global___Serving.Status.ValueType
    """the last known status of this run"""

    updated_at: builtins.int
    """the last time this"""

    def __init__(self,
        *,
        workspace_id: typing.Text = ...,
        agent: typing.Optional[global___AgentDetails] = ...,
        agent_token: typing.Text = ...,
        created_at: builtins.int = ...,
        config: typing.Text = ...,
        status: global___Serving.Status.ValueType = ...,
        updated_at: builtins.int = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["agent",b"agent"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["agent",b"agent","agent_token",b"agent_token","config",b"config","created_at",b"created_at","status",b"status","updated_at",b"updated_at","workspace_id",b"workspace_id"]) -> None: ...
global___Serving = Serving

class Record(google.protobuf.message.Message):
    """This is the data that the user will be logging if this"""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    class _DataType:
        ValueType = typing.NewType('ValueType', builtins.int)
        V: typing_extensions.TypeAlias = ValueType
    class _DataTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Record._DataType.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        FLOAT: Record._DataType.ValueType  # 0
        INTEGER: Record._DataType.ValueType  # 1
        STRING: Record._DataType.ValueType  # 2
    class DataType(_DataType, metaclass=_DataTypeEnumTypeWrapper):
        """since it is not possible to have the map in the message, we need to have an enum for the target datatype"""
        pass

    FLOAT: Record.DataType.ValueType  # 0
    INTEGER: Record.DataType.ValueType  # 1
    STRING: Record.DataType.ValueType  # 2

    KEY_FIELD_NUMBER: builtins.int
    VALUE_TYPE_FIELD_NUMBER: builtins.int
    STEP_FIELD_NUMBER: builtins.int
    FLOAT_DATA_FIELD_NUMBER: builtins.int
    INTEGER_DATA_FIELD_NUMBER: builtins.int
    STRING_DATA_FIELD_NUMBER: builtins.int
    key: typing.Text
    """name of this data"""

    value_type: global___Record.DataType.ValueType
    step: builtins.int
    """also can be called "X-axis" or just x"""

    @property
    def float_data(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.float]:
        """all the data is done in the"""
        pass
    @property
    def integer_data(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]: ...
    @property
    def string_data(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[typing.Text]: ...
    def __init__(self,
        *,
        key: typing.Text = ...,
        value_type: global___Record.DataType.ValueType = ...,
        step: builtins.int = ...,
        float_data: typing.Optional[typing.Iterable[builtins.float]] = ...,
        integer_data: typing.Optional[typing.Iterable[builtins.int]] = ...,
        string_data: typing.Optional[typing.Iterable[typing.Text]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["float_data",b"float_data","integer_data",b"integer_data","key",b"key","step",b"step","string_data",b"string_data","value_type",b"value_type"]) -> None: ...
global___Record = Record

class RecordColumn(google.protobuf.message.Message):
    """RecordColumn should be the main key:value(s) thing we are going to use it for both the charts and scalar data."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    class _DataType:
        ValueType = typing.NewType('ValueType', builtins.int)
        V: typing_extensions.TypeAlias = ValueType
    class _DataTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[RecordColumn._DataType.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        FLOAT: RecordColumn._DataType.ValueType  # 0
        INTEGER: RecordColumn._DataType.ValueType  # 1
        STRING: RecordColumn._DataType.ValueType  # 2
    class DataType(_DataType, metaclass=_DataTypeEnumTypeWrapper):
        """type of this data"""
        pass

    FLOAT: RecordColumn.DataType.ValueType  # 0
    INTEGER: RecordColumn.DataType.ValueType  # 1
    STRING: RecordColumn.DataType.ValueType  # 2

    class RecordRow(google.protobuf.message.Message):
        """the actual data"""
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        X_FIELD_NUMBER: builtins.int
        FLOAT_DATA_FIELD_NUMBER: builtins.int
        INTEGER_DATA_FIELD_NUMBER: builtins.int
        STRING_DATA_FIELD_NUMBER: builtins.int
        x: builtins.int
        """also can be called "X-axis" or just x"""

        float_data: builtins.float
        """all the data is done in the"""

        integer_data: builtins.int
        string_data: typing.Text
        def __init__(self,
            *,
            x: builtins.int = ...,
            float_data: builtins.float = ...,
            integer_data: builtins.int = ...,
            string_data: typing.Text = ...,
            ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["float_data",b"float_data","integer_data",b"integer_data","string_data",b"string_data","x",b"x"]) -> None: ...

    KEY_FIELD_NUMBER: builtins.int
    VALUE_TYPE_FIELD_NUMBER: builtins.int
    ROWS_FIELD_NUMBER: builtins.int
    key: typing.Text
    """since it is not possible to have the map in the message, we need to have an enum for the target datatype
    name of this data
    """

    value_type: global___RecordColumn.DataType.ValueType
    @property
    def rows(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___RecordColumn.RecordRow]:
        """give me all the values for a given column (key), so in case of table, we can simply say that
        we are returning only one value for each column ie. len(RecordColumn.rows) == 1
        this is similar to saying bar chart value, it will be a scalar but wrapped as a array of length one
        """
        pass
    def __init__(self,
        *,
        key: typing.Text = ...,
        value_type: global___RecordColumn.DataType.ValueType = ...,
        rows: typing.Optional[typing.Iterable[global___RecordColumn.RecordRow]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["key",b"key","rows",b"rows","value_type",b"value_type"]) -> None: ...
global___RecordColumn = RecordColumn

class RunLog(google.protobuf.message.Message):
    """This is the aggregation of all the logs for this run"""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    class _LogType:
        ValueType = typing.NewType('ValueType', builtins.int)
        V: typing_extensions.TypeAlias = ValueType
    class _LogTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[RunLog._LogType.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        SYSTEM: RunLog._LogType.ValueType  # 0
        """these are the mtrics like GPU/RAM utilisation"""

        NBX: RunLog._LogType.ValueType  # 1
        """these are the metrics that NimbleBox generates for the user"""

        USER: RunLog._LogType.ValueType  # 2
        """these are the metrics that the user has logged"""

    class LogType(_LogType, metaclass=_LogTypeEnumTypeWrapper):
        pass

    SYSTEM: RunLog.LogType.ValueType  # 0
    """these are the mtrics like GPU/RAM utilisation"""

    NBX: RunLog.LogType.ValueType  # 1
    """these are the metrics that NimbleBox generates for the user"""

    USER: RunLog.LogType.ValueType  # 2
    """these are the metrics that the user has logged"""


    EXPERIMENT_ID_FIELD_NUMBER: builtins.int
    DATA_FIELD_NUMBER: builtins.int
    COLUMN_DATA_FIELD_NUMBER: builtins.int
    LOG_TYPE_FIELD_NUMBER: builtins.int
    PROJECT_ID_FIELD_NUMBER: builtins.int
    WORKSPACE_ID_FIELD_NUMBER: builtins.int
    experiment_id: typing.Text
    @property
    def data(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Record]:
        """TODO: @yashbonde deprecate this"""
        pass
    @property
    def column_data(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___RecordColumn]:
        """this is the chart wise data"""
        pass
    log_type: global___RunLog.LogType.ValueType
    """type of data"""

    project_id: typing.Text
    """project id"""

    workspace_id: typing.Text
    """workspace id"""

    def __init__(self,
        *,
        experiment_id: typing.Text = ...,
        data: typing.Optional[typing.Iterable[global___Record]] = ...,
        column_data: typing.Optional[typing.Iterable[global___RecordColumn]] = ...,
        log_type: global___RunLog.LogType.ValueType = ...,
        project_id: typing.Text = ...,
        workspace_id: typing.Text = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["column_data",b"column_data","data",b"data","experiment_id",b"experiment_id","log_type",b"log_type","project_id",b"project_id","workspace_id",b"workspace_id"]) -> None: ...
global___RunLog = RunLog

class AgentDetails(google.protobuf.message.Message):
    """all the NBX-Infra details for this specific process"""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    class _NBX:
        ValueType = typing.NewType('ValueType', builtins.int)
        V: typing_extensions.TypeAlias = ValueType
    class _NBXEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[AgentDetails._NBX.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        JOB: AgentDetails._NBX.ValueType  # 0
        SERVING: AgentDetails._NBX.ValueType  # 1
    class NBX(_NBX, metaclass=_NBXEnumTypeWrapper):
        pass

    JOB: AgentDetails.NBX.ValueType  # 0
    SERVING: AgentDetails.NBX.ValueType  # 1

    WORKSPACE_ID_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    NBX_JOB_ID_FIELD_NUMBER: builtins.int
    NBX_SERVING_ID_FIELD_NUMBER: builtins.int
    NBX_RUN_ID_FIELD_NUMBER: builtins.int
    NBX_MODEL_ID_FIELD_NUMBER: builtins.int
    workspace_id: typing.Text
    type: global___AgentDetails.NBX.ValueType
    """this is the type of the agent, JOB or SERVING"""

    nbx_job_id: typing.Text
    """NBX-Jobs ID"""

    nbx_serving_id: typing.Text
    """deployment id"""

    nbx_run_id: typing.Text
    """JobRun"""

    nbx_model_id: typing.Text
    """model id"""

    def __init__(self,
        *,
        workspace_id: typing.Text = ...,
        type: global___AgentDetails.NBX.ValueType = ...,
        nbx_job_id: typing.Text = ...,
        nbx_serving_id: typing.Text = ...,
        nbx_run_id: typing.Text = ...,
        nbx_model_id: typing.Text = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["id",b"id","instance",b"instance","nbx_job_id",b"nbx_job_id","nbx_model_id",b"nbx_model_id","nbx_run_id",b"nbx_run_id","nbx_serving_id",b"nbx_serving_id"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["id",b"id","instance",b"instance","nbx_job_id",b"nbx_job_id","nbx_model_id",b"nbx_model_id","nbx_run_id",b"nbx_run_id","nbx_serving_id",b"nbx_serving_id","type",b"type","workspace_id",b"workspace_id"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["id",b"id"]) -> typing.Optional[typing_extensions.Literal["nbx_job_id","nbx_serving_id"]]: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["instance",b"instance"]) -> typing.Optional[typing_extensions.Literal["nbx_run_id","nbx_model_id"]]: ...
global___AgentDetails = AgentDetails

class InitRunRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    WORKSPACE_ID_FIELD_NUMBER: builtins.int
    PROJECT_ID_FIELD_NUMBER: builtins.int
    PROJECT_NAME_FIELD_NUMBER: builtins.int
    AGENT_DETAILS_FIELD_NUMBER: builtins.int
    CONFIG_FIELD_NUMBER: builtins.int
    workspace_id: typing.Text
    """when this is an experiment we will have project details"""

    project_id: typing.Text
    project_name: typing.Text
    @property
    def agent_details(self) -> global___AgentDetails: ...
    config: typing.Text
    """the jsonified singular config string"""

    def __init__(self,
        *,
        workspace_id: typing.Text = ...,
        project_id: typing.Text = ...,
        project_name: typing.Text = ...,
        agent_details: typing.Optional[global___AgentDetails] = ...,
        config: typing.Text = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["agent_details",b"agent_details"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["agent_details",b"agent_details","config",b"config","project_id",b"project_id","project_name",b"project_name","workspace_id",b"workspace_id"]) -> None: ...
global___InitRunRequest = InitRunRequest

class File(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    NAME_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    IS_INPUT_FIELD_NUMBER: builtins.int
    RELIC_KEY_FIELD_NUMBER: builtins.int
    name: typing.Text
    """the relative (to **job root**) filename of the File, final location is save_location/name"""

    created_at: builtins.int
    """when was this made"""

    is_input: builtins.bool
    """this was there when the run was created or this was created by the run as an output"""

    relic_key: typing.Text
    """RelicFile relic_file = 4; // this is the file when used with
    experiments/{project_name}/{experiment_id}/{relic_key}
    """

    def __init__(self,
        *,
        name: typing.Text = ...,
        created_at: builtins.int = ...,
        is_input: builtins.bool = ...,
        relic_key: typing.Text = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["created_at",b"created_at","is_input",b"is_input","name",b"name","relic_key",b"relic_key"]) -> None: ...
global___File = File

class FileList(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    EXPERIMENT_ID_FIELD_NUMBER: builtins.int
    FILES_FIELD_NUMBER: builtins.int
    experiment_id: typing.Text
    """associated run"""

    @property
    def files(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___File]:
        """all the Files"""
        pass
    def __init__(self,
        *,
        experiment_id: typing.Text = ...,
        files: typing.Optional[typing.Iterable[global___File]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["experiment_id",b"experiment_id","files",b"files"]) -> None: ...
global___FileList = FileList

class Run(google.protobuf.message.Message):
    """the Big Object"""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    class _Status:
        ValueType = typing.NewType('ValueType', builtins.int)
        V: typing_extensions.TypeAlias = ValueType
    class _StatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Run._Status.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        NOT_SET: Run._Status.ValueType  # 0
        """When created and added to DB but no further action taken"""

        RUNNING: Run._Status.ValueType  # 1
        """When the first on_log has been called"""

        COMPLETED: Run._Status.ValueType  # 2
        """When the on_train_end has been called"""

        FAILED: Run._Status.ValueType  # 3
        """When the NBX-Job failed"""

        DELETED: Run._Status.ValueType  # 4
        """When the run was deleted"""

    class Status(_Status, metaclass=_StatusEnumTypeWrapper):
        pass

    NOT_SET: Run.Status.ValueType  # 0
    """When created and added to DB but no further action taken"""

    RUNNING: Run.Status.ValueType  # 1
    """When the first on_log has been called"""

    COMPLETED: Run.Status.ValueType  # 2
    """When the on_train_end has been called"""

    FAILED: Run.Status.ValueType  # 3
    """When the NBX-Job failed"""

    DELETED: Run.Status.ValueType  # 4
    """When the run was deleted"""


    WORKSPACE_ID_FIELD_NUMBER: builtins.int
    PROJECT_ID_FIELD_NUMBER: builtins.int
    PROJECT_NAME_FIELD_NUMBER: builtins.int
    EXPERIMENT_ID_FIELD_NUMBER: builtins.int
    AGENT_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    UPDATED_AT_FIELD_NUMBER: builtins.int
    ENDED_AT_FIELD_NUMBER: builtins.int
    SAVE_LOCATION_FIELD_NUMBER: builtins.int
    FILE_LIST_FIELD_NUMBER: builtins.int
    CONFIG_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    UPDATE_KEYS_FIELD_NUMBER: builtins.int
    workspace_id: typing.Text
    """the workspace this run is part of"""

    project_id: typing.Text
    """the project this run is part of"""

    project_name: typing.Text
    """the project this run is part of"""

    experiment_id: typing.Text
    """the unique ID of this run from the MongoDB backend"""

    @property
    def agent(self) -> global___AgentDetails:
        """the agent details"""
        pass
    created_at: builtins.int
    """same as InitRunRequest.created_at"""

    updated_at: builtins.int
    """the last time this run was updated"""

    ended_at: builtins.int
    """when was run declared dead, the actual kill can be well before that"""

    save_location: typing.Text
    """this is the location where the Files from this run are stored"""

    @property
    def file_list(self) -> global___FileList:
        """all the Files from this run"""
        pass
    config: typing.Text
    """the jsonified config string"""

    status: global___Run.Status.ValueType
    """the last known status of this run"""

    @property
    def update_keys(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[typing.Text]:
        """now we create a special thing which will be populated and sent during updates"""
        pass
    def __init__(self,
        *,
        workspace_id: typing.Text = ...,
        project_id: typing.Text = ...,
        project_name: typing.Text = ...,
        experiment_id: typing.Text = ...,
        agent: typing.Optional[global___AgentDetails] = ...,
        created_at: builtins.int = ...,
        updated_at: builtins.int = ...,
        ended_at: builtins.int = ...,
        save_location: typing.Text = ...,
        file_list: typing.Optional[global___FileList] = ...,
        config: typing.Text = ...,
        status: global___Run.Status.ValueType = ...,
        update_keys: typing.Optional[typing.Iterable[typing.Text]] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["agent",b"agent","file_list",b"file_list"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["agent",b"agent","config",b"config","created_at",b"created_at","ended_at",b"ended_at","experiment_id",b"experiment_id","file_list",b"file_list","project_id",b"project_id","project_name",b"project_name","save_location",b"save_location","status",b"status","update_keys",b"update_keys","updated_at",b"updated_at","workspace_id",b"workspace_id"]) -> None: ...
global___Run = Run

class ListProjectsRequest(google.protobuf.message.Message):
    """
    Now we have the data structures for the user-client to get the data from the Konark.

    Request Reponse kind of thing
    $app/monitoring/
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    WORKSPACE_ID_FIELD_NUMBER: builtins.int
    PROJECT_ID_OR_NAME_FIELD_NUMBER: builtins.int
    PAGE_NO_FIELD_NUMBER: builtins.int
    workspace_id: typing.Text
    """the workspace this is part of"""

    project_id_or_name: typing.Text
    """used specifically for searching, if empty, it will return all the projects"""

    page_no: builtins.int
    def __init__(self,
        *,
        workspace_id: typing.Text = ...,
        project_id_or_name: typing.Text = ...,
        page_no: builtins.int = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["page_no",b"page_no","project_id_or_name",b"project_id_or_name","workspace_id",b"workspace_id"]) -> None: ...
global___ListProjectsRequest = ListProjectsRequest

class Project(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    WORKSPACE_ID_FIELD_NUMBER: builtins.int
    PROJECT_ID_FIELD_NUMBER: builtins.int
    PROJECT_NAME_FIELD_NUMBER: builtins.int
    TOTAL_RUNS_FIELD_NUMBER: builtins.int
    LOG_METRICS_FIELD_NUMBER: builtins.int
    CONFIG_METRICS_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    IS_DELETED_FIELD_NUMBER: builtins.int
    workspace_id: typing.Text
    """the workspace this is part of"""

    project_id: typing.Text
    """the unique ID for this project"""

    project_name: typing.Text
    """the usermodifiable name of the project"""

    total_runs: builtins.int
    """the total number of experiments in this project"""

    @property
    def log_metrics(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[typing.Text]:
        """the list of loggeed metrics in the project"""
        pass
    @property
    def config_metrics(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[typing.Text]:
        """the list of config metrics in the project"""
        pass
    created_at: builtins.int
    """the time when this project was created"""

    is_deleted: builtins.bool
    """if this project is deleted"""

    def __init__(self,
        *,
        workspace_id: typing.Text = ...,
        project_id: typing.Text = ...,
        project_name: typing.Text = ...,
        total_runs: builtins.int = ...,
        log_metrics: typing.Optional[typing.Iterable[typing.Text]] = ...,
        config_metrics: typing.Optional[typing.Iterable[typing.Text]] = ...,
        created_at: builtins.int = ...,
        is_deleted: builtins.bool = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["config_metrics",b"config_metrics","created_at",b"created_at","is_deleted",b"is_deleted","log_metrics",b"log_metrics","project_id",b"project_id","project_name",b"project_name","total_runs",b"total_runs","workspace_id",b"workspace_id"]) -> None: ...
global___Project = Project

class ListProjectsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    PROJECTS_FIELD_NUMBER: builtins.int
    TOTAL_PAGES_FIELD_NUMBER: builtins.int
    @property
    def projects(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Project]:
        """the list of projects in this workspace"""
        pass
    total_pages: builtins.int
    """the total number of pages"""

    def __init__(self,
        *,
        projects: typing.Optional[typing.Iterable[global___Project]] = ...,
        total_pages: builtins.int = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["projects",b"projects","total_pages",b"total_pages"]) -> None: ...
global___ListProjectsResponse = ListProjectsResponse

class ListRunsRequest(google.protobuf.message.Message):
    """$app/monitoring/gjj9dk30"""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    WORKSPACE_ID_FIELD_NUMBER: builtins.int
    PROJECT_ID_FIELD_NUMBER: builtins.int
    EXPERIMENT_ID_FIELD_NUMBER: builtins.int
    PAGE_NO_FIELD_NUMBER: builtins.int
    DESC_FIELD_NUMBER: builtins.int
    workspace_id: typing.Text
    """the workspace this is part of"""

    project_id: typing.Text
    """the unique ID for this project"""

    experiment_id: typing.Text
    """for searching"""

    page_no: builtins.int
    desc: builtins.bool
    def __init__(self,
        *,
        workspace_id: typing.Text = ...,
        project_id: typing.Text = ...,
        experiment_id: typing.Text = ...,
        page_no: builtins.int = ...,
        desc: builtins.bool = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["desc",b"desc","experiment_id",b"experiment_id","page_no",b"page_no","project_id",b"project_id","workspace_id",b"workspace_id"]) -> None: ...
global___ListRunsRequest = ListRunsRequest

class ListRunsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    EXPERIMENT_IDS_FIELD_NUMBER: builtins.int
    KEYS_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    TOTAL_PAGES_FIELD_NUMBER: builtins.int
    @property
    def experiment_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[typing.Text]:
        """the list of runs in this project"""
        pass
    @property
    def keys(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[typing.Text]:
        """the list of chart-keys for this run"""
        pass
    @property
    def created_at(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """time when these runs were created"""
        pass
    total_pages: builtins.int
    """the total number of pages"""

    def __init__(self,
        *,
        experiment_ids: typing.Optional[typing.Iterable[typing.Text]] = ...,
        keys: typing.Optional[typing.Iterable[typing.Text]] = ...,
        created_at: typing.Optional[typing.Iterable[builtins.int]] = ...,
        total_pages: builtins.int = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["created_at",b"created_at","experiment_ids",b"experiment_ids","keys",b"keys","total_pages",b"total_pages"]) -> None: ...
global___ListRunsResponse = ListRunsResponse

class RunLogRequest(google.protobuf.message.Message):
    """logs for $app/monitoring/gjj9dk30/experiment/cmk03kt03/"""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    WORKSPACE_ID_FIELD_NUMBER: builtins.int
    PROJECT_ID_FIELD_NUMBER: builtins.int
    EXPERIMENT_ID_FIELD_NUMBER: builtins.int
    KEY_FIELD_NUMBER: builtins.int
    START_AT_FIELD_NUMBER: builtins.int
    END_AT_FIELD_NUMBER: builtins.int
    workspace_id: typing.Text
    project_id: typing.Text
    experiment_id: typing.Text
    """the unique ID for this run"""

    key: typing.Text
    """the key to search for, if empty, it will return all the logs"""

    start_at: builtins.int
    """the start at, default is 0"""

    end_at: builtins.int
    """the end at, default is -1"""

    def __init__(self,
        *,
        workspace_id: typing.Text = ...,
        project_id: typing.Text = ...,
        experiment_id: typing.Text = ...,
        key: typing.Text = ...,
        start_at: builtins.int = ...,
        end_at: builtins.int = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["end_at",b"end_at","experiment_id",b"experiment_id","key",b"key","project_id",b"project_id","start_at",b"start_at","workspace_id",b"workspace_id"]) -> None: ...
global___RunLogRequest = RunLogRequest

class Acknowledge(google.protobuf.message.Message):
    """generic response to any message"""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    SUCCESS_FIELD_NUMBER: builtins.int
    MESSAGE_FIELD_NUMBER: builtins.int
    success: builtins.bool
    message: typing.Text
    """message can contain message or traceback if not success"""

    def __init__(self,
        *,
        success: builtins.bool = ...,
        message: typing.Text = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["message",b"message","success",b"success"]) -> None: ...
global___Acknowledge = Acknowledge

class GetExperimentTableRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    WORKSPACE_ID_FIELD_NUMBER: builtins.int
    PROJECT_ID_FIELD_NUMBER: builtins.int
    PAGE_NO_FIELD_NUMBER: builtins.int
    EXPERIMENT_ID_FIELD_NUMBER: builtins.int
    START_FIELD_NUMBER: builtins.int
    END_FIELD_NUMBER: builtins.int
    workspace_id: typing.Text
    project_id: typing.Text
    page_no: builtins.int
    experiment_id: typing.Text
    start: builtins.int
    """these two things will simply run the command => runs.experiment_ids[start:end]
    start: on this page start from here
    """

    end: builtins.int
    """end: on this page end till here"""

    def __init__(self,
        *,
        workspace_id: typing.Text = ...,
        project_id: typing.Text = ...,
        page_no: builtins.int = ...,
        experiment_id: typing.Text = ...,
        start: builtins.int = ...,
        end: builtins.int = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["end",b"end","experiment_id",b"experiment_id","page_no",b"page_no","project_id",b"project_id","start",b"start","workspace_id",b"workspace_id"]) -> None: ...
global___GetExperimentTableRequest = GetExperimentTableRequest

class ExperimentTable(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    class Row(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        EXPERIMENT_ID_FIELD_NUMBER: builtins.int
        DATA_FIELD_NUMBER: builtins.int
        experiment_id: typing.Text
        """each row in the table is an experiment and all the columns generated against that experiment"""

        @property
        def data(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___RecordColumn]:
            """here the len(data.rows) == 1"""
            pass
        def __init__(self,
            *,
            experiment_id: typing.Text = ...,
            data: typing.Optional[typing.Iterable[global___RecordColumn]] = ...,
            ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["data",b"data","experiment_id",b"experiment_id"]) -> None: ...

    TOTAL_PAGES_FIELD_NUMBER: builtins.int
    ROWS_FIELD_NUMBER: builtins.int
    total_pages: builtins.int
    """the big table object"""

    @property
    def rows(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ExperimentTable.Row]: ...
    def __init__(self,
        *,
        total_pages: builtins.int = ...,
        rows: typing.Optional[typing.Iterable[global___ExperimentTable.Row]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["rows",b"rows","total_pages",b"total_pages"]) -> None: ...
global___ExperimentTable = ExperimentTable

class Rule(google.protobuf.message.Message):
    """Alerting

    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    WORKSPACE_ID_FIELD_NUMBER: builtins.int
    PROJECT_ID_FIELD_NUMBER: builtins.int
    RULE_NAME_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    IS_DEACTIVATED_FIELD_NUMBER: builtins.int
    IS_DELETED_FIELD_NUMBER: builtins.int
    LOGIC_FIELD_NUMBER: builtins.int
    EMAIL_IDS_FIELD_NUMBER: builtins.int
    ALERT_MESSAGE_FIELD_NUMBER: builtins.int
    TRUE_COUNT_FIELD_NUMBER: builtins.int
    LOGIC_VERSION_FIELD_NUMBER: builtins.int
    MAX_RANGE_FIELD_NUMBER: builtins.int
    UPDATE_KEYS_FIELD_NUMBER: builtins.int
    workspace_id: typing.Text
    project_id: typing.Text
    rule_name: typing.Text
    created_at: builtins.int
    is_deactivated: builtins.bool
    is_deleted: builtins.bool
    logic: typing.Text
    """now we come to things around the logic and alerts themseleves
    the jsonified json_logic body
    """

    @property
    def email_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[typing.Text]:
        """the list of email ids to send the alert to"""
        pass
    alert_message: typing.Text
    """the message to send to the email ids"""

    true_count: builtins.int
    """this tells the number of times this rule has been broken"""

    logic_version: builtins.int
    """this tells the version number of the logic format that we are using, here's some
    details about them:
    0: the variables in functions have to be shifted by one
    1: the variables can be consume directly as they come
    """

    max_range: builtins.int
    """this is the number for maximum range from all the rules, this will be used to
    conviniently get the data from the tables
    """

    @property
    def update_keys(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[typing.Text]:
        """now we create a special thing which will be populated and sent during updates"""
        pass
    def __init__(self,
        *,
        workspace_id: typing.Text = ...,
        project_id: typing.Text = ...,
        rule_name: typing.Text = ...,
        created_at: builtins.int = ...,
        is_deactivated: builtins.bool = ...,
        is_deleted: builtins.bool = ...,
        logic: typing.Text = ...,
        email_ids: typing.Optional[typing.Iterable[typing.Text]] = ...,
        alert_message: typing.Text = ...,
        true_count: builtins.int = ...,
        logic_version: builtins.int = ...,
        max_range: builtins.int = ...,
        update_keys: typing.Optional[typing.Iterable[typing.Text]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["alert_message",b"alert_message","created_at",b"created_at","email_ids",b"email_ids","is_deactivated",b"is_deactivated","is_deleted",b"is_deleted","logic",b"logic","logic_version",b"logic_version","max_range",b"max_range","project_id",b"project_id","rule_name",b"rule_name","true_count",b"true_count","update_keys",b"update_keys","workspace_id",b"workspace_id"]) -> None: ...
global___Rule = Rule

class ListRules(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    WORKSPACE_ID_FIELD_NUMBER: builtins.int
    PROJECT_ID_FIELD_NUMBER: builtins.int
    PAGE_NO_FIELD_NUMBER: builtins.int
    TOTAL_PAGES_FIELD_NUMBER: builtins.int
    RULES_FIELD_NUMBER: builtins.int
    RULE_NAME_FIELD_NUMBER: builtins.int
    workspace_id: typing.Text
    project_id: typing.Text
    page_no: builtins.int
    total_pages: builtins.int
    @property
    def rules(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Rule]:
        """when sent to server, it will blindly update the rules and send it back"""
        pass
    rule_name: typing.Text
    """name of the rule if performing direct search"""

    def __init__(self,
        *,
        workspace_id: typing.Text = ...,
        project_id: typing.Text = ...,
        page_no: builtins.int = ...,
        total_pages: builtins.int = ...,
        rules: typing.Optional[typing.Iterable[global___Rule]] = ...,
        rule_name: typing.Text = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["page_no",b"page_no","project_id",b"project_id","rule_name",b"rule_name","rules",b"rules","total_pages",b"total_pages","workspace_id",b"workspace_id"]) -> None: ...
global___ListRules = ListRules

class RuleBuilder(google.protobuf.message.Message):
    """the purpose of this message is to help the FE in creating the UI"""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    class Op(google.protobuf.message.Message):
        """just like the ListRules message, the job of the server is to take the above two values
        and return the following fields populated, it will completely ignore the rest.
        """
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        SYMBOL_FIELD_NUMBER: builtins.int
        NAME_FIELD_NUMBER: builtins.int
        symbol: typing.Text
        """≠"""

        name: typing.Text
        """not equal"""

        def __init__(self,
            *,
            symbol: typing.Text = ...,
            name: typing.Text = ...,
            ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["name",b"name","symbol",b"symbol"]) -> None: ...

    class Fn(google.protobuf.message.Message):
        """list of functions that can be used in the logic, server side will tell what can done
        and what not. infact server side is the dumbest thing in the world, it will just blindly
        tell what is in the DB. So we can have immediate control vs. going through CI/CD.
        """
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        SYMBOL_FIELD_NUMBER: builtins.int
        NAME_FIELD_NUMBER: builtins.int
        FE_META_FIELD_NUMBER: builtins.int
        symbol: typing.Text
        """"avg" """

        name: typing.Text
        """"Average" """

        fe_meta: typing.Text
        """optional json-data for FE to use"""

        def __init__(self,
            *,
            symbol: typing.Text = ...,
            name: typing.Text = ...,
            fe_meta: typing.Text = ...,
            ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["fe_meta",b"fe_meta","name",b"name","symbol",b"symbol"]) -> None: ...

    WORKSPACE_ID_FIELD_NUMBER: builtins.int
    PROJECT_ID_FIELD_NUMBER: builtins.int
    METRICS_FIELD_NUMBER: builtins.int
    OPERATORS_FIELD_NUMBER: builtins.int
    FUNCTIONS_FIELD_NUMBER: builtins.int
    workspace_id: typing.Text
    project_id: typing.Text
    @property
    def metrics(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[typing.Text]:
        """the list of metrics"""
        pass
    @property
    def operators(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___RuleBuilder.Op]:
        """the list of operators"""
        pass
    @property
    def functions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___RuleBuilder.Fn]:
        """the list of functions"""
        pass
    def __init__(self,
        *,
        workspace_id: typing.Text = ...,
        project_id: typing.Text = ...,
        metrics: typing.Optional[typing.Iterable[typing.Text]] = ...,
        operators: typing.Optional[typing.Iterable[global___RuleBuilder.Op]] = ...,
        functions: typing.Optional[typing.Iterable[global___RuleBuilder.Fn]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["functions",b"functions","metrics",b"metrics","operators",b"operators","project_id",b"project_id","workspace_id",b"workspace_id"]) -> None: ...
global___RuleBuilder = RuleBuilder
