import tkinter as tk
from tkinter import ttk

def assets():
    """
    Opens a window displaying the current asset list and a help message.
    """
    # Create the main window
    root = tk.Tk()
    root.title("Asset Management")
    root.geometry("400x500")
    
    # Create header
    header = ttk.Label(root, text="Current Asset List", font=("Arial", 16, "bold"))
    header.pack(pady=20)
    
    # Create frame for assets
    asset_frame = ttk.Frame(root)
    asset_frame.pack(fill=tk.BOTH, expand=True, padx=20)
    
    # List of assets
    assets = ['Asset A', 'Asset B', 'Asset C', 'Asset D', 
              'Asset E', 'Asset F', 'Asset G', 'Asset H']
    
    # Add assets to frame
    for asset in assets:
        asset_label = ttk.Label(asset_frame, text=asset, font=("Arial", 12))
        asset_label.pack(anchor='w', pady=5)
    
    # Add help note
    note = ttk.Label(root, text="Need help in asset management?\nHelp is appreciated!", 
                     font=("Arial", 10, "italic"), justify=tk.CENTER)
    note.pack(pady=20)
    
    root.mainloop()