import tkinter as tk
from tkinter import ttk

def quantum():
    """
    Displays quantum-related information in a Tkinter window.
    """
    # Create the main window
    root = tk.Tk()
    root.title("Quantum Computing Fundamentals")
    root.geometry("500x600")
    
    # Create main frame
    main_frame = ttk.Frame(root)
    main_frame.pack(fill=tk.BOTH, expand=True, padx=20, pady=20)
    
    # Add title
    title = ttk.Label(main_frame, 
                      text="🌟 Quantum Computing Fundamentals 🌟",
                      font=("Arial", 16, "bold"))
    title.pack(pady=20)
    
    # Add introduction text
    intro_text = """In quantum computing, unlike classical bits that are either 0 or 1,
quantum bits (qubits) can exist in multiple states simultaneously
through superposition. This property, along with entanglement,
enables quantum computers to solve certain problems exponentially
faster than classical computers."""
    
    intro = ttk.Label(main_frame, text=intro_text, 
                      wraplength=400, justify=tk.CENTER,
                      font=("Arial", 11))
    intro.pack(pady=20)
    
    # Add key concepts
    concepts_frame = ttk.LabelFrame(main_frame, text="Key Concepts",
                                   padding=10)
    concepts_frame.pack(fill=tk.X, pady=20)
    
    concepts = [
        "• Superposition: Qubits can be in multiple states at once",
        "• Entanglement: Quantum states can be deeply connected",
        "• Quantum Gates: Basic building blocks of quantum circuits",
        "• Quantum Algorithms: Special algorithms for quantum computers"
    ]
    
    for concept in concepts:
        concept_label = ttk.Label(concepts_frame, text=concept,
                                 font=("Arial", 11))
        concept_label.pack(anchor='w', pady=5)
    
    # Add footer
    footer = ttk.Label(main_frame, 
                      text="The future of computing is quantum! 🚀",
                      font=("Arial", 12, "italic"))
    footer.pack(pady=20)
    
    root.mainloop()
