import tkinter as tk
from tkinter import ttk
import time

def swap():
    """
    Opens a window with an asset swapping game simulation.
    """
    # Create the main window
    root = tk.Tk()
    root.title("Asset Swap Game")
    root.geometry("600x800")
    
    # Default assets
    default_assets = [
        "Bitcoin: 50,000 USD",
        "Ethereum: 3,000 USD",
        "Tesla Stock: 200 shares",
        "Gold: 10 oz",
        "Real Estate: 1 property"
    ]
    
    # Variables to store user input
    selected_asset = tk.StringVar(value=default_assets[0])
    info_var = tk.StringVar()
    receiver_var = tk.StringVar()
    
    def animate_swap():
        # Get values
        asset = selected_asset.get()
        info = info_var.get()
        receiver = receiver_var.get()
        
        if not info or not receiver:
            status_label.config(text="Please fill in all fields!")
            return
            
        # Create animation frame
        animation_frame = ttk.Frame(main_frame)
        animation_frame.pack(pady=20)
        
        # Create labels for animation
        sender_label = ttk.Label(animation_frame, text=f"You\n{asset}", font=("Arial", 12))
        sender_label.grid(row=0, column=0, padx=20)
        
        asset_label = ttk.Label(animation_frame, text="→", font=("Arial", 20))
        asset_label.grid(row=0, column=1, padx=40)
        
        receiver_label = ttk.Label(animation_frame, text=f"{receiver}\n{asset}", font=("Arial", 12))
        receiver_label.grid(row=0, column=2, padx=20)
        
        # Animate
        for i in range(5):
            asset_label.config(text="→")
            root.update()
            time.sleep(0.2)
            asset_label.config(text="⇒")
            root.update()
            time.sleep(0.2)
        
        # Show success message
        status_label.config(text=f"Asset successfully swapped!\nTransaction Info: {info}")
        
        # Schedule animation frame removal
        root.after(3000, animation_frame.destroy)
    
    # Create main frame
    main_frame = ttk.Frame(root)
    main_frame.pack(fill=tk.BOTH, expand=True, padx=20, pady=20)
    
    # Title
    title = ttk.Label(main_frame, text="Asset Swap Game", font=("Arial", 18, "bold"))
    title.pack(pady=20)
    
    # Asset selection
    asset_frame = ttk.LabelFrame(main_frame, text="Select Asset", padding=10)
    asset_frame.pack(fill=tk.X, pady=10)
    
    asset_menu = ttk.OptionMenu(asset_frame, selected_asset, *default_assets)
    asset_menu.pack(fill=tk.X)
    
    # Info entry
    info_frame = ttk.LabelFrame(main_frame, text="Transaction Info", padding=10)
    info_frame.pack(fill=tk.X, pady=10)
    
    info_entry = ttk.Entry(info_frame, textvariable=info_var)
    info_entry.pack(fill=tk.X)
    
    # Receiver entry
    receiver_frame = ttk.LabelFrame(main_frame, text="Receiver Name", padding=10)
    receiver_frame.pack(fill=tk.X, pady=10)
    
    receiver_entry = ttk.Entry(receiver_frame, textvariable=receiver_var)
    receiver_entry.pack(fill=tk.X)
    
    # Swap button
    swap_button = ttk.Button(main_frame, text="Swap Asset", command=animate_swap)
    swap_button.pack(pady=20)
    
    # Status label
    status_label = ttk.Label(main_frame, text="", font=("Arial", 11))
    status_label.pack(pady=10)
    
    # Instructions
    instructions_frame = ttk.LabelFrame(main_frame, text="How to Play", padding=10)
    instructions_frame.pack(fill=tk.X, pady=20)
    
    instructions_text = """
1. Select an asset from the dropdown menu
2. Enter transaction information (e.g., "Trade #123", "Urgent swap")
3. Enter the receiver's name
4. Click 'Swap Asset' to see the animation

Default Values:
• Assets: Bitcoin, Ethereum, Tesla Stock, Gold, Real Estate
• Transaction Info: [Your custom message]
• Receiver: [Any name]
    """
    
    instructions = ttk.Label(instructions_frame, text=instructions_text,
                           justify=tk.LEFT, font=("Arial", 10))
    instructions.pack(fill=tk.X)
    
    root.mainloop()