"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SmsVoice = void 0;
const shared_1 = require("../shared");
/**
 * Statement provider for service [sms-voice](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonpinpointsmsandvoiceservice.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class SmsVoice extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [sms-voice](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonpinpointsmsandvoiceservice.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'sms-voice';
        this.actionList = {
            "CreateConfigurationSet": {
                "url": "https://docs.aws.amazon.com/pinpoint-sms-voice/latest/apireference/v1-sms-voice-configuration-sets.html",
                "description": "Create a new configuration set. After you create the configuration set, you can add one or more event destinations to it.",
                "accessLevel": "Write"
            },
            "CreateConfigurationSetEventDestination": {
                "url": "https://docs.aws.amazon.com/pinpoint-sms-voice/latest/apireference/v1-sms-voice-configuration-sets-configurationsetname-event-destinations.html",
                "description": "Create a new event destination in a configuration set.",
                "accessLevel": "Write"
            },
            "DeleteConfigurationSet": {
                "url": "https://docs.aws.amazon.com/pinpoint-sms-voice/latest/apireference/v1-sms-voice-configuration-sets-configurationsetname.html",
                "description": "Deletes an existing configuration set.",
                "accessLevel": "Write"
            },
            "DeleteConfigurationSetEventDestination": {
                "url": "https://docs.aws.amazon.com/pinpoint-sms-voice/latest/apireference/v1-sms-voice-configuration-sets-configurationsetname-event-destinations-eventdestinationname.html",
                "description": "Deletes an event destination in a configuration set.",
                "accessLevel": "Write"
            },
            "GetConfigurationSetEventDestinations": {
                "url": "https://docs.aws.amazon.com/pinpoint-sms-voice/latest/apireference/v1-sms-voice-configuration-sets-configurationsetname-event-destinations.html",
                "description": "Obtain information about an event destination, including the types of events it reports, the Amazon Resource Name (ARN) of the destination, and the name of the event destination.",
                "accessLevel": "Read"
            },
            "ListConfigurationSets": {
                "url": "https://docs.aws.amazon.com/pinpoint-sms-voice/latest/apireference/v1-sms-voice-configuration-sets.html",
                "description": "Return a list of configuration sets. This operation only returns the configuration sets that are associated with your account in the current AWS Region.",
                "accessLevel": "Read"
            },
            "SendVoiceMessage": {
                "url": "https://docs.aws.amazon.com/pinpoint-sms-voice/latest/apireference/v1-sms-voice-voice-message.html",
                "description": "Create a new voice message and send it to a recipient's phone number.",
                "accessLevel": "Write"
            },
            "UpdateConfigurationSetEventDestination": {
                "url": "https://docs.aws.amazon.com/pinpoint-sms-voice/latest/apireference/v1-sms-voice-configuration-sets-configurationsetname-event-destinations-eventdestinationname.html",
                "description": "Update an event destination in a configuration set. An event destination is a location that you publish information about your voice calls to. For example, you can log an event to an Amazon CloudWatch destination when a call fails.",
                "accessLevel": "Write"
            }
        };
        this.resourceTypes = {};
    }
    /**
     * Create a new configuration set. After you create the configuration set, you can add one or more event destinations to it.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice/latest/apireference/v1-sms-voice-configuration-sets.html
     */
    createConfigurationSet() {
        this.add('sms-voice:CreateConfigurationSet');
        return this;
    }
    /**
     * Create a new event destination in a configuration set.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice/latest/apireference/v1-sms-voice-configuration-sets-configurationsetname-event-destinations.html
     */
    createConfigurationSetEventDestination() {
        this.add('sms-voice:CreateConfigurationSetEventDestination');
        return this;
    }
    /**
     * Deletes an existing configuration set.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice/latest/apireference/v1-sms-voice-configuration-sets-configurationsetname.html
     */
    deleteConfigurationSet() {
        this.add('sms-voice:DeleteConfigurationSet');
        return this;
    }
    /**
     * Deletes an event destination in a configuration set.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice/latest/apireference/v1-sms-voice-configuration-sets-configurationsetname-event-destinations-eventdestinationname.html
     */
    deleteConfigurationSetEventDestination() {
        this.add('sms-voice:DeleteConfigurationSetEventDestination');
        return this;
    }
    /**
     * Obtain information about an event destination, including the types of events it reports, the Amazon Resource Name (ARN) of the destination, and the name of the event destination.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice/latest/apireference/v1-sms-voice-configuration-sets-configurationsetname-event-destinations.html
     */
    getConfigurationSetEventDestinations() {
        this.add('sms-voice:GetConfigurationSetEventDestinations');
        return this;
    }
    /**
     * Return a list of configuration sets. This operation only returns the configuration sets that are associated with your account in the current AWS Region.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice/latest/apireference/v1-sms-voice-configuration-sets.html
     */
    listConfigurationSets() {
        this.add('sms-voice:ListConfigurationSets');
        return this;
    }
    /**
     * Create a new voice message and send it to a recipient's phone number.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice/latest/apireference/v1-sms-voice-voice-message.html
     */
    sendVoiceMessage() {
        this.add('sms-voice:SendVoiceMessage');
        return this;
    }
    /**
     * Update an event destination in a configuration set. An event destination is a location that you publish information about your voice calls to. For example, you can log an event to an Amazon CloudWatch destination when a call fails.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice/latest/apireference/v1-sms-voice-configuration-sets-configurationsetname-event-destinations-eventdestinationname.html
     */
    updateConfigurationSetEventDestination() {
        this.add('sms-voice:UpdateConfigurationSetEventDestination');
        return this;
    }
}
exports.SmsVoice = SmsVoice;
//# sourceMappingURL=data:application/json;base64,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