"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Ssmmessages = void 0;
const shared_1 = require("../shared");
/**
 * Statement provider for service [ssmmessages](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonsessionmanagermessagegatewayservice.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Ssmmessages extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [ssmmessages](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonsessionmanagermessagegatewayservice.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'ssmmessages';
        this.actionList = {
            "CreateControlChannel": {
                "url": "",
                "description": "Registers a control channel for an instance to send control messages to Systems Manager service.",
                "accessLevel": "Write"
            },
            "CreateDataChannel": {
                "url": "",
                "description": "Registers a data channel for an instance to send data messages to Systems Manager service.",
                "accessLevel": "Write"
            },
            "OpenControlChannel": {
                "url": "",
                "description": "Opens a websocket connection for a registered control channel stream from an instance to Systems Manager service.",
                "accessLevel": "Write"
            },
            "OpenDataChannel": {
                "url": "",
                "description": "Opens a websocket connection for a registered data channel stream from an instance to Systems Manager service.",
                "accessLevel": "Write"
            }
        };
        this.resourceTypes = {};
    }
    /**
     * Registers a control channel for an instance to send control messages to Systems Manager service.
     *
     * Access Level: Write
     */
    createControlChannel() {
        this.add('ssmmessages:CreateControlChannel');
        return this;
    }
    /**
     * Registers a data channel for an instance to send data messages to Systems Manager service.
     *
     * Access Level: Write
     */
    createDataChannel() {
        this.add('ssmmessages:CreateDataChannel');
        return this;
    }
    /**
     * Opens a websocket connection for a registered control channel stream from an instance to Systems Manager service.
     *
     * Access Level: Write
     */
    openControlChannel() {
        this.add('ssmmessages:OpenControlChannel');
        return this;
    }
    /**
     * Opens a websocket connection for a registered data channel stream from an instance to Systems Manager service.
     *
     * Access Level: Write
     */
    openDataChannel() {
        this.add('ssmmessages:OpenDataChannel');
        return this;
    }
}
exports.Ssmmessages = Ssmmessages;
//# sourceMappingURL=data:application/json;base64,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