"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Transcribe = void 0;
const shared_1 = require("../shared");
/**
 * Statement provider for service [transcribe](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazontranscribe.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Transcribe extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [transcribe](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazontranscribe.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'transcribe';
        this.actionList = {
            "CreateMedicalVocabulary": {
                "url": "https://docs.aws.amazon.com/transcribe/latest/dg/API_CreateMedicalVocabulary.html",
                "description": "Grants permission to create a new custom vocabulary that you can use to change the way Amazon Transcribe Medical handles transcription of an audio file.",
                "accessLevel": "Write"
            },
            "CreateVocabulary": {
                "url": "https://docs.aws.amazon.com/transcribe/latest/dg/API_CreateVocabulary.html",
                "description": "Grants permission to create a new custom vocabulary that you can use to change the way Amazon Transcribe handles transcription of an audio file.",
                "accessLevel": "Write"
            },
            "CreateVocabularyFilter": {
                "url": "https://docs.aws.amazon.com/transcribe/latest/dg/API_CreateVocabularyFilter.html",
                "description": "Grants permission to create a new vocabulary filter that you can use to filter out words from the transcription of an audio file generated by Amazon Transcribe",
                "accessLevel": "Write"
            },
            "DeleteMedicalTranscriptionJob": {
                "url": "https://docs.aws.amazon.com/transcribe/latest/dg/API_DeleteMedicalTranscriptionJob.html",
                "description": "Grants permission to delete a previously submitted medical transcription job.",
                "accessLevel": "Write"
            },
            "DeleteMedicalVocabulary": {
                "url": "https://docs.aws.amazon.com/transcribe/latest/dg/API_DeleteMedicalVocabulary.html",
                "description": "Grants permission to delete a medical vocabulary from Amazon Transcribe.",
                "accessLevel": "Write"
            },
            "DeleteTranscriptionJob": {
                "url": "https://docs.aws.amazon.com/transcribe/latest/dg/API_DeleteTranscriptionJob.html",
                "description": "Grants permission to delete a previously submitted transcription job along with any other generated results such as the transcription, models, and so on.",
                "accessLevel": "Write"
            },
            "DeleteVocabulary": {
                "url": "https://docs.aws.amazon.com/transcribe/latest/dg/API_DeleteVocabulary.html",
                "description": "Grants permission to delete a vocabulary from Amazon Transcribe.",
                "accessLevel": "Write"
            },
            "DeleteVocabularyFilter": {
                "url": "https://docs.aws.amazon.com/transcribe/latest/dg/API_DeleteVocabularyFilter.html",
                "description": "Grants permission to delete a vocabulary filter from Amazon Transcribe.",
                "accessLevel": "Write"
            },
            "GetMedicalTranscriptionJob": {
                "url": "https://docs.aws.amazon.com/transcribe/latest/dg/API_GetMedicalTranscriptionJob.html",
                "description": "Grants permission to return information about a medical transcription job.",
                "accessLevel": "Read"
            },
            "GetMedicalVocabulary": {
                "url": "https://docs.aws.amazon.com/transcribe/latest/dg/API_GetMedicalVocabulary.html",
                "description": "Grants permission to get information about a medical vocabulary.",
                "accessLevel": "Read"
            },
            "GetTranscriptionJob": {
                "url": "https://docs.aws.amazon.com/transcribe/latest/dg/API_GetTranscriptionJob.html",
                "description": "Grants permission to return information about a transcription job.",
                "accessLevel": "Read"
            },
            "GetVocabulary": {
                "url": "https://docs.aws.amazon.com/transcribe/latest/dg/API_GetVocabulary.html",
                "description": "Grants permission to to get information about a vocabulary.",
                "accessLevel": "Read"
            },
            "GetVocabularyFilter": {
                "url": "https://docs.aws.amazon.com/transcribe/latest/dg/API_GetVocabularyFilter.html",
                "description": "Grants permission to get information about a vocabulary filter.",
                "accessLevel": "Read"
            },
            "ListMedicalTranscriptionJobs": {
                "url": "https://docs.aws.amazon.com/transcribe/latest/dg/API_ListMedicalTranscriptionJobs.html",
                "description": "Grants permission to list medical transcription jobs with the specified status.",
                "accessLevel": "List"
            },
            "ListMedicalVocabularies": {
                "url": "https://docs.aws.amazon.com/transcribe/latest/dg/API_ListMedicalVocabularies.html",
                "description": "Grants permission to return a list of medical vocabularies that match the specified criteria. If no criteria are specified, returns the entire list of vocabularies.",
                "accessLevel": "List"
            },
            "ListTranscriptionJobs": {
                "url": "https://docs.aws.amazon.com/transcribe/latest/dg/API_ListTranscriptionJobs.html",
                "description": "Grants permission to list transcription jobs with the specified status.",
                "accessLevel": "List"
            },
            "ListVocabularies": {
                "url": "https://docs.aws.amazon.com/transcribe/latest/dg/API_ListVocabularies.html",
                "description": "Grants permission to return a list of vocabularies that match the specified criteria. If no criteria are specified, returns the entire list of vocabularies.",
                "accessLevel": "List"
            },
            "ListVocabularyFilters": {
                "url": "https://docs.aws.amazon.com/transcribe/latest/dg/API_ListVocabularyFilters.html",
                "description": "Grants permission to return a list of vocabulary filters that match the specified criteria. If no criteria are specified, returns the at most 5 vocabulary filters.",
                "accessLevel": "List"
            },
            "StartMedicalStreamTranscription": {
                "url": "https://docs.aws.amazon.com/transcribe/latest/dg/API_streaming_StartMedicalStreamTranscription.html",
                "description": "Grants permission to start a protocol where audio is streamed to Transcribe Medical and the transcription results are streamed to your application.",
                "accessLevel": "Write"
            },
            "StartMedicalStreamTranscriptionWebSocket": {
                "url": "https://docs.aws.amazon.com/transcribe/latest/dg/API_streaming_StartMedicalStreamTranscriptionWebSocket.html",
                "description": "Grants permission to start a WebSocket where audio is streamed to Transcribe Medical and the transcription results are streamed to your application.",
                "accessLevel": "Write"
            },
            "StartMedicalTranscriptionJob": {
                "url": "https://docs.aws.amazon.com/transcribe/latest/dg/API_StartMedicalTranscriptionJob.html",
                "description": "Grants permission to start an asynchronous job to transcribe medical speech to text.",
                "accessLevel": "Write"
            },
            "StartStreamTranscription": {
                "url": "https://docs.aws.amazon.com/transcribe/latest/dg/API_streaming_StartStreamTranscription.html",
                "description": "Grants permission to start a bidirectional HTTP2 stream to transcribe speech to text in real time.",
                "accessLevel": "Write"
            },
            "StartStreamTranscriptionWebSocket": {
                "url": "https://docs.aws.amazon.com/transcribe/latest/dg/API_streaming_StartStreamTranscriptionWebSocket.html",
                "description": "Grants permission to start a websocket stream to transcribe speech to text in real time.",
                "accessLevel": "Write"
            },
            "StartTranscriptionJob": {
                "url": "https://docs.aws.amazon.com/transcribe/latest/dg/API_StartTranscriptionJob.html",
                "description": "Grants permission to start an asynchronous job to transcribe speech to text.",
                "accessLevel": "Write"
            },
            "UpdateMedicalVocabulary": {
                "url": "https://docs.aws.amazon.com/transcribe/latest/dg/API_UpdateMedicalVocabulary.html",
                "description": "Grants permission to update an existing medical vocabulary with new values. The UpdateMedicalVocabulary operation overwrites all of the existing information with the values that you provide in the request.",
                "accessLevel": "Write"
            },
            "UpdateVocabulary": {
                "url": "https://docs.aws.amazon.com/transcribe/latest/dg/API_UpdateVocabulary.html",
                "description": "Grants permission to update an existing vocabulary with new values. The UpdateVocabulary operation overwrites all of the existing information with the values that you provide in the request.",
                "accessLevel": "Write"
            },
            "UpdateVocabularyFilter": {
                "url": "https://docs.aws.amazon.com/transcribe/latest/dg/API_UpdateVocabularyFilter.html",
                "description": "Grants permission to update an existing vocabulary filter with new values. The UpdateVocabularyFilter operation overwrites all of the existing information with the values that you provide in the request.",
                "accessLevel": "Write"
            }
        };
        this.resourceTypes = {};
    }
    /**
     * Grants permission to create a new custom vocabulary that you can use to change the way Amazon Transcribe Medical handles transcription of an audio file.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_CreateMedicalVocabulary.html
     */
    createMedicalVocabulary() {
        this.add('transcribe:CreateMedicalVocabulary');
        return this;
    }
    /**
     * Grants permission to create a new custom vocabulary that you can use to change the way Amazon Transcribe handles transcription of an audio file.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_CreateVocabulary.html
     */
    createVocabulary() {
        this.add('transcribe:CreateVocabulary');
        return this;
    }
    /**
     * Grants permission to create a new vocabulary filter that you can use to filter out words from the transcription of an audio file generated by Amazon Transcribe
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_CreateVocabularyFilter.html
     */
    createVocabularyFilter() {
        this.add('transcribe:CreateVocabularyFilter');
        return this;
    }
    /**
     * Grants permission to delete a previously submitted medical transcription job.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_DeleteMedicalTranscriptionJob.html
     */
    deleteMedicalTranscriptionJob() {
        this.add('transcribe:DeleteMedicalTranscriptionJob');
        return this;
    }
    /**
     * Grants permission to delete a medical vocabulary from Amazon Transcribe.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_DeleteMedicalVocabulary.html
     */
    deleteMedicalVocabulary() {
        this.add('transcribe:DeleteMedicalVocabulary');
        return this;
    }
    /**
     * Grants permission to delete a previously submitted transcription job along with any other generated results such as the transcription, models, and so on.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_DeleteTranscriptionJob.html
     */
    deleteTranscriptionJob() {
        this.add('transcribe:DeleteTranscriptionJob');
        return this;
    }
    /**
     * Grants permission to delete a vocabulary from Amazon Transcribe.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_DeleteVocabulary.html
     */
    deleteVocabulary() {
        this.add('transcribe:DeleteVocabulary');
        return this;
    }
    /**
     * Grants permission to delete a vocabulary filter from Amazon Transcribe.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_DeleteVocabularyFilter.html
     */
    deleteVocabularyFilter() {
        this.add('transcribe:DeleteVocabularyFilter');
        return this;
    }
    /**
     * Grants permission to return information about a medical transcription job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_GetMedicalTranscriptionJob.html
     */
    getMedicalTranscriptionJob() {
        this.add('transcribe:GetMedicalTranscriptionJob');
        return this;
    }
    /**
     * Grants permission to get information about a medical vocabulary.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_GetMedicalVocabulary.html
     */
    getMedicalVocabulary() {
        this.add('transcribe:GetMedicalVocabulary');
        return this;
    }
    /**
     * Grants permission to return information about a transcription job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_GetTranscriptionJob.html
     */
    getTranscriptionJob() {
        this.add('transcribe:GetTranscriptionJob');
        return this;
    }
    /**
     * Grants permission to to get information about a vocabulary.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_GetVocabulary.html
     */
    getVocabulary() {
        this.add('transcribe:GetVocabulary');
        return this;
    }
    /**
     * Grants permission to get information about a vocabulary filter.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_GetVocabularyFilter.html
     */
    getVocabularyFilter() {
        this.add('transcribe:GetVocabularyFilter');
        return this;
    }
    /**
     * Grants permission to list medical transcription jobs with the specified status.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_ListMedicalTranscriptionJobs.html
     */
    listMedicalTranscriptionJobs() {
        this.add('transcribe:ListMedicalTranscriptionJobs');
        return this;
    }
    /**
     * Grants permission to return a list of medical vocabularies that match the specified criteria. If no criteria are specified, returns the entire list of vocabularies.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_ListMedicalVocabularies.html
     */
    listMedicalVocabularies() {
        this.add('transcribe:ListMedicalVocabularies');
        return this;
    }
    /**
     * Grants permission to list transcription jobs with the specified status.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_ListTranscriptionJobs.html
     */
    listTranscriptionJobs() {
        this.add('transcribe:ListTranscriptionJobs');
        return this;
    }
    /**
     * Grants permission to return a list of vocabularies that match the specified criteria. If no criteria are specified, returns the entire list of vocabularies.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_ListVocabularies.html
     */
    listVocabularies() {
        this.add('transcribe:ListVocabularies');
        return this;
    }
    /**
     * Grants permission to return a list of vocabulary filters that match the specified criteria. If no criteria are specified, returns the at most 5 vocabulary filters.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_ListVocabularyFilters.html
     */
    listVocabularyFilters() {
        this.add('transcribe:ListVocabularyFilters');
        return this;
    }
    /**
     * Grants permission to start a protocol where audio is streamed to Transcribe Medical and the transcription results are streamed to your application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_streaming_StartMedicalStreamTranscription.html
     */
    startMedicalStreamTranscription() {
        this.add('transcribe:StartMedicalStreamTranscription');
        return this;
    }
    /**
     * Grants permission to start a WebSocket where audio is streamed to Transcribe Medical and the transcription results are streamed to your application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_streaming_StartMedicalStreamTranscriptionWebSocket.html
     */
    startMedicalStreamTranscriptionWebSocket() {
        this.add('transcribe:StartMedicalStreamTranscriptionWebSocket');
        return this;
    }
    /**
     * Grants permission to start an asynchronous job to transcribe medical speech to text.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_StartMedicalTranscriptionJob.html
     */
    startMedicalTranscriptionJob() {
        this.add('transcribe:StartMedicalTranscriptionJob');
        return this;
    }
    /**
     * Grants permission to start a bidirectional HTTP2 stream to transcribe speech to text in real time.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_streaming_StartStreamTranscription.html
     */
    startStreamTranscription() {
        this.add('transcribe:StartStreamTranscription');
        return this;
    }
    /**
     * Grants permission to start a websocket stream to transcribe speech to text in real time.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_streaming_StartStreamTranscriptionWebSocket.html
     */
    startStreamTranscriptionWebSocket() {
        this.add('transcribe:StartStreamTranscriptionWebSocket');
        return this;
    }
    /**
     * Grants permission to start an asynchronous job to transcribe speech to text.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_StartTranscriptionJob.html
     */
    startTranscriptionJob() {
        this.add('transcribe:StartTranscriptionJob');
        return this;
    }
    /**
     * Grants permission to update an existing medical vocabulary with new values. The UpdateMedicalVocabulary operation overwrites all of the existing information with the values that you provide in the request.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_UpdateMedicalVocabulary.html
     */
    updateMedicalVocabulary() {
        this.add('transcribe:UpdateMedicalVocabulary');
        return this;
    }
    /**
     * Grants permission to update an existing vocabulary with new values. The UpdateVocabulary operation overwrites all of the existing information with the values that you provide in the request.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_UpdateVocabulary.html
     */
    updateVocabulary() {
        this.add('transcribe:UpdateVocabulary');
        return this;
    }
    /**
     * Grants permission to update an existing vocabulary filter with new values. The UpdateVocabularyFilter operation overwrites all of the existing information with the values that you provide in the request.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_UpdateVocabularyFilter.html
     */
    updateVocabularyFilter() {
        this.add('transcribe:UpdateVocabularyFilter');
        return this;
    }
}
exports.Transcribe = Transcribe;
//# sourceMappingURL=data:application/json;base64,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