"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Translate = void 0;
const shared_1 = require("../shared");
/**
 * Statement provider for service [translate](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazontranslate.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Translate extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [translate](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazontranslate.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'translate';
        this.actionList = {
            "DeleteTerminology": {
                "url": "https://docs.aws.amazon.com/translate/latest/dg/API_DeleteTerminology.html",
                "description": "A synchronous action that deletes a custom terminology.",
                "accessLevel": "Write"
            },
            "DescribeTextTranslationJob": {
                "url": "https://docs.aws.amazon.com/translate/latest/dg/API_DescribeTextTranslationJob.html",
                "description": "Gets the properties associated with an asynchronous batch translation job including name, ID, status, source and target languages, input/output S3 buckets, and so on.",
                "accessLevel": "Read"
            },
            "GetTerminology": {
                "url": "https://docs.aws.amazon.com/translate/latest/dg/API_GetTerminology.html",
                "description": "Retrieves a custom terminology.",
                "accessLevel": "Read"
            },
            "ImportTerminology": {
                "url": "https://docs.aws.amazon.com/translate/latest/dg/API_ImportTerminology.html",
                "description": "Creates or updates a custom terminology, depending on whether or not one already exists for the given terminology name.",
                "accessLevel": "Write"
            },
            "ListTerminologies": {
                "url": "https://docs.aws.amazon.com/translate/latest/dg/API_ListTerminologies.html",
                "description": "Provides a list of custom terminologies associated with your account.",
                "accessLevel": "Read"
            },
            "ListTextTranslationJobs": {
                "url": "https://docs.aws.amazon.com/translate/latest/dg/API_ListTextTranslationJobs.html",
                "description": "Gets a list of the batch translation jobs that you have submitted.",
                "accessLevel": "Read"
            },
            "StartTextTranslationJob": {
                "url": "https://docs.aws.amazon.com/translate/latest/dg/API_StartTextTranslationJob.html",
                "description": "Starts an asynchronous batch translation job. Batch translation jobs can be used to translate large volumes of text across multiple documents at once.",
                "accessLevel": "Write"
            },
            "StopTextTranslationJob": {
                "url": "https://docs.aws.amazon.com/translate/latest/dg/API_StopTextTranslationJob.html",
                "description": "Stops an asynchronous batch translation job that is in progress.",
                "accessLevel": "Write"
            },
            "TranslateText": {
                "url": "https://docs.aws.amazon.com/translate/latest/dg/API_TranslateText.html",
                "description": "Translate text from a source language to a target language.",
                "accessLevel": "Read"
            }
        };
        this.resourceTypes = {};
    }
    /**
     * A synchronous action that deletes a custom terminology.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_DeleteTerminology.html
     */
    deleteTerminology() {
        this.add('translate:DeleteTerminology');
        return this;
    }
    /**
     * Gets the properties associated with an asynchronous batch translation job including name, ID, status, source and target languages, input/output S3 buckets, and so on.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_DescribeTextTranslationJob.html
     */
    describeTextTranslationJob() {
        this.add('translate:DescribeTextTranslationJob');
        return this;
    }
    /**
     * Retrieves a custom terminology.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_GetTerminology.html
     */
    getTerminology() {
        this.add('translate:GetTerminology');
        return this;
    }
    /**
     * Creates or updates a custom terminology, depending on whether or not one already exists for the given terminology name.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_ImportTerminology.html
     */
    importTerminology() {
        this.add('translate:ImportTerminology');
        return this;
    }
    /**
     * Provides a list of custom terminologies associated with your account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_ListTerminologies.html
     */
    listTerminologies() {
        this.add('translate:ListTerminologies');
        return this;
    }
    /**
     * Gets a list of the batch translation jobs that you have submitted.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_ListTextTranslationJobs.html
     */
    listTextTranslationJobs() {
        this.add('translate:ListTextTranslationJobs');
        return this;
    }
    /**
     * Starts an asynchronous batch translation job. Batch translation jobs can be used to translate large volumes of text across multiple documents at once.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_StartTextTranslationJob.html
     */
    startTextTranslationJob() {
        this.add('translate:StartTextTranslationJob');
        return this;
    }
    /**
     * Stops an asynchronous batch translation job that is in progress.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_StopTextTranslationJob.html
     */
    stopTextTranslationJob() {
        this.add('translate:StopTextTranslationJob');
        return this;
    }
    /**
     * Translate text from a source language to a target language.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_TranslateText.html
     */
    translateText() {
        this.add('translate:TranslateText');
        return this;
    }
}
exports.Translate = Translate;
//# sourceMappingURL=data:application/json;base64,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