"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AutoscalingPlans = void 0;
const shared_1 = require("../shared");
/**
 * Statement provider for service [autoscaling-plans](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awsautoscaling.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class AutoscalingPlans extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [autoscaling-plans](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awsautoscaling.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'autoscaling-plans';
        this.actionList = {
            "CreateScalingPlan": {
                "url": "https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_CreateScalingPlan.html",
                "description": "Creates a scaling plan.",
                "accessLevel": "Write"
            },
            "DeleteScalingPlan": {
                "url": "https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_DeleteScalingPlan.html",
                "description": "Deletes the specified scaling plan.",
                "accessLevel": "Write"
            },
            "DescribeScalingPlanResources": {
                "url": "https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_DescribeScalingPlanResources.html",
                "description": "Describes the scalable resources in the specified scaling plan.",
                "accessLevel": "Read"
            },
            "DescribeScalingPlans": {
                "url": "https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_DescribeScalingPlans.html",
                "description": "Describes the specified scaling plans or all of your scaling plans.",
                "accessLevel": "Read"
            },
            "GetScalingPlanResourceForecastData": {
                "url": "https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_GetScalingPlanResourceForecastData.html",
                "description": "Retrieves the forecast data for a scalable resource.",
                "accessLevel": "Read"
            },
            "UpdateScalingPlan": {
                "url": "https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_UpdateScalingPlan.html",
                "description": "Updates a scaling plan.",
                "accessLevel": "Write"
            }
        };
        this.resourceTypes = {};
    }
    /**
     * Creates a scaling plan.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_CreateScalingPlan.html
     */
    createScalingPlan() {
        this.add('autoscaling-plans:CreateScalingPlan');
        return this;
    }
    /**
     * Deletes the specified scaling plan.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_DeleteScalingPlan.html
     */
    deleteScalingPlan() {
        this.add('autoscaling-plans:DeleteScalingPlan');
        return this;
    }
    /**
     * Describes the scalable resources in the specified scaling plan.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_DescribeScalingPlanResources.html
     */
    describeScalingPlanResources() {
        this.add('autoscaling-plans:DescribeScalingPlanResources');
        return this;
    }
    /**
     * Describes the specified scaling plans or all of your scaling plans.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_DescribeScalingPlans.html
     */
    describeScalingPlans() {
        this.add('autoscaling-plans:DescribeScalingPlans');
        return this;
    }
    /**
     * Retrieves the forecast data for a scalable resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_GetScalingPlanResourceForecastData.html
     */
    getScalingPlanResourceForecastData() {
        this.add('autoscaling-plans:GetScalingPlanResourceForecastData');
        return this;
    }
    /**
     * Updates a scaling plan.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_UpdateScalingPlan.html
     */
    updateScalingPlan() {
        this.add('autoscaling-plans:UpdateScalingPlan');
        return this;
    }
}
exports.AutoscalingPlans = AutoscalingPlans;
//# sourceMappingURL=data:application/json;base64,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