import { Actions, PolicyStatement, ResourceTypes } from "../shared";
/**
 * Statement provider for service [iotthingsgraph](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awsiotthingsgraph.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Iotthingsgraph extends PolicyStatement {
    servicePrefix: string;
    protected actionList: Actions;
    resourceTypes: ResourceTypes;
    /**
     * Statement provider for service [iotthingsgraph](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awsiotthingsgraph.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Associates a device with a concrete thing that is in the user's registry. A thing can be associated with only one device at a time. If you associate a thing with a new device id, its previous association will be removed.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_AssociateEntityToThing.html
     */
    associateEntityToThing(): this;
    /**
     * Creates a workflow template. Workflows can be created only in the user's namespace. (The public namespace contains only entities.) The workflow can contain only entities in the specified namespace. The workflow is validated against the entities in the latest version of the user's namespace unless another namespace version is specified in the request.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_CreateFlowTemplate.html
     */
    createFlowTemplate(): this;
    /**
     * Creates an instance of a system with specified configurations and Things.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_CreateSystemInstance.html
     */
    createSystemInstance(): this;
    /**
     * Creates a system. The system is validated against the entities in the latest version of the user's namespace unless another namespace version is specified in the request.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_CreateSystemTemplate.html
     */
    createSystemTemplate(): this;
    /**
     * Deletes a workflow. Any new system or system instance that contains this workflow will fail to update or deploy. Existing system instances that contain the workflow will continue to run (since they use a snapshot of the workflow taken at the time of deploying the system instance).
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_DeleteFlowTemplate.html
     */
    deleteFlowTemplate(): this;
    /**
     * Deletes the specified namespace. This action deletes all of the entities in the namespace. Delete the systems and flows in the namespace before performing this action.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_DeleteNamespace.html
     */
    deleteNamespace(): this;
    /**
     * Deletes a system instance. Only instances that have never been deployed, or that have been undeployed from the target can be deleted. Users can create a new system instance that has the same ID as a deleted system instance.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_DeleteSystemInstance.html
     */
    deleteSystemInstance(): this;
    /**
     * Deletes a system. New system instances can't contain the system after its deletion. Existing system instances that contain the system will continue to work because they use a snapshot of the system that is taken when it is deployed.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_DeleteSystemTemplate.html
     */
    deleteSystemTemplate(): this;
    /**
     * Deploys the system instance to the target specified in CreateSystemInstance.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_DeploySystemInstance.html
     */
    deploySystemInstance(): this;
    /**
     * Deprecates the specified workflow. This action marks the workflow for deletion. Deprecated flows can't be deployed, but existing system instances that use the flow will continue to run.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_DeprecateFlowTemplate.html
     */
    deprecateFlowTemplate(): this;
    /**
     * Deprecates the specified system.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_DeprecateSystemTemplate.html
     */
    deprecateSystemTemplate(): this;
    /**
     * Gets the latest version of the user's namespace and the public version that it is tracking.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_DescribeNamespace.html
     */
    describeNamespace(): this;
    /**
     * Dissociates a device entity from a concrete thing. The action takes only the type of the entity that you need to dissociate because only one entity of a particular type can be associated with a thing.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_DissociateEntityFromThing.html
     */
    dissociateEntityFromThing(): this;
    /**
     * Gets descriptions of the specified entities. Uses the latest version of the user's namespace by default.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_GetEntities.html
     */
    getEntities(): this;
    /**
     * Gets the latest version of the DefinitionDocument and FlowTemplateSummary for the specified workflow.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_GetFlowTemplate.html
     */
    getFlowTemplate(): this;
    /**
     * Gets revisions of the specified workflow. Only the last 100 revisions are stored. If the workflow has been deprecated, this action will return revisions that occurred before the deprecation. This action won't work for workflows that have been deleted.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_GetFlowTemplateRevisions.html
     */
    getFlowTemplateRevisions(): this;
    /**
     * Gets the status of a namespace deletion task.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_GetNamespaceDeletionStatus.html
     */
    getNamespaceDeletionStatus(): this;
    /**
     * Gets a system instance.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_GetSystemInstance.html
     */
    getSystemInstance(): this;
    /**
     * Gets a system.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_GetSystemTemplate.html
     */
    getSystemTemplate(): this;
    /**
     * Gets revisions made to the specified system template. Only the previous 100 revisions are stored. If the system has been deprecated, this action will return the revisions that occurred before its deprecation. This action won't work with systems that have been deleted.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_GetSystemTemplateRevisions.html
     */
    getSystemTemplateRevisions(): this;
    /**
     * Gets the status of the specified upload.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_GetUploadStatus.html
     */
    getUploadStatus(): this;
    /**
     * Lists details of a single workflow execution
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_ListFlowExecutionMessages.html
     */
    listFlowExecutionMessages(): this;
    /**
     * Lists all tags for a given resource
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_ListTagsForResource.html
     */
    listTagsForResource(): this;
    /**
     * Searches for entities of the specified type. You can search for entities in your namespace and the public namespace that you're tracking.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_SearchEntities.html
     */
    searchEntities(): this;
    /**
     * Searches for workflow executions of a system instance
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_SearchFlowExecutions.html
     */
    searchFlowExecutions(): this;
    /**
     * Searches for summary information about workflows.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_SearchFlowTemplates.html
     */
    searchFlowTemplates(): this;
    /**
     * Searches for system instances in the user's account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_SearchSystemInstances.html
     */
    searchSystemInstances(): this;
    /**
     * Searches for summary information about systems in the user's account. You can filter by the ID of a workflow to return only systems that use the specified workflow.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_SearchSystemTemplates.html
     */
    searchSystemTemplates(): this;
    /**
     * Searches for things associated with the specified entity. You can search by both device and device model.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_SearchThings.html
     */
    searchThings(): this;
    /**
     * Tag a specified resource
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_TagResource.html
     */
    tagResource(): this;
    /**
     * Removes the system instance and associated triggers from the target.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_UndeploySystemInstance.html
     */
    undeploySystemInstance(): this;
    /**
     * Untag a specified resource
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_UntagResource.html
     */
    untagResource(): this;
    /**
     * Updates the specified workflow. All deployed systems and system instances that use the workflow will see the changes in the flow when it is redeployed. The workflow can contain only entities in the specified namespace.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_UpdateFlowTemplate.html
     */
    updateFlowTemplate(): this;
    /**
     * Updates the specified system. You don't need to run this action after updating a workflow. Any system instance that uses the system will see the changes in the system when it is redeployed.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_UpdateSystemTemplate.html
     */
    updateSystemTemplate(): this;
    /**
     * Asynchronously uploads one or more entity definitions to the user's namespace.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_UploadEntityDefinitions.html
     */
    uploadEntityDefinitions(): this;
    /**
     * Adds a resource of type Workflow to the statement
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/ug/iot-tg-models-tdm-iot-workflow.html
     *
     * @param namespacePath - Identifier for the namespacePath.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onWorkflow(namespacePath: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type System to the statement
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/ug/iot-tg-models-tdm-iot-system.html
     *
     * @param namespacePath - Identifier for the namespacePath.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onSystem(namespacePath: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type SystemInstance to the statement
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/ug/iot-tg-models-tdm-iot-sdc-deployconfig.html
     *
     * @param namespacePath - Identifier for the namespacePath.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible condition keys:
     *  - aws:ResourceTag/${TagKey}
     */
    onSystemInstance(namespacePath: string, account?: string, region?: string, partition?: string): this;
}
