"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Lakeformation = void 0;
const shared_1 = require("../shared");
/**
 * Statement provider for service [lakeformation](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awslakeformation.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Lakeformation extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [lakeformation](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awslakeformation.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'lakeformation';
        this.actionList = {
            "BatchGrantPermissions": {
                "url": "https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api.html",
                "description": "Grants data lake permissions to one or more principals in a batch.",
                "accessLevel": "Permissions management"
            },
            "BatchRevokePermissions": {
                "url": "https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api.html",
                "description": "Revokes data lake permissions from one or more principals in a batch.",
                "accessLevel": "Permissions management"
            },
            "DeregisterResource": {
                "url": "https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api.html",
                "description": "Deregisters a registered location.",
                "accessLevel": "Write"
            },
            "DescribeResource": {
                "url": "https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api.html",
                "description": "Describes a registered location.",
                "accessLevel": "Read"
            },
            "GetDataAccess": {
                "url": "https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api.html",
                "description": "Grants virtual data lake access permissions.",
                "accessLevel": "Write"
            },
            "GetDataLakeSettings": {
                "url": "https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api.html",
                "description": "Retrieves data lake settings such as the list of data lake administrators and database and table default permissions.",
                "accessLevel": "Read"
            },
            "GetEffectivePermissionsForPath": {
                "url": "https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api.html",
                "description": "Retrieves permissions attached to resources in the given path.",
                "accessLevel": "Read"
            },
            "GrantPermissions": {
                "url": "https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api.html",
                "description": "Grants data lake permissions to a principal.",
                "accessLevel": "Permissions management"
            },
            "ListPermissions": {
                "url": "https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api.html",
                "description": "Lists permissions filtered by principal or resource.",
                "accessLevel": "List"
            },
            "ListResources": {
                "url": "https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api.html",
                "description": "Lists registered locations.",
                "accessLevel": "List"
            },
            "PutDataLakeSettings": {
                "url": "https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api.html",
                "description": "Overwrites data lake settings such as the list of data lake administrators and database and table default permissions.",
                "accessLevel": "Permissions management"
            },
            "RegisterResource": {
                "url": "https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api.html",
                "description": "Registers a new location to be managed by Lake Formation.",
                "accessLevel": "Write"
            },
            "RevokePermissions": {
                "url": "https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api.html",
                "description": "Revokes data lake permissions from a principal.",
                "accessLevel": "Permissions management"
            },
            "UpdateResource": {
                "url": "https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api.html",
                "description": "Updates a registered location.",
                "accessLevel": "Write"
            }
        };
        this.resourceTypes = {};
    }
    /**
     * Grants data lake permissions to one or more principals in a batch.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api.html
     */
    batchGrantPermissions() {
        this.add('lakeformation:BatchGrantPermissions');
        return this;
    }
    /**
     * Revokes data lake permissions from one or more principals in a batch.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api.html
     */
    batchRevokePermissions() {
        this.add('lakeformation:BatchRevokePermissions');
        return this;
    }
    /**
     * Deregisters a registered location.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api.html
     */
    deregisterResource() {
        this.add('lakeformation:DeregisterResource');
        return this;
    }
    /**
     * Describes a registered location.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api.html
     */
    describeResource() {
        this.add('lakeformation:DescribeResource');
        return this;
    }
    /**
     * Grants virtual data lake access permissions.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api.html
     */
    getDataAccess() {
        this.add('lakeformation:GetDataAccess');
        return this;
    }
    /**
     * Retrieves data lake settings such as the list of data lake administrators and database and table default permissions.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api.html
     */
    getDataLakeSettings() {
        this.add('lakeformation:GetDataLakeSettings');
        return this;
    }
    /**
     * Retrieves permissions attached to resources in the given path.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api.html
     */
    getEffectivePermissionsForPath() {
        this.add('lakeformation:GetEffectivePermissionsForPath');
        return this;
    }
    /**
     * Grants data lake permissions to a principal.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api.html
     */
    grantPermissions() {
        this.add('lakeformation:GrantPermissions');
        return this;
    }
    /**
     * Lists permissions filtered by principal or resource.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api.html
     */
    listPermissions() {
        this.add('lakeformation:ListPermissions');
        return this;
    }
    /**
     * Lists registered locations.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api.html
     */
    listResources() {
        this.add('lakeformation:ListResources');
        return this;
    }
    /**
     * Overwrites data lake settings such as the list of data lake administrators and database and table default permissions.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api.html
     */
    putDataLakeSettings() {
        this.add('lakeformation:PutDataLakeSettings');
        return this;
    }
    /**
     * Registers a new location to be managed by Lake Formation.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api.html
     */
    registerResource() {
        this.add('lakeformation:RegisterResource');
        return this;
    }
    /**
     * Revokes data lake permissions from a principal.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api.html
     */
    revokePermissions() {
        this.add('lakeformation:RevokePermissions');
        return this;
    }
    /**
     * Updates a registered location.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api.html
     */
    updateResource() {
        this.add('lakeformation:UpdateResource');
        return this;
    }
}
exports.Lakeformation = Lakeformation;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXdzbGFrZWZvcm1hdGlvbi5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImF3c2xha2Vmb3JtYXRpb24udHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEsc0NBQW9FO0FBRXBFOzs7O0dBSUc7QUFDSCxNQUFhLGFBQWMsU0FBUSx3QkFBZTtJQTRFaEQ7Ozs7T0FJRztJQUNILFlBQWEsR0FBWTtRQUN2QixLQUFLLENBQUMsR0FBRyxDQUFDLENBQUM7UUFqRk4sa0JBQWEsR0FBRyxlQUFlLENBQUM7UUFDN0IsZUFBVSxHQUFZO1lBQzlCLHVCQUF1QixFQUFFO2dCQUN2QixLQUFLLEVBQUUsa0ZBQWtGO2dCQUN6RixhQUFhLEVBQUUsb0VBQW9FO2dCQUNuRixhQUFhLEVBQUUsd0JBQXdCO2FBQ3hDO1lBQ0Qsd0JBQXdCLEVBQUU7Z0JBQ3hCLEtBQUssRUFBRSxrRkFBa0Y7Z0JBQ3pGLGFBQWEsRUFBRSx1RUFBdUU7Z0JBQ3RGLGFBQWEsRUFBRSx3QkFBd0I7YUFDeEM7WUFDRCxvQkFBb0IsRUFBRTtnQkFDcEIsS0FBSyxFQUFFLGtGQUFrRjtnQkFDekYsYUFBYSxFQUFFLG9DQUFvQztnQkFDbkQsYUFBYSxFQUFFLE9BQU87YUFDdkI7WUFDRCxrQkFBa0IsRUFBRTtnQkFDbEIsS0FBSyxFQUFFLGtGQUFrRjtnQkFDekYsYUFBYSxFQUFFLGtDQUFrQztnQkFDakQsYUFBYSxFQUFFLE1BQU07YUFDdEI7WUFDRCxlQUFlLEVBQUU7Z0JBQ2YsS0FBSyxFQUFFLGtGQUFrRjtnQkFDekYsYUFBYSxFQUFFLDhDQUE4QztnQkFDN0QsYUFBYSxFQUFFLE9BQU87YUFDdkI7WUFDRCxxQkFBcUIsRUFBRTtnQkFDckIsS0FBSyxFQUFFLGtGQUFrRjtnQkFDekYsYUFBYSxFQUFFLHVIQUF1SDtnQkFDdEksYUFBYSxFQUFFLE1BQU07YUFDdEI7WUFDRCxnQ0FBZ0MsRUFBRTtnQkFDaEMsS0FBSyxFQUFFLGtGQUFrRjtnQkFDekYsYUFBYSxFQUFFLGdFQUFnRTtnQkFDL0UsYUFBYSxFQUFFLE1BQU07YUFDdEI7WUFDRCxrQkFBa0IsRUFBRTtnQkFDbEIsS0FBSyxFQUFFLGtGQUFrRjtnQkFDekYsYUFBYSxFQUFFLDhDQUE4QztnQkFDN0QsYUFBYSxFQUFFLHdCQUF3QjthQUN4QztZQUNELGlCQUFpQixFQUFFO2dCQUNqQixLQUFLLEVBQUUsa0ZBQWtGO2dCQUN6RixhQUFhLEVBQUUsc0RBQXNEO2dCQUNyRSxhQUFhLEVBQUUsTUFBTTthQUN0QjtZQUNELGVBQWUsRUFBRTtnQkFDZixLQUFLLEVBQUUsa0ZBQWtGO2dCQUN6RixhQUFhLEVBQUUsNkJBQTZCO2dCQUM1QyxhQUFhLEVBQUUsTUFBTTthQUN0QjtZQUNELHFCQUFxQixFQUFFO2dCQUNyQixLQUFLLEVBQUUsa0ZBQWtGO2dCQUN6RixhQUFhLEVBQUUsd0hBQXdIO2dCQUN2SSxhQUFhLEVBQUUsd0JBQXdCO2FBQ3hDO1lBQ0Qsa0JBQWtCLEVBQUU7Z0JBQ2xCLEtBQUssRUFBRSxrRkFBa0Y7Z0JBQ3pGLGFBQWEsRUFBRSwyREFBMkQ7Z0JBQzFFLGFBQWEsRUFBRSxPQUFPO2FBQ3ZCO1lBQ0QsbUJBQW1CLEVBQUU7Z0JBQ25CLEtBQUssRUFBRSxrRkFBa0Y7Z0JBQ3pGLGFBQWEsRUFBRSxpREFBaUQ7Z0JBQ2hFLGFBQWEsRUFBRSx3QkFBd0I7YUFDeEM7WUFDRCxnQkFBZ0IsRUFBRTtnQkFDaEIsS0FBSyxFQUFFLGtGQUFrRjtnQkFDekYsYUFBYSxFQUFFLGdDQUFnQztnQkFDL0MsYUFBYSxFQUFFLE9BQU87YUFDdkI7U0FDRixDQUFDO1FBQ0ssa0JBQWEsR0FBa0IsRUFBRSxDQUFDO0lBU3pDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxxQkFBcUI7UUFDMUIsSUFBSSxDQUFDLEdBQUcsQ0FBQyxxQ0FBcUMsQ0FBQyxDQUFDO1FBQ2hELE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLHNCQUFzQjtRQUMzQixJQUFJLENBQUMsR0FBRyxDQUFDLHNDQUFzQyxDQUFDLENBQUM7UUFDakQsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksa0JBQWtCO1FBQ3ZCLElBQUksQ0FBQyxHQUFHLENBQUMsa0NBQWtDLENBQUMsQ0FBQztRQUM3QyxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxnQkFBZ0I7UUFDckIsSUFBSSxDQUFDLEdBQUcsQ0FBQyxnQ0FBZ0MsQ0FBQyxDQUFDO1FBQzNDLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGFBQWE7UUFDbEIsSUFBSSxDQUFDLEdBQUcsQ0FBQyw2QkFBNkIsQ0FBQyxDQUFDO1FBQ3hDLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLG1CQUFtQjtRQUN4QixJQUFJLENBQUMsR0FBRyxDQUFDLG1DQUFtQyxDQUFDLENBQUM7UUFDOUMsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksOEJBQThCO1FBQ25DLElBQUksQ0FBQyxHQUFHLENBQUMsOENBQThDLENBQUMsQ0FBQztRQUN6RCxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxnQkFBZ0I7UUFDckIsSUFBSSxDQUFDLEdBQUcsQ0FBQyxnQ0FBZ0MsQ0FBQyxDQUFDO1FBQzNDLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGVBQWU7UUFDcEIsSUFBSSxDQUFDLEdBQUcsQ0FBQywrQkFBK0IsQ0FBQyxDQUFDO1FBQzFDLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGFBQWE7UUFDbEIsSUFBSSxDQUFDLEdBQUcsQ0FBQyw2QkFBNkIsQ0FBQyxDQUFDO1FBQ3hDLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLG1CQUFtQjtRQUN4QixJQUFJLENBQUMsR0FBRyxDQUFDLG1DQUFtQyxDQUFDLENBQUM7UUFDOUMsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksZ0JBQWdCO1FBQ3JCLElBQUksQ0FBQyxHQUFHLENBQUMsZ0NBQWdDLENBQUMsQ0FBQztRQUMzQyxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxpQkFBaUI7UUFDdEIsSUFBSSxDQUFDLEdBQUcsQ0FBQyxpQ0FBaUMsQ0FBQyxDQUFDO1FBQzVDLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGNBQWM7UUFDbkIsSUFBSSxDQUFDLEdBQUcsQ0FBQyw4QkFBOEIsQ0FBQyxDQUFDO1FBQ3pDLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztDQUNGO0FBNVBELHNDQTRQQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEFjdGlvbnMsIFBvbGljeVN0YXRlbWVudCwgUmVzb3VyY2VUeXBlcyB9IGZyb20gXCIuLi9zaGFyZWRcIjtcblxuLyoqXG4gKiBTdGF0ZW1lbnQgcHJvdmlkZXIgZm9yIHNlcnZpY2UgW2xha2Vmb3JtYXRpb25dKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9JQU0vbGF0ZXN0L1VzZXJHdWlkZS9saXN0X2F3c2xha2Vmb3JtYXRpb24uaHRtbCkuXG4gKlxuICogQHBhcmFtIHNpZCBbU0lEXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vSUFNL2xhdGVzdC9Vc2VyR3VpZGUvcmVmZXJlbmNlX3BvbGljaWVzX2VsZW1lbnRzX3NpZC5odG1sKSBvZiB0aGUgc3RhdGVtZW50XG4gKi9cbmV4cG9ydCBjbGFzcyBMYWtlZm9ybWF0aW9uIGV4dGVuZHMgUG9saWN5U3RhdGVtZW50IHtcbiAgcHVibGljIHNlcnZpY2VQcmVmaXggPSAnbGFrZWZvcm1hdGlvbic7XG4gIHByb3RlY3RlZCBhY3Rpb25MaXN0OiBBY3Rpb25zID0ge1xuICAgIFwiQmF0Y2hHcmFudFBlcm1pc3Npb25zXCI6IHtcbiAgICAgIFwidXJsXCI6IFwiaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2xha2UtZm9ybWF0aW9uL2xhdGVzdC9kZy9hd3MtbGFrZS1mb3JtYXRpb24tYXBpLmh0bWxcIixcbiAgICAgIFwiZGVzY3JpcHRpb25cIjogXCJHcmFudHMgZGF0YSBsYWtlIHBlcm1pc3Npb25zIHRvIG9uZSBvciBtb3JlIHByaW5jaXBhbHMgaW4gYSBiYXRjaC5cIixcbiAgICAgIFwiYWNjZXNzTGV2ZWxcIjogXCJQZXJtaXNzaW9ucyBtYW5hZ2VtZW50XCJcbiAgICB9LFxuICAgIFwiQmF0Y2hSZXZva2VQZXJtaXNzaW9uc1wiOiB7XG4gICAgICBcInVybFwiOiBcImh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9sYWtlLWZvcm1hdGlvbi9sYXRlc3QvZGcvYXdzLWxha2UtZm9ybWF0aW9uLWFwaS5odG1sXCIsXG4gICAgICBcImRlc2NyaXB0aW9uXCI6IFwiUmV2b2tlcyBkYXRhIGxha2UgcGVybWlzc2lvbnMgZnJvbSBvbmUgb3IgbW9yZSBwcmluY2lwYWxzIGluIGEgYmF0Y2guXCIsXG4gICAgICBcImFjY2Vzc0xldmVsXCI6IFwiUGVybWlzc2lvbnMgbWFuYWdlbWVudFwiXG4gICAgfSxcbiAgICBcIkRlcmVnaXN0ZXJSZXNvdXJjZVwiOiB7XG4gICAgICBcInVybFwiOiBcImh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9sYWtlLWZvcm1hdGlvbi9sYXRlc3QvZGcvYXdzLWxha2UtZm9ybWF0aW9uLWFwaS5odG1sXCIsXG4gICAgICBcImRlc2NyaXB0aW9uXCI6IFwiRGVyZWdpc3RlcnMgYSByZWdpc3RlcmVkIGxvY2F0aW9uLlwiLFxuICAgICAgXCJhY2Nlc3NMZXZlbFwiOiBcIldyaXRlXCJcbiAgICB9LFxuICAgIFwiRGVzY3JpYmVSZXNvdXJjZVwiOiB7XG4gICAgICBcInVybFwiOiBcImh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9sYWtlLWZvcm1hdGlvbi9sYXRlc3QvZGcvYXdzLWxha2UtZm9ybWF0aW9uLWFwaS5odG1sXCIsXG4gICAgICBcImRlc2NyaXB0aW9uXCI6IFwiRGVzY3JpYmVzIGEgcmVnaXN0ZXJlZCBsb2NhdGlvbi5cIixcbiAgICAgIFwiYWNjZXNzTGV2ZWxcIjogXCJSZWFkXCJcbiAgICB9LFxuICAgIFwiR2V0RGF0YUFjY2Vzc1wiOiB7XG4gICAgICBcInVybFwiOiBcImh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9sYWtlLWZvcm1hdGlvbi9sYXRlc3QvZGcvYXdzLWxha2UtZm9ybWF0aW9uLWFwaS5odG1sXCIsXG4gICAgICBcImRlc2NyaXB0aW9uXCI6IFwiR3JhbnRzIHZpcnR1YWwgZGF0YSBsYWtlIGFjY2VzcyBwZXJtaXNzaW9ucy5cIixcbiAgICAgIFwiYWNjZXNzTGV2ZWxcIjogXCJXcml0ZVwiXG4gICAgfSxcbiAgICBcIkdldERhdGFMYWtlU2V0dGluZ3NcIjoge1xuICAgICAgXCJ1cmxcIjogXCJodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vbGFrZS1mb3JtYXRpb24vbGF0ZXN0L2RnL2F3cy1sYWtlLWZvcm1hdGlvbi1hcGkuaHRtbFwiLFxuICAgICAgXCJkZXNjcmlwdGlvblwiOiBcIlJldHJpZXZlcyBkYXRhIGxha2Ugc2V0dGluZ3Mgc3VjaCBhcyB0aGUgbGlzdCBvZiBkYXRhIGxha2UgYWRtaW5pc3RyYXRvcnMgYW5kIGRhdGFiYXNlIGFuZCB0YWJsZSBkZWZhdWx0IHBlcm1pc3Npb25zLlwiLFxuICAgICAgXCJhY2Nlc3NMZXZlbFwiOiBcIlJlYWRcIlxuICAgIH0sXG4gICAgXCJHZXRFZmZlY3RpdmVQZXJtaXNzaW9uc0ZvclBhdGhcIjoge1xuICAgICAgXCJ1cmxcIjogXCJodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vbGFrZS1mb3JtYXRpb24vbGF0ZXN0L2RnL2F3cy1sYWtlLWZvcm1hdGlvbi1hcGkuaHRtbFwiLFxuICAgICAgXCJkZXNjcmlwdGlvblwiOiBcIlJldHJpZXZlcyBwZXJtaXNzaW9ucyBhdHRhY2hlZCB0byByZXNvdXJjZXMgaW4gdGhlIGdpdmVuIHBhdGguXCIsXG4gICAgICBcImFjY2Vzc0xldmVsXCI6IFwiUmVhZFwiXG4gICAgfSxcbiAgICBcIkdyYW50UGVybWlzc2lvbnNcIjoge1xuICAgICAgXCJ1cmxcIjogXCJodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vbGFrZS1mb3JtYXRpb24vbGF0ZXN0L2RnL2F3cy1sYWtlLWZvcm1hdGlvbi1hcGkuaHRtbFwiLFxuICAgICAgXCJkZXNjcmlwdGlvblwiOiBcIkdyYW50cyBkYXRhIGxha2UgcGVybWlzc2lvbnMgdG8gYSBwcmluY2lwYWwuXCIsXG4gICAgICBcImFjY2Vzc0xldmVsXCI6IFwiUGVybWlzc2lvbnMgbWFuYWdlbWVudFwiXG4gICAgfSxcbiAgICBcIkxpc3RQZXJtaXNzaW9uc1wiOiB7XG4gICAgICBcInVybFwiOiBcImh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9sYWtlLWZvcm1hdGlvbi9sYXRlc3QvZGcvYXdzLWxha2UtZm9ybWF0aW9uLWFwaS5odG1sXCIsXG4gICAgICBcImRlc2NyaXB0aW9uXCI6IFwiTGlzdHMgcGVybWlzc2lvbnMgZmlsdGVyZWQgYnkgcHJpbmNpcGFsIG9yIHJlc291cmNlLlwiLFxuICAgICAgXCJhY2Nlc3NMZXZlbFwiOiBcIkxpc3RcIlxuICAgIH0sXG4gICAgXCJMaXN0UmVzb3VyY2VzXCI6IHtcbiAgICAgIFwidXJsXCI6IFwiaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2xha2UtZm9ybWF0aW9uL2xhdGVzdC9kZy9hd3MtbGFrZS1mb3JtYXRpb24tYXBpLmh0bWxcIixcbiAgICAgIFwiZGVzY3JpcHRpb25cIjogXCJMaXN0cyByZWdpc3RlcmVkIGxvY2F0aW9ucy5cIixcbiAgICAgIFwiYWNjZXNzTGV2ZWxcIjogXCJMaXN0XCJcbiAgICB9LFxuICAgIFwiUHV0RGF0YUxha2VTZXR0aW5nc1wiOiB7XG4gICAgICBcInVybFwiOiBcImh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9sYWtlLWZvcm1hdGlvbi9sYXRlc3QvZGcvYXdzLWxha2UtZm9ybWF0aW9uLWFwaS5odG1sXCIsXG4gICAgICBcImRlc2NyaXB0aW9uXCI6IFwiT3ZlcndyaXRlcyBkYXRhIGxha2Ugc2V0dGluZ3Mgc3VjaCBhcyB0aGUgbGlzdCBvZiBkYXRhIGxha2UgYWRtaW5pc3RyYXRvcnMgYW5kIGRhdGFiYXNlIGFuZCB0YWJsZSBkZWZhdWx0IHBlcm1pc3Npb25zLlwiLFxuICAgICAgXCJhY2Nlc3NMZXZlbFwiOiBcIlBlcm1pc3Npb25zIG1hbmFnZW1lbnRcIlxuICAgIH0sXG4gICAgXCJSZWdpc3RlclJlc291cmNlXCI6IHtcbiAgICAgIFwidXJsXCI6IFwiaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2xha2UtZm9ybWF0aW9uL2xhdGVzdC9kZy9hd3MtbGFrZS1mb3JtYXRpb24tYXBpLmh0bWxcIixcbiAgICAgIFwiZGVzY3JpcHRpb25cIjogXCJSZWdpc3RlcnMgYSBuZXcgbG9jYXRpb24gdG8gYmUgbWFuYWdlZCBieSBMYWtlIEZvcm1hdGlvbi5cIixcbiAgICAgIFwiYWNjZXNzTGV2ZWxcIjogXCJXcml0ZVwiXG4gICAgfSxcbiAgICBcIlJldm9rZVBlcm1pc3Npb25zXCI6IHtcbiAgICAgIFwidXJsXCI6IFwiaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2xha2UtZm9ybWF0aW9uL2xhdGVzdC9kZy9hd3MtbGFrZS1mb3JtYXRpb24tYXBpLmh0bWxcIixcbiAgICAgIFwiZGVzY3JpcHRpb25cIjogXCJSZXZva2VzIGRhdGEgbGFrZSBwZXJtaXNzaW9ucyBmcm9tIGEgcHJpbmNpcGFsLlwiLFxuICAgICAgXCJhY2Nlc3NMZXZlbFwiOiBcIlBlcm1pc3Npb25zIG1hbmFnZW1lbnRcIlxuICAgIH0sXG4gICAgXCJVcGRhdGVSZXNvdXJjZVwiOiB7XG4gICAgICBcInVybFwiOiBcImh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9sYWtlLWZvcm1hdGlvbi9sYXRlc3QvZGcvYXdzLWxha2UtZm9ybWF0aW9uLWFwaS5odG1sXCIsXG4gICAgICBcImRlc2NyaXB0aW9uXCI6IFwiVXBkYXRlcyBhIHJlZ2lzdGVyZWQgbG9jYXRpb24uXCIsXG4gICAgICBcImFjY2Vzc0xldmVsXCI6IFwiV3JpdGVcIlxuICAgIH1cbiAgfTtcbiAgcHVibGljIHJlc291cmNlVHlwZXM6IFJlc291cmNlVHlwZXMgPSB7fTtcblxuICAvKipcbiAgICogU3RhdGVtZW50IHByb3ZpZGVyIGZvciBzZXJ2aWNlIFtsYWtlZm9ybWF0aW9uXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vSUFNL2xhdGVzdC9Vc2VyR3VpZGUvbGlzdF9hd3NsYWtlZm9ybWF0aW9uLmh0bWwpLlxuICAgKlxuICAgKiBAcGFyYW0gc2lkIFtTSURdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9JQU0vbGF0ZXN0L1VzZXJHdWlkZS9yZWZlcmVuY2VfcG9saWNpZXNfZWxlbWVudHNfc2lkLmh0bWwpIG9mIHRoZSBzdGF0ZW1lbnRcbiAgICovXG4gIGNvbnN0cnVjdG9yIChzaWQ/OiBzdHJpbmcpIHtcbiAgICBzdXBlcihzaWQpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBkYXRhIGxha2UgcGVybWlzc2lvbnMgdG8gb25lIG9yIG1vcmUgcHJpbmNpcGFscyBpbiBhIGJhdGNoLlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFBlcm1pc3Npb25zIG1hbmFnZW1lbnRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2xha2UtZm9ybWF0aW9uL2xhdGVzdC9kZy9hd3MtbGFrZS1mb3JtYXRpb24tYXBpLmh0bWxcbiAgICovXG4gIHB1YmxpYyBiYXRjaEdyYW50UGVybWlzc2lvbnMoKSB7XG4gICAgdGhpcy5hZGQoJ2xha2Vmb3JtYXRpb246QmF0Y2hHcmFudFBlcm1pc3Npb25zJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogUmV2b2tlcyBkYXRhIGxha2UgcGVybWlzc2lvbnMgZnJvbSBvbmUgb3IgbW9yZSBwcmluY2lwYWxzIGluIGEgYmF0Y2guXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUGVybWlzc2lvbnMgbWFuYWdlbWVudFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vbGFrZS1mb3JtYXRpb24vbGF0ZXN0L2RnL2F3cy1sYWtlLWZvcm1hdGlvbi1hcGkuaHRtbFxuICAgKi9cbiAgcHVibGljIGJhdGNoUmV2b2tlUGVybWlzc2lvbnMoKSB7XG4gICAgdGhpcy5hZGQoJ2xha2Vmb3JtYXRpb246QmF0Y2hSZXZva2VQZXJtaXNzaW9ucycpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIERlcmVnaXN0ZXJzIGEgcmVnaXN0ZXJlZCBsb2NhdGlvbi5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vbGFrZS1mb3JtYXRpb24vbGF0ZXN0L2RnL2F3cy1sYWtlLWZvcm1hdGlvbi1hcGkuaHRtbFxuICAgKi9cbiAgcHVibGljIGRlcmVnaXN0ZXJSZXNvdXJjZSgpIHtcbiAgICB0aGlzLmFkZCgnbGFrZWZvcm1hdGlvbjpEZXJlZ2lzdGVyUmVzb3VyY2UnKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBEZXNjcmliZXMgYSByZWdpc3RlcmVkIGxvY2F0aW9uLlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2xha2UtZm9ybWF0aW9uL2xhdGVzdC9kZy9hd3MtbGFrZS1mb3JtYXRpb24tYXBpLmh0bWxcbiAgICovXG4gIHB1YmxpYyBkZXNjcmliZVJlc291cmNlKCkge1xuICAgIHRoaXMuYWRkKCdsYWtlZm9ybWF0aW9uOkRlc2NyaWJlUmVzb3VyY2UnKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgdmlydHVhbCBkYXRhIGxha2UgYWNjZXNzIHBlcm1pc3Npb25zLlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9sYWtlLWZvcm1hdGlvbi9sYXRlc3QvZGcvYXdzLWxha2UtZm9ybWF0aW9uLWFwaS5odG1sXG4gICAqL1xuICBwdWJsaWMgZ2V0RGF0YUFjY2VzcygpIHtcbiAgICB0aGlzLmFkZCgnbGFrZWZvcm1hdGlvbjpHZXREYXRhQWNjZXNzJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogUmV0cmlldmVzIGRhdGEgbGFrZSBzZXR0aW5ncyBzdWNoIGFzIHRoZSBsaXN0IG9mIGRhdGEgbGFrZSBhZG1pbmlzdHJhdG9ycyBhbmQgZGF0YWJhc2UgYW5kIHRhYmxlIGRlZmF1bHQgcGVybWlzc2lvbnMuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vbGFrZS1mb3JtYXRpb24vbGF0ZXN0L2RnL2F3cy1sYWtlLWZvcm1hdGlvbi1hcGkuaHRtbFxuICAgKi9cbiAgcHVibGljIGdldERhdGFMYWtlU2V0dGluZ3MoKSB7XG4gICAgdGhpcy5hZGQoJ2xha2Vmb3JtYXRpb246R2V0RGF0YUxha2VTZXR0aW5ncycpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIFJldHJpZXZlcyBwZXJtaXNzaW9ucyBhdHRhY2hlZCB0byByZXNvdXJjZXMgaW4gdGhlIGdpdmVuIHBhdGguXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vbGFrZS1mb3JtYXRpb24vbGF0ZXN0L2RnL2F3cy1sYWtlLWZvcm1hdGlvbi1hcGkuaHRtbFxuICAgKi9cbiAgcHVibGljIGdldEVmZmVjdGl2ZVBlcm1pc3Npb25zRm9yUGF0aCgpIHtcbiAgICB0aGlzLmFkZCgnbGFrZWZvcm1hdGlvbjpHZXRFZmZlY3RpdmVQZXJtaXNzaW9uc0ZvclBhdGgnKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgZGF0YSBsYWtlIHBlcm1pc3Npb25zIHRvIGEgcHJpbmNpcGFsLlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFBlcm1pc3Npb25zIG1hbmFnZW1lbnRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2xha2UtZm9ybWF0aW9uL2xhdGVzdC9kZy9hd3MtbGFrZS1mb3JtYXRpb24tYXBpLmh0bWxcbiAgICovXG4gIHB1YmxpYyBncmFudFBlcm1pc3Npb25zKCkge1xuICAgIHRoaXMuYWRkKCdsYWtlZm9ybWF0aW9uOkdyYW50UGVybWlzc2lvbnMnKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBMaXN0cyBwZXJtaXNzaW9ucyBmaWx0ZXJlZCBieSBwcmluY2lwYWwgb3IgcmVzb3VyY2UuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogTGlzdFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vbGFrZS1mb3JtYXRpb24vbGF0ZXN0L2RnL2F3cy1sYWtlLWZvcm1hdGlvbi1hcGkuaHRtbFxuICAgKi9cbiAgcHVibGljIGxpc3RQZXJtaXNzaW9ucygpIHtcbiAgICB0aGlzLmFkZCgnbGFrZWZvcm1hdGlvbjpMaXN0UGVybWlzc2lvbnMnKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBMaXN0cyByZWdpc3RlcmVkIGxvY2F0aW9ucy5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBMaXN0XG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9sYWtlLWZvcm1hdGlvbi9sYXRlc3QvZGcvYXdzLWxha2UtZm9ybWF0aW9uLWFwaS5odG1sXG4gICAqL1xuICBwdWJsaWMgbGlzdFJlc291cmNlcygpIHtcbiAgICB0aGlzLmFkZCgnbGFrZWZvcm1hdGlvbjpMaXN0UmVzb3VyY2VzJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogT3ZlcndyaXRlcyBkYXRhIGxha2Ugc2V0dGluZ3Mgc3VjaCBhcyB0aGUgbGlzdCBvZiBkYXRhIGxha2UgYWRtaW5pc3RyYXRvcnMgYW5kIGRhdGFiYXNlIGFuZCB0YWJsZSBkZWZhdWx0IHBlcm1pc3Npb25zLlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFBlcm1pc3Npb25zIG1hbmFnZW1lbnRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2xha2UtZm9ybWF0aW9uL2xhdGVzdC9kZy9hd3MtbGFrZS1mb3JtYXRpb24tYXBpLmh0bWxcbiAgICovXG4gIHB1YmxpYyBwdXREYXRhTGFrZVNldHRpbmdzKCkge1xuICAgIHRoaXMuYWRkKCdsYWtlZm9ybWF0aW9uOlB1dERhdGFMYWtlU2V0dGluZ3MnKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBSZWdpc3RlcnMgYSBuZXcgbG9jYXRpb24gdG8gYmUgbWFuYWdlZCBieSBMYWtlIEZvcm1hdGlvbi5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vbGFrZS1mb3JtYXRpb24vbGF0ZXN0L2RnL2F3cy1sYWtlLWZvcm1hdGlvbi1hcGkuaHRtbFxuICAgKi9cbiAgcHVibGljIHJlZ2lzdGVyUmVzb3VyY2UoKSB7XG4gICAgdGhpcy5hZGQoJ2xha2Vmb3JtYXRpb246UmVnaXN0ZXJSZXNvdXJjZScpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIFJldm9rZXMgZGF0YSBsYWtlIHBlcm1pc3Npb25zIGZyb20gYSBwcmluY2lwYWwuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUGVybWlzc2lvbnMgbWFuYWdlbWVudFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vbGFrZS1mb3JtYXRpb24vbGF0ZXN0L2RnL2F3cy1sYWtlLWZvcm1hdGlvbi1hcGkuaHRtbFxuICAgKi9cbiAgcHVibGljIHJldm9rZVBlcm1pc3Npb25zKCkge1xuICAgIHRoaXMuYWRkKCdsYWtlZm9ybWF0aW9uOlJldm9rZVBlcm1pc3Npb25zJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogVXBkYXRlcyBhIHJlZ2lzdGVyZWQgbG9jYXRpb24uXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2xha2UtZm9ybWF0aW9uL2xhdGVzdC9kZy9hd3MtbGFrZS1mb3JtYXRpb24tYXBpLmh0bWxcbiAgICovXG4gIHB1YmxpYyB1cGRhdGVSZXNvdXJjZSgpIHtcbiAgICB0aGlzLmFkZCgnbGFrZWZvcm1hdGlvbjpVcGRhdGVSZXNvdXJjZScpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG59XG4iXX0=