import { Actions, PolicyStatement, ResourceTypes } from "../shared";
/**
 * Statement provider for service [outposts](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awsoutposts.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Outposts extends PolicyStatement {
    servicePrefix: string;
    protected actionList: Actions;
    resourceTypes: ResourceTypes;
    /**
     * Statement provider for service [outposts](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awsoutposts.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Creates an Outpost
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/outposts/latest/APIReference/API_CreateOutpost.html
     */
    createOutpost(): this;
    /**
     * Gets information about the specified Outpost
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/outposts/latest/APIReference/API_GetOutpost.html
     */
    getOutpost(): this;
    /**
     * Lists the instance types for the specified Outpost
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/outposts/latest/APIReference/API_GetOutpostInstanceTypes.html
     */
    getOutpostInstanceTypes(): this;
    /**
     * List the Outposts for your AWS account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/outposts/latest/APIReference/API_ListOutposts.html
     */
    listOutposts(): this;
    /**
     * Lists the sites for the specified AWS account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/outposts/latest/APIReference/API_ListSites.html
     */
    listSites(): this;
    /**
     * Adds a resource of type Outpost to the statement
     *
     * https://docs.aws.amazon.com/outposts/latest/APIReference/API_Outpost.html
     *
     * @param outpostId - Identifier for the outpostId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onOutpost(outpostId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type Site to the statement
     *
     * https://docs.aws.amazon.com/outposts/latest/APIReference/API_Site.html
     *
     * @param siteId - Identifier for the siteId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onSite(siteId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type Order to the statement
     *
     * https://docs.aws.amazon.com/outposts/latest/APIReference/Welcome.html
     *
     * @param orderId - Identifier for the orderId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onOrder(orderId: string, account?: string, region?: string, partition?: string): this;
}
