import { Actions, PolicyStatement, ResourceTypes } from "../shared";
/**
 * Statement provider for service [snowball](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awssnowball.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Snowball extends PolicyStatement {
    servicePrefix: string;
    protected actionList: Actions;
    resourceTypes: ResourceTypes;
    /**
     * Statement provider for service [snowball](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awssnowball.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Cancels a cluster job.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_CancelCluster.html
     */
    cancelCluster(): this;
    /**
     * Cancels the specified job.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_CancelJob.html
     */
    cancelJob(): this;
    /**
     * Creates an address for a Snowball to be shipped to.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_CreateAddress.html
     */
    createAddress(): this;
    /**
     * Creates an empty cluster.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_CreateCluster.html
     */
    createCluster(): this;
    /**
     * Creates a job to import or export data between Amazon S3 and your on-premises data center.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_CreateJob.html
     */
    createJob(): this;
    /**
     * Takes an AddressId and returns specific details about that address in the form of an Address object.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_DescribeAddress.html
     */
    describeAddress(): this;
    /**
     * Returns a specified number of ADDRESS objects.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_DescribeAddresses.html
     */
    describeAddresses(): this;
    /**
     * Returns information about a specific cluster including shipping information, cluster status, and other important metadata.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_DescribeCluster.html
     */
    describeCluster(): this;
    /**
     * Returns information about a specific job including shipping information, job status, and other important metadata.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_DescribeJob.html
     */
    describeJob(): this;
    /**
     * Returns a link to an Amazon S3 presigned URL for the manifest file associated with the specified JobId value.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_GetJobManifest.html
     */
    getJobManifest(): this;
    /**
     * Returns the UnlockCode code value for the specified job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_GetJobUnlockCode.html
     */
    getJobUnlockCode(): this;
    /**
     * Returns information about the Snowball service limit for your account, and also the number of Snowballs your account has in use.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_GetSnowballUsage.html
     */
    getSnowballUsage(): this;
    /**
     * Returns an array of JobListEntry objects of the specified length.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_ListClusterJobs.html
     */
    listClusterJobs(): this;
    /**
     * Returns an array of ClusterListEntry objects of the specified length.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_ListClusters.html
     */
    listClusters(): this;
    /**
     * Returns an array of JobListEntry objects of the specified length.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_ListJobs.html
     */
    listJobs(): this;
    /**
     * While a cluster's ClusterState value is in the AwaitingQuorum state, you can update some of the information associated with a cluster.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_UpdateCluster.html
     */
    updateCluster(): this;
    /**
     * While a job's JobState value is New, you can update some of the information associated with a job.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_UpdateJob.html
     */
    updateJob(): this;
}
