"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Comprehendmedical = void 0;
const shared_1 = require("../shared");
/**
 * Statement provider for service [comprehendmedical](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_comprehendmedical.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Comprehendmedical extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [comprehendmedical](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_comprehendmedical.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'comprehendmedical';
        this.actionList = {
            "DetectEntities": {
                "url": "https://docs.aws.amazon.com/comprehend/latest/dg/API_hera_DetectEntities.html",
                "description": "Inspects the specified text for the specified type of entities and returns information about them.",
                "accessLevel": "Read"
            },
            "DetectPHI": {
                "url": "https://docs.aws.amazon.com/comprehend/latest/dg/API_hera_DetectPHI.html",
                "description": "Inspects the specified text for PHI entities and returns information about them.",
                "accessLevel": "Read"
            }
        };
        this.resourceTypes = {};
    }
    /**
     * Inspects the specified text for the specified type of entities and returns information about them.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_hera_DetectEntities.html
     */
    detectEntities() {
        this.add('comprehendmedical:DetectEntities');
        return this;
    }
    /**
     * Inspects the specified text for PHI entities and returns information about them.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_hera_DetectPHI.html
     */
    detectPHI() {
        this.add('comprehendmedical:DetectPHI');
        return this;
    }
}
exports.Comprehendmedical = Comprehendmedical;
//# sourceMappingURL=data:application/json;base64,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