"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ComputeOptimizer = void 0;
const shared_1 = require("../shared");
/**
 * Statement provider for service [compute-optimizer](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_computeoptimizer.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class ComputeOptimizer extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [compute-optimizer](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_computeoptimizer.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'compute-optimizer';
        this.actionList = {
            "DescribeRecommendationExportJobs": {
                "url": "https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_DescribeRecommendationExportJobs.html",
                "description": "Grants permission to view the status of recommendation export jobs.",
                "accessLevel": "List"
            },
            "ExportAutoScalingGroupRecommendations": {
                "url": "https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_ExportAutoScalingGroupRecommendations.html",
                "description": "Grants permission to export autoscaling group recommendations to S3 for the provided accounts.",
                "accessLevel": "Write"
            },
            "ExportEC2InstanceRecommendations": {
                "url": "https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_ExportEC2InstanceRecommendations.html",
                "description": "Grants permission to export EC2 instance recommendations to S3 for the provided accounts.",
                "accessLevel": "Write"
            },
            "GetAutoScalingGroupRecommendations": {
                "url": "https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_GetAutoScalingGroupRecommendations.html",
                "description": "Grants permission to get recommendations for the provided autoscaling groups.",
                "accessLevel": "List"
            },
            "GetEC2InstanceRecommendations": {
                "url": "https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_GetEC2InstanceRecommendations.html",
                "description": "Grants permission to get recommendations for the provided EC2 instances.",
                "accessLevel": "List"
            },
            "GetEC2RecommendationProjectedMetrics": {
                "url": "https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_GetEC2RecommendationProjectedMetrics.html",
                "description": "Grants permission to get the recommendation projected metrics of the specified instance.",
                "accessLevel": "List"
            },
            "GetEnrollmentStatus": {
                "url": "https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_GetEnrollmentStatus.html",
                "description": "Grants permission to get the enrollment status for the specified account.",
                "accessLevel": "List"
            },
            "GetRecommendationSummaries": {
                "url": "https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_GetRecommendationSummaries.html",
                "description": "Grants permission to get the recommendation summaries for the specified account(s).",
                "accessLevel": "List"
            },
            "UpdateEnrollmentStatus": {
                "url": "https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_UpdateEnrollmentStatus.html",
                "description": "Grants permission to update the enrollment status.",
                "accessLevel": "Write"
            }
        };
        this.resourceTypes = {};
    }
    /**
     * Grants permission to view the status of recommendation export jobs.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_DescribeRecommendationExportJobs.html
     */
    describeRecommendationExportJobs() {
        this.add('compute-optimizer:DescribeRecommendationExportJobs');
        return this;
    }
    /**
     * Grants permission to export autoscaling group recommendations to S3 for the provided accounts.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_ExportAutoScalingGroupRecommendations.html
     */
    exportAutoScalingGroupRecommendations() {
        this.add('compute-optimizer:ExportAutoScalingGroupRecommendations');
        return this;
    }
    /**
     * Grants permission to export EC2 instance recommendations to S3 for the provided accounts.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_ExportEC2InstanceRecommendations.html
     */
    exportEC2InstanceRecommendations() {
        this.add('compute-optimizer:ExportEC2InstanceRecommendations');
        return this;
    }
    /**
     * Grants permission to get recommendations for the provided autoscaling groups.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_GetAutoScalingGroupRecommendations.html
     */
    getAutoScalingGroupRecommendations() {
        this.add('compute-optimizer:GetAutoScalingGroupRecommendations');
        return this;
    }
    /**
     * Grants permission to get recommendations for the provided EC2 instances.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_GetEC2InstanceRecommendations.html
     */
    getEC2InstanceRecommendations() {
        this.add('compute-optimizer:GetEC2InstanceRecommendations');
        return this;
    }
    /**
     * Grants permission to get the recommendation projected metrics of the specified instance.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_GetEC2RecommendationProjectedMetrics.html
     */
    getEC2RecommendationProjectedMetrics() {
        this.add('compute-optimizer:GetEC2RecommendationProjectedMetrics');
        return this;
    }
    /**
     * Grants permission to get the enrollment status for the specified account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_GetEnrollmentStatus.html
     */
    getEnrollmentStatus() {
        this.add('compute-optimizer:GetEnrollmentStatus');
        return this;
    }
    /**
     * Grants permission to get the recommendation summaries for the specified account(s).
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_GetRecommendationSummaries.html
     */
    getRecommendationSummaries() {
        this.add('compute-optimizer:GetRecommendationSummaries');
        return this;
    }
    /**
     * Grants permission to update the enrollment status.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_UpdateEnrollmentStatus.html
     */
    updateEnrollmentStatus() {
        this.add('compute-optimizer:UpdateEnrollmentStatus');
        return this;
    }
}
exports.ComputeOptimizer = ComputeOptimizer;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY29tcHV0ZW9wdGltaXplci5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImNvbXB1dGVvcHRpbWl6ZXIudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEsc0NBQW9FO0FBRXBFOzs7O0dBSUc7QUFDSCxNQUFhLGdCQUFpQixTQUFRLHdCQUFlO0lBbURuRDs7OztPQUlHO0lBQ0gsWUFBYSxHQUFZO1FBQ3ZCLEtBQUssQ0FBQyxHQUFHLENBQUMsQ0FBQztRQXhETixrQkFBYSxHQUFHLG1CQUFtQixDQUFDO1FBQ2pDLGVBQVUsR0FBWTtZQUM5QixrQ0FBa0MsRUFBRTtnQkFDbEMsS0FBSyxFQUFFLDZHQUE2RztnQkFDcEgsYUFBYSxFQUFFLHFFQUFxRTtnQkFDcEYsYUFBYSxFQUFFLE1BQU07YUFDdEI7WUFDRCx1Q0FBdUMsRUFBRTtnQkFDdkMsS0FBSyxFQUFFLGtIQUFrSDtnQkFDekgsYUFBYSxFQUFFLGdHQUFnRztnQkFDL0csYUFBYSxFQUFFLE9BQU87YUFDdkI7WUFDRCxrQ0FBa0MsRUFBRTtnQkFDbEMsS0FBSyxFQUFFLDZHQUE2RztnQkFDcEgsYUFBYSxFQUFFLDJGQUEyRjtnQkFDMUcsYUFBYSxFQUFFLE9BQU87YUFDdkI7WUFDRCxvQ0FBb0MsRUFBRTtnQkFDcEMsS0FBSyxFQUFFLCtHQUErRztnQkFDdEgsYUFBYSxFQUFFLCtFQUErRTtnQkFDOUYsYUFBYSxFQUFFLE1BQU07YUFDdEI7WUFDRCwrQkFBK0IsRUFBRTtnQkFDL0IsS0FBSyxFQUFFLDBHQUEwRztnQkFDakgsYUFBYSxFQUFFLDBFQUEwRTtnQkFDekYsYUFBYSxFQUFFLE1BQU07YUFDdEI7WUFDRCxzQ0FBc0MsRUFBRTtnQkFDdEMsS0FBSyxFQUFFLGlIQUFpSDtnQkFDeEgsYUFBYSxFQUFFLDBGQUEwRjtnQkFDekcsYUFBYSxFQUFFLE1BQU07YUFDdEI7WUFDRCxxQkFBcUIsRUFBRTtnQkFDckIsS0FBSyxFQUFFLGdHQUFnRztnQkFDdkcsYUFBYSxFQUFFLDJFQUEyRTtnQkFDMUYsYUFBYSxFQUFFLE1BQU07YUFDdEI7WUFDRCw0QkFBNEIsRUFBRTtnQkFDNUIsS0FBSyxFQUFFLHVHQUF1RztnQkFDOUcsYUFBYSxFQUFFLHFGQUFxRjtnQkFDcEcsYUFBYSxFQUFFLE1BQU07YUFDdEI7WUFDRCx3QkFBd0IsRUFBRTtnQkFDeEIsS0FBSyxFQUFFLG1HQUFtRztnQkFDMUcsYUFBYSxFQUFFLG9EQUFvRDtnQkFDbkUsYUFBYSxFQUFFLE9BQU87YUFDdkI7U0FDRixDQUFDO1FBQ0ssa0JBQWEsR0FBa0IsRUFBRSxDQUFDO0lBU3pDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxnQ0FBZ0M7UUFDckMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxvREFBb0QsQ0FBQyxDQUFDO1FBQy9ELE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLHFDQUFxQztRQUMxQyxJQUFJLENBQUMsR0FBRyxDQUFDLHlEQUF5RCxDQUFDLENBQUM7UUFDcEUsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksZ0NBQWdDO1FBQ3JDLElBQUksQ0FBQyxHQUFHLENBQUMsb0RBQW9ELENBQUMsQ0FBQztRQUMvRCxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxrQ0FBa0M7UUFDdkMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxzREFBc0QsQ0FBQyxDQUFDO1FBQ2pFLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLDZCQUE2QjtRQUNsQyxJQUFJLENBQUMsR0FBRyxDQUFDLGlEQUFpRCxDQUFDLENBQUM7UUFDNUQsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksb0NBQW9DO1FBQ3pDLElBQUksQ0FBQyxHQUFHLENBQUMsd0RBQXdELENBQUMsQ0FBQztRQUNuRSxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxtQkFBbUI7UUFDeEIsSUFBSSxDQUFDLEdBQUcsQ0FBQyx1Q0FBdUMsQ0FBQyxDQUFDO1FBQ2xELE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLDBCQUEwQjtRQUMvQixJQUFJLENBQUMsR0FBRyxDQUFDLDhDQUE4QyxDQUFDLENBQUM7UUFDekQsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksc0JBQXNCO1FBQzNCLElBQUksQ0FBQyxHQUFHLENBQUMsMENBQTBDLENBQUMsQ0FBQztRQUNyRCxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7Q0FDRjtBQXZLRCw0Q0F1S0MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBBY3Rpb25zLCBQb2xpY3lTdGF0ZW1lbnQsIFJlc291cmNlVHlwZXMgfSBmcm9tIFwiLi4vc2hhcmVkXCI7XG5cbi8qKlxuICogU3RhdGVtZW50IHByb3ZpZGVyIGZvciBzZXJ2aWNlIFtjb21wdXRlLW9wdGltaXplcl0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0lBTS9sYXRlc3QvVXNlckd1aWRlL2xpc3RfY29tcHV0ZW9wdGltaXplci5odG1sKS5cbiAqXG4gKiBAcGFyYW0gc2lkIFtTSURdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9JQU0vbGF0ZXN0L1VzZXJHdWlkZS9yZWZlcmVuY2VfcG9saWNpZXNfZWxlbWVudHNfc2lkLmh0bWwpIG9mIHRoZSBzdGF0ZW1lbnRcbiAqL1xuZXhwb3J0IGNsYXNzIENvbXB1dGVPcHRpbWl6ZXIgZXh0ZW5kcyBQb2xpY3lTdGF0ZW1lbnQge1xuICBwdWJsaWMgc2VydmljZVByZWZpeCA9ICdjb21wdXRlLW9wdGltaXplcic7XG4gIHByb3RlY3RlZCBhY3Rpb25MaXN0OiBBY3Rpb25zID0ge1xuICAgIFwiRGVzY3JpYmVSZWNvbW1lbmRhdGlvbkV4cG9ydEpvYnNcIjoge1xuICAgICAgXCJ1cmxcIjogXCJodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vY29tcHV0ZS1vcHRpbWl6ZXIvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfRGVzY3JpYmVSZWNvbW1lbmRhdGlvbkV4cG9ydEpvYnMuaHRtbFwiLFxuICAgICAgXCJkZXNjcmlwdGlvblwiOiBcIkdyYW50cyBwZXJtaXNzaW9uIHRvIHZpZXcgdGhlIHN0YXR1cyBvZiByZWNvbW1lbmRhdGlvbiBleHBvcnQgam9icy5cIixcbiAgICAgIFwiYWNjZXNzTGV2ZWxcIjogXCJMaXN0XCJcbiAgICB9LFxuICAgIFwiRXhwb3J0QXV0b1NjYWxpbmdHcm91cFJlY29tbWVuZGF0aW9uc1wiOiB7XG4gICAgICBcInVybFwiOiBcImh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9jb21wdXRlLW9wdGltaXplci9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9FeHBvcnRBdXRvU2NhbGluZ0dyb3VwUmVjb21tZW5kYXRpb25zLmh0bWxcIixcbiAgICAgIFwiZGVzY3JpcHRpb25cIjogXCJHcmFudHMgcGVybWlzc2lvbiB0byBleHBvcnQgYXV0b3NjYWxpbmcgZ3JvdXAgcmVjb21tZW5kYXRpb25zIHRvIFMzIGZvciB0aGUgcHJvdmlkZWQgYWNjb3VudHMuXCIsXG4gICAgICBcImFjY2Vzc0xldmVsXCI6IFwiV3JpdGVcIlxuICAgIH0sXG4gICAgXCJFeHBvcnRFQzJJbnN0YW5jZVJlY29tbWVuZGF0aW9uc1wiOiB7XG4gICAgICBcInVybFwiOiBcImh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9jb21wdXRlLW9wdGltaXplci9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9FeHBvcnRFQzJJbnN0YW5jZVJlY29tbWVuZGF0aW9ucy5odG1sXCIsXG4gICAgICBcImRlc2NyaXB0aW9uXCI6IFwiR3JhbnRzIHBlcm1pc3Npb24gdG8gZXhwb3J0IEVDMiBpbnN0YW5jZSByZWNvbW1lbmRhdGlvbnMgdG8gUzMgZm9yIHRoZSBwcm92aWRlZCBhY2NvdW50cy5cIixcbiAgICAgIFwiYWNjZXNzTGV2ZWxcIjogXCJXcml0ZVwiXG4gICAgfSxcbiAgICBcIkdldEF1dG9TY2FsaW5nR3JvdXBSZWNvbW1lbmRhdGlvbnNcIjoge1xuICAgICAgXCJ1cmxcIjogXCJodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vY29tcHV0ZS1vcHRpbWl6ZXIvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfR2V0QXV0b1NjYWxpbmdHcm91cFJlY29tbWVuZGF0aW9ucy5odG1sXCIsXG4gICAgICBcImRlc2NyaXB0aW9uXCI6IFwiR3JhbnRzIHBlcm1pc3Npb24gdG8gZ2V0IHJlY29tbWVuZGF0aW9ucyBmb3IgdGhlIHByb3ZpZGVkIGF1dG9zY2FsaW5nIGdyb3Vwcy5cIixcbiAgICAgIFwiYWNjZXNzTGV2ZWxcIjogXCJMaXN0XCJcbiAgICB9LFxuICAgIFwiR2V0RUMySW5zdGFuY2VSZWNvbW1lbmRhdGlvbnNcIjoge1xuICAgICAgXCJ1cmxcIjogXCJodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vY29tcHV0ZS1vcHRpbWl6ZXIvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfR2V0RUMySW5zdGFuY2VSZWNvbW1lbmRhdGlvbnMuaHRtbFwiLFxuICAgICAgXCJkZXNjcmlwdGlvblwiOiBcIkdyYW50cyBwZXJtaXNzaW9uIHRvIGdldCByZWNvbW1lbmRhdGlvbnMgZm9yIHRoZSBwcm92aWRlZCBFQzIgaW5zdGFuY2VzLlwiLFxuICAgICAgXCJhY2Nlc3NMZXZlbFwiOiBcIkxpc3RcIlxuICAgIH0sXG4gICAgXCJHZXRFQzJSZWNvbW1lbmRhdGlvblByb2plY3RlZE1ldHJpY3NcIjoge1xuICAgICAgXCJ1cmxcIjogXCJodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vY29tcHV0ZS1vcHRpbWl6ZXIvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfR2V0RUMyUmVjb21tZW5kYXRpb25Qcm9qZWN0ZWRNZXRyaWNzLmh0bWxcIixcbiAgICAgIFwiZGVzY3JpcHRpb25cIjogXCJHcmFudHMgcGVybWlzc2lvbiB0byBnZXQgdGhlIHJlY29tbWVuZGF0aW9uIHByb2plY3RlZCBtZXRyaWNzIG9mIHRoZSBzcGVjaWZpZWQgaW5zdGFuY2UuXCIsXG4gICAgICBcImFjY2Vzc0xldmVsXCI6IFwiTGlzdFwiXG4gICAgfSxcbiAgICBcIkdldEVucm9sbG1lbnRTdGF0dXNcIjoge1xuICAgICAgXCJ1cmxcIjogXCJodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vY29tcHV0ZS1vcHRpbWl6ZXIvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfR2V0RW5yb2xsbWVudFN0YXR1cy5odG1sXCIsXG4gICAgICBcImRlc2NyaXB0aW9uXCI6IFwiR3JhbnRzIHBlcm1pc3Npb24gdG8gZ2V0IHRoZSBlbnJvbGxtZW50IHN0YXR1cyBmb3IgdGhlIHNwZWNpZmllZCBhY2NvdW50LlwiLFxuICAgICAgXCJhY2Nlc3NMZXZlbFwiOiBcIkxpc3RcIlxuICAgIH0sXG4gICAgXCJHZXRSZWNvbW1lbmRhdGlvblN1bW1hcmllc1wiOiB7XG4gICAgICBcInVybFwiOiBcImh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9jb21wdXRlLW9wdGltaXplci9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9HZXRSZWNvbW1lbmRhdGlvblN1bW1hcmllcy5odG1sXCIsXG4gICAgICBcImRlc2NyaXB0aW9uXCI6IFwiR3JhbnRzIHBlcm1pc3Npb24gdG8gZ2V0IHRoZSByZWNvbW1lbmRhdGlvbiBzdW1tYXJpZXMgZm9yIHRoZSBzcGVjaWZpZWQgYWNjb3VudChzKS5cIixcbiAgICAgIFwiYWNjZXNzTGV2ZWxcIjogXCJMaXN0XCJcbiAgICB9LFxuICAgIFwiVXBkYXRlRW5yb2xsbWVudFN0YXR1c1wiOiB7XG4gICAgICBcInVybFwiOiBcImh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9jb21wdXRlLW9wdGltaXplci9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9VcGRhdGVFbnJvbGxtZW50U3RhdHVzLmh0bWxcIixcbiAgICAgIFwiZGVzY3JpcHRpb25cIjogXCJHcmFudHMgcGVybWlzc2lvbiB0byB1cGRhdGUgdGhlIGVucm9sbG1lbnQgc3RhdHVzLlwiLFxuICAgICAgXCJhY2Nlc3NMZXZlbFwiOiBcIldyaXRlXCJcbiAgICB9XG4gIH07XG4gIHB1YmxpYyByZXNvdXJjZVR5cGVzOiBSZXNvdXJjZVR5cGVzID0ge307XG5cbiAgLyoqXG4gICAqIFN0YXRlbWVudCBwcm92aWRlciBmb3Igc2VydmljZSBbY29tcHV0ZS1vcHRpbWl6ZXJdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9JQU0vbGF0ZXN0L1VzZXJHdWlkZS9saXN0X2NvbXB1dGVvcHRpbWl6ZXIuaHRtbCkuXG4gICAqXG4gICAqIEBwYXJhbSBzaWQgW1NJRF0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0lBTS9sYXRlc3QvVXNlckd1aWRlL3JlZmVyZW5jZV9wb2xpY2llc19lbGVtZW50c19zaWQuaHRtbCkgb2YgdGhlIHN0YXRlbWVudFxuICAgKi9cbiAgY29uc3RydWN0b3IgKHNpZD86IHN0cmluZykge1xuICAgIHN1cGVyKHNpZCk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gdmlldyB0aGUgc3RhdHVzIG9mIHJlY29tbWVuZGF0aW9uIGV4cG9ydCBqb2JzLlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IExpc3RcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2NvbXB1dGUtb3B0aW1pemVyL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0Rlc2NyaWJlUmVjb21tZW5kYXRpb25FeHBvcnRKb2JzLmh0bWxcbiAgICovXG4gIHB1YmxpYyBkZXNjcmliZVJlY29tbWVuZGF0aW9uRXhwb3J0Sm9icygpIHtcbiAgICB0aGlzLmFkZCgnY29tcHV0ZS1vcHRpbWl6ZXI6RGVzY3JpYmVSZWNvbW1lbmRhdGlvbkV4cG9ydEpvYnMnKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBleHBvcnQgYXV0b3NjYWxpbmcgZ3JvdXAgcmVjb21tZW5kYXRpb25zIHRvIFMzIGZvciB0aGUgcHJvdmlkZWQgYWNjb3VudHMuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2NvbXB1dGUtb3B0aW1pemVyL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0V4cG9ydEF1dG9TY2FsaW5nR3JvdXBSZWNvbW1lbmRhdGlvbnMuaHRtbFxuICAgKi9cbiAgcHVibGljIGV4cG9ydEF1dG9TY2FsaW5nR3JvdXBSZWNvbW1lbmRhdGlvbnMoKSB7XG4gICAgdGhpcy5hZGQoJ2NvbXB1dGUtb3B0aW1pemVyOkV4cG9ydEF1dG9TY2FsaW5nR3JvdXBSZWNvbW1lbmRhdGlvbnMnKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBleHBvcnQgRUMyIGluc3RhbmNlIHJlY29tbWVuZGF0aW9ucyB0byBTMyBmb3IgdGhlIHByb3ZpZGVkIGFjY291bnRzLlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9jb21wdXRlLW9wdGltaXplci9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9FeHBvcnRFQzJJbnN0YW5jZVJlY29tbWVuZGF0aW9ucy5odG1sXG4gICAqL1xuICBwdWJsaWMgZXhwb3J0RUMySW5zdGFuY2VSZWNvbW1lbmRhdGlvbnMoKSB7XG4gICAgdGhpcy5hZGQoJ2NvbXB1dGUtb3B0aW1pemVyOkV4cG9ydEVDMkluc3RhbmNlUmVjb21tZW5kYXRpb25zJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gZ2V0IHJlY29tbWVuZGF0aW9ucyBmb3IgdGhlIHByb3ZpZGVkIGF1dG9zY2FsaW5nIGdyb3Vwcy5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBMaXN0XG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9jb21wdXRlLW9wdGltaXplci9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9HZXRBdXRvU2NhbGluZ0dyb3VwUmVjb21tZW5kYXRpb25zLmh0bWxcbiAgICovXG4gIHB1YmxpYyBnZXRBdXRvU2NhbGluZ0dyb3VwUmVjb21tZW5kYXRpb25zKCkge1xuICAgIHRoaXMuYWRkKCdjb21wdXRlLW9wdGltaXplcjpHZXRBdXRvU2NhbGluZ0dyb3VwUmVjb21tZW5kYXRpb25zJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gZ2V0IHJlY29tbWVuZGF0aW9ucyBmb3IgdGhlIHByb3ZpZGVkIEVDMiBpbnN0YW5jZXMuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogTGlzdFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vY29tcHV0ZS1vcHRpbWl6ZXIvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfR2V0RUMySW5zdGFuY2VSZWNvbW1lbmRhdGlvbnMuaHRtbFxuICAgKi9cbiAgcHVibGljIGdldEVDMkluc3RhbmNlUmVjb21tZW5kYXRpb25zKCkge1xuICAgIHRoaXMuYWRkKCdjb21wdXRlLW9wdGltaXplcjpHZXRFQzJJbnN0YW5jZVJlY29tbWVuZGF0aW9ucycpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGdldCB0aGUgcmVjb21tZW5kYXRpb24gcHJvamVjdGVkIG1ldHJpY3Mgb2YgdGhlIHNwZWNpZmllZCBpbnN0YW5jZS5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBMaXN0XG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9jb21wdXRlLW9wdGltaXplci9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9HZXRFQzJSZWNvbW1lbmRhdGlvblByb2plY3RlZE1ldHJpY3MuaHRtbFxuICAgKi9cbiAgcHVibGljIGdldEVDMlJlY29tbWVuZGF0aW9uUHJvamVjdGVkTWV0cmljcygpIHtcbiAgICB0aGlzLmFkZCgnY29tcHV0ZS1vcHRpbWl6ZXI6R2V0RUMyUmVjb21tZW5kYXRpb25Qcm9qZWN0ZWRNZXRyaWNzJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gZ2V0IHRoZSBlbnJvbGxtZW50IHN0YXR1cyBmb3IgdGhlIHNwZWNpZmllZCBhY2NvdW50LlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IExpc3RcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2NvbXB1dGUtb3B0aW1pemVyL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0dldEVucm9sbG1lbnRTdGF0dXMuaHRtbFxuICAgKi9cbiAgcHVibGljIGdldEVucm9sbG1lbnRTdGF0dXMoKSB7XG4gICAgdGhpcy5hZGQoJ2NvbXB1dGUtb3B0aW1pemVyOkdldEVucm9sbG1lbnRTdGF0dXMnKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBnZXQgdGhlIHJlY29tbWVuZGF0aW9uIHN1bW1hcmllcyBmb3IgdGhlIHNwZWNpZmllZCBhY2NvdW50KHMpLlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IExpc3RcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2NvbXB1dGUtb3B0aW1pemVyL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0dldFJlY29tbWVuZGF0aW9uU3VtbWFyaWVzLmh0bWxcbiAgICovXG4gIHB1YmxpYyBnZXRSZWNvbW1lbmRhdGlvblN1bW1hcmllcygpIHtcbiAgICB0aGlzLmFkZCgnY29tcHV0ZS1vcHRpbWl6ZXI6R2V0UmVjb21tZW5kYXRpb25TdW1tYXJpZXMnKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byB1cGRhdGUgdGhlIGVucm9sbG1lbnQgc3RhdHVzLlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9jb21wdXRlLW9wdGltaXplci9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9VcGRhdGVFbnJvbGxtZW50U3RhdHVzLmh0bWxcbiAgICovXG4gIHB1YmxpYyB1cGRhdGVFbnJvbGxtZW50U3RhdHVzKCkge1xuICAgIHRoaXMuYWRkKCdjb21wdXRlLW9wdGltaXplcjpVcGRhdGVFbnJvbGxtZW50U3RhdHVzJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cbn1cbiJdfQ==