import { Actions, PolicyStatement, ResourceTypes } from "../shared";
/**
 * Statement provider for service [networkmanager](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_networkmanager.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Networkmanager extends PolicyStatement {
    servicePrefix: string;
    protected actionList: Actions;
    resourceTypes: ResourceTypes;
    /**
     * Statement provider for service [networkmanager](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_networkmanager.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to associate a customer gateway to a device
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/networkmanager/latest/APIReference/API_AssociateCustomerGateway.html
     */
    associateCustomerGateway(): this;
    /**
     * Grants permission to associate a link to a device
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/networkmanager/latest/APIReference/API_AssociateLink.html
     */
    associateLink(): this;
    /**
     * Grants permission to create a new device
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/networkmanager/latest/APIReference/API_CreateDevice.html
     */
    createDevice(): this;
    /**
     * Grants permission to create a new global network
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/networkmanager/latest/APIReference/API_CreateGlobalNetwork.html
     */
    createGlobalNetwork(): this;
    /**
     * Grants permission to create a new link
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/networkmanager/latest/APIReference/API_CreateLink.html
     */
    createLink(): this;
    /**
     * Grants permission to create a new site
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/networkmanager/latest/APIReference/API_CreateSite.html
     */
    createSite(): this;
    /**
     * Grants permission to delete a device
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/networkmanager/latest/APIReference/API_DeleteDevice.html
     */
    deleteDevice(): this;
    /**
     * Grants permission to delete a global network
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/networkmanager/latest/APIReference/API_DeleteGlobalNetwork.html
     */
    deleteGlobalNetwork(): this;
    /**
     * Grants permission to delete a link
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/networkmanager/latest/APIReference/API_DeleteLink.html
     */
    deleteLink(): this;
    /**
     * Grants permission to delete a site
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/networkmanager/latest/APIReference/API_DeleteSite.html
     */
    deleteSite(): this;
    /**
     * Grants permission to deregister a transit gateway from a global network
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/networkmanager/latest/APIReference/API_DeregisterTransitGateway.html
     */
    deregisterTransitGateway(): this;
    /**
     * Grants permission to describe global networks
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/networkmanager/latest/APIReference/API_DescribeGlobalNetworks.html
     */
    describeGlobalNetworks(): this;
    /**
     * Grants permission to disassociate a customer gateway from a device
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/networkmanager/latest/APIReference/API_DisassociateCustomerGateway.html
     */
    disassociateCustomerGateway(): this;
    /**
     * Grants permission to disassociate a link from a device
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/networkmanager/latest/APIReference/API_DisassociateLink.html
     */
    disassociateLink(): this;
    /**
     * Grants permission to describe customer gateway associations
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/networkmanager/latest/APIReference/API_GetCustomerGatewayAssociations.html
     */
    getCustomerGatewayAssociations(): this;
    /**
     * Grants permission to describe devices
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/networkmanager/latest/APIReference/API_GetDevices.html
     */
    getDevices(): this;
    /**
     * Grants permission to describe link associations
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/networkmanager/latest/APIReference/API_GetLinkAssociations.html
     */
    getLinkAssociations(): this;
    /**
     * Grants permission to describe links
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/networkmanager/latest/APIReference/API_GetLinks.html
     */
    getLinks(): this;
    /**
     * Grants permission to describe global networks
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/networkmanager/latest/APIReference/API_GetSites.html
     */
    getSites(): this;
    /**
     * Grants permission to describe transit gateway registrations
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/networkmanager/latest/APIReference/API_GetTransitGatewayRegistrations.html
     */
    getTransitGatewayRegistrations(): this;
    /**
     * Grants permission to lists tag for a Network Manager resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/networkmanager/latest/APIReference/API_ListTagsForResource.html
     */
    listTagsForResource(): this;
    /**
     * Grants permission to register a transit gateway to a global network
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/networkmanager/latest/APIReference/API_RegisterTransitGateway.html
     */
    registerTransitGateway(): this;
    /**
     * Grants permission to tag a Network Manager resource
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/networkmanager/latest/APIReference/API_TagResource.html
     */
    tagResource(): this;
    /**
     * Grants permission to untag a Network Manager resource
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/networkmanager/latest/APIReference/API_UntagResource.html
     */
    untagResource(): this;
    /**
     * Grants permission to update a device
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/networkmanager/latest/APIReference/API_UpdateDevice.html
     */
    updateDevice(): this;
    /**
     * Grants permission to update a global network
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/networkmanager/latest/APIReference/API_UpdateGlobalNetwork.html
     */
    updateGlobalNetwork(): this;
    /**
     * Grants permission to update a link
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/networkmanager/latest/APIReference/API_UpdateLink.html
     */
    updateLink(): this;
    /**
     * Grants permission to update a site
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/networkmanager/latest/APIReference/API_UpdateSite.html
     */
    updateSite(): this;
    /**
     * Adds a resource of type global-network to the statement
     *
     * https://docs.aws.amazon.com/vpc/latest/tgw/what-is-network-manager.html/
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible condition keys:
     *  - aws:ResourceTag/${TagKey}
     */
    onGlobalNetwork(resourceId: string, account?: string, partition?: string): this;
    /**
     * Adds a resource of type site to the statement
     *
     * https://docs.aws.amazon.com/vpc/latest/tgw/what-is-network-manager.html/
     *
     * @param globalNetworkId - Identifier for the globalNetworkId.
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible condition keys:
     *  - aws:ResourceTag/${TagKey}
     */
    onSite(globalNetworkId: string, resourceId: string, account?: string, partition?: string): this;
    /**
     * Adds a resource of type link to the statement
     *
     * https://docs.aws.amazon.com/vpc/latest/tgw/what-is-network-manager.html/
     *
     * @param globalNetworkId - Identifier for the globalNetworkId.
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible condition keys:
     *  - aws:ResourceTag/${TagKey}
     */
    onLink(globalNetworkId: string, resourceId: string, account?: string, partition?: string): this;
    /**
     * Adds a resource of type device to the statement
     *
     * https://docs.aws.amazon.com/vpc/latest/tgw/what-is-network-manager.html/
     *
     * @param globalNetworkId - Identifier for the globalNetworkId.
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible condition keys:
     *  - aws:ResourceTag/${TagKey}
     */
    onDevice(globalNetworkId: string, resourceId: string, account?: string, partition?: string): this;
    /**
     * Controls which customer gateways can be associated or disassociated
     *
     * https://docs.aws.amazon.com/vpc/latest/tgw/nm-security-iam.html
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifCgwArn(value: string | string[], operator?: string): this;
    /**
     * Controls which transit gateways can be registered or deregistered
     *
     * https://docs.aws.amazon.com/vpc/latest/tgw/nm-security-iam.html
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifTgwArn(value: string | string[], operator?: string): this;
}
