# coding: utf-8

"""
    CRM Pipelines

    Pipelines represent distinct stages in a workflow, like closing a deal or servicing a support ticket. These endpoints provide access to read and modify pipelines in HubSpot. Pipelines support `deals` and `tickets` object types.  ## Pipeline ID validation  When calling endpoints that take pipelineId as a parameter, that ID must correspond to an existing, un-archived pipeline. Otherwise the request will fail with a `404 Not Found` response.  # noqa: E501

    The version of the OpenAPI document: v3
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from hubspot.crm.pipelines.configuration import Configuration


class PublicAuditInfo(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {"portal_id": "int", "identifier": "str", "action": "str", "timestamp": "datetime", "message": "str", "raw_object": "object", "from_user_id": "int"}

    attribute_map = {"portal_id": "portalId", "identifier": "identifier", "action": "action", "timestamp": "timestamp", "message": "message", "raw_object": "rawObject", "from_user_id": "fromUserId"}

    def __init__(self, portal_id=None, identifier=None, action=None, timestamp=None, message=None, raw_object=None, from_user_id=None, local_vars_configuration=None):  # noqa: E501
        """PublicAuditInfo - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._portal_id = None
        self._identifier = None
        self._action = None
        self._timestamp = None
        self._message = None
        self._raw_object = None
        self._from_user_id = None
        self.discriminator = None

        self.portal_id = portal_id
        self.identifier = identifier
        self.action = action
        if timestamp is not None:
            self.timestamp = timestamp
        if message is not None:
            self.message = message
        if raw_object is not None:
            self.raw_object = raw_object
        if from_user_id is not None:
            self.from_user_id = from_user_id

    @property
    def portal_id(self):
        """Gets the portal_id of this PublicAuditInfo.  # noqa: E501


        :return: The portal_id of this PublicAuditInfo.  # noqa: E501
        :rtype: int
        """
        return self._portal_id

    @portal_id.setter
    def portal_id(self, portal_id):
        """Sets the portal_id of this PublicAuditInfo.


        :param portal_id: The portal_id of this PublicAuditInfo.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and portal_id is None:  # noqa: E501
            raise ValueError("Invalid value for `portal_id`, must not be `None`")  # noqa: E501

        self._portal_id = portal_id

    @property
    def identifier(self):
        """Gets the identifier of this PublicAuditInfo.  # noqa: E501


        :return: The identifier of this PublicAuditInfo.  # noqa: E501
        :rtype: str
        """
        return self._identifier

    @identifier.setter
    def identifier(self, identifier):
        """Sets the identifier of this PublicAuditInfo.


        :param identifier: The identifier of this PublicAuditInfo.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and identifier is None:  # noqa: E501
            raise ValueError("Invalid value for `identifier`, must not be `None`")  # noqa: E501

        self._identifier = identifier

    @property
    def action(self):
        """Gets the action of this PublicAuditInfo.  # noqa: E501


        :return: The action of this PublicAuditInfo.  # noqa: E501
        :rtype: str
        """
        return self._action

    @action.setter
    def action(self, action):
        """Sets the action of this PublicAuditInfo.


        :param action: The action of this PublicAuditInfo.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and action is None:  # noqa: E501
            raise ValueError("Invalid value for `action`, must not be `None`")  # noqa: E501

        self._action = action

    @property
    def timestamp(self):
        """Gets the timestamp of this PublicAuditInfo.  # noqa: E501


        :return: The timestamp of this PublicAuditInfo.  # noqa: E501
        :rtype: datetime
        """
        return self._timestamp

    @timestamp.setter
    def timestamp(self, timestamp):
        """Sets the timestamp of this PublicAuditInfo.


        :param timestamp: The timestamp of this PublicAuditInfo.  # noqa: E501
        :type: datetime
        """

        self._timestamp = timestamp

    @property
    def message(self):
        """Gets the message of this PublicAuditInfo.  # noqa: E501


        :return: The message of this PublicAuditInfo.  # noqa: E501
        :rtype: str
        """
        return self._message

    @message.setter
    def message(self, message):
        """Sets the message of this PublicAuditInfo.


        :param message: The message of this PublicAuditInfo.  # noqa: E501
        :type: str
        """

        self._message = message

    @property
    def raw_object(self):
        """Gets the raw_object of this PublicAuditInfo.  # noqa: E501


        :return: The raw_object of this PublicAuditInfo.  # noqa: E501
        :rtype: object
        """
        return self._raw_object

    @raw_object.setter
    def raw_object(self, raw_object):
        """Sets the raw_object of this PublicAuditInfo.


        :param raw_object: The raw_object of this PublicAuditInfo.  # noqa: E501
        :type: object
        """

        self._raw_object = raw_object

    @property
    def from_user_id(self):
        """Gets the from_user_id of this PublicAuditInfo.  # noqa: E501


        :return: The from_user_id of this PublicAuditInfo.  # noqa: E501
        :rtype: int
        """
        return self._from_user_id

    @from_user_id.setter
    def from_user_id(self, from_user_id):
        """Sets the from_user_id of this PublicAuditInfo.


        :param from_user_id: The from_user_id of this PublicAuditInfo.  # noqa: E501
        :type: int
        """

        self._from_user_id = from_user_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(lambda item: (item[0], item[1].to_dict()) if hasattr(item[1], "to_dict") else item, value.items()))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PublicAuditInfo):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, PublicAuditInfo):
            return True

        return self.to_dict() != other.to_dict()
