# coding: utf-8

"""
    Marketing Events Extension

    These APIs allow you to interact with HubSpot's Marketing Events Extension. It allows you to: * Create, Read or update Marketing Event information in HubSpot * Specify whether a HubSpot contact has registered, attended or cancelled a registration to a Marketing Event. * Specify a URL that can be called to get the details of a Marketing Event.   # noqa: E501

    The version of the OpenAPI document: v3
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from hubspot.marketing.events.configuration import Configuration


class EventDetailSettingsUrl(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {"event_details_url": "str"}

    attribute_map = {"event_details_url": "eventDetailsUrl"}

    def __init__(self, event_details_url=None, local_vars_configuration=None):  # noqa: E501
        """EventDetailSettingsUrl - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._event_details_url = None
        self.discriminator = None

        self.event_details_url = event_details_url

    @property
    def event_details_url(self):
        """Gets the event_details_url of this EventDetailSettingsUrl.  # noqa: E501

        The url that will be used to fetch marketing event details by id. Must contain a `%s` character sequence that will be substituted with the event id. For example: `https://my.event.app/events/%s`  # noqa: E501

        :return: The event_details_url of this EventDetailSettingsUrl.  # noqa: E501
        :rtype: str
        """
        return self._event_details_url

    @event_details_url.setter
    def event_details_url(self, event_details_url):
        """Sets the event_details_url of this EventDetailSettingsUrl.

        The url that will be used to fetch marketing event details by id. Must contain a `%s` character sequence that will be substituted with the event id. For example: `https://my.event.app/events/%s`  # noqa: E501

        :param event_details_url: The event_details_url of this EventDetailSettingsUrl.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and event_details_url is None:  # noqa: E501
            raise ValueError("Invalid value for `event_details_url`, must not be `None`")  # noqa: E501

        self._event_details_url = event_details_url

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(lambda item: (item[0], item[1].to_dict()) if hasattr(item[1], "to_dict") else item, value.items()))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, EventDetailSettingsUrl):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, EventDetailSettingsUrl):
            return True

        return self.to_dict() != other.to_dict()
