# Generated by Django 2.2.9 on 2020-01-03 14:04

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [("core", "0018_auto_20191127_2350")]

    operations = [
        migrations.CreateModel(
            name="NpmRemote",
            fields=[
                (
                    "remote_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        related_name="npm_npmremote",
                        serialize=False,
                        to="core.Remote",
                    ),
                )
            ],
            options={"default_related_name": "%(app_label)s_%(model_name)s"},
            bases=("core.remote",),
        ),
        migrations.CreateModel(
            name="NpmRepository",
            fields=[
                (
                    "repository_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        related_name="npm_npmrepository",
                        serialize=False,
                        to="core.Repository",
                    ),
                )
            ],
            options={"default_related_name": "%(app_label)s_%(model_name)s"},
            bases=("core.repository",),
        ),
        migrations.CreateModel(
            name="Package",
            fields=[
                (
                    "content_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        related_name="npm_package",
                        serialize=False,
                        to="core.Content",
                    ),
                ),
                ("name", models.CharField(max_length=214)),
                ("version", models.CharField(max_length=16)),
            ],
            options={
                "default_related_name": "%(app_label)s_%(model_name)s",
                "unique_together": {("name", "version")},
            },
            bases=("core.content",),
        ),
        migrations.CreateModel(
            name="NpmDistribution",
            fields=[
                (
                    "basedistribution_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        related_name="npm_npmdistribution",
                        serialize=False,
                        to="core.BaseDistribution",
                    ),
                ),
                (
                    "repository",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="npm_npmdistribution",
                        to="core.Repository",
                    ),
                ),
                (
                    "repository_version",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="npm_npmdistribution",
                        to="core.RepositoryVersion",
                    ),
                ),
            ],
            options={"default_related_name": "%(app_label)s_%(model_name)s"},
            bases=("core.basedistribution",),
        ),
    ]
