# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['py_imports', 'py_imports.base']

package_data = \
{'': ['*']}

install_requires = \
['pyflakes==2.4.0']

setup_kwargs = {
    'name': 'py-imports',
    'version': '1.2.0',
    'description': 'Python Toolkit to imports introspection',
    'long_description': '\n![Py-Imports](https://github.com/AndresBena19/py-imports/blob/develop/img/icon-import-py.png?raw=true )\n<p align="center">\n    <em>Be aware about imports meta information </em>\n</p>\n<p align="center">\n<a href="https://github.com/andresbena19/py-imports/actions?query=workflow%3ATest+event%3Apush+branch%3Amaster" target="_blank">\n    <img src="https://github.com/tiangolo/fastapi/workflows/Test/badge.svg?event=push&branch=master" alt="Test">\n</a>\n<a href="https://codecov.io/gh/andresbena19/py-imports" target="_blank">\n    <img src="https://img.shields.io/codecov/c/github/andresbena19/py-imports" alt="Coverage">\n</a>\n<a href="https://pypi.org/project/py-imports" target="_blank">\n    <img src="https://img.shields.io/pypi/v/py-imports?color=%2334D058&label=pypi%20package" alt="Package version">\n</a>\n<a href="https://pypi.org/project/py-imports" target="_blank">\n    <img src="https://img.shields.io/pypi/pyversions/py_imports.svg?color=%2334D058" alt="Supported Python versions">\n</a>\n</p>\n\n\n---\n\n**Source Code**: <a href="https://github.com/andresbena19/py-imports" target="_blank"> https://github.com/andresbena19/py-imports\n</a>\n## Requirements :wrench: :hammer: :nut_and_bolt:\n\nPython 3.7+\n\npy-imports stands on the shoulders of giants:\n\n* <a href="https://docs.python.org/3/library/ast.html" class="external-link" target="_blank">ast — Abstract Syntax Trees</a> to traverse python code.\n\n## Installation :computer:\n\n<div class="termy">\n\n```console\n$ pip install py-imports\n\n---> 100%\n\nAll it\'s ready to begin \n```\n\n</div>\n\n## Example :paperclip:\n\n### Introspect it\n\n* Create a file `main.py` with:\n\n```Python\nimport logging\nfrom py_imports.manager import PyImports\nfrom .parse_local_dir import file_imports_from_dir_one\n\nmyself = "main.py"\n\n# Let\'s introspect myself\nwith PyImports() as manager:\n    imports_file = manager.get_imports(myself)\n\n# Now you have access to the imports used in each file \nimports_file\n{\n \'main.py\': <py_imports.base.models.ImportsCollectionFile object at 0x10b889220>\n}\n\n# Get details about the absolute, relative and standard imports in the file\ncollector_object = imports_file.get(myself)\nabsolute_imports = collector_object.absolute_imports\nrelative_imports = collector_object.relative_imports\nstandard_imports = collector_object.imports\n\n```\n\n<details>\n  <summary>Get meta information about absolute imports...<code>absolute_imports</code></summary>\n\n   ```Python\n     # Absolute imports\n     #  --- from py_imports.manager import PyImports ---\n     # If we introspect the object, we will get the following\n    \n     example_abs_import = absolute_imports[0]\n     example_abs_import.children -> [\'PyImports\']\n     example_abs_import.parent -> \'py_imports.manager\'\n     example_abs_import.statement -> \'from py_imports.manager import PyImports\'\n     example_abs_import.level -> 0\n     example_abs_import.line -> 2\n\n   ```\n</details>\n\n<details>\n  <summary>Get meta information about relative imports...<code>relative_imports</code></summary>\n\n   ```Python\n     # relative imports\n     #  --- from .parse_local_dir import file_imports_from_dir_one ---\n     # If we introspect the object, we will get the following\n    \n     example_relative_import = relative_imports[0]\n     example_abs_import.children -> [\'file_imports_from_dir_one\']\n     example_abs_import.children_unused -> [\'file_imports_from_dir_one\']\n     example_abs_import.parent -> \'parse_local_dir\'\n     example_abs_import.statement -> \'from .parse_local_dir import file_imports_from_dir_one\'\n     example_abs_import.level -> 1\n     example_abs_import.line -> 3\n \n   ```\n</details>\n\n<details>\n  <summary>Get meta information about standard imports ...<code>standard_imports</code></summary>\n\n   ```Python \n        # standard imports\n        #  --- import logging ---\n        # If we introspect the object, we will get the following\n        \n        example_standard_import = standard_imports[0]\n        example_standard_import.children -> [\'logging\']\n        example_standard_import.children_unused -> [\'logging\']\n        example_standard_import.statement -> \'import logging\'\n        example_standard_import.line -> 1\n \n   ```\n</details>\n\n\n### Now you know more about you... :lotus_position:\n## Features :sunny:\n### :sunglasses: Classify the imports found into three groups\n      -  Python Abstract Grammar\n          | Import(alias* names)\n          | ImportFrom(identifier? module, alias* names, int? level)\n\n   - ### Relative Imports  \n    \n      Relative imports use leading dots. A single leading dot indicates a relative import, starting with the current package. \n      Two or more leading dots indicate a relative import to the parent(s) of the current package, one level per dot after the first.\n   \n      - #### Schema syntax\n        Relative imports must always use `from <> import`;`import <> `is always absolute.\n        - **pydocs**: https://docs.python.org/3/reference/import.html#package-relative-imports\n        - Metadata will be abstracted in `RelativeImportStatement` objects.\n      - #### Ex.\n        ```Python   \n        from .moduleY import spam\n        from .moduleY import spam as ham\n        from . import moduleY\n        from ..subpackage1 import moduleY\n        from ..subpackage2.moduleZ import eggs\n        from ..moduleA import foo\n        from ...package import bar\n        from ...sys import path\n        ```\n        \n   - ### Absolute Imports  \n      Absolute import involves full path i.e., from the project’s root folder to the desired module. An absolute import state that the resource   \n      to be imported using its full path from the project’s root folder.\n      \n      - #### Schema syntax\n         Absolute imports may use either the `import <>` or `from <> import <>` syntax, but relative imports may only use the second form.\n         - **PEP328**: https://www.python.org/dev/peps/pep-0328/\n         - Metadata will be abstracted in `AbsoluteImportStatement` objects.\n      - #### Ex.\n        ```Python\n        from moduleY import spam\n        from moduleY import spam as ham\n    \n        # OR\n      \n        import XXX.YYY.ZZZ\n        ```\n   - ### Standard Imports  \n      Standard imports will be introspected and the data about it will be saved in an\n      object named `ImportStatement`.\n   \n      - #### Schema syntax\n         standard imports use  the `import <>`  syntax.\n         - **PEP328**: https://www.python.org/dev/peps/pep-0328/\n         - Metadata will be abstracted in `ImportStatement` objects.\n      - #### Ex.\n        ```Python\n        import moduleY\n        import moduleX\n        ```\n\n### :sunglasses: Validate if the imports are being used \n - ### Unused imports \n    If some child it\'s not used in an import, this will be added in  `children_unused` attribute in every concrete implementation that represent an imports.\n \n    ```Python\n    from ..subpackage1 import moduleY, moduleZ\n    \n    def foo() -> moduleZ:\n        pass\n    ```\n    In this case the relative import  `from ..subpackage1 import moduleY, moduleZ` has a child that is not used in the file.\n    ```Python\n    ...  # After introspect the file\n    \n    relative_imports = imports_file.relative_imports\n    relative_imports[0].children_unused = ["moduleY"]\n    \n    # But the total of children present in this file \n    relative_imports[0].children = ["moduleY", "moduleZ"]\n    ```\n   :eyes: **it\'s used `pyflakes` to determine the unused imports, because follow the same philosophy to get the \n    information just using a static analysis.**\n## Notes :bookmark:\n\nThis library does not execute any part of the python  target code, this just make a static analysis over the code to describe the meta information about the imports in the file.\n## License :traffic_light:\n\nThis project is licensed under the terms of the MIT license.\n',
    'author': 'Andres',
    'author_email': 'andresbenavides404@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/AndresBena19/py-imports.git',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
