import * as cdk from 'aws-cdk-lib';
import * as constructs from 'constructs';
/**
 * A resource provider for managing helm. Version: 1.2.1
 *
 * @schema CfnHelmProps
 */
export interface CfnHelmProps {
    /**
     * EKS cluster name
     *
     * @schema CfnHelmProps#ClusterID
     */
    readonly clusterId?: string;
    /**
     * Secrets Manager ARN for kubeconfig file
     *
     * @schema CfnHelmProps#KubeConfig
     */
    readonly kubeConfig?: string;
    /**
     * IAM to use with EKS cluster authentication, if not resource execution role will be used
     *
     * @schema CfnHelmProps#RoleArn
     */
    readonly roleArn?: string;
    /**
     * Repository url. Defaults to kubernetes-charts.storage.googleapis.com
     *
     * @default kubernetes-charts.storage.googleapis.com
     * @schema CfnHelmProps#Repository
     */
    readonly repository?: string;
    /**
     * Extra options for repository
     *
     * @schema CfnHelmProps#RepositoryOptions
     */
    readonly repositoryOptions?: CfnHelmPropsRepositoryOptions;
    /**
     * Chart name
     *
     * @schema CfnHelmProps#Chart
     */
    readonly chart: string;
    /**
     * Namespace to use with helm. Created if doesn't exist and default will be used if not provided
     *
     * @schema CfnHelmProps#Namespace
     */
    readonly namespace?: string;
    /**
     * Name for the helm release
     *
     * @schema CfnHelmProps#Name
     */
    readonly name?: string;
    /**
     * Custom Values can optionally be specified
     *
     * @schema CfnHelmProps#Values
     */
    readonly values?: any;
    /**
     * String representation of a values.yaml file
     *
     * @schema CfnHelmProps#ValueYaml
     */
    readonly valueYaml?: string;
    /**
     * Version can be specified, if not latest will be used
     *
     * @schema CfnHelmProps#Version
     */
    readonly version?: string;
    /**
     * Custom Value Yaml file can optionally be specified
     *
     * @schema CfnHelmProps#ValueOverrideURL
     */
    readonly valueOverrideUrl?: string;
    /**
     * Resources from the helm charts
     *
     * @schema CfnHelmProps#Resources
     */
    readonly resources?: any;
    /**
     * Timeout for resource provider. Default 60 mins
     *
     * @schema CfnHelmProps#TimeOut
     */
    readonly timeOut?: number;
    /**
     * For network connectivity to Cluster inside VPC
     *
     * @schema CfnHelmProps#VPCConfiguration
     */
    readonly vpcConfiguration?: CfnHelmPropsVpcConfiguration;
}
/**
 * Converts an object of type 'CfnHelmProps' to JSON representation.
 */
export declare function toJson_CfnHelmProps(obj: CfnHelmProps | undefined): Record<string, any> | undefined;
/**
 * Extra options for repository
 *
 * @schema CfnHelmPropsRepositoryOptions
 */
export interface CfnHelmPropsRepositoryOptions {
    /**
     * Chart repository username
     *
     * @schema CfnHelmPropsRepositoryOptions#Username
     */
    readonly username?: string;
    /**
     * Chart repository password
     *
     * @schema CfnHelmPropsRepositoryOptions#Password
     */
    readonly password?: string;
    /**
     * Verify certificates of HTTPS-enabled servers using this CA bundle from S3
     *
     * @schema CfnHelmPropsRepositoryOptions#CAFile
     */
    readonly caFile?: string;
    /**
     * Skip TLS certificate checks for the repository
     *
     * @schema CfnHelmPropsRepositoryOptions#InsecureSkipTLSVerify
     */
    readonly insecureSkipTlsVerify?: boolean;
}
/**
 * Converts an object of type 'CfnHelmPropsRepositoryOptions' to JSON representation.
 */
export declare function toJson_CfnHelmPropsRepositoryOptions(obj: CfnHelmPropsRepositoryOptions | undefined): Record<string, any> | undefined;
/**
 * For network connectivity to Cluster inside VPC
 *
 * @schema CfnHelmPropsVpcConfiguration
 */
export interface CfnHelmPropsVpcConfiguration {
    /**
     * Specify one or more security groups
     *
     * @schema CfnHelmPropsVpcConfiguration#SecurityGroupIds
     */
    readonly securityGroupIds?: string[];
    /**
     * Specify one or more subnets
     *
     * @schema CfnHelmPropsVpcConfiguration#SubnetIds
     */
    readonly subnetIds?: string[];
}
/**
 * Converts an object of type 'CfnHelmPropsVpcConfiguration' to JSON representation.
 */
export declare function toJson_CfnHelmPropsVpcConfiguration(obj: CfnHelmPropsVpcConfiguration | undefined): Record<string, any> | undefined;
/**
 * A CloudFormation `AWSQS::Kubernetes::Helm`
 *
 * @cloudformationResource AWSQS::Kubernetes::Helm
 * @stability external
 * @link https://github.com/aws-quickstart/quickstart-helm-resource-provider.git
 */
export declare class CfnHelm extends cdk.CfnResource {
    /**
    * The CloudFormation resource type name for this resource class.
    */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWSQS::Kubernetes::Helm";
    /**
     * Resource props.
     */
    readonly props: CfnHelmProps;
    /**
     * Attribute `AWSQS::Kubernetes::Helm.ID`
     * @link https://github.com/aws-quickstart/quickstart-helm-resource-provider.git
     */
    readonly attrId: string;
    /**
     * Create a new `AWSQS::Kubernetes::Helm`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnHelmProps);
}
