# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'ExtraDiskSizeNode',
    'InstanceCopySetting',
    'NotificationResponder',
    'SecurityFirewallRule',
    'GetAccountInstanceResult',
    'GetAccountVpcsVpcResult',
    'GetNodesNodeResult',
    'GetPluginsCommunityPluginResult',
    'GetPluginsPluginResult',
]

@pulumi.output_type
class ExtraDiskSizeNode(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "additionalDiskSize":
            suggest = "additional_disk_size"
        elif key == "diskSize":
            suggest = "disk_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExtraDiskSizeNode. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExtraDiskSizeNode.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExtraDiskSizeNode.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 additional_disk_size: Optional[int] = None,
                 disk_size: Optional[int] = None,
                 name: Optional[str] = None):
        """
        :param int additional_disk_size: Additional added disk size
        :param int disk_size: Subscription plan disk size
        """
        if additional_disk_size is not None:
            pulumi.set(__self__, "additional_disk_size", additional_disk_size)
        if disk_size is not None:
            pulumi.set(__self__, "disk_size", disk_size)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="additionalDiskSize")
    def additional_disk_size(self) -> Optional[int]:
        """
        Additional added disk size
        """
        return pulumi.get(self, "additional_disk_size")

    @property
    @pulumi.getter(name="diskSize")
    def disk_size(self) -> Optional[int]:
        """
        Subscription plan disk size
        """
        return pulumi.get(self, "disk_size")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        return pulumi.get(self, "name")


@pulumi.output_type
class InstanceCopySetting(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "subscriptionId":
            suggest = "subscription_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceCopySetting. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceCopySetting.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceCopySetting.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 settings: Sequence[str],
                 subscription_id: str):
        """
        :param Sequence[str] settings: Array of one or more settings to be copied. Allowed values: [alarms, config, definitions, firewall, logs, metrics, plugins]
               
               See more below, copy settings
        :param str subscription_id: Instance identifier of the CloudAMQP instance to copy the settings from.
        """
        pulumi.set(__self__, "settings", settings)
        pulumi.set(__self__, "subscription_id", subscription_id)

    @property
    @pulumi.getter
    def settings(self) -> Sequence[str]:
        """
        Array of one or more settings to be copied. Allowed values: [alarms, config, definitions, firewall, logs, metrics, plugins]

        See more below, copy settings
        """
        return pulumi.get(self, "settings")

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> str:
        """
        Instance identifier of the CloudAMQP instance to copy the settings from.
        """
        return pulumi.get(self, "subscription_id")


@pulumi.output_type
class NotificationResponder(dict):
    def __init__(__self__, *,
                 type: str,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 username: Optional[str] = None):
        """
        :param str type: Type of responder. [`team`, `user`, `escalation`, `schedule`]
        :param str id: Identifier in UUID format
        :param str name: Name of the responder
        :param str username: Username of the responder
               
               Responders of type `team`, `escalation` and `schedule` can use either id or name.
               While `user` can use either id or username.
        """
        pulumi.set(__self__, "type", type)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of responder. [`team`, `user`, `escalation`, `schedule`]
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Identifier in UUID format
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the responder
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        """
        Username of the responder

        Responders of type `team`, `escalation` and `schedule` can use either id or name.
        While `user` can use either id or username.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class SecurityFirewallRule(dict):
    def __init__(__self__, *,
                 ip: str,
                 description: Optional[str] = None,
                 ports: Optional[Sequence[int]] = None,
                 services: Optional[Sequence[str]] = None):
        """
        :param str ip: CIDR address: IP address with CIDR notation (e.g. 10.56.72.0/24)
        :param str description: Description name of the rule. e.g. Default.
               
               Pre-defined services for RabbitMQ:
               
               | Service name | Port  |
               |--------------|-------|
               | AMQP         | 5672  |
               | AMQPS        | 5671  |
               | HTTPS        | 443   |
               | MQTT         | 1883  |
               | MQTTS        | 8883  |
               | STOMP        | 61613 |
               | STOMPS       | 61614 |
               | STREAM       | 5552  |
               | STREAM_SSL   | 5551  |
               
               Pre-defined services for LavinMQ:
               
               | Service name | Port  |
               |--------------|-------|
               | AMQP         | 5672  |
               | AMQPS        | 5671  |
               | HTTPS        | 443   |
        :param Sequence[int] ports: Custom ports to be opened
        :param Sequence[str] services: Pre-defined service ports, see table below
        """
        pulumi.set(__self__, "ip", ip)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)
        if services is not None:
            pulumi.set(__self__, "services", services)

    @property
    @pulumi.getter
    def ip(self) -> str:
        """
        CIDR address: IP address with CIDR notation (e.g. 10.56.72.0/24)
        """
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description name of the rule. e.g. Default.

        Pre-defined services for RabbitMQ:

        | Service name | Port  |
        |--------------|-------|
        | AMQP         | 5672  |
        | AMQPS        | 5671  |
        | HTTPS        | 443   |
        | MQTT         | 1883  |
        | MQTTS        | 8883  |
        | STOMP        | 61613 |
        | STOMPS       | 61614 |
        | STREAM       | 5552  |
        | STREAM_SSL   | 5551  |

        Pre-defined services for LavinMQ:

        | Service name | Port  |
        |--------------|-------|
        | AMQP         | 5672  |
        | AMQPS        | 5671  |
        | HTTPS        | 443   |
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def ports(self) -> Optional[Sequence[int]]:
        """
        Custom ports to be opened
        """
        return pulumi.get(self, "ports")

    @property
    @pulumi.getter
    def services(self) -> Optional[Sequence[str]]:
        """
        Pre-defined service ports, see table below
        """
        return pulumi.get(self, "services")


@pulumi.output_type
class GetAccountInstanceResult(dict):
    def __init__(__self__, *,
                 id: int,
                 name: str,
                 plan: str,
                 region: str,
                 tags: Optional[Sequence[str]] = None):
        """
        :param int id: The instance identifier
        :param str name: The name of the instance
        :param str plan: The subscription plan used for the instance
        :param str region: The region were the instanece is located in
        :param Sequence[str] tags: Tag for the instance
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "plan", plan)
        pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def id(self) -> int:
        """
        The instance identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the instance
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def plan(self) -> str:
        """
        The subscription plan used for the instance
        """
        return pulumi.get(self, "plan")

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        The region were the instanece is located in
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[str]]:
        """
        Tag for the instance
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class GetAccountVpcsVpcResult(dict):
    def __init__(__self__, *,
                 id: int,
                 name: str,
                 region: str,
                 subnet: str,
                 vpc_name: str,
                 tags: Optional[Sequence[str]] = None):
        """
        :param int id: The instance identifier
        :param str name: The name of the instance
        :param str region: The region were the instanece is located in
        :param str subnet: The VPC subnet
        :param str vpc_name: VPC name given when hosted at the cloud provider
        :param Sequence[str] tags: Tag the VPC instance with optional tags
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "subnet", subnet)
        pulumi.set(__self__, "vpc_name", vpc_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def id(self) -> int:
        """
        The instance identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the instance
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        The region were the instanece is located in
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def subnet(self) -> str:
        """
        The VPC subnet
        """
        return pulumi.get(self, "subnet")

    @property
    @pulumi.getter(name="vpcName")
    def vpc_name(self) -> str:
        """
        VPC name given when hosted at the cloud provider
        """
        return pulumi.get(self, "vpc_name")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[str]]:
        """
        Tag the VPC instance with optional tags
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class GetNodesNodeResult(dict):
    def __init__(__self__, *,
                 additional_disk_size: int,
                 availability_zone: str,
                 configured: bool,
                 disk_size: int,
                 erlang_version: str,
                 hipe: bool,
                 hostname: str,
                 hostname_internal: str,
                 name: str,
                 rabbitmq_version: str,
                 running: bool):
        pulumi.set(__self__, "additional_disk_size", additional_disk_size)
        pulumi.set(__self__, "availability_zone", availability_zone)
        pulumi.set(__self__, "configured", configured)
        pulumi.set(__self__, "disk_size", disk_size)
        pulumi.set(__self__, "erlang_version", erlang_version)
        pulumi.set(__self__, "hipe", hipe)
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "hostname_internal", hostname_internal)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "rabbitmq_version", rabbitmq_version)
        pulumi.set(__self__, "running", running)

    @property
    @pulumi.getter(name="additionalDiskSize")
    def additional_disk_size(self) -> int:
        return pulumi.get(self, "additional_disk_size")

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> str:
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter
    def configured(self) -> bool:
        return pulumi.get(self, "configured")

    @property
    @pulumi.getter(name="diskSize")
    def disk_size(self) -> int:
        return pulumi.get(self, "disk_size")

    @property
    @pulumi.getter(name="erlangVersion")
    def erlang_version(self) -> str:
        return pulumi.get(self, "erlang_version")

    @property
    @pulumi.getter
    def hipe(self) -> bool:
        return pulumi.get(self, "hipe")

    @property
    @pulumi.getter
    def hostname(self) -> str:
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter(name="hostnameInternal")
    def hostname_internal(self) -> str:
        return pulumi.get(self, "hostname_internal")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="rabbitmqVersion")
    def rabbitmq_version(self) -> str:
        return pulumi.get(self, "rabbitmq_version")

    @property
    @pulumi.getter
    def running(self) -> bool:
        return pulumi.get(self, "running")


@pulumi.output_type
class GetPluginsCommunityPluginResult(dict):
    def __init__(__self__, *,
                 description: str,
                 name: str,
                 require: str):
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "require", require)

    @property
    @pulumi.getter
    def description(self) -> str:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def require(self) -> str:
        return pulumi.get(self, "require")


@pulumi.output_type
class GetPluginsPluginResult(dict):
    def __init__(__self__, *,
                 description: str,
                 enabled: bool,
                 name: str,
                 version: str):
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def description(self) -> str:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def version(self) -> str:
        return pulumi.get(self, "version")


