# flake8: noqa
# Generated by Django 2.1.9 on 2019-07-06 08:33

import django.db.models.deletion
import time_wizard.workarounds
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('contenttypes', '0002_remove_content_type_name'),
        ('time_wizard', '0002_delete_models'),
    ]

    operations = [
        migrations.CreateModel(
            name='PeriodModel',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('object_id', models.PositiveIntegerField()),
            ],
            options={
                'base_manager_name': 'objects',
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='TimeWizardModel',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(blank=True, help_text='Optional name to identify the given TimeWizard.', max_length=255)),
            ],
        ),
        migrations.CreateModel(
            name='AbsolutePeriodModel',
            fields=[
                ('periodmodel_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='time_wizard.PeriodModel')),
                ('start', models.DateTimeField(blank=True, null=True)),
                ('end', models.DateTimeField(blank=True, null=True)),
            ],
            options={
                'base_manager_name': 'objects',
                'abstract': False,
            },
            bases=('time_wizard.periodmodel',),
        ),
        migrations.CreateModel(
            name='HolidayRangePeriodModel',
            fields=[
                ('periodmodel_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='time_wizard.PeriodModel')),
                ('time_value', models.PositiveSmallIntegerField(default=0, help_text='Amount of time between this and the selected holiday.')),
                ('time_unit', models.CharField(blank=True, choices=[('1', 'Minute'), ('60', 'Hour'), ('1440', 'Day'), ('10080', 'Week')], help_text='Unit for the chosen time_value.', max_length=16)),
                ('range_position', models.CharField(blank=True, choices=[('before', 'Before'), ('after', 'After'), ('both', 'Both')], help_text='Choose if a given time range is either before, after or before and after the selected holiday.', max_length=8)),
                ('start_time', models.TimeField(blank=True, null=True)),
                ('end_time', models.TimeField(blank=True, null=True)),
                ('country', models.CharField(choices=[('AR', 'AR'), ('AT', 'AT'), ('AU', 'AU'), ('BE', 'BE'), ('BG', 'BG'), ('BR', 'BR'), ('BY', 'BY'), ('CA', 'CA'), ('CH', 'CH'), ('CO', 'CO'), ('CZ', 'CZ'), ('DE', 'DE'), ('DK', 'DK'), ('ECB', 'ECB'), ('ES', 'ES'), ('FI', 'FI'), ('FRA', 'FRA'), ('HND', 'HND'), ('HR', 'HR'), ('HU', 'HU'), ('IE', 'IE'), ('IND', 'IND'), ('IT', 'IT'), ('JP', 'JP'), ('LT', 'LT'), ('LU', 'LU'), ('MX', 'MX'), ('NL', 'NL'), ('NO', 'NO'), ('NZ', 'NZ'), ('PL', 'PL'), ('PT', 'PT'), ('PTE', 'PTE'), ('RU', 'RU'), ('SE', 'SE'), ('SI', 'SI'), ('SK', 'SK'), ('TAR', 'TAR'), ('UA', 'UA'), ('UK', 'UK'), ('US', 'US'), ('ZA', 'ZA')], max_length=8)),
                ('province', models.CharField(blank=True, max_length=8)),
                ('holiday', models.CharField(max_length=64)),
            ],
            options={
                'base_manager_name': 'objects',
                'abstract': False,
            },
            bases=('time_wizard.periodmodel',),
        ),
        migrations.AddField(
            model_name='periodmodel',
            name='content_type',
            field=models.ForeignKey(on_delete=time_wizard.workarounds.NON_POLYMORPHIC_CASCADE, related_name='periods', to='contenttypes.ContentType'),
        ),
        migrations.AddField(
            model_name='periodmodel',
            name='polymorphic_ctype',
            field=models.ForeignKey(editable=False, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='polymorphic_time_wizard.periodmodel_set+', to='contenttypes.ContentType'),
        ),
    ]
