
This package contains functions used in data processing of hyperspectral images
captured using a scanning Fabry-Pérot interferometer (FPI). This includes transmission
simulations of the FPI itself.


-------------------
## Image handling

### HSTI.import_data_cube(path)

  _This function imports the hyperspectral thermal datacube from the raw output of the camera. The path that the function uses as input must be the one containing the 'images' directory._

### HSTI.export_data_cube(cube, folder_name)

  _This function takes an HSTI numpy array and exports it as individual .ppm images to a folder given by folder_name._

### HSTI.remove_stuck_px(cube)

  _This function removes the dead pixels in the bolometer by replacing them with the average of their non-zero neighbors._

### HSTI.remove_outlying_px(cube, cut_off)

  _This function removes outlying pixel measurements of values higher than the cut off value._

### HSTI.median_filter_cube(cube, kernel_size)

  _This function runs a median filter across the image plane. The size of the kernel must be defined._


-------------------
## Preprocessing

### HSTI.remove_vignette(cube)

  _This function takes a single HSTI as input and returns a new vignetting corrected cube._

### HSTI.debend(cube, central_mirror_sep)

  _This function takes a single HSTI as input and returns a new spectral bending corrected cube._

### HSTI.baseline(cube)

  _This function subtracts the mean pixel value from every band in the datacube._

### HSTI.standardize(cube)

  _This function subtracts the mean pixel value from every band in the datacube and divides all values with the pixel standard deviation._

### HSTI.normalize_cube(cube)

  _This function normalises the entire data cube by dividing all bands by the sum of the bands._

### HSTI.normalize_pixel(cube)

  _This function normalises the entire data cube by dividing all bands by the sum of the bands in each individual pixel._

### HSTI.sbtrct_first_band(cube)

  _This function subtracts the first band from the remaining bands in the datacube, effectively setting the first band to zero._

-------------------

## Common analysis


### HSTI.fps(points, n_seeds)

  _Function which distributes n_seeds (a numper of points) equally within a lists of points to obtain furthest point sampling._

  _The function takes in a list of points. Every entry in the list contains both the x and y coordinate of a given point. It returns the coordinates of the selected sample points._


### HSTI.voronoi(array_2D, n_seeds)

  _This function ._

### HSTI.mse(lst1, lst2)

  _This function returns the mean square error (MSE) between two lists of same length._


-------------------
## FPI Simulation

### HSTI.fpi_sim()

  _This function ._

### HSTI.fpi_sim_matrix()

  _This function ._

### HSTI.fpi_sim_matrix_angular()

  _This function ._



-------------------

# Contact

  _For bug reports or other questions please contact mani@newtec.dk or alj@newtec.dk._
