# mypy-boto3-ce<a id="mypy-boto3-ce"></a>

[![PyPI - mypy-boto3-ce](https://img.shields.io/pypi/v/mypy-boto3-ce.svg?color=blue)](https://pypi.org/project/mypy-boto3-ce)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-ce.svg?color=blue)](https://pypi.org/project/mypy-boto3-ce)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-ce?color=blue)](https://pypistats.org/packages/mypy-boto3-ce)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.CostExplorer 1.17.72](https://boto3.amazonaws.com/v1/documentation/api/1.17.72/reference/services/ce.html#CostExplorer)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-buider 4.13.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-ce docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_ce/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-ce](#mypy-boto3-ce)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

## How to install<a id="how-to-install"></a>

Install `boto3-stubs` for `CostExplorer` service.

```bash
python -m pip install boto3-stubs[ce]
```

## Usage<a id="usage"></a>

### VSCode<a id="vscode"></a>

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[ce]` in your environment:
  `python -m pip install 'boto3-stubs[ce]'`

Both type checking and auto-complete should work for `CostExplorer` service. No
explicit type annotations required, write your `boto3` code as usual.

### PyCharm<a id="pycharm"></a>

- Install `boto-stubs[ce]` in your environment:
  `python -m pip install 'boto3-stubs[ce]'`

Both type checking and auto-complete should work for `CostExplorer` service. No
explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed
`boto3-stubs` submodules.

### Other IDEs<a id="other-ides"></a>

Not tested, but as long as your IDE support `mypy` or `pyright`, everything
should work.

### mypy<a id="mypy"></a>

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[ce]` in your environment:
  `python -m pip install 'boto3-stubs[ce]'`
- Run `mypy` as usual

Type checking should work for `CostExplorer` service. No explicit type
annotations required, write your `boto3` code as usual.

### pyright<a id="pyright"></a>

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[ce]` in your environment:
  `python -m pip install 'boto3-stubs[ce]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `CostExplorer` service. No explicit type
annotations required, write your `boto3` code as usual.

## Explicit type annotations<a id="explicit-type-annotations"></a>

### Client annotations<a id="client-annotations"></a>

`CostExplorerClient` provides annotations for `boto3.client("ce")`.

```python
import boto3

from mypy_boto3_ce import CostExplorerClient

client: CostExplorerClient = boto3.client("ce")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: CostExplorerClient = session.client("ce")
```

### Literals<a id="literals"></a>

`mypy_boto3_ce.literals` module contains literals extracted from shapes that
can be used in user code for type checking.

```python
from mypy_boto3_ce.literals import (
    AccountScopeType,
    AnomalyFeedbackTypeType,
    AnomalySubscriptionFrequencyType,
    ContextType,
    CostCategoryInheritedValueDimensionNameType,
    CostCategoryRuleTypeType,
    CostCategoryRuleVersionType,
    CostCategoryStatusComponentType,
    CostCategoryStatusType,
    DimensionType,
    GranularityType,
    GroupDefinitionTypeType,
    LookbackPeriodInDaysType,
    MatchOptionType,
    MetricType,
    MonitorDimensionType,
    MonitorTypeType,
    NumericOperatorType,
    OfferingClassType,
    PaymentOptionType,
    RecommendationTargetType,
    RightsizingTypeType,
    SavingsPlansDataTypeType,
    SortOrderType,
    SubscriberStatusType,
    SubscriberTypeType,
    SupportedSavingsPlansTypeType,
    TermInYearsType,
)

def check_value(value: AccountScopeType) -> bool:
    ...
```

### Typed dictionaries<a id="typed-dictionaries"></a>

`mypy_boto3_ce.type_defs` module contains structures and shapes assembled to
typed dictionaries for additional type checking.

```python
from mypy_boto3_ce.type_defs import (
    AnomalyDateIntervalTypeDef,
    AnomalyMonitorTypeDef,
    AnomalyScoreTypeDef,
    AnomalySubscriptionTypeDef,
    AnomalyTypeDef,
    CostCategoryInheritedValueDimensionTypeDef,
    CostCategoryProcessingStatusTypeDef,
    CostCategoryReferenceTypeDef,
    CostCategoryRuleTypeDef,
    CostCategoryTypeDef,
    CostCategoryValuesTypeDef,
    CoverageByTimeTypeDef,
    CoverageCostTypeDef,
    CoverageHoursTypeDef,
    CoverageNormalizedUnitsTypeDef,
    CoverageTypeDef,
    CreateAnomalyMonitorResponseTypeDef,
    CreateAnomalySubscriptionResponseTypeDef,
    CreateCostCategoryDefinitionResponseTypeDef,
    CurrentInstanceTypeDef,
    DateIntervalTypeDef,
    DeleteCostCategoryDefinitionResponseTypeDef,
    DescribeCostCategoryDefinitionResponseTypeDef,
    DimensionValuesTypeDef,
    DimensionValuesWithAttributesTypeDef,
    EBSResourceUtilizationTypeDef,
    EC2InstanceDetailsTypeDef,
    EC2ResourceDetailsTypeDef,
    EC2ResourceUtilizationTypeDef,
    EC2SpecificationTypeDef,
    ESInstanceDetailsTypeDef,
    ElastiCacheInstanceDetailsTypeDef,
    ExpressionTypeDef,
    ForecastResultTypeDef,
    GetAnomaliesResponseTypeDef,
    GetAnomalyMonitorsResponseTypeDef,
    GetAnomalySubscriptionsResponseTypeDef,
    GetCostAndUsageResponseTypeDef,
    GetCostAndUsageWithResourcesResponseTypeDef,
    GetCostCategoriesResponseTypeDef,
    GetCostForecastResponseTypeDef,
    GetDimensionValuesResponseTypeDef,
    GetReservationCoverageResponseTypeDef,
    GetReservationPurchaseRecommendationResponseTypeDef,
    GetReservationUtilizationResponseTypeDef,
    GetRightsizingRecommendationResponseTypeDef,
    GetSavingsPlansCoverageResponseTypeDef,
    GetSavingsPlansPurchaseRecommendationResponseTypeDef,
    GetSavingsPlansUtilizationDetailsResponseTypeDef,
    GetSavingsPlansUtilizationResponseTypeDef,
    GetTagsResponseTypeDef,
    GetUsageForecastResponseTypeDef,
    GroupDefinitionTypeDef,
    GroupTypeDef,
    ImpactTypeDef,
    InstanceDetailsTypeDef,
    ListCostCategoryDefinitionsResponseTypeDef,
    MetricValueTypeDef,
    ModifyRecommendationDetailTypeDef,
    ProvideAnomalyFeedbackResponseTypeDef,
    RDSInstanceDetailsTypeDef,
    RedshiftInstanceDetailsTypeDef,
    ReservationAggregatesTypeDef,
    ReservationCoverageGroupTypeDef,
    ReservationPurchaseRecommendationDetailTypeDef,
    ReservationPurchaseRecommendationMetadataTypeDef,
    ReservationPurchaseRecommendationSummaryTypeDef,
    ReservationPurchaseRecommendationTypeDef,
    ReservationUtilizationGroupTypeDef,
    ResourceDetailsTypeDef,
    ResourceUtilizationTypeDef,
    ResultByTimeTypeDef,
    RightsizingRecommendationConfigurationTypeDef,
    RightsizingRecommendationMetadataTypeDef,
    RightsizingRecommendationSummaryTypeDef,
    RightsizingRecommendationTypeDef,
    RootCauseTypeDef,
    SavingsPlansAmortizedCommitmentTypeDef,
    SavingsPlansCoverageDataTypeDef,
    SavingsPlansCoverageTypeDef,
    SavingsPlansDetailsTypeDef,
    SavingsPlansPurchaseRecommendationDetailTypeDef,
    SavingsPlansPurchaseRecommendationMetadataTypeDef,
    SavingsPlansPurchaseRecommendationSummaryTypeDef,
    SavingsPlansPurchaseRecommendationTypeDef,
    SavingsPlansSavingsTypeDef,
    SavingsPlansUtilizationAggregatesTypeDef,
    SavingsPlansUtilizationByTimeTypeDef,
    SavingsPlansUtilizationDetailTypeDef,
    SavingsPlansUtilizationTypeDef,
    ServiceSpecificationTypeDef,
    SortDefinitionTypeDef,
    SubscriberTypeDef,
    TagValuesTypeDef,
    TargetInstanceTypeDef,
    TerminateRecommendationDetailTypeDef,
    TotalImpactFilterTypeDef,
    UpdateAnomalyMonitorResponseTypeDef,
    UpdateAnomalySubscriptionResponseTypeDef,
    UpdateCostCategoryDefinitionResponseTypeDef,
    UtilizationByTimeTypeDef,
)

def get_structure() -> AnomalyDateIntervalTypeDef:
    return {
      ...
    }
```

## Versioning<a id="versioning"></a>

`mypy-boto3-ce` version is the same as related `boto3` version and follows
[PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

## Documentation<a id="documentation"></a>

All type annotations can be found in
[mypy-boto3-ce docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_ce/)

## Support and contributing<a id="support-and-contributing"></a>

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
